/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.scoreboard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class Scoreboard {
    private final Map<String, ScoreObjective> field_96545_a = Maps.newHashMap();
    private final Map<ScoreCriteria, List<ScoreObjective>> field_96543_b = Maps.newHashMap();
    private final Map<String, Map<ScoreObjective, Score>> field_96544_c = Maps.newHashMap();
    private final ScoreObjective[] field_96541_d = new ScoreObjective[19];
    private final Map<String, ScorePlayerTeam> field_96542_e = Maps.newHashMap();
    private final Map<String, ScorePlayerTeam> field_96540_f = Maps.newHashMap();
    private static String[] field_178823_g;

    public ScoreObjective func_197899_c(String string) {
        return this.field_96545_a.get(string);
    }

    @Nullable
    public ScoreObjective func_96518_b(@Nullable String string) {
        return this.field_96545_a.get(string);
    }

    public ScoreObjective func_199868_a(String string, ScoreCriteria scoreCriteria2, ITextComponent iTextComponent, ScoreCriteria.RenderType renderType) {
        if (string.length() > 16) {
            throw new IllegalArgumentException("The objective name '" + string + "' is too long!");
        }
        if (this.field_96545_a.containsKey(string)) {
            throw new IllegalArgumentException("An objective with the name '" + string + "' already exists!");
        }
        ScoreObjective scoreObjective = new ScoreObjective(this, string, scoreCriteria2, iTextComponent, renderType);
        this.field_96543_b.computeIfAbsent(scoreCriteria2, scoreCriteria -> Lists.newArrayList()).add(scoreObjective);
        this.field_96545_a.put(string, scoreObjective);
        this.func_96522_a(scoreObjective);
        return scoreObjective;
    }

    public final void func_197893_a(ScoreCriteria scoreCriteria, String string, Consumer<Score> consumer) {
        this.field_96543_b.getOrDefault(scoreCriteria, Collections.emptyList()).forEach(scoreObjective -> consumer.accept(this.func_96529_a(string, (ScoreObjective)scoreObjective)));
    }

    public boolean func_178819_b(String string, ScoreObjective scoreObjective) {
        Map<ScoreObjective, Score> map = this.field_96544_c.get(string);
        if (map == null) {
            return false;
        }
        Score \u26032 = map.get(scoreObjective);
        return \u26032 != null;
    }

    public Score func_96529_a(String string2, ScoreObjective scoreObjective2) {
        if (string2.length() > 40) {
            throw new IllegalArgumentException("The player name '" + string2 + "' is too long!");
        }
        Map map = this.field_96544_c.computeIfAbsent(string2, string -> Maps.newHashMap());
        return map.computeIfAbsent(scoreObjective2, scoreObjective -> {
            Score score = new Score(this, (ScoreObjective)scoreObjective, string2);
            score.func_96647_c(0);
            return score;
        });
    }

    public Collection<Score> func_96534_i(ScoreObjective scoreObjective) {
        ArrayList arrayList = Lists.newArrayList();
        for (Map<ScoreObjective, Score> map : this.field_96544_c.values()) {
            Score score = map.get(scoreObjective);
            if (score == null) continue;
            arrayList.add(score);
        }
        Collections.sort(arrayList, Score.field_96658_a);
        return arrayList;
    }

    public Collection<ScoreObjective> func_96514_c() {
        return this.field_96545_a.values();
    }

    public Collection<String> func_197897_d() {
        return this.field_96545_a.keySet();
    }

    public Collection<String> func_96526_d() {
        return Lists.newArrayList(this.field_96544_c.keySet());
    }

    public void func_178822_d(String string2, @Nullable ScoreObjective scoreObjective) {
        if (scoreObjective == null) {
            Map<ScoreObjective, Score> map = this.field_96544_c.remove(string2);
            if (map != null) {
                this.func_96516_a(string2);
            }
        } else {
            String string2;
            Map<ScoreObjective, Score> \u26032 = this.field_96544_c.get(string2);
            if (\u26032 != null) {
                Score score = \u26032.remove(scoreObjective);
                if (\u26032.size() < 1) {
                    Map<ScoreObjective, Score> map = this.field_96544_c.remove(string2);
                    if (map != null) {
                        this.func_96516_a(string2);
                    }
                } else if (score != null) {
                    this.func_178820_a(string2, scoreObjective);
                }
            }
        }
    }

    public Map<ScoreObjective, Score> func_96510_d(String string) {
        HashMap hashMap = this.field_96544_c.get(string);
        if (hashMap == null) {
            hashMap = Maps.newHashMap();
        }
        return hashMap;
    }

    public void func_96519_k(ScoreObjective scoreObjective2) {
        ScoreObjective scoreObjective2;
        this.field_96545_a.remove(scoreObjective2.func_96679_b());
        for (int i = 0; i < 19; ++i) {
            if (this.func_96539_a(i) != scoreObjective2) continue;
            this.func_96530_a(i, null);
        }
        List<ScoreObjective> \u26032 = this.field_96543_b.get(scoreObjective2.func_96680_c());
        if (\u26032 != null) {
            \u26032.remove(scoreObjective2);
        }
        for (Map<ScoreObjective, Score> map : this.field_96544_c.values()) {
            map.remove(scoreObjective2);
        }
        this.func_96533_c(scoreObjective2);
    }

    public void func_96530_a(int n, @Nullable ScoreObjective scoreObjective) {
        this.field_96541_d[n] = scoreObjective;
    }

    @Nullable
    public ScoreObjective func_96539_a(int n) {
        return this.field_96541_d[n];
    }

    public ScorePlayerTeam func_96508_e(String string) {
        return this.field_96542_e.get(string);
    }

    public ScorePlayerTeam func_96527_f(String string) {
        if (string.length() > 16) {
            throw new IllegalArgumentException("The team name '" + string + "' is too long!");
        }
        ScorePlayerTeam scorePlayerTeam = this.func_96508_e(string);
        if (scorePlayerTeam != null) {
            throw new IllegalArgumentException("A team with the name '" + string + "' already exists!");
        }
        scorePlayerTeam = new ScorePlayerTeam(this, string);
        this.field_96542_e.put(string, scorePlayerTeam);
        this.func_96523_a(scorePlayerTeam);
        return scorePlayerTeam;
    }

    public void func_96511_d(ScorePlayerTeam scorePlayerTeam2) {
        ScorePlayerTeam scorePlayerTeam2;
        this.field_96542_e.remove(scorePlayerTeam2.func_96661_b());
        for (String string : scorePlayerTeam2.func_96670_d()) {
            this.field_96540_f.remove(string);
        }
        this.func_96513_c(scorePlayerTeam2);
    }

    public boolean func_197901_a(String string, ScorePlayerTeam scorePlayerTeam) {
        if (string.length() > 40) {
            throw new IllegalArgumentException("The player name '" + string + "' is too long!");
        }
        if (this.func_96509_i(string) != null) {
            this.func_96524_g(string);
        }
        this.field_96540_f.put(string, scorePlayerTeam);
        return scorePlayerTeam.func_96670_d().add(string);
    }

    public boolean func_96524_g(String string) {
        ScorePlayerTeam scorePlayerTeam = this.func_96509_i(string);
        if (scorePlayerTeam != null) {
            this.func_96512_b(string, scorePlayerTeam);
            return true;
        }
        return false;
    }

    public void func_96512_b(String string, ScorePlayerTeam scorePlayerTeam) {
        if (this.func_96509_i(string) != scorePlayerTeam) {
            throw new IllegalStateException("Player is either on another team or not on any team. Cannot remove from team '" + scorePlayerTeam.func_96661_b() + "'.");
        }
        this.field_96540_f.remove(string);
        scorePlayerTeam.func_96670_d().remove(string);
    }

    public Collection<String> func_96531_f() {
        return this.field_96542_e.keySet();
    }

    public Collection<ScorePlayerTeam> func_96525_g() {
        return this.field_96542_e.values();
    }

    @Nullable
    public ScorePlayerTeam func_96509_i(String string) {
        return this.field_96540_f.get(string);
    }

    public void func_96522_a(ScoreObjective scoreObjective) {
    }

    public void func_199869_b(ScoreObjective scoreObjective) {
    }

    public void func_96533_c(ScoreObjective scoreObjective) {
    }

    public void func_96536_a(Score score) {
    }

    public void func_96516_a(String string) {
    }

    public void func_178820_a(String string, ScoreObjective scoreObjective) {
    }

    public void func_96523_a(ScorePlayerTeam scorePlayerTeam) {
    }

    public void func_96538_b(ScorePlayerTeam scorePlayerTeam) {
    }

    public void func_96513_c(ScorePlayerTeam scorePlayerTeam) {
    }

    public static String func_96517_b(int n) {
        switch (n) {
            case 0: {
                return "list";
            }
            case 1: {
                return "sidebar";
            }
            case 2: {
                return "belowName";
            }
        }
        if (n >= 3 && n <= 18 && (\u2603 = TextFormatting.func_175744_a(n - 3)) != null && \u2603 != TextFormatting.RESET) {
            return "sidebar.team." + \u2603.func_96297_d();
        }
        return null;
    }

    public static int func_96537_j(String string) {
        if ("list".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("sidebar".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("belowName".equalsIgnoreCase(string)) {
            return 2;
        }
        if (string.startsWith("sidebar.team.") && (\u2603 = TextFormatting.func_96300_b(\u2603 = string.substring("sidebar.team.".length()))) != null && \u2603.func_175746_b() >= 0) {
            return \u2603.func_175746_b() + 3;
        }
        return -1;
    }

    public static String[] func_178821_h() {
        if (field_178823_g == null) {
            field_178823_g = new String[19];
            for (int i = 0; i < 19; ++i) {
                Scoreboard.field_178823_g[i] = Scoreboard.func_96517_b(i);
            }
        }
        return field_178823_g;
    }

    public void func_181140_a(Entity entity) {
        if (entity == null || entity instanceof EntityPlayer || entity.func_70089_S()) {
            return;
        }
        String string = entity.func_189512_bd();
        this.func_178822_d(string, null);
        this.func_96524_g(string);
    }

    protected NBTTagList func_197902_i() {
        NBTTagList nBTTagList = new NBTTagList();
        this.field_96544_c.values().stream().map(Map::values).forEach(collection -> collection.stream().filter(score -> score.func_96645_d() != null).forEach(score -> {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("Name", score.func_96653_e());
            nBTTagCompound.func_74778_a("Objective", score.func_96645_d().func_96679_b());
            nBTTagCompound.func_74768_a("Score", score.func_96652_c());
            nBTTagCompound.func_74757_a("Locked", score.func_178816_g());
            nBTTagList.add(nBTTagCompound);
        }));
        return nBTTagList;
    }

    protected void func_197905_a(NBTTagList nBTTagList) {
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound = nBTTagList.func_150305_b(i);
            ScoreObjective \u26032 = this.func_197899_c(nBTTagCompound.func_74779_i("Objective"));
            String \u26033 = nBTTagCompound.func_74779_i("Name");
            if (\u26033.length() > 40) {
                \u26033 = \u26033.substring(0, 40);
            }
            Score \u26034 = this.func_96529_a(\u26033, \u26032);
            \u26034.func_96647_c(nBTTagCompound.func_74762_e("Score"));
            if (!nBTTagCompound.func_74764_b("Locked")) continue;
            \u26034.func_178815_a(nBTTagCompound.func_74767_n("Locked"));
        }
    }
}

