/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.state.IProperty;
import net.minecraft.state.IStateHolder;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NBTUtil {
    private static final Logger field_193591_a = LogManager.getLogger();

    @Nullable
    public static GameProfile func_152459_a(NBTTagCompound nBTTagCompound) {
        String string = null;
        \u2603 = null;
        if (nBTTagCompound.func_150297_b("Name", 8)) {
            string = nBTTagCompound.func_74779_i("Name");
        }
        if (nBTTagCompound.func_150297_b("Id", 8)) {
            \u2603 = nBTTagCompound.func_74779_i("Id");
        }
        try {
            UUID uUID;
            try {
                uUID = UUID.fromString(\u2603);
            }
            catch (Throwable throwable) {
                uUID = null;
            }
            GameProfile \u26032 = new GameProfile(uUID, string);
            if (nBTTagCompound.func_150297_b("Properties", 10)) {
                NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l("Properties");
                for (String string2 : nBTTagCompound2.func_150296_c()) {
                    NBTTagList nBTTagList = nBTTagCompound2.func_150295_c(string2, 10);
                    for (int i = 0; i < nBTTagList.size(); ++i) {
                        NBTTagCompound nBTTagCompound3 = nBTTagList.func_150305_b(i);
                        String \u26033 = nBTTagCompound3.func_74779_i("Value");
                        if (nBTTagCompound3.func_150297_b("Signature", 8)) {
                            \u26032.getProperties().put((Object)string2, (Object)new Property(string2, \u26033, nBTTagCompound3.func_74779_i("Signature")));
                            continue;
                        }
                        \u26032.getProperties().put((Object)string2, (Object)new Property(string2, \u26033));
                    }
                }
            }
            return \u26032;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static NBTTagCompound func_180708_a(NBTTagCompound nBTTagCompound2, GameProfile gameProfile) {
        NBTTagCompound nBTTagCompound2;
        if (!StringUtils.func_151246_b(gameProfile.getName())) {
            nBTTagCompound2.func_74778_a("Name", gameProfile.getName());
        }
        if (gameProfile.getId() != null) {
            nBTTagCompound2.func_74778_a("Id", gameProfile.getId().toString());
        }
        if (!gameProfile.getProperties().isEmpty()) {
            NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
            for (String string : gameProfile.getProperties().keySet()) {
                NBTTagList nBTTagList = new NBTTagList();
                for (Property property : gameProfile.getProperties().get((Object)string)) {
                    NBTTagCompound nBTTagCompound4 = new NBTTagCompound();
                    nBTTagCompound4.func_74778_a("Value", property.getValue());
                    if (property.hasSignature()) {
                        nBTTagCompound4.func_74778_a("Signature", property.getSignature());
                    }
                    nBTTagList.add(nBTTagCompound4);
                }
                nBTTagCompound3.func_74782_a(string, nBTTagList);
            }
            nBTTagCompound2.func_74782_a("Properties", nBTTagCompound3);
        }
        return nBTTagCompound2;
    }

    @VisibleForTesting
    public static boolean func_181123_a(@Nullable INBTBase iNBTBase3, @Nullable INBTBase iNBTBase2, boolean bl) {
        INBTBase iNBTBase3;
        if (iNBTBase3 == iNBTBase2) {
            return true;
        }
        if (iNBTBase3 == null) {
            return true;
        }
        if (iNBTBase2 == null) {
            return false;
        }
        if (!iNBTBase3.getClass().equals(iNBTBase2.getClass())) {
            return false;
        }
        if (iNBTBase3 instanceof NBTTagCompound) {
            NBTTagCompound nBTTagCompound = (NBTTagCompound)iNBTBase3;
            \u2603 = (NBTTagCompound)iNBTBase2;
            for (String string : nBTTagCompound.func_150296_c()) {
                INBTBase iNBTBase4 = nBTTagCompound.func_74781_a(string);
                if (NBTUtil.func_181123_a(iNBTBase4, \u2603.func_74781_a(string), bl)) continue;
                return false;
            }
            return true;
        }
        if (iNBTBase3 instanceof NBTTagList && bl) {
            NBTTagList nBTTagList = (NBTTagList)iNBTBase3;
            \u2603 = (NBTTagList)iNBTBase2;
            if (nBTTagList.isEmpty()) {
                return \u2603.isEmpty();
            }
            for (int i = 0; i < nBTTagList.size(); ++i) {
                INBTBase iNBTBase5 = nBTTagList.get(i);
                boolean \u26032 = false;
                for (int j = 0; j < \u2603.size(); ++j) {
                    if (!NBTUtil.func_181123_a(iNBTBase5, \u2603.get(j), bl)) continue;
                    \u26032 = true;
                    break;
                }
                if (\u26032) continue;
                return false;
            }
            return true;
        }
        return iNBTBase3.equals(iNBTBase2);
    }

    public static NBTTagCompound func_186862_a(UUID uUID) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74772_a("M", uUID.getMostSignificantBits());
        nBTTagCompound.func_74772_a("L", uUID.getLeastSignificantBits());
        return nBTTagCompound;
    }

    public static UUID func_186860_b(NBTTagCompound nBTTagCompound) {
        return new UUID(nBTTagCompound.func_74763_f("M"), nBTTagCompound.func_74763_f("L"));
    }

    public static BlockPos func_186861_c(NBTTagCompound nBTTagCompound) {
        return new BlockPos(nBTTagCompound.func_74762_e("X"), nBTTagCompound.func_74762_e("Y"), nBTTagCompound.func_74762_e("Z"));
    }

    public static NBTTagCompound func_186859_a(BlockPos blockPos) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74768_a("X", blockPos.func_177958_n());
        nBTTagCompound.func_74768_a("Y", blockPos.func_177956_o());
        nBTTagCompound.func_74768_a("Z", blockPos.func_177952_p());
        return nBTTagCompound;
    }

    public static IBlockState func_190008_d(NBTTagCompound nBTTagCompound) {
        if (!nBTTagCompound.func_150297_b("Name", 8)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        Block block = IRegistry.field_212618_g.func_82594_a(new ResourceLocation(nBTTagCompound.func_74779_i("Name")));
        IBlockState \u26032 = block.func_176223_P();
        if (nBTTagCompound.func_150297_b("Properties", 10)) {
            NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l("Properties");
            StateContainer<Block, IBlockState> \u26033 = block.func_176194_O();
            for (String string : nBTTagCompound2.func_150296_c()) {
                IProperty<?> iProperty = \u26033.func_185920_a(string);
                if (iProperty == null) continue;
                \u26032 = NBTUtil.func_193590_a(\u26032, iProperty, string, nBTTagCompound2, nBTTagCompound);
            }
        }
        return \u26032;
    }

    private static <S extends IStateHolder<S>, T extends Comparable<T>> S func_193590_a(S s, IProperty<T> iProperty, String string, NBTTagCompound nBTTagCompound, NBTTagCompound nBTTagCompound2) {
        Optional<T> optional = iProperty.func_185929_b(nBTTagCompound.func_74779_i(string));
        if (optional.isPresent()) {
            return (S)((IStateHolder)s.func_206870_a(iProperty, (Comparable)((Comparable)optional.get())));
        }
        field_193591_a.warn("Unable to read property: {} with value: {} for blockstate: {}", (Object)string, (Object)nBTTagCompound.func_74779_i(string), (Object)nBTTagCompound2.toString());
        return s;
    }

    public static NBTTagCompound func_190009_a(IBlockState iBlockState) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74778_a("Name", IRegistry.field_212618_g.func_177774_c(iBlockState.func_177230_c()).toString());
        ImmutableMap<IProperty<?>, Comparable<?>> \u26032 = iBlockState.func_206871_b();
        if (!\u26032.isEmpty()) {
            \u2603 = new NBTTagCompound();
            for (Map.Entry entry : \u26032.entrySet()) {
                IProperty iProperty = (IProperty)entry.getKey();
                \u2603.func_74778_a(iProperty.func_177701_a(), NBTUtil.func_190010_a(iProperty, (Comparable)entry.getValue()));
            }
            nBTTagCompound.func_74782_a("Properties", \u2603);
        }
        return nBTTagCompound;
    }

    private static <T extends Comparable<T>> String func_190010_a(IProperty<T> iProperty, Comparable<?> comparable) {
        return iProperty.func_177702_a(comparable);
    }

    public static NBTTagCompound func_210822_a(DataFixer dataFixer, DSL.TypeReference typeReference, NBTTagCompound nBTTagCompound, int n) {
        return NBTUtil.func_210821_a(dataFixer, typeReference, nBTTagCompound, n, 1631);
    }

    public static NBTTagCompound func_210821_a(DataFixer dataFixer, DSL.TypeReference typeReference, NBTTagCompound nBTTagCompound, int n, int n2) {
        return (NBTTagCompound)dataFixer.update(typeReference, new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nBTTagCompound), n, n2).getValue();
    }
}

