/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCollection;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.lang3.ArrayUtils;

public class NBTTagIntArray
extends NBTTagCollection<NBTTagInt> {
    private int[] field_74749_a;

    NBTTagIntArray() {
    }

    public NBTTagIntArray(int[] nArray) {
        this.field_74749_a = nArray;
    }

    public NBTTagIntArray(List<Integer> list) {
        this(NBTTagIntArray.func_193584_a(list));
    }

    private static int[] func_193584_a(List<Integer> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Integer n = list.get(i);
            nArray[i] = n == null ? 0 : n;
        }
        return nArray;
    }

    @Override
    public void func_74734_a(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.field_74749_a.length);
        for (int n : this.field_74749_a) {
            dataOutput.writeInt(n);
        }
    }

    @Override
    public void func_152446_a(DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) throws IOException {
        nBTSizeTracker.func_152450_a(192L);
        int n2 = dataInput.readInt();
        nBTSizeTracker.func_152450_a(32 * n2);
        this.field_74749_a = new int[n2];
        for (\u2603 = 0; \u2603 < n2; ++\u2603) {
            this.field_74749_a[\u2603] = dataInput.readInt();
        }
    }

    @Override
    public byte func_74732_a() {
        return 11;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[I;");
        for (int i = 0; i < this.field_74749_a.length; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.field_74749_a[i]);
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    public NBTTagIntArray func_74737_b() {
        int[] nArray = new int[this.field_74749_a.length];
        System.arraycopy(this.field_74749_a, 0, nArray, 0, this.field_74749_a.length);
        return new NBTTagIntArray(nArray);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof NBTTagIntArray && Arrays.equals(this.field_74749_a, ((NBTTagIntArray)object).field_74749_a);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.field_74749_a);
    }

    public int[] func_150302_c() {
        return this.field_74749_a;
    }

    @Override
    public ITextComponent func_199850_a(String string, int n) {
        ITextComponent iTextComponent;
        ITextComponent iTextComponent2 = new TextComponentString("I").func_211708_a(field_197641_e);
        iTextComponent = new TextComponentString("[").func_150257_a(iTextComponent2).func_150258_a(";");
        for (int i = 0; i < this.field_74749_a.length; ++i) {
            iTextComponent.func_150258_a(" ").func_150257_a(new TextComponentString(String.valueOf(this.field_74749_a[i])).func_211708_a(field_197640_d));
            if (i == this.field_74749_a.length - 1) continue;
            iTextComponent.func_150258_a(",");
        }
        iTextComponent.func_150258_a("]");
        return iTextComponent;
    }

    @Override
    public int size() {
        return this.field_74749_a.length;
    }

    @Override
    public NBTTagInt func_197647_c(int n) {
        return new NBTTagInt(this.field_74749_a[n]);
    }

    @Override
    public void func_197648_a(int n, INBTBase iNBTBase) {
        this.field_74749_a[n] = ((NBTPrimitive)iNBTBase).func_150287_d();
    }

    @Override
    public void func_197649_b(int n) {
        this.field_74749_a = ArrayUtils.remove((int[])this.field_74749_a, (int)n);
    }

    @Override
    public /* synthetic */ INBTBase func_197647_c(int n) {
        return this.func_197647_c(n);
    }

    @Override
    public /* synthetic */ INBTBase func_74737_b() {
        return this.func_74737_b();
    }
}

