/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBTTagCompound
implements INBTBase {
    private static final Logger field_191551_b = LogManager.getLogger();
    private static final Pattern field_193583_c = Pattern.compile("[A-Za-z0-9._+-]+");
    private final Map<String, INBTBase> field_74784_a = Maps.newHashMap();

    @Override
    public void func_74734_a(DataOutput dataOutput2) throws IOException {
        DataOutput dataOutput2;
        for (String string : this.field_74784_a.keySet()) {
            INBTBase iNBTBase = this.field_74784_a.get(string);
            NBTTagCompound.func_150298_a(string, iNBTBase, dataOutput2);
        }
        dataOutput2.writeByte(0);
    }

    @Override
    public void func_152446_a(DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) throws IOException {
        nBTSizeTracker.func_152450_a(384L);
        if (n > 512) {
            throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        this.field_74784_a.clear();
        while ((\u2603 = NBTTagCompound.func_152447_a(dataInput, nBTSizeTracker)) != 0) {
            String string = NBTTagCompound.func_152448_b(dataInput, nBTSizeTracker);
            nBTSizeTracker.func_152450_a(224 + 16 * string.length());
            INBTBase \u26032 = NBTTagCompound.func_152449_a(\u2603, string, dataInput, n + 1, nBTSizeTracker);
            if (this.field_74784_a.put(string, \u26032) == null) continue;
            nBTSizeTracker.func_152450_a(288L);
        }
    }

    public Set<String> func_150296_c() {
        return this.field_74784_a.keySet();
    }

    @Override
    public byte func_74732_a() {
        return 10;
    }

    public int func_186856_d() {
        return this.field_74784_a.size();
    }

    public void func_74782_a(String string, INBTBase iNBTBase) {
        this.field_74784_a.put(string, iNBTBase);
    }

    public void func_74774_a(String string, byte by) {
        this.field_74784_a.put(string, new NBTTagByte(by));
    }

    public void func_74777_a(String string, short s) {
        this.field_74784_a.put(string, new NBTTagShort(s));
    }

    public void func_74768_a(String string, int n) {
        this.field_74784_a.put(string, new NBTTagInt(n));
    }

    public void func_74772_a(String string, long l) {
        this.field_74784_a.put(string, new NBTTagLong(l));
    }

    public void func_186854_a(String string, UUID uUID) {
        this.func_74772_a(string + "Most", uUID.getMostSignificantBits());
        this.func_74772_a(string + "Least", uUID.getLeastSignificantBits());
    }

    @Nullable
    public UUID func_186857_a(String string) {
        return new UUID(this.func_74763_f(string + "Most"), this.func_74763_f(string + "Least"));
    }

    public boolean func_186855_b(String string) {
        return this.func_150297_b(string + "Most", 99) && this.func_150297_b(string + "Least", 99);
    }

    public void func_74776_a(String string, float f) {
        this.field_74784_a.put(string, new NBTTagFloat(f));
    }

    public void func_74780_a(String string, double d) {
        this.field_74784_a.put(string, new NBTTagDouble(d));
    }

    public void func_74778_a(String string, String string2) {
        this.field_74784_a.put(string, new NBTTagString(string2));
    }

    public void func_74773_a(String string, byte[] byArray) {
        this.field_74784_a.put(string, new NBTTagByteArray(byArray));
    }

    public void func_74783_a(String string, int[] nArray) {
        this.field_74784_a.put(string, new NBTTagIntArray(nArray));
    }

    public void func_197646_b(String string, List<Integer> list) {
        this.field_74784_a.put(string, new NBTTagIntArray(list));
    }

    public void func_197644_a(String string, long[] lArray) {
        this.field_74784_a.put(string, new NBTTagLongArray(lArray));
    }

    public void func_202168_c(String string, List<Long> list) {
        this.field_74784_a.put(string, new NBTTagLongArray(list));
    }

    public void func_74757_a(String string, boolean bl) {
        this.func_74774_a(string, bl ? (byte)1 : 0);
    }

    public INBTBase func_74781_a(String string) {
        return this.field_74784_a.get(string);
    }

    public byte func_150299_b(String string) {
        INBTBase iNBTBase = this.field_74784_a.get(string);
        if (iNBTBase == null) {
            return 0;
        }
        return iNBTBase.func_74732_a();
    }

    public boolean func_74764_b(String string) {
        return this.field_74784_a.containsKey(string);
    }

    public boolean func_150297_b(String string, int n) {
        byte by = this.func_150299_b(string);
        if (by == n) {
            return true;
        }
        if (n == 99) {
            return by == 1 || by == 2 || by == 3 || by == 4 || by == 5 || by == 6;
        }
        return false;
    }

    public byte func_74771_c(String string) {
        try {
            if (this.func_150297_b(string, 99)) {
                return ((NBTPrimitive)this.field_74784_a.get(string)).func_150290_f();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public short func_74765_d(String string) {
        try {
            if (this.func_150297_b(string, 99)) {
                return ((NBTPrimitive)this.field_74784_a.get(string)).func_150289_e();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public int func_74762_e(String string) {
        try {
            if (this.func_150297_b(string, 99)) {
                return ((NBTPrimitive)this.field_74784_a.get(string)).func_150287_d();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public long func_74763_f(String string) {
        try {
            if (this.func_150297_b(string, 99)) {
                return ((NBTPrimitive)this.field_74784_a.get(string)).func_150291_c();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    public float func_74760_g(String string) {
        try {
            if (this.func_150297_b(string, 99)) {
                return ((NBTPrimitive)this.field_74784_a.get(string)).func_150288_h();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    public double func_74769_h(String string) {
        try {
            if (this.func_150297_b(string, 99)) {
                return ((NBTPrimitive)this.field_74784_a.get(string)).func_150286_g();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    public String func_74779_i(String string) {
        try {
            if (this.func_150297_b(string, 8)) {
                return this.field_74784_a.get(string).func_150285_a_();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public byte[] func_74770_j(String string) {
        try {
            if (this.func_150297_b(string, 7)) {
                return ((NBTTagByteArray)this.field_74784_a.get(string)).func_150292_c();
            }
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.func_82581_a(string, 7, classCastException));
        }
        return new byte[0];
    }

    public int[] func_74759_k(String string) {
        try {
            if (this.func_150297_b(string, 11)) {
                return ((NBTTagIntArray)this.field_74784_a.get(string)).func_150302_c();
            }
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.func_82581_a(string, 11, classCastException));
        }
        return new int[0];
    }

    public long[] func_197645_o(String string) {
        try {
            if (this.func_150297_b(string, 12)) {
                return ((NBTTagLongArray)this.field_74784_a.get(string)).func_197652_h();
            }
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.func_82581_a(string, 12, classCastException));
        }
        return new long[0];
    }

    public NBTTagCompound func_74775_l(String string) {
        try {
            if (this.func_150297_b(string, 10)) {
                return (NBTTagCompound)this.field_74784_a.get(string);
            }
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.func_82581_a(string, 10, classCastException));
        }
        return new NBTTagCompound();
    }

    public NBTTagList func_150295_c(String string, int n) {
        try {
            if (this.func_150299_b(string) == 9) {
                NBTTagList nBTTagList = (NBTTagList)this.field_74784_a.get(string);
                if (nBTTagList.isEmpty() || nBTTagList.func_150303_d() == n) {
                    return nBTTagList;
                }
                return new NBTTagList();
            }
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.func_82581_a(string, 9, classCastException));
        }
        return new NBTTagList();
    }

    public boolean func_74767_n(String string) {
        return this.func_74771_c(string) != 0;
    }

    public void func_82580_o(String string) {
        this.field_74784_a.remove(string);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        Collection<String> \u26032 = this.field_74784_a.keySet();
        if (field_191551_b.isDebugEnabled()) {
            ArrayList arrayList = Lists.newArrayList(this.field_74784_a.keySet());
            Collections.sort(arrayList);
            \u26032 = arrayList;
        }
        for (String string : \u26032) {
            if (stringBuilder.length() != 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append(NBTTagCompound.func_193582_s(string)).append(':').append(this.field_74784_a.get(string));
        }
        return stringBuilder.append('}').toString();
    }

    public boolean isEmpty() {
        return this.field_74784_a.isEmpty();
    }

    private CrashReport func_82581_a(String string, int n, ClassCastException classCastException) {
        CrashReport crashReport = CrashReport.func_85055_a(classCastException, "Reading NBT data");
        CrashReportCategory \u26032 = crashReport.func_85057_a("Corrupt NBT tag", 1);
        \u26032.func_189529_a("Tag type found", () -> field_82578_b[this.field_74784_a.get(string).func_74732_a()]);
        \u26032.func_189529_a("Tag type expected", () -> field_82578_b[n]);
        \u26032.func_71507_a("Tag name", string);
        return crashReport;
    }

    @Override
    public NBTTagCompound func_74737_b() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        for (String string : this.field_74784_a.keySet()) {
            nBTTagCompound.func_74782_a(string, this.field_74784_a.get(string).func_74737_b());
        }
        return nBTTagCompound;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof NBTTagCompound && Objects.equals(this.field_74784_a, ((NBTTagCompound)object).field_74784_a);
    }

    public int hashCode() {
        return this.field_74784_a.hashCode();
    }

    private static void func_150298_a(String string, INBTBase iNBTBase, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(iNBTBase.func_74732_a());
        if (iNBTBase.func_74732_a() == 0) {
            return;
        }
        dataOutput.writeUTF(string);
        iNBTBase.func_74734_a(dataOutput);
    }

    private static byte func_152447_a(DataInput dataInput, NBTSizeTracker nBTSizeTracker) throws IOException {
        return dataInput.readByte();
    }

    private static String func_152448_b(DataInput dataInput, NBTSizeTracker nBTSizeTracker) throws IOException {
        return dataInput.readUTF();
    }

    static INBTBase func_152449_a(byte by, String string, DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) throws IOException {
        INBTBase iNBTBase = INBTBase.func_150284_a(by);
        try {
            iNBTBase.func_152446_a(dataInput, n, nBTSizeTracker);
        }
        catch (IOException \u26032) {
            CrashReport crashReport = CrashReport.func_85055_a(\u26032, "Loading NBT data");
            CrashReportCategory \u26033 = crashReport.func_85058_a("NBT Tag");
            \u26033.func_71507_a("Tag name", string);
            \u26033.func_71507_a("Tag type", by);
            throw new ReportedException(crashReport);
        }
        return iNBTBase;
    }

    public NBTTagCompound func_197643_a(NBTTagCompound nBTTagCompound) {
        for (String string2 : nBTTagCompound.field_74784_a.keySet()) {
            String string2;
            INBTBase iNBTBase = nBTTagCompound.field_74784_a.get(string2);
            if (iNBTBase.func_74732_a() == 10) {
                if (this.func_150297_b(string2, 10)) {
                    NBTTagCompound nBTTagCompound2 = this.func_74775_l(string2);
                    nBTTagCompound2.func_197643_a((NBTTagCompound)iNBTBase);
                    continue;
                }
                this.func_74782_a(string2, iNBTBase.func_74737_b());
                continue;
            }
            this.func_74782_a(string2, iNBTBase.func_74737_b());
        }
        return this;
    }

    protected static String func_193582_s(String string) {
        if (field_193583_c.matcher(string).matches()) {
            return string;
        }
        return NBTTagString.func_197654_a(string, true);
    }

    protected static ITextComponent func_197642_t(String string) {
        if (field_193583_c.matcher(string).matches()) {
            return new TextComponentString(string).func_211708_a(field_197638_b);
        }
        ITextComponent iTextComponent = new TextComponentString(NBTTagString.func_197654_a(string, false)).func_211708_a(field_197638_b);
        return new TextComponentString("\"").func_150257_a(iTextComponent).func_150258_a("\"");
    }

    @Override
    public ITextComponent func_199850_a(String string2, int n) {
        String string2;
        Object \u26033;
        if (this.field_74784_a.isEmpty()) {
            return new TextComponentString("{}");
        }
        TextComponentString textComponentString = new TextComponentString("{");
        Object \u26032 = this.field_74784_a.keySet();
        if (field_191551_b.isDebugEnabled()) {
            \u26033 = Lists.newArrayList(this.field_74784_a.keySet());
            Collections.sort(\u26033);
            \u26032 = \u26033;
        }
        if (!string2.isEmpty()) {
            textComponentString.func_150258_a("\n");
        }
        \u26033 = \u26032.iterator();
        while (\u26033.hasNext()) {
            \u2603 = (String)\u26033.next();
            ITextComponent iTextComponent = new TextComponentString(Strings.repeat((String)string2, (int)(n + 1))).func_150257_a(NBTTagCompound.func_197642_t(\u2603)).func_150258_a(String.valueOf(':')).func_150258_a(" ").func_150257_a(this.field_74784_a.get(\u2603).func_199850_a(string2, n + 1));
            if (\u26033.hasNext()) {
                iTextComponent.func_150258_a(String.valueOf(',')).func_150258_a(string2.isEmpty() ? " " : "\n");
            }
            textComponentString.func_150257_a(iTextComponent);
        }
        if (!string2.isEmpty()) {
            textComponentString.func_150258_a("\n").func_150258_a(Strings.repeat((String)string2, (int)n));
        }
        textComponentString.func_150258_a("}");
        return textComponentString;
    }

    @Override
    public /* synthetic */ INBTBase func_74737_b() {
        return this.func_74737_b();
    }
}

