/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.item.crafting.RecipeSerializers;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ShapelessRecipe
implements IRecipe {
    private final ResourceLocation field_199562_a;
    private final String field_194138_c;
    private final ItemStack field_77580_a;
    private final NonNullList<Ingredient> field_77579_b;

    public ShapelessRecipe(ResourceLocation resourceLocation, String string, ItemStack itemStack, NonNullList<Ingredient> nonNullList) {
        this.field_199562_a = resourceLocation;
        this.field_194138_c = string;
        this.field_77580_a = itemStack;
        this.field_77579_b = nonNullList;
    }

    @Override
    public ResourceLocation func_199560_c() {
        return this.field_199562_a;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.field_199576_b;
    }

    @Override
    public ItemStack func_77571_b() {
        return this.field_77580_a;
    }

    @Override
    public NonNullList<Ingredient> func_192400_c() {
        return this.field_77579_b;
    }

    @Override
    public boolean func_77569_a(IInventory iInventory, World world) {
        if (!(iInventory instanceof InventoryCrafting)) {
            return false;
        }
        RecipeItemHelper recipeItemHelper = new RecipeItemHelper();
        int \u26032 = 0;
        for (int i = 0; i < iInventory.func_174923_h(); ++i) {
            for (\u2603 = 0; \u2603 < iInventory.func_174922_i(); ++\u2603) {
                ItemStack itemStack = iInventory.func_70301_a(\u2603 + i * iInventory.func_174922_i());
                if (itemStack.func_190926_b()) continue;
                ++\u26032;
                recipeItemHelper.func_194112_a(new ItemStack(itemStack.func_77973_b()));
            }
        }
        return \u26032 == this.field_77579_b.size() && recipeItemHelper.func_194116_a(this, null);
    }

    @Override
    public ItemStack func_77572_b(IInventory iInventory) {
        return this.field_77580_a.func_77946_l();
    }

    public static class Serializer
    implements IRecipeSerializer<ShapelessRecipe> {
        @Override
        public ShapelessRecipe func_199425_a_(ResourceLocation resourceLocation, JsonObject jsonObject) {
            String string = JsonUtils.func_151219_a(jsonObject, "group", "");
            NonNullList<Ingredient> \u26032 = Serializer.func_199568_a(JsonUtils.func_151214_t(jsonObject, "ingredients"));
            if (\u26032.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (\u26032.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            ItemStack \u26033 = ShapedRecipe.func_199798_a(JsonUtils.func_152754_s(jsonObject, "result"));
            return new ShapelessRecipe(resourceLocation, string, \u26033, \u26032);
        }

        private static NonNullList<Ingredient> func_199568_a(JsonArray jsonArray) {
            NonNullList<Ingredient> nonNullList = NonNullList.func_191196_a();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a(jsonArray.get(i));
                if (ingredient.func_203189_d()) continue;
                nonNullList.add(ingredient);
            }
            return nonNullList;
        }

        @Override
        public String func_199567_a() {
            return "crafting_shapeless";
        }

        @Override
        public ShapelessRecipe func_199426_a_(ResourceLocation resourceLocation, PacketBuffer packetBuffer2) {
            PacketBuffer packetBuffer2;
            String string = packetBuffer2.func_150789_c(Short.MAX_VALUE);
            int \u26032 = packetBuffer2.func_150792_a();
            NonNullList<Ingredient> \u26033 = NonNullList.func_191197_a(\u26032, Ingredient.field_193370_a);
            for (int i = 0; i < \u26033.size(); ++i) {
                \u26033.set(i, Ingredient.func_199566_b(packetBuffer2));
            }
            ItemStack \u26034 = packetBuffer2.func_150791_c();
            return new ShapelessRecipe(resourceLocation, string, \u26034, \u26033);
        }

        @Override
        public void func_199427_a_(PacketBuffer packetBuffer2, ShapelessRecipe shapelessRecipe) {
            PacketBuffer packetBuffer2;
            packetBuffer2.func_180714_a(shapelessRecipe.field_194138_c);
            packetBuffer2.func_150787_b(shapelessRecipe.field_77579_b.size());
            for (Ingredient ingredient : shapelessRecipe.field_77579_b) {
                ingredient.func_199564_a(packetBuffer2);
            }
            packetBuffer2.func_150788_a(shapelessRecipe.field_77580_a);
        }

        @Override
        public /* synthetic */ IRecipe func_199426_a_(ResourceLocation resourceLocation, PacketBuffer packetBuffer) {
            return this.func_199426_a_(resourceLocation, packetBuffer);
        }

        @Override
        public /* synthetic */ IRecipe func_199425_a_(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return this.func_199425_a_(resourceLocation, jsonObject);
        }
    }
}

