/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.item.crafting.BannerAddPatternRecipe;
import net.minecraft.item.crafting.BannerDuplicateRecipe;
import net.minecraft.item.crafting.FireworkRocketRecipe;
import net.minecraft.item.crafting.FireworkStarFadeRecipe;
import net.minecraft.item.crafting.FireworkStarRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.RecipeBookCloning;
import net.minecraft.item.crafting.RecipeRepairItem;
import net.minecraft.item.crafting.RecipeTippedArrow;
import net.minecraft.item.crafting.RecipesArmorDyes;
import net.minecraft.item.crafting.RecipesMapCloning;
import net.minecraft.item.crafting.RecipesMapExtending;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.item.crafting.ShieldRecipes;
import net.minecraft.item.crafting.ShulkerBoxColoringRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class RecipeSerializers {
    private static final Map<String, IRecipeSerializer<?>> field_199590_p = Maps.newHashMap();
    public static final IRecipeSerializer<ShapedRecipe> field_199575_a = RecipeSerializers.func_199573_a(new ShapedRecipe.Serializer());
    public static final IRecipeSerializer<ShapelessRecipe> field_199576_b = RecipeSerializers.func_199573_a(new ShapelessRecipe.Serializer());
    public static final SimpleSerializer<RecipesArmorDyes> field_199577_c = RecipeSerializers.func_199573_a(new SimpleSerializer<RecipesArmorDyes>("crafting_special_armordye", RecipesArmorDyes::new));
    public static final SimpleSerializer<RecipeBookCloning> field_199578_d = RecipeSerializers.func_199573_a(new SimpleSerializer<RecipeBookCloning>("crafting_special_bookcloning", RecipeBookCloning::new));
    public static final SimpleSerializer<RecipesMapCloning> field_199579_e = RecipeSerializers.func_199573_a(new SimpleSerializer<RecipesMapCloning>("crafting_special_mapcloning", RecipesMapCloning::new));
    public static final SimpleSerializer<RecipesMapExtending> field_199580_f = RecipeSerializers.func_199573_a(new SimpleSerializer<RecipesMapExtending>("crafting_special_mapextending", RecipesMapExtending::new));
    public static final SimpleSerializer<FireworkRocketRecipe> field_199581_g = RecipeSerializers.func_199573_a(new SimpleSerializer<FireworkRocketRecipe>("crafting_special_firework_rocket", FireworkRocketRecipe::new));
    public static final SimpleSerializer<FireworkStarRecipe> field_199582_h = RecipeSerializers.func_199573_a(new SimpleSerializer<FireworkStarRecipe>("crafting_special_firework_star", FireworkStarRecipe::new));
    public static final SimpleSerializer<FireworkStarFadeRecipe> field_199583_i = RecipeSerializers.func_199573_a(new SimpleSerializer<FireworkStarFadeRecipe>("crafting_special_firework_star_fade", FireworkStarFadeRecipe::new));
    public static final SimpleSerializer<RecipeRepairItem> field_199584_j = RecipeSerializers.func_199573_a(new SimpleSerializer<RecipeRepairItem>("crafting_special_repairitem", RecipeRepairItem::new));
    public static final SimpleSerializer<RecipeTippedArrow> field_199585_k = RecipeSerializers.func_199573_a(new SimpleSerializer<RecipeTippedArrow>("crafting_special_tippedarrow", RecipeTippedArrow::new));
    public static final SimpleSerializer<BannerDuplicateRecipe> field_199586_l = RecipeSerializers.func_199573_a(new SimpleSerializer<BannerDuplicateRecipe>("crafting_special_bannerduplicate", BannerDuplicateRecipe::new));
    public static final SimpleSerializer<BannerAddPatternRecipe> field_199587_m = RecipeSerializers.func_199573_a(new SimpleSerializer<BannerAddPatternRecipe>("crafting_special_banneraddpattern", BannerAddPatternRecipe::new));
    public static final SimpleSerializer<ShieldRecipes> field_199588_n = RecipeSerializers.func_199573_a(new SimpleSerializer<ShieldRecipes>("crafting_special_shielddecoration", ShieldRecipes::new));
    public static final SimpleSerializer<ShulkerBoxColoringRecipe> field_199589_o = RecipeSerializers.func_199573_a(new SimpleSerializer<ShulkerBoxColoringRecipe>("crafting_special_shulkerboxcoloring", ShulkerBoxColoringRecipe::new));
    public static final IRecipeSerializer<FurnaceRecipe> field_201839_p = RecipeSerializers.func_199573_a(new FurnaceRecipe.Serializer());

    public static <S extends IRecipeSerializer<T>, T extends IRecipe> S func_199573_a(S s) {
        if (field_199590_p.containsKey(s.func_199567_a())) {
            throw new IllegalArgumentException("Duplicate recipe serializer " + s.func_199567_a());
        }
        field_199590_p.put(s.func_199567_a(), s);
        return s;
    }

    public static IRecipe func_199572_a(ResourceLocation resourceLocation, JsonObject jsonObject) {
        String string = JsonUtils.func_151200_h(jsonObject, "type");
        IRecipeSerializer<?> \u26032 = field_199590_p.get(string);
        if (\u26032 == null) {
            throw new JsonSyntaxException("Invalid or unsupported recipe type '" + string + "'");
        }
        return \u26032.func_199425_a_(resourceLocation, jsonObject);
    }

    public static IRecipe func_199571_a(PacketBuffer packetBuffer) {
        ResourceLocation resourceLocation = packetBuffer.func_192575_l();
        String \u26032 = packetBuffer.func_150789_c(Short.MAX_VALUE);
        IRecipeSerializer<?> \u26033 = field_199590_p.get(\u26032);
        if (\u26033 == null) {
            throw new IllegalArgumentException("Unknown recipe serializer " + \u26032);
        }
        return \u26033.func_199426_a_(resourceLocation, packetBuffer);
    }

    public static <T extends IRecipe> void func_199574_a(T t, PacketBuffer packetBuffer) {
        packetBuffer.func_192572_a(t.func_199560_c());
        packetBuffer.func_180714_a(t.func_199559_b().func_199567_a());
        IRecipeSerializer<?> iRecipeSerializer = t.func_199559_b();
        iRecipeSerializer.func_199427_a_(packetBuffer, t);
    }

    public static final class SimpleSerializer<T extends IRecipe>
    implements IRecipeSerializer<T> {
        private final String field_199569_a;
        private final Function<ResourceLocation, T> field_199570_b;

        public SimpleSerializer(String string, Function<ResourceLocation, T> function) {
            this.field_199569_a = string;
            this.field_199570_b = function;
        }

        @Override
        public T func_199425_a_(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return (T)((IRecipe)this.field_199570_b.apply(resourceLocation));
        }

        @Override
        public T func_199426_a_(ResourceLocation resourceLocation, PacketBuffer packetBuffer) {
            return (T)((IRecipe)this.field_199570_b.apply(resourceLocation));
        }

        @Override
        public void func_199427_a_(PacketBuffer packetBuffer, T t) {
        }

        @Override
        public String func_199567_a() {
            return this.field_199569_a;
        }
    }
}

