/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeSerializers;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeManager
implements IResourceManagerReloadListener {
    private static final Logger field_199521_c = LogManager.getLogger();
    public static final int field_199519_a = "recipes/".length();
    public static final int field_199520_b = ".json".length();
    private final Map<ResourceLocation, IRecipe> field_199522_d = Maps.newHashMap();
    private boolean field_199523_e;

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        this.field_199523_e = false;
        this.field_199522_d.clear();
        for (ResourceLocation resourceLocation : iResourceManager.func_199003_a("recipes", string -> string.endsWith(".json"))) {
            String string2 = resourceLocation.func_110623_a();
            ResourceLocation \u26032 = new ResourceLocation(resourceLocation.func_110624_b(), string2.substring(field_199519_a, string2.length() - field_199520_b));
            try {
                IResource iResource = iResourceManager.func_199002_a(resourceLocation);
                Throwable throwable = null;
                try {
                    JsonObject jsonObject = JsonUtils.func_188178_a(gson, IOUtils.toString((InputStream)iResource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                    if (jsonObject == null) {
                        field_199521_c.error("Couldn't load recipe {} as it's null or empty", (Object)\u26032);
                        continue;
                    }
                    this.func_199509_a(RecipeSerializers.func_199572_a(\u26032, jsonObject));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iResource == null) continue;
                    if (throwable != null) {
                        try {
                            iResource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iResource.close();
                }
            }
            catch (JsonParseException | IllegalArgumentException throwable) {
                field_199521_c.error("Parsing error loading recipe {}", (Object)\u26032, (Object)throwable);
                this.field_199523_e = true;
            }
            catch (IOException iOException) {
                field_199521_c.error("Couldn't read custom advancement {} from {}", (Object)\u26032, (Object)resourceLocation, (Object)iOException);
                this.field_199523_e = true;
            }
        }
        field_199521_c.info("Loaded {} recipes", (Object)this.field_199522_d.size());
    }

    public void func_199509_a(IRecipe iRecipe) {
        if (this.field_199522_d.containsKey(iRecipe.func_199560_c())) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + iRecipe.func_199560_c());
        }
        this.field_199522_d.put(iRecipe.func_199560_c(), iRecipe);
    }

    public ItemStack func_199514_a(IInventory iInventory, World world) {
        for (IRecipe iRecipe : this.field_199522_d.values()) {
            if (!iRecipe.func_77569_a(iInventory, world)) continue;
            return iRecipe.func_77572_b(iInventory);
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public IRecipe func_199515_b(IInventory iInventory, World world) {
        for (IRecipe iRecipe : this.field_199522_d.values()) {
            if (!iRecipe.func_77569_a(iInventory, world)) continue;
            return iRecipe;
        }
        return null;
    }

    public NonNullList<ItemStack> func_199513_c(IInventory iInventory2, World world) {
        IInventory iInventory2;
        for (IRecipe iRecipe : this.field_199522_d.values()) {
            if (!iRecipe.func_77569_a(iInventory2, world)) continue;
            return iRecipe.func_179532_b(iInventory2);
        }
        NonNullList<ItemStack> \u26032 = NonNullList.func_191197_a(iInventory2.func_70302_i_(), ItemStack.field_190927_a);
        for (int i = 0; i < \u26032.size(); ++i) {
            \u26032.set(i, iInventory2.func_70301_a(i));
        }
        return \u26032;
    }

    @Nullable
    public IRecipe func_199517_a(ResourceLocation resourceLocation) {
        return this.field_199522_d.get(resourceLocation);
    }

    public Collection<IRecipe> func_199510_b() {
        return this.field_199522_d.values();
    }

    public Collection<ResourceLocation> func_199511_c() {
        return this.field_199522_d.keySet();
    }
}

