/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.fluid;

import java.util.Random;
import net.minecraft.block.BlockFlowingFluid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public abstract class LavaFluid
extends FlowingFluid {
    @Override
    public Fluid func_210197_e() {
        return Fluids.field_207213_d;
    }

    @Override
    public Fluid func_210198_f() {
        return Fluids.field_204547_b;
    }

    @Override
    public Item func_204524_b() {
        return Items.field_151129_at;
    }

    @Override
    public void func_207186_b(World world, BlockPos blockPos, IFluidState iFluidState, Random random) {
        if (!world.func_82736_K().func_82766_b("doFireTick")) {
            return;
        }
        int n = random.nextInt(3);
        if (n > 0) {
            BlockPos blockPos2 = blockPos;
            for (int i = 0; i < n; ++i) {
                if (!world.func_195588_v(blockPos2 = blockPos2.func_177982_a(random.nextInt(3) - 1, 1, random.nextInt(3) - 1))) {
                    return;
                }
                IBlockState iBlockState = world.func_180495_p(blockPos2);
                if (iBlockState.func_196958_f()) {
                    if (!this.func_176369_e(world, blockPos2)) continue;
                    world.func_175656_a(blockPos2, Blocks.field_150480_ab.func_176223_P());
                    return;
                }
                if (!iBlockState.func_185904_a().func_76230_c()) continue;
                return;
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                BlockPos blockPos3 = blockPos.func_177982_a(random.nextInt(3) - 1, 0, random.nextInt(3) - 1);
                if (!world.func_195588_v(blockPos3)) {
                    return;
                }
                if (!world.func_175623_d(blockPos3.func_177984_a()) || !this.func_176368_m(world, blockPos3)) continue;
                world.func_175656_a(blockPos3.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    private boolean func_176369_e(IWorldReaderBase iWorldReaderBase, BlockPos blockPos) {
        for (EnumFacing enumFacing : EnumFacing.values()) {
            if (!this.func_176368_m(iWorldReaderBase, blockPos.func_177972_a(enumFacing))) continue;
            return true;
        }
        return false;
    }

    private boolean func_176368_m(IWorldReaderBase iWorldReaderBase, BlockPos blockPos) {
        if (blockPos.func_177956_o() >= 0 && blockPos.func_177956_o() < 256 && !iWorldReaderBase.func_175667_e(blockPos)) {
            return false;
        }
        return iWorldReaderBase.func_180495_p(blockPos).func_185904_a().func_76217_h();
    }

    @Override
    protected void func_205580_a(IWorld iWorld, BlockPos blockPos, IBlockState iBlockState) {
        this.func_205581_a(iWorld, blockPos);
    }

    @Override
    public int func_185698_b(IWorldReaderBase iWorldReaderBase) {
        return iWorldReaderBase.func_201675_m().func_177500_n() ? 4 : 2;
    }

    @Override
    public IBlockState func_204527_a(IFluidState iFluidState) {
        return (IBlockState)Blocks.field_150353_l.func_176223_P().func_206870_a(BlockFlowingFluid.field_176367_b, LavaFluid.func_207205_e(iFluidState));
    }

    @Override
    public boolean func_207187_a(Fluid fluid) {
        return fluid == Fluids.field_204547_b || fluid == Fluids.field_207213_d;
    }

    @Override
    public int func_204528_b(IWorldReaderBase iWorldReaderBase) {
        return iWorldReaderBase.func_201675_m().func_177500_n() ? 1 : 2;
    }

    @Override
    public boolean func_211757_a(IFluidState iFluidState, Fluid fluid, EnumFacing enumFacing) {
        return iFluidState.func_206885_f() >= 0.44444445f && fluid.func_207185_a(FluidTags.field_206959_a);
    }

    @Override
    public int func_205569_a(IWorldReaderBase iWorldReaderBase) {
        return iWorldReaderBase.func_201675_m().func_177495_o() ? 10 : 30;
    }

    @Override
    public int func_205578_a(World world, IFluidState iFluidState, IFluidState iFluidState2) {
        int n = this.func_205569_a(world);
        if (!(iFluidState.func_206888_e() || iFluidState2.func_206888_e() || iFluidState.func_177229_b(field_207209_a).booleanValue() || iFluidState2.func_177229_b(field_207209_a).booleanValue() || !(iFluidState2.func_206885_f() > iFluidState.func_206885_f()) || world.func_201674_k().nextInt(4) == 0)) {
            n *= 4;
        }
        return n;
    }

    protected void func_205581_a(IWorld iWorld, BlockPos blockPos) {
        double d = blockPos.func_177958_n();
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p();
        iWorld.func_184133_a(null, blockPos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (iWorld.func_201674_k().nextFloat() - iWorld.func_201674_k().nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            iWorld.func_195594_a(Particles.field_197594_E, d + Math.random(), \u2603 + 1.2, \u2603 + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected boolean func_205579_d() {
        return false;
    }

    @Override
    protected void func_205574_a(IWorld iWorld, BlockPos blockPos, IBlockState iBlockState, EnumFacing enumFacing, IFluidState iFluidState) {
        if (enumFacing == EnumFacing.DOWN) {
            \u2603 = iWorld.func_204610_c(blockPos);
            if (this.func_207185_a(FluidTags.field_206960_b) && \u2603.func_206884_a(FluidTags.field_206959_a)) {
                if (iBlockState.func_177230_c() instanceof BlockFlowingFluid) {
                    iWorld.func_180501_a(blockPos, Blocks.field_150348_b.func_176223_P(), 3);
                }
                this.func_205581_a(iWorld, blockPos);
                return;
            }
        }
        super.func_205574_a(iWorld, blockPos, iBlockState, enumFacing, iFluidState);
    }

    @Override
    protected boolean func_207196_h() {
        return true;
    }

    @Override
    protected float func_210195_d() {
        return 100.0f;
    }

    public static class Flowing
    extends LavaFluid {
        @Override
        protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(field_207210_b);
        }

        @Override
        public int func_207192_d(IFluidState iFluidState) {
            return iFluidState.func_177229_b(field_207210_b);
        }

        @Override
        public boolean func_207193_c(IFluidState iFluidState) {
            return false;
        }
    }

    public static class Source
    extends LavaFluid {
        @Override
        public int func_207192_d(IFluidState iFluidState) {
            return 8;
        }

        @Override
        public boolean func_207193_c(IFluidState iFluidState) {
            return true;
        }
    }
}

