/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public abstract class EntityArrow
extends Entity
implements IProjectile {
    private static final Predicate<Entity> field_184553_f = EntitySelectors.field_180132_d.and(EntitySelectors.field_94557_a.and(Entity::func_70067_L));
    private static final DataParameter<Byte> field_184554_g = EntityDataManager.func_187226_a(EntityArrow.class, DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<UUID>> field_212362_a = EntityDataManager.func_187226_a(EntityArrow.class, DataSerializers.field_187203_m);
    private int field_145791_d = -1;
    private int field_145792_e = -1;
    private int field_145789_f = -1;
    @Nullable
    private IBlockState field_195056_av;
    protected boolean field_70254_i;
    protected int field_184552_b;
    public PickupStatus field_70251_a = PickupStatus.DISALLOWED;
    public int field_70249_b;
    public UUID field_70250_c;
    private int field_70252_j;
    private int field_70257_an;
    private double field_70255_ao = 2.0;
    private int field_70256_ap;

    protected EntityArrow(EntityType<?> entityType, World world) {
        super(entityType, world);
        this.func_70105_a(0.5f, 0.5f);
    }

    protected EntityArrow(EntityType<?> entityType, double d, double d2, double d3, World world) {
        this(entityType, world);
        this.func_70107_b(d, d2, d3);
    }

    protected EntityArrow(EntityType<?> entityType, EntityLivingBase entityLivingBase, World world) {
        this(entityType, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u + (double)entityLivingBase.func_70047_e() - (double)0.1f, entityLivingBase.field_70161_v, world);
        this.func_212361_a(entityLivingBase);
        if (entityLivingBase instanceof EntityPlayer) {
            this.field_70251_a = PickupStatus.ALLOWED;
        }
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184554_g, (byte)0);
        this.field_70180_af.func_187214_a(field_212362_a, Optional.empty());
    }

    public void func_184547_a(Entity entity, float f, float f2, float f3, float f4, float f5) {
        \u2603 = -MathHelper.func_76126_a(f2 * ((float)Math.PI / 180)) * MathHelper.func_76134_b(f * ((float)Math.PI / 180));
        \u2603 = -MathHelper.func_76126_a(f * ((float)Math.PI / 180));
        \u2603 = MathHelper.func_76134_b(f2 * ((float)Math.PI / 180)) * MathHelper.func_76134_b(f * ((float)Math.PI / 180));
        this.func_70186_c(\u2603, \u2603, \u2603, f4, f5);
        this.field_70159_w += entity.field_70159_w;
        this.field_70179_y += entity.field_70179_y;
        if (!entity.field_70122_E) {
            this.field_70181_x += entity.field_70181_x;
        }
    }

    @Override
    public void func_70186_c(double d, double d2, double d3, float f, float f2) {
        \u2603 = MathHelper.func_76133_a(d * d + d2 * d2 + d3 * d3);
        d /= (double)\u2603;
        d2 /= (double)\u2603;
        d3 /= (double)\u2603;
        d += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f2;
        d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f2;
        d3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f2;
        this.field_70159_w = d *= (double)f;
        this.field_70181_x = d2 *= (double)f;
        this.field_70179_y = d3 *= (double)f;
        \u2603 = MathHelper.func_76133_a(d * d + d3 * d3);
        this.field_70177_z = (float)(MathHelper.func_181159_b(d, d3) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b(d2, \u2603) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.field_70252_j = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void func_70071_h_() {
        void var6_12;
        void var6_10;
        VoxelShape \u26032;
        BlockPos blockPos;
        IBlockState iBlockState;
        super.func_70071_h_();
        boolean bl = this.func_203047_q();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f2 = MathHelper.func_76133_a(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            this.field_70177_z = (float)(MathHelper.func_181159_b(this.field_70159_w, this.field_70179_y) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b(this.field_70181_x, f2) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((iBlockState = this.field_70170_p.func_180495_p(blockPos = new BlockPos(this.field_145791_d, this.field_145792_e, this.field_145789_f))).func_196958_f() || bl || (\u26032 = iBlockState.func_196952_d(this.field_70170_p, blockPos)).func_197766_b())) {
            for (AxisAlignedBB axisAlignedBB : \u26032.func_197756_d()) {
                if (!axisAlignedBB.func_186670_a(blockPos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) continue;
                this.field_70254_i = true;
                break;
            }
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.field_70254_i && !bl) {
            if (this.field_195056_av != iBlockState && this.field_70170_p.func_195586_b(null, this.func_174813_aQ().func_186662_g(0.05))) {
                this.field_70254_i = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70252_j = 0;
                this.field_70257_an = 0;
            } else {
                this.func_203048_f();
            }
            ++this.field_184552_b;
            return;
        }
        this.field_184552_b = 0;
        ++this.field_70257_an;
        Vec3d \u26034 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d \u26033 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult rayTraceResult = this.field_70170_p.func_200259_a(\u26034, \u26033, RayTraceFluidMode.NEVER, true, false);
        \u26034 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        \u26033 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (rayTraceResult != null) {
            \u26033 = new Vec3d(rayTraceResult.field_72307_f.field_72450_a, rayTraceResult.field_72307_f.field_72448_b, rayTraceResult.field_72307_f.field_72449_c);
        }
        if ((\u2603 = this.func_184551_a(\u26034, \u26033)) != null) {
            RayTraceResult rayTraceResult2 = new RayTraceResult(\u2603);
        }
        if (var6_10 != null && var6_10.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)var6_10.field_72308_g;
            Entity \u26035 = this.func_212360_k();
            if (\u26035 instanceof EntityPlayer && !((EntityPlayer)\u26035).func_96122_a(entityPlayer)) {
                Object var6_11 = null;
            }
        }
        if (var6_12 != null && !bl) {
            this.func_184549_a((RayTraceResult)var6_12);
            this.field_70160_al = true;
        }
        if (this.func_70241_g()) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_195594_a(Particles.field_197614_g, this.field_70165_t + this.field_70159_w * (double)i / 4.0, this.field_70163_u + this.field_70181_x * (double)i / 4.0, this.field_70161_v + this.field_70179_y * (double)i / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f3 = MathHelper.func_76133_a(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        this.field_70177_z = bl ? (float)(MathHelper.func_181159_b(-this.field_70159_w, -this.field_70179_y) * 57.2957763671875) : (float)(MathHelper.func_181159_b(this.field_70159_w, this.field_70179_y) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b(this.field_70181_x, f3) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f = 0.99f;
        float \u26036 = 0.05f;
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f4 = 0.25f;
                this.field_70170_p.func_195594_a(Particles.field_197612_e, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            f = this.func_203044_p();
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)f;
        this.field_70179_y *= (double)f;
        if (!this.func_189652_ae() && !bl) {
            this.field_70181_x -= (double)0.05f;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    protected void func_203048_f() {
        ++this.field_70252_j;
        if (this.field_70252_j >= 1200) {
            this.func_70106_y();
        }
    }

    protected void func_184549_a(RayTraceResult rayTraceResult) {
        if (rayTraceResult.field_72308_g != null) {
            this.func_203046_b(rayTraceResult);
        } else {
            BlockPos blockPos = rayTraceResult.func_178782_a();
            this.field_145791_d = blockPos.func_177958_n();
            this.field_145792_e = blockPos.func_177956_o();
            this.field_145789_f = blockPos.func_177952_p();
            this.field_195056_av = \u2603 = this.field_70170_p.func_180495_p(blockPos);
            this.field_70159_w = (float)(rayTraceResult.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(rayTraceResult.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(rayTraceResult.field_72307_f.field_72449_c - this.field_70161_v);
            float \u26032 = MathHelper.func_76133_a(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y) * 20.0f;
            this.field_70165_t -= this.field_70159_w / (double)\u26032;
            this.field_70163_u -= this.field_70181_x / (double)\u26032;
            this.field_70161_v -= this.field_70179_y / (double)\u26032;
            this.func_184185_a(this.func_203050_i(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.field_70254_i = true;
            this.field_70249_b = 7;
            this.func_70243_d(false);
            if (!\u2603.func_196958_f()) {
                this.field_195056_av.func_196950_a(this.field_70170_p, blockPos, this);
            }
        }
    }

    protected void func_203046_b(RayTraceResult rayTraceResult) {
        Entity entity = rayTraceResult.field_72308_g;
        float \u26032 = MathHelper.func_76133_a(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
        int \u26033 = MathHelper.func_76143_f((double)\u26032 * this.field_70255_ao);
        if (this.func_70241_g()) {
            \u26033 += this.field_70146_Z.nextInt(\u26033 / 2 + 2);
        }
        DamageSource \u26034 = (\u2603 = this.func_212360_k()) == null ? DamageSource.func_76353_a(this, this) : DamageSource.func_76353_a(this, \u2603);
        if (this.func_70027_ad() && !(entity instanceof EntityEnderman)) {
            entity.func_70015_d(5);
        }
        if (entity.func_70097_a(\u26034, \u26033)) {
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
                if (!this.field_70170_p.field_72995_K) {
                    entityLivingBase.func_85034_r(entityLivingBase.func_85035_bI() + 1);
                }
                if (this.field_70256_ap > 0 && (\u2603 = MathHelper.func_76133_a(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > 0.0f) {
                    entityLivingBase.func_70024_g(this.field_70159_w * (double)this.field_70256_ap * (double)0.6f / (double)\u2603, 0.1, this.field_70179_y * (double)this.field_70256_ap * (double)0.6f / (double)\u2603);
                }
                if (\u2603 instanceof EntityLivingBase) {
                    EnchantmentHelper.func_151384_a(entityLivingBase, \u2603);
                    EnchantmentHelper.func_151385_b((EntityLivingBase)\u2603, entityLivingBase);
                }
                this.func_184548_a(entityLivingBase);
                if (\u2603 != null && entityLivingBase != \u2603 && entityLivingBase instanceof EntityPlayer && \u2603 instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)\u2603).field_71135_a.func_147359_a(new SPacketChangeGameState(6, 0.0f));
                }
            }
            this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (!(entity instanceof EntityEnderman)) {
                this.func_70106_y();
            }
        } else {
            this.field_70159_w *= (double)-0.1f;
            this.field_70181_x *= (double)-0.1f;
            this.field_70179_y *= (double)-0.1f;
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            this.field_70257_an = 0;
            if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < (double)0.001f) {
                if (this.field_70251_a == PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            }
        }
    }

    protected SoundEvent func_203050_i() {
        return SoundEvents.field_187731_t;
    }

    @Override
    public void func_70091_d(MoverType moverType, double d, double d2, double d3) {
        super.func_70091_d(moverType, d, d2, d3);
        if (this.field_70254_i) {
            this.field_145791_d = MathHelper.func_76128_c(this.field_70165_t);
            this.field_145792_e = MathHelper.func_76128_c(this.field_70163_u);
            this.field_145789_f = MathHelper.func_76128_c(this.field_70161_v);
        }
    }

    protected void func_184548_a(EntityLivingBase entityLivingBase) {
    }

    @Nullable
    protected Entity func_184551_a(Vec3d vec3d, Vec3d vec3d2) {
        Entity entity = null;
        List<Entity> \u26032 = this.field_70170_p.func_175674_a(this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), field_184553_f);
        double \u26033 = 0.0;
        for (int i = 0; i < \u26032.size(); ++i) {
            Entity entity2 = \u26032.get(i);
            if (entity2 == this.func_212360_k() && this.field_70257_an < 5 || (\u2603 = (\u2603 = entity2.func_174813_aQ().func_186662_g(0.3f)).func_72327_a(vec3d, vec3d2)) == null || !((\u2603 = vec3d.func_72436_e(\u2603.field_72307_f)) < \u26033) && \u26033 != 0.0) continue;
            entity = entity2;
            \u26033 = \u2603;
        }
        return entity;
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74768_a("xTile", this.field_145791_d);
        nBTTagCompound.func_74768_a("yTile", this.field_145792_e);
        nBTTagCompound.func_74768_a("zTile", this.field_145789_f);
        nBTTagCompound.func_74777_a("life", (short)this.field_70252_j);
        if (this.field_195056_av != null) {
            nBTTagCompound.func_74782_a("inBlockState", NBTUtil.func_190009_a(this.field_195056_av));
        }
        nBTTagCompound.func_74774_a("shake", (byte)this.field_70249_b);
        nBTTagCompound.func_74774_a("inGround", (byte)(this.field_70254_i ? 1 : 0));
        nBTTagCompound.func_74774_a("pickup", (byte)this.field_70251_a.ordinal());
        nBTTagCompound.func_74780_a("damage", this.field_70255_ao);
        nBTTagCompound.func_74757_a("crit", this.func_70241_g());
        if (this.field_70250_c != null) {
            nBTTagCompound.func_186854_a("OwnerUUID", this.field_70250_c);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        this.field_145791_d = nBTTagCompound.func_74762_e("xTile");
        this.field_145792_e = nBTTagCompound.func_74762_e("yTile");
        this.field_145789_f = nBTTagCompound.func_74762_e("zTile");
        this.field_70252_j = nBTTagCompound.func_74765_d("life");
        if (nBTTagCompound.func_150297_b("inBlockState", 10)) {
            this.field_195056_av = NBTUtil.func_190008_d(nBTTagCompound.func_74775_l("inBlockState"));
        }
        this.field_70249_b = nBTTagCompound.func_74771_c("shake") & 0xFF;
        boolean bl = this.field_70254_i = nBTTagCompound.func_74771_c("inGround") == 1;
        if (nBTTagCompound.func_150297_b("damage", 99)) {
            this.field_70255_ao = nBTTagCompound.func_74769_h("damage");
        }
        if (nBTTagCompound.func_150297_b("pickup", 99)) {
            this.field_70251_a = PickupStatus.func_188795_a(nBTTagCompound.func_74771_c("pickup"));
        } else if (nBTTagCompound.func_150297_b("player", 99)) {
            this.field_70251_a = nBTTagCompound.func_74767_n("player") ? PickupStatus.ALLOWED : PickupStatus.DISALLOWED;
        }
        this.func_70243_d(nBTTagCompound.func_74767_n("crit"));
        if (nBTTagCompound.func_186855_b("OwnerUUID")) {
            this.field_70250_c = nBTTagCompound.func_186857_a("OwnerUUID");
        }
    }

    public void func_212361_a(@Nullable Entity entity) {
        this.field_70250_c = entity == null ? null : entity.func_110124_au();
    }

    @Nullable
    public Entity func_212360_k() {
        if (this.field_70250_c != null && this.field_70170_p instanceof WorldServer) {
            return ((WorldServer)this.field_70170_p).func_175733_a(this.field_70250_c);
        }
        return null;
    }

    @Override
    public void func_70100_b_(EntityPlayer entityPlayer) {
        boolean bl;
        if (this.field_70170_p.field_72995_K || !this.field_70254_i && !this.func_203047_q() || this.field_70249_b > 0) {
            return;
        }
        boolean bl2 = bl = this.field_70251_a == PickupStatus.ALLOWED || this.field_70251_a == PickupStatus.CREATIVE_ONLY && entityPlayer.field_71075_bZ.field_75098_d || this.func_203047_q() && this.func_212360_k().func_110124_au() == entityPlayer.func_110124_au();
        if (this.field_70251_a == PickupStatus.ALLOWED && !entityPlayer.field_71071_by.func_70441_a(this.func_184550_j())) {
            bl = false;
        }
        if (bl) {
            entityPlayer.func_71001_a(this, 1);
            this.func_70106_y();
        }
    }

    protected abstract ItemStack func_184550_j();

    @Override
    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70239_b(double d) {
        this.field_70255_ao = d;
    }

    public double func_70242_d() {
        return this.field_70255_ao;
    }

    public void func_70240_a(int n) {
        this.field_70256_ap = n;
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    @Override
    public float func_70047_e() {
        return 0.0f;
    }

    public void func_70243_d(boolean bl) {
        this.func_203049_a(1, bl);
    }

    private void func_203049_a(int n, boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184554_g);
        if (bl) {
            this.field_70180_af.func_187227_b(field_184554_g, (byte)(by | n));
        } else {
            this.field_70180_af.func_187227_b(field_184554_g, (byte)(by & ~n));
        }
    }

    public boolean func_70241_g() {
        byte by = this.field_70180_af.func_187225_a(field_184554_g);
        return (by & 1) != 0;
    }

    public void func_190547_a(EntityLivingBase entityLivingBase, float f) {
        int n = EnchantmentHelper.func_185284_a(Enchantments.field_185309_u, entityLivingBase);
        \u2603 = EnchantmentHelper.func_185284_a(Enchantments.field_185310_v, entityLivingBase);
        this.func_70239_b((double)(f * 2.0f) + (this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f)));
        if (n > 0) {
            this.func_70239_b(this.func_70242_d() + (double)n * 0.5 + 0.5);
        }
        if (\u2603 > 0) {
            this.func_70240_a(\u2603);
        }
        if (EnchantmentHelper.func_185284_a(Enchantments.field_185311_w, entityLivingBase) > 0) {
            this.func_70015_d(100);
        }
    }

    protected float func_203044_p() {
        return 0.6f;
    }

    public void func_203045_n(boolean bl) {
        this.field_70145_X = bl;
        this.func_203049_a(2, bl);
    }

    public boolean func_203047_q() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70145_X;
        }
        return (this.field_70180_af.func_187225_a(field_184554_g) & 2) != 0;
    }

    public static enum PickupStatus {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY;


        public static PickupStatus func_188795_a(int n) {
            if (n < 0 || n > PickupStatus.values().length) {
                n = 0;
            }
            return PickupStatus.values()[n];
        }
    }
}

