/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemSpawnEgg;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityHorse
extends AbstractHorse {
    private static final UUID field_184786_bD = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final DataParameter<Integer> field_184789_bG = EntityDataManager.func_187226_a(EntityHorse.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184791_bI = EntityDataManager.func_187226_a(EntityHorse.class, DataSerializers.field_187192_b);
    private static final String[] field_110268_bz = new String[]{"textures/entity/horse/horse_white.png", "textures/entity/horse/horse_creamy.png", "textures/entity/horse/horse_chestnut.png", "textures/entity/horse/horse_brown.png", "textures/entity/horse/horse_black.png", "textures/entity/horse/horse_gray.png", "textures/entity/horse/horse_darkbrown.png"};
    private static final String[] field_110269_bA = new String[]{"hwh", "hcr", "hch", "hbr", "hbl", "hgr", "hdb"};
    private static final String[] field_110291_bB = new String[]{null, "textures/entity/horse/horse_markings_white.png", "textures/entity/horse/horse_markings_whitefield.png", "textures/entity/horse/horse_markings_whitedots.png", "textures/entity/horse/horse_markings_blackdots.png"};
    private static final String[] field_110292_bC = new String[]{"", "wo_", "wmo", "wdo", "bdo"};
    private String field_110286_bQ;
    private final String[] field_110280_bR = new String[3];

    public EntityHorse(World world) {
        super(EntityType.field_200762_B, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184789_bG, 0);
        this.field_70180_af.func_187214_a(field_184791_bI, HorseArmorType.NONE.func_188579_a());
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Variant", this.func_110202_bQ());
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            nBTTagCompound.func_74782_a("ArmorItem", this.field_110296_bG.func_70301_a(1).func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        super.func_70037_a(nBTTagCompound);
        this.func_110235_q(nBTTagCompound.func_74762_e("Variant"));
        if (nBTTagCompound.func_150297_b("ArmorItem", 10) && !(\u2603 = ItemStack.func_199557_a(nBTTagCompound.func_74775_l("ArmorItem"))).func_190926_b() && HorseArmorType.func_188577_b(\u2603.func_77973_b())) {
            this.field_110296_bG.func_70299_a(1, \u2603);
        }
        this.func_110232_cE();
    }

    public void func_110235_q(int n) {
        this.field_70180_af.func_187227_b(field_184789_bG, n);
        this.func_110230_cF();
    }

    public int func_110202_bQ() {
        return this.field_70180_af.func_187225_a(field_184789_bG);
    }

    private void func_110230_cF() {
        this.field_110286_bQ = null;
    }

    @Override
    protected void func_110232_cE() {
        super.func_110232_cE();
        this.func_146086_d(this.field_110296_bG.func_70301_a(1));
    }

    public void func_146086_d(ItemStack itemStack) {
        HorseArmorType horseArmorType = HorseArmorType.func_188580_a(itemStack);
        this.field_70180_af.func_187227_b(field_184791_bI, horseArmorType.func_188579_a());
        this.func_110230_cF();
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_188479_b(field_184786_bD);
            int n = horseArmorType.func_188578_c();
            if (n != 0) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier(field_184786_bD, "Horse armor bonus", (double)n, 0).func_111168_a(false));
            }
        }
    }

    public HorseArmorType func_184783_dl() {
        return HorseArmorType.func_188575_a(this.field_70180_af.func_187225_a(field_184791_bI));
    }

    @Override
    public void func_76316_a(IInventory iInventory) {
        HorseArmorType horseArmorType = this.func_184783_dl();
        super.func_76316_a(iInventory);
        \u2603 = this.func_184783_dl();
        if (this.field_70173_aa > 20 && horseArmorType != \u2603 && \u2603 != HorseArmorType.NONE) {
            this.func_184185_a(SoundEvents.field_187702_cm, 0.5f, 1.0f);
        }
    }

    @Override
    protected void func_190680_a(SoundType soundType) {
        super.func_190680_a(soundType);
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_184185_a(SoundEvents.field_187705_cn, soundType.func_185843_a() * 0.6f, soundType.func_185847_b());
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.func_110267_cL());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.func_110203_cN());
        this.func_110148_a(field_110271_bv).func_111128_a(this.func_110245_cM());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.func_110230_cF();
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        super.func_184639_G();
        return SoundEvents.field_187696_ck;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        super.func_184615_bR();
        return SoundEvents.field_187708_co;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        super.func_184601_bQ(damageSource);
        return SoundEvents.field_187717_cr;
    }

    @Override
    protected SoundEvent func_184785_dv() {
        super.func_184785_dv();
        return SoundEvents.field_187699_cl;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186396_D;
    }

    @Override
    public boolean func_184645_a(EntityPlayer entityPlayer2, EnumHand enumHand) {
        EntityPlayer entityPlayer2;
        ItemStack itemStack = entityPlayer2.func_184586_b(enumHand);
        boolean bl = \u2603 = !itemStack.func_190926_b();
        if (\u2603 && itemStack.func_77973_b() instanceof ItemSpawnEgg) {
            return super.func_184645_a(entityPlayer2, enumHand);
        }
        if (!this.func_70631_g_()) {
            if (this.func_110248_bS() && entityPlayer2.func_70093_af()) {
                this.func_110199_f(entityPlayer2);
                return true;
            }
            if (this.func_184207_aI()) {
                return super.func_184645_a(entityPlayer2, enumHand);
            }
        }
        if (\u2603) {
            if (this.func_190678_b(entityPlayer2, itemStack)) {
                if (!entityPlayer2.field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
                return true;
            }
            if (itemStack.func_111282_a(entityPlayer2, this, enumHand)) {
                return true;
            }
            if (!this.func_110248_bS()) {
                this.func_190687_dF();
                return true;
            }
            boolean bl2 = HorseArmorType.func_188580_a(itemStack) != HorseArmorType.NONE;
            boolean bl3 = \u2603 = !this.func_70631_g_() && !this.func_110257_ck() && itemStack.func_77973_b() == Items.field_151141_av;
            if (bl2 || \u2603) {
                this.func_110199_f(entityPlayer2);
                return true;
            }
        }
        if (this.func_70631_g_()) {
            return super.func_184645_a(entityPlayer2, enumHand);
        }
        this.func_110237_h(entityPlayer2);
        return true;
    }

    @Override
    public boolean func_70878_b(EntityAnimal entityAnimal) {
        if (entityAnimal == this) {
            return false;
        }
        if (entityAnimal instanceof EntityDonkey || entityAnimal instanceof EntityHorse) {
            return this.func_110200_cJ() && ((AbstractHorse)entityAnimal).func_110200_cJ();
        }
        return false;
    }

    @Override
    public EntityAgeable func_90011_a(EntityAgeable entityAgeable2) {
        AbstractHorse \u26033;
        if (entityAgeable2 instanceof EntityDonkey) {
            \u26033 = new EntityMule(this.field_70170_p);
        } else {
            EntityAgeable entityAgeable2;
            EntityHorse \u26032 = (EntityHorse)entityAgeable2;
            \u26033 = new EntityHorse(this.field_70170_p);
            int \u26034 = this.field_70146_Z.nextInt(9);
            int \u26035 = \u26034 < 4 ? this.func_110202_bQ() & 0xFF : (\u26034 < 8 ? \u26032.func_110202_bQ() & 0xFF : this.field_70146_Z.nextInt(7));
            int \u26036 = this.field_70146_Z.nextInt(5);
            \u26035 = \u26036 < 2 ? (\u26035 |= this.func_110202_bQ() & 0xFF00) : (\u26036 < 4 ? (\u26035 |= \u26032.func_110202_bQ() & 0xFF00) : (\u26035 |= this.field_70146_Z.nextInt(5) << 8 & 0xFF00));
            ((EntityHorse)\u26033).func_110235_q(\u26035);
        }
        this.func_190681_a(entityAgeable2, \u26033);
        return \u26033;
    }

    @Override
    public boolean func_190677_dK() {
        return true;
    }

    @Override
    public boolean func_190682_f(ItemStack itemStack) {
        return HorseArmorType.func_188577_b(itemStack.func_77973_b());
    }

    @Override
    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficultyInstance, @Nullable IEntityLivingData \u260322, @Nullable NBTTagCompound nBTTagCompound) {
        IEntityLivingData \u260322;
        int n;
        if ((\u260322 = super.func_204210_a(difficultyInstance, \u260322, nBTTagCompound)) instanceof GroupData) {
            n = ((GroupData)\u260322).field_190885_a;
        } else {
            n = this.field_70146_Z.nextInt(7);
            \u260322 = new GroupData(n);
        }
        this.func_110235_q(n | this.field_70146_Z.nextInt(5) << 8);
        return \u260322;
    }

    public static class GroupData
    implements IEntityLivingData {
        public int field_190885_a;

        public GroupData(int n) {
            this.field_190885_a = n;
        }
    }
}

