/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreathAir;
import net.minecraft.entity.ai.EntityAIFindWater;
import net.minecraft.entity.ai.EntityAIFollowBoat;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIJump;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWanderSwim;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityDolphinHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.MobEffects;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityDolphin
extends EntityWaterMob {
    private static final DataParameter<BlockPos> field_208014_b = EntityDataManager.func_187226_a(EntityDolphin.class, DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> field_208013_bB = EntityDataManager.func_187226_a(EntityDolphin.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_211138_bB = EntityDataManager.func_187226_a(EntityDolphin.class, DataSerializers.field_187192_b);
    public static final Predicate<EntityItem> field_205025_a = entityItem -> !entityItem.func_174874_s() && entityItem.func_70089_S() && entityItem.func_70090_H();

    public EntityDolphin(World world) {
        super(EntityType.field_205137_n, world);
        this.func_70105_a(0.9f, 0.6f);
        this.field_70765_h = new MoveHelper(this);
        this.field_70749_g = new EntityDolphinHelper(this, 10);
        this.func_98053_h(true);
    }

    @Override
    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficultyInstance, @Nullable IEntityLivingData iEntityLivingData, @Nullable NBTTagCompound nBTTagCompound) {
        this.func_70050_g(this.func_205010_bg());
        this.field_70125_A = 0.0f;
        return super.func_204210_a(difficultyInstance, iEntityLivingData, nBTTagCompound);
    }

    @Override
    public boolean func_70648_aU() {
        return false;
    }

    @Override
    protected void func_209207_l(int n) {
    }

    public void func_208012_g(BlockPos blockPos) {
        this.field_70180_af.func_187227_b(field_208014_b, blockPos);
    }

    public BlockPos func_208010_l() {
        return this.field_70180_af.func_187225_a(field_208014_b);
    }

    public boolean func_208011_dD() {
        return this.field_70180_af.func_187225_a(field_208013_bB);
    }

    public void func_208008_s(boolean bl) {
        this.field_70180_af.func_187227_b(field_208013_bB, bl);
    }

    public int func_211136_dB() {
        return this.field_70180_af.func_187225_a(field_211138_bB);
    }

    public void func_211137_b(int n) {
        this.field_70180_af.func_187227_b(field_211138_bB, n);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_208014_b, BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(field_208013_bB, false);
        this.field_70180_af.func_187214_a(field_211138_bB, 2400);
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("TreasurePosX", this.func_208010_l().func_177958_n());
        nBTTagCompound.func_74768_a("TreasurePosY", this.func_208010_l().func_177956_o());
        nBTTagCompound.func_74768_a("TreasurePosZ", this.func_208010_l().func_177952_p());
        nBTTagCompound.func_74757_a("GotFish", this.func_208011_dD());
        nBTTagCompound.func_74768_a("Moistness", this.func_211136_dB());
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        int n = nBTTagCompound.func_74762_e("TreasurePosX");
        \u2603 = nBTTagCompound.func_74762_e("TreasurePosY");
        \u2603 = nBTTagCompound.func_74762_e("TreasurePosZ");
        this.func_208012_g(new BlockPos(n, \u2603, \u2603));
        super.func_70037_a(nBTTagCompound);
        this.func_208008_s(nBTTagCompound.func_74767_n("GotFish"));
        this.func_211137_b(nBTTagCompound.func_74762_e("Moistness"));
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new EntityAIBreathAir(this));
        this.field_70714_bg.func_75776_a(0, new EntityAIFindWater(this));
        this.field_70714_bg.func_75776_a(1, new AISwimToTreasure(this));
        this.field_70714_bg.func_75776_a(2, new AISwimWithPlayer(this, 4.0));
        this.field_70714_bg.func_75776_a(4, new EntityAIWanderSwim(this, 1.0, 10));
        this.field_70714_bg.func_75776_a(4, new EntityAILookIdle(this));
        this.field_70714_bg.func_75776_a(5, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, new EntityAIJump(this, 10));
        this.field_70714_bg.func_75776_a(6, new EntityAIAttackMelee(this, 1.2f, true));
        this.field_70714_bg.func_75776_a(8, new AIPlayWithItems());
        this.field_70714_bg.func_75776_a(8, new EntityAIFollowBoat(this));
        this.field_70714_bg.func_75776_a(9, new EntityAIAvoidEntity<EntityGuardian>(this, EntityGuardian.class, 8.0f, 1.0, 1.0));
        this.field_70715_bh.func_75776_a(1, new EntityAIHurtByTarget((EntityCreature)this, true, EntityGuardian.class));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.2f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    @Override
    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateSwimmer(this, world);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean bl = entity.func_70097_a(DamageSource.func_76358_a(this), (int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        if (bl) {
            this.func_174815_a(this, entity);
            this.func_184185_a(SoundEvents.field_205205_aV, 1.0f, 1.0f);
        }
        return bl;
    }

    @Override
    public int func_205010_bg() {
        return 4800;
    }

    @Override
    protected int func_207300_l(int n) {
        return this.func_205010_bg();
    }

    @Override
    public float func_70047_e() {
        return 0.3f;
    }

    @Override
    public int func_70646_bf() {
        return 1;
    }

    @Override
    public int func_184649_cE() {
        return 1;
    }

    @Override
    protected boolean func_184228_n(Entity entity) {
        return true;
    }

    @Override
    protected void func_175445_a(EntityItem entityItem) {
        if (this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b() && this.func_175448_a(\u2603 = entityItem.func_92059_d())) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, \u2603);
            this.field_82174_bp[EntityEquipmentSlot.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a(entityItem, \u2603.func_190916_E());
            entityItem.func_70106_y();
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_175446_cd()) {
            return;
        }
        if (this.func_203008_ap()) {
            this.func_211137_b(2400);
        } else {
            this.func_211137_b(this.func_211136_dB() - 1);
            if (this.func_211136_dB() <= 0) {
                this.func_70097_a(DamageSource.field_205132_u, 1.0f);
            }
            if (this.field_70122_E) {
                this.field_70181_x += 0.5;
                this.field_70159_w += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.2f);
                this.field_70179_y += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.2f);
                this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
                this.field_70122_E = false;
                this.field_70160_al = true;
            }
        }
        if (this.field_70170_p.field_72995_K && this.func_70090_H() && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y > 0.03) {
            Vec3d vec3d = this.func_70676_i(0.0f);
            float \u26032 = MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180)) * 0.3f;
            float \u26033 = MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180)) * 0.3f;
            float \u26034 = 1.2f - this.field_70146_Z.nextFloat() * 0.7f;
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a(Particles.field_206864_X, this.field_70165_t - vec3d.field_72450_a * (double)\u26034 + (double)\u26032, this.field_70163_u - vec3d.field_72448_b, this.field_70161_v - vec3d.field_72449_c * (double)\u26034 + (double)\u26033, 0.0, 0.0, 0.0);
                this.field_70170_p.func_195594_a(Particles.field_206864_X, this.field_70165_t - vec3d.field_72450_a * (double)\u26034 - (double)\u26032, this.field_70163_u - vec3d.field_72448_b, this.field_70161_v - vec3d.field_72449_c * (double)\u26034 - (double)\u26033, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected boolean func_184645_a(EntityPlayer entityPlayer, EnumHand enumHand) {
        ItemStack itemStack = entityPlayer.func_184586_b(enumHand);
        if (!itemStack.func_190926_b() && itemStack.func_77973_b().func_206844_a(ItemTags.field_206964_G)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a(SoundEvents.field_205207_aX, 1.0f, 1.0f);
            }
            this.func_208008_s(true);
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            return true;
        }
        return super.func_184645_a(entityPlayer, enumHand);
    }

    @Nullable
    public EntityItem func_205024_f(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        double d = this.field_70163_u - (double)0.3f + (double)this.func_70047_e();
        EntityItem \u26032 = new EntityItem(this.field_70170_p, this.field_70165_t, d, this.field_70161_v, itemStack);
        \u26032.func_174867_a(40);
        \u26032.func_200216_c(this.func_110124_au());
        float \u26033 = 0.3f;
        \u26032.field_70159_w = -MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180)) * MathHelper.func_76134_b(this.field_70125_A * ((float)Math.PI / 180)) * \u26033;
        \u26032.field_70181_x = MathHelper.func_76126_a(this.field_70125_A * ((float)Math.PI / 180)) * \u26033 * 1.5f;
        \u26032.field_70179_y = MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180)) * MathHelper.func_76134_b(this.field_70125_A * ((float)Math.PI / 180)) * \u26033;
        float \u26034 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
        \u26033 = 0.02f * this.field_70146_Z.nextFloat();
        \u26032.field_70159_w += (double)(MathHelper.func_76134_b(\u26034) * \u26033);
        \u26032.field_70179_y += (double)(MathHelper.func_76126_a(\u26034) * \u26033);
        this.field_70170_p.func_72838_d(\u26032);
        return \u26032;
    }

    @Override
    public boolean func_205020_a(IWorld iWorld, boolean bl) {
        return this.field_70163_u > 45.0 && this.field_70163_u < (double)iWorld.func_181545_F() && iWorld.func_180494_b(new BlockPos(this)) != Biomes.field_76771_b || iWorld.func_180494_b(new BlockPos(this)) != Biomes.field_150575_M && super.func_205020_a(iWorld, bl);
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_205208_aY;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_205206_aW;
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        return this.func_70090_H() ? SoundEvents.field_205204_aU : SoundEvents.field_205203_aT;
    }

    @Override
    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_205212_bc;
    }

    @Override
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_205211_bb;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_205214_aN;
    }

    protected boolean func_208006_dE() {
        BlockPos blockPos = this.func_70661_as().func_208485_j();
        if (blockPos != null) {
            return this.func_174818_b(blockPos) < 144.0;
        }
        return false;
    }

    @Override
    public void func_191986_a(float f, float f2, float f3) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_191958_b(f, f2, f3, this.func_70689_ay());
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
            if (this.func_70638_az() == null) {
                this.field_70181_x -= 0.005;
            }
        } else {
            super.func_191986_a(f, f2, f3);
        }
    }

    @Override
    public boolean func_184652_a(EntityPlayer entityPlayer) {
        return true;
    }

    static class AISwimToTreasure
    extends EntityAIBase {
        private final EntityDolphin field_208057_a;
        private boolean field_208058_b;

        AISwimToTreasure(EntityDolphin entityDolphin) {
            this.field_208057_a = entityDolphin;
            this.func_75248_a(3);
        }

        @Override
        public boolean func_75252_g() {
            return false;
        }

        @Override
        public boolean func_75250_a() {
            return this.field_208057_a.func_208011_dD() && this.field_208057_a.func_70086_ai() >= 100;
        }

        @Override
        public boolean func_75253_b() {
            BlockPos blockPos = this.field_208057_a.func_208010_l();
            return this.field_208057_a.func_174818_b(new BlockPos((double)blockPos.func_177958_n(), this.field_208057_a.field_70163_u, (double)blockPos.func_177952_p())) > 16.0 && !this.field_208058_b && this.field_208057_a.func_70086_ai() >= 100;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void func_75249_e() {
            this.field_208058_b = false;
            this.field_208057_a.func_70661_as().func_75499_g();
            World world = this.field_208057_a.field_70170_p;
            BlockPos \u26032 = new BlockPos(this.field_208057_a);
            String \u26033 = (double)world.field_73012_v.nextFloat() >= 0.5 ? "Ocean_Ruin" : "Shipwreck";
            BlockPos \u26034 = world.func_211157_a(\u26033, \u26032, 50, false);
            if (\u26034 == null) {
                BlockPos blockPos = world.func_211157_a(\u26033.equals("Ocean_Ruin") ? "Shipwreck" : "Ocean_Ruin", \u26032, 50, false);
                if (blockPos == null) {
                    this.field_208058_b = true;
                    return;
                }
                this.field_208057_a.func_208012_g(blockPos);
            } else {
                this.field_208057_a.func_208012_g(\u26034);
            }
            world.func_72960_a(this.field_208057_a, (byte)38);
        }

        @Override
        public void func_75251_c() {
            BlockPos blockPos = this.field_208057_a.func_208010_l();
            if (this.field_208057_a.func_174818_b(new BlockPos((double)blockPos.func_177958_n(), this.field_208057_a.field_70163_u, (double)blockPos.func_177952_p())) <= 16.0 || this.field_208058_b) {
                this.field_208057_a.func_208008_s(false);
            }
        }

        @Override
        public void func_75246_d() {
            BlockPos blockPos = this.field_208057_a.func_208010_l();
            World \u26032 = this.field_208057_a.field_70170_p;
            if (this.field_208057_a.func_208006_dE() || this.field_208057_a.func_70661_as().func_75500_f()) {
                Vec3d vec3d = RandomPositionGenerator.func_203155_a(this.field_208057_a, 16, 1, new Vec3d(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), 0.3926991f);
                if (vec3d == null) {
                    vec3d = RandomPositionGenerator.func_75464_a(this.field_208057_a, 8, 4, new Vec3d(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()));
                }
                if (!(vec3d == null || \u26032.func_204610_c(\u2603 = new BlockPos(vec3d)).func_206884_a(FluidTags.field_206959_a) && \u26032.func_180495_p(\u2603).func_196957_g(\u26032, \u2603, PathType.WATER))) {
                    vec3d = RandomPositionGenerator.func_75464_a(this.field_208057_a, 8, 5, new Vec3d(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()));
                }
                if (vec3d == null) {
                    this.field_208058_b = true;
                    return;
                }
                this.field_208057_a.func_70671_ap().func_75650_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.field_208057_a.func_184649_cE() + 20, this.field_208057_a.func_70646_bf());
                this.field_208057_a.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.3);
                if (\u26032.field_73012_v.nextInt(80) == 0) {
                    \u26032.func_72960_a(this.field_208057_a, (byte)38);
                }
            }
        }
    }

    static class AISwimWithPlayer
    extends EntityAIBase {
        private final EntityDolphin field_206834_a;
        private final double field_206835_b;
        private EntityPlayer field_206836_c;

        AISwimWithPlayer(EntityDolphin entityDolphin, double d) {
            this.field_206834_a = entityDolphin;
            this.field_206835_b = d;
            this.func_75248_a(3);
        }

        @Override
        public boolean func_75250_a() {
            this.field_206836_c = this.field_206834_a.field_70170_p.func_72890_a(this.field_206834_a, 10.0);
            if (this.field_206836_c == null) {
                return false;
            }
            return this.field_206836_c.func_203007_ba();
        }

        @Override
        public boolean func_75253_b() {
            return this.field_206836_c != null && this.field_206836_c.func_203007_ba() && this.field_206834_a.func_70068_e(this.field_206836_c) < 256.0;
        }

        @Override
        public void func_75249_e() {
            this.field_206836_c.func_195064_c(new PotionEffect(MobEffects.field_206827_D, 100));
        }

        @Override
        public void func_75251_c() {
            this.field_206836_c = null;
            this.field_206834_a.func_70661_as().func_75499_g();
        }

        @Override
        public void func_75246_d() {
            this.field_206834_a.func_70671_ap().func_75651_a(this.field_206836_c, this.field_206834_a.func_184649_cE() + 20, this.field_206834_a.func_70646_bf());
            if (this.field_206834_a.func_70068_e(this.field_206836_c) < 6.25) {
                this.field_206834_a.func_70661_as().func_75499_g();
            } else {
                this.field_206834_a.func_70661_as().func_75497_a(this.field_206836_c, this.field_206835_b);
            }
            if (this.field_206836_c.func_203007_ba() && this.field_206836_c.field_70170_p.field_73012_v.nextInt(6) == 0) {
                this.field_206836_c.func_195064_c(new PotionEffect(MobEffects.field_206827_D, 100));
            }
        }
    }

    class AIPlayWithItems
    extends EntityAIBase {
        private int field_205154_b;

        private AIPlayWithItems() {
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_205154_b > EntityDolphin.this.field_70173_aa) {
                return false;
            }
            List<EntityItem> list = EntityDolphin.this.field_70170_p.func_175647_a(EntityItem.class, EntityDolphin.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_205025_a);
            return !list.isEmpty() || !EntityDolphin.this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b();
        }

        @Override
        public void func_75249_e() {
            List<EntityItem> list = EntityDolphin.this.field_70170_p.func_175647_a(EntityItem.class, EntityDolphin.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_205025_a);
            if (!list.isEmpty()) {
                EntityDolphin.this.func_70661_as().func_75497_a(list.get(0), 1.2f);
                EntityDolphin.this.func_184185_a(SoundEvents.field_205210_ba, 1.0f, 1.0f);
            }
            this.field_205154_b = 0;
        }

        @Override
        public void func_75251_c() {
            ItemStack itemStack = EntityDolphin.this.func_184582_a(EntityEquipmentSlot.MAINHAND);
            if (!itemStack.func_190926_b()) {
                EntityDolphin.this.func_205024_f(itemStack);
                EntityDolphin.this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                this.field_205154_b = EntityDolphin.this.field_70173_aa + EntityDolphin.this.field_70146_Z.nextInt(100);
            }
        }

        @Override
        public void func_75246_d() {
            List<EntityItem> list = EntityDolphin.this.field_70170_p.func_175647_a(EntityItem.class, EntityDolphin.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_205025_a);
            ItemStack \u26032 = EntityDolphin.this.func_184582_a(EntityEquipmentSlot.MAINHAND);
            if (!\u26032.func_190926_b()) {
                EntityDolphin.this.func_205024_f(\u26032);
                EntityDolphin.this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
            } else if (!list.isEmpty()) {
                EntityDolphin.this.func_70661_as().func_75497_a(list.get(0), 1.2f);
            }
        }
    }

    static class MoveHelper
    extends EntityMoveHelper {
        private final EntityDolphin field_205138_i;

        public MoveHelper(EntityDolphin entityDolphin) {
            super(entityDolphin);
            this.field_205138_i = entityDolphin;
        }

        @Override
        public void func_75641_c() {
            if (this.field_205138_i.func_70090_H()) {
                this.field_205138_i.field_70181_x += 0.005;
            }
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO || this.field_205138_i.func_70661_as().func_75500_f()) {
                this.field_205138_i.func_70659_e(0.0f);
                this.field_205138_i.func_184646_p(0.0f);
                this.field_205138_i.func_70657_f(0.0f);
                this.field_205138_i.func_191989_p(0.0f);
                return;
            }
            double d = this.field_75646_b - this.field_205138_i.field_70165_t;
            \u2603 = this.field_75647_c - this.field_205138_i.field_70163_u;
            \u2603 = this.field_75644_d - this.field_205138_i.field_70161_v;
            \u2603 = d * d + \u2603 * \u2603 + \u2603 * \u2603;
            if (\u2603 < 2.500000277905201E-7) {
                this.field_75648_a.func_191989_p(0.0f);
                return;
            }
            float \u26032 = (float)(MathHelper.func_181159_b(\u2603, d) * 57.2957763671875) - 90.0f;
            this.field_205138_i.field_70761_aq = this.field_205138_i.field_70177_z = this.func_75639_a(this.field_205138_i.field_70177_z, \u26032, 10.0f);
            this.field_205138_i.field_70759_as = this.field_205138_i.field_70177_z;
            float \u26033 = (float)(this.field_75645_e * this.field_205138_i.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            if (this.field_205138_i.func_70090_H()) {
                this.field_205138_i.func_70659_e(\u26033 * 0.02f);
                float f = -((float)(MathHelper.func_181159_b(\u2603, MathHelper.func_76133_a(d * d + \u2603 * \u2603)) * 57.2957763671875));
                f = MathHelper.func_76131_a(MathHelper.func_76142_g(f), -85.0f, 85.0f);
                this.field_205138_i.field_70125_A = this.func_75639_a(this.field_205138_i.field_70125_A, f, 5.0f);
                \u2603 = MathHelper.func_76134_b(this.field_205138_i.field_70125_A * ((float)Math.PI / 180));
                \u2603 = MathHelper.func_76126_a(this.field_205138_i.field_70125_A * ((float)Math.PI / 180));
                this.field_205138_i.field_191988_bg = \u2603 * \u26033;
                this.field_205138_i.field_70701_bs = -\u2603 * \u26033;
            } else {
                this.field_205138_i.func_70659_e(\u26033 * 0.1f);
            }
        }
    }
}

