/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityWitch
extends EntityMob
implements IRangedAttackMob {
    private static final UUID field_110184_bp = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier field_110185_bq = new AttributeModifier(field_110184_bp, "Drinking speed penalty", -0.25, 0).func_111168_a(false);
    private static final DataParameter<Boolean> field_184731_c = EntityDataManager.func_187226_a(EntityWitch.class, DataSerializers.field_187198_h);
    private int field_82200_e;

    public EntityWitch(World world) {
        super(EntityType.field_200759_ay, world);
        this.func_70105_a(0.6f, 1.95f);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(2, new EntityAIAttackRanged(this, 1.0, 60, 10.0f));
        this.field_70714_bg.func_75776_a(2, new EntityAIWanderAvoidWater(this, 1.0));
        this.field_70714_bg.func_75776_a(3, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(field_184731_c, false);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187920_gt;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187923_gw;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187921_gu;
    }

    public void func_82197_f(boolean bl) {
        this.func_184212_Q().func_187227_b(field_184731_c, bl);
    }

    public boolean func_184730_o() {
        return this.func_184212_Q().func_187225_a(field_184731_c);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(26.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_184730_o()) {
                if (this.field_82200_e-- <= 0) {
                    this.func_82197_f(false);
                    ItemStack itemStack = this.func_184614_ca();
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                    if (itemStack.func_77973_b() == Items.field_151068_bn && (\u2603 = PotionUtils.func_185189_a(itemStack)) != null) {
                        for (PotionEffect potionEffect : \u2603) {
                            this.func_195064_c(new PotionEffect(potionEffect));
                        }
                    }
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(field_110185_bq);
                }
            } else {
                PotionType potionType = null;
                if (this.field_70146_Z.nextFloat() < 0.15f && this.func_208600_a(FluidTags.field_206959_a) && !this.func_70644_a(MobEffects.field_76427_o)) {
                    potionType = PotionTypes.field_185248_t;
                } else if (this.field_70146_Z.nextFloat() < 0.15f && (this.func_70027_ad() || this.func_189748_bU() != null && this.func_189748_bU().func_76347_k()) && !this.func_70644_a(MobEffects.field_76426_n)) {
                    potionType = PotionTypes.field_185241_m;
                } else if (this.field_70146_Z.nextFloat() < 0.05f && this.func_110143_aJ() < this.func_110138_aP()) {
                    potionType = PotionTypes.field_185250_v;
                } else if (this.field_70146_Z.nextFloat() < 0.5f && this.func_70638_az() != null && !this.func_70644_a(MobEffects.field_76424_c) && this.func_70638_az().func_70068_e(this) > 121.0) {
                    potionType = PotionTypes.field_185243_o;
                }
                if (potionType != null) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, PotionUtils.func_185188_a(new ItemStack(Items.field_151068_bn), potionType));
                    this.field_82200_e = this.func_184614_ca().func_77988_m();
                    this.func_82197_f(true);
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187922_gv, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                    IAttributeInstance iAttributeInstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
                    iAttributeInstance.func_111124_b(field_110185_bq);
                    iAttributeInstance.func_111121_a(field_110185_bq);
                }
            }
            if (this.field_70146_Z.nextFloat() < 7.5E-4f) {
                this.field_70170_p.func_72960_a(this, (byte)15);
            }
        }
        super.func_70636_d();
    }

    @Override
    protected float func_70672_c(DamageSource damageSource, float f) {
        f = super.func_70672_c(damageSource, f);
        if (damageSource.func_76346_g() == this) {
            f = 0.0f;
        }
        if (damageSource.func_82725_o()) {
            f = (float)((double)f * 0.15);
        }
        return f;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186432_n;
    }

    @Override
    public void func_82196_d(EntityLivingBase entityLivingBase, float f) {
        if (this.func_184730_o()) {
            return;
        }
        double d = entityLivingBase.field_70163_u + (double)entityLivingBase.func_70047_e() - (double)1.1f;
        \u2603 = entityLivingBase.field_70165_t + entityLivingBase.field_70159_w - this.field_70165_t;
        \u2603 = d - this.field_70163_u;
        \u2603 = entityLivingBase.field_70161_v + entityLivingBase.field_70179_y - this.field_70161_v;
        float \u26032 = MathHelper.func_76133_a(\u2603 * \u2603 + \u2603 * \u2603);
        PotionType \u26033 = PotionTypes.field_185252_x;
        if (\u26032 >= 8.0f && !entityLivingBase.func_70644_a(MobEffects.field_76421_d)) {
            \u26033 = PotionTypes.field_185246_r;
        } else if (entityLivingBase.func_110143_aJ() >= 8.0f && !entityLivingBase.func_70644_a(MobEffects.field_76436_u)) {
            \u26033 = PotionTypes.field_185254_z;
        } else if (\u26032 <= 3.0f && !entityLivingBase.func_70644_a(MobEffects.field_76437_t) && this.field_70146_Z.nextFloat() < 0.25f) {
            \u26033 = PotionTypes.field_185226_I;
        }
        EntityPotion \u26034 = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, PotionUtils.func_185188_a(new ItemStack(Items.field_185155_bH), \u26033));
        \u26034.field_70125_A -= -20.0f;
        \u26034.func_70186_c(\u2603, \u2603 + (double)(\u26032 * 0.2f), \u2603, 0.75f, 8.0f);
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
        this.field_70170_p.func_72838_d(\u26034);
    }

    @Override
    public float func_70047_e() {
        return 1.62f;
    }

    @Override
    public void func_184724_a(boolean bl) {
    }
}

