/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityVex
extends EntityMob {
    protected static final DataParameter<Byte> field_190664_a = EntityDataManager.func_187226_a(EntityVex.class, DataSerializers.field_187191_a);
    private EntityLiving field_190665_b;
    @Nullable
    private BlockPos field_190666_c;
    private boolean field_190667_bw;
    private int field_190668_bx;

    public EntityVex(World world) {
        super(EntityType.field_200755_au, world);
        this.field_70178_ae = true;
        this.field_70765_h = new AIMoveControl(this);
        this.func_70105_a(0.4f, 0.8f);
        this.field_70728_aV = 3;
    }

    @Override
    public void func_70091_d(MoverType moverType, double d, double d2, double d3) {
        super.func_70091_d(moverType, d, d2, d3);
        this.func_145775_I();
    }

    @Override
    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
        if (this.field_190667_bw && --this.field_190668_bx <= 0) {
            this.field_190668_bx = 20;
            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
        }
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(4, new AIChargeAttack());
        this.field_70714_bg.func_75776_a(8, new AIMoveRandom());
        this.field_70714_bg.func_75776_a(9, new EntityAIWatchClosest(this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, new EntityAIWatchClosest(this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, new EntityAIHurtByTarget((EntityCreature)this, true, EntityVex.class));
        this.field_70715_bh.func_75776_a(2, new AICopyOwnerTarget(this));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(14.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_190664_a, (byte)0);
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        super.func_70037_a(nBTTagCompound);
        if (nBTTagCompound.func_74764_b("BoundX")) {
            this.field_190666_c = new BlockPos(nBTTagCompound.func_74762_e("BoundX"), nBTTagCompound.func_74762_e("BoundY"), nBTTagCompound.func_74762_e("BoundZ"));
        }
        if (nBTTagCompound.func_74764_b("LifeTicks")) {
            this.func_190653_a(nBTTagCompound.func_74762_e("LifeTicks"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
        if (this.field_190666_c != null) {
            nBTTagCompound.func_74768_a("BoundX", this.field_190666_c.func_177958_n());
            nBTTagCompound.func_74768_a("BoundY", this.field_190666_c.func_177956_o());
            nBTTagCompound.func_74768_a("BoundZ", this.field_190666_c.func_177952_p());
        }
        if (this.field_190667_bw) {
            nBTTagCompound.func_74768_a("LifeTicks", this.field_190668_bx);
        }
    }

    public EntityLiving func_190645_o() {
        return this.field_190665_b;
    }

    @Nullable
    public BlockPos func_190646_di() {
        return this.field_190666_c;
    }

    public void func_190651_g(@Nullable BlockPos blockPos) {
        this.field_190666_c = blockPos;
    }

    private boolean func_190656_b(int n) {
        byte by = this.field_70180_af.func_187225_a(field_190664_a);
        return (by & n) != 0;
    }

    private void func_190660_a(int n, boolean bl) {
        int n2 = this.field_70180_af.func_187225_a(field_190664_a).byteValue();
        n2 = bl ? (n2 |= n) : (n2 &= ~n);
        this.field_70180_af.func_187227_b(field_190664_a, (byte)(n2 & 0xFF));
    }

    public boolean func_190647_dj() {
        return this.func_190656_b(1);
    }

    public void func_190648_a(boolean bl) {
        this.func_190660_a(1, bl);
    }

    public void func_190658_a(EntityLiving entityLiving) {
        this.field_190665_b = entityLiving;
    }

    public void func_190653_a(int n) {
        this.field_190667_bw = true;
        this.field_190668_bx = n;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191264_hc;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191266_he;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_191267_hf;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_191188_ax;
    }

    @Override
    public float func_70013_c() {
        return 1.0f;
    }

    @Override
    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficultyInstance, @Nullable IEntityLivingData iEntityLivingData, @Nullable NBTTagCompound nBTTagCompound) {
        this.func_180481_a(difficultyInstance);
        this.func_180483_b(difficultyInstance);
        return super.func_204210_a(difficultyInstance, iEntityLivingData, nBTTagCompound);
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
        this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
    }

    class AICopyOwnerTarget
    extends EntityAITarget {
        public AICopyOwnerTarget(EntityCreature entityCreature) {
            super(entityCreature, false);
        }

        @Override
        public boolean func_75250_a() {
            return EntityVex.this.field_190665_b != null && EntityVex.this.field_190665_b.func_70638_az() != null && this.func_75296_a(EntityVex.this.field_190665_b.func_70638_az(), false);
        }

        @Override
        public void func_75249_e() {
            EntityVex.this.func_70624_b(EntityVex.this.field_190665_b.func_70638_az());
            super.func_75249_e();
        }
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        @Override
        public boolean func_75250_a() {
            return !EntityVex.this.func_70605_aq().func_75640_a() && EntityVex.this.field_70146_Z.nextInt(7) == 0;
        }

        @Override
        public boolean func_75253_b() {
            return false;
        }

        @Override
        public void func_75246_d() {
            BlockPos blockPos = EntityVex.this.func_190646_di();
            if (blockPos == null) {
                blockPos = new BlockPos(EntityVex.this);
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockPos2 = blockPos.func_177982_a(EntityVex.this.field_70146_Z.nextInt(15) - 7, EntityVex.this.field_70146_Z.nextInt(11) - 5, EntityVex.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityVex.this.field_70170_p.func_175623_d(blockPos2)) continue;
                EntityVex.this.field_70765_h.func_75642_a((double)blockPos2.func_177958_n() + 0.5, (double)blockPos2.func_177956_o() + 0.5, (double)blockPos2.func_177952_p() + 0.5, 0.25);
                if (EntityVex.this.func_70638_az() != null) break;
                EntityVex.this.func_70671_ap().func_75650_a((double)blockPos2.func_177958_n() + 0.5, (double)blockPos2.func_177956_o() + 0.5, (double)blockPos2.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIChargeAttack
    extends EntityAIBase {
        public AIChargeAttack() {
            this.func_75248_a(1);
        }

        @Override
        public boolean func_75250_a() {
            if (EntityVex.this.func_70638_az() != null && !EntityVex.this.func_70605_aq().func_75640_a() && EntityVex.this.field_70146_Z.nextInt(7) == 0) {
                return EntityVex.this.func_70068_e(EntityVex.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        @Override
        public boolean func_75253_b() {
            return EntityVex.this.func_70605_aq().func_75640_a() && EntityVex.this.func_190647_dj() && EntityVex.this.func_70638_az() != null && EntityVex.this.func_70638_az().func_70089_S();
        }

        @Override
        public void func_75249_e() {
            EntityLivingBase entityLivingBase = EntityVex.this.func_70638_az();
            Vec3d \u26032 = entityLivingBase.func_174824_e(1.0f);
            EntityVex.this.field_70765_h.func_75642_a(\u26032.field_72450_a, \u26032.field_72448_b, \u26032.field_72449_c, 1.0);
            EntityVex.this.func_190648_a(true);
            EntityVex.this.func_184185_a(SoundEvents.field_191265_hd, 1.0f, 1.0f);
        }

        @Override
        public void func_75251_c() {
            EntityVex.this.func_190648_a(false);
        }

        @Override
        public void func_75246_d() {
            EntityLivingBase entityLivingBase = EntityVex.this.func_70638_az();
            if (EntityVex.this.func_174813_aQ().func_72326_a(entityLivingBase.func_174813_aQ())) {
                EntityVex.this.func_70652_k(entityLivingBase);
                EntityVex.this.func_190648_a(false);
            } else {
                double d = EntityVex.this.func_70068_e(entityLivingBase);
                if (d < 9.0) {
                    Vec3d vec3d = entityLivingBase.func_174824_e(1.0f);
                    EntityVex.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
                }
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityVex entityVex2) {
            super(entityVex2);
        }

        @Override
        public void func_75641_c() {
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                return;
            }
            double d = this.field_75646_b - EntityVex.this.field_70165_t;
            \u2603 = this.field_75647_c - EntityVex.this.field_70163_u;
            \u2603 = this.field_75644_d - EntityVex.this.field_70161_v;
            \u2603 = d * d + \u2603 * \u2603 + \u2603 * \u2603;
            if ((\u2603 = (double)MathHelper.func_76133_a(\u2603)) < EntityVex.this.func_174813_aQ().func_72320_b()) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                EntityVex.this.field_70159_w *= 0.5;
                EntityVex.this.field_70181_x *= 0.5;
                EntityVex.this.field_70179_y *= 0.5;
            } else {
                EntityVex.this.field_70159_w += d / \u2603 * 0.05 * this.field_75645_e;
                EntityVex.this.field_70181_x += \u2603 / \u2603 * 0.05 * this.field_75645_e;
                EntityVex.this.field_70179_y += \u2603 / \u2603 * 0.05 * this.field_75645_e;
                if (EntityVex.this.func_70638_az() == null) {
                    EntityVex.this.field_70761_aq = EntityVex.this.field_70177_z = -((float)MathHelper.func_181159_b(EntityVex.this.field_70159_w, EntityVex.this.field_70179_y)) * 57.295776f;
                } else {
                    \u2603 = EntityVex.this.func_70638_az().field_70165_t - EntityVex.this.field_70165_t;
                    \u2603 = EntityVex.this.func_70638_az().field_70161_v - EntityVex.this.field_70161_v;
                    EntityVex.this.field_70761_aq = EntityVex.this.field_70177_z = -((float)MathHelper.func_181159_b(\u2603, \u2603)) * 57.295776f;
                }
            }
        }
    }
}

