/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntitySilverfish
extends EntityMob {
    private AISummonSilverfish field_175460_b;

    public EntitySilverfish(World world) {
        super(EntityType.field_200740_af, world);
        this.func_70105_a(0.4f, 0.3f);
    }

    @Override
    protected void func_184651_r() {
        this.field_175460_b = new AISummonSilverfish(this);
        this.field_70714_bg.func_75776_a(1, new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(3, this.field_175460_b);
        this.field_70714_bg.func_75776_a(4, new EntityAIAttackMelee(this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, new AIHideInStone(this));
        this.field_70715_bh.func_75776_a(1, new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    public double func_70033_W() {
        return 0.1;
    }

    @Override
    public float func_70047_e() {
        return 0.1f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    @Override
    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187793_eY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187850_fa;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187795_eZ;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, IBlockState iBlockState) {
        this.func_184185_a(SoundEvents.field_187852_fb, 0.15f, 1.0f);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if ((damageSource instanceof EntityDamageSource || damageSource == DamageSource.field_76376_m) && this.field_175460_b != null) {
            this.field_175460_b.func_179462_f();
        }
        return super.func_70097_a(damageSource, f);
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186438_t;
    }

    @Override
    public void func_70071_h_() {
        this.field_70761_aq = this.field_70177_z;
        super.func_70071_h_();
    }

    @Override
    public void func_181013_g(float f) {
        this.field_70177_z = f;
        super.func_181013_g(f);
    }

    @Override
    public float func_205022_a(BlockPos blockPos, IWorldReaderBase iWorldReaderBase) {
        if (BlockSilverfish.func_196466_i(iWorldReaderBase.func_180495_p(blockPos.func_177977_b()))) {
            return 10.0f;
        }
        return super.func_205022_a(blockPos, iWorldReaderBase);
    }

    @Override
    protected boolean func_70814_o() {
        return true;
    }

    @Override
    public boolean func_205020_a(IWorld iWorld, boolean bl) {
        if (super.func_205020_a(iWorld, bl)) {
            EntityPlayer entityPlayer = iWorld.func_184136_b(this, 5.0);
            return entityPlayer == null;
        }
        return false;
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.ARTHROPOD;
    }

    static class AIHideInStone
    extends EntityAIWander {
        private EnumFacing field_179483_b;
        private boolean field_179484_c;

        public AIHideInStone(EntitySilverfish entitySilverfish) {
            super(entitySilverfish, 1.0, 10);
            this.func_75248_a(1);
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_75457_a.func_70638_az() != null) {
                return false;
            }
            if (!this.field_75457_a.func_70661_as().func_75500_f()) {
                return false;
            }
            Random random = this.field_75457_a.func_70681_au();
            if (this.field_75457_a.field_70170_p.func_82736_K().func_82766_b("mobGriefing") && random.nextInt(10) == 0) {
                this.field_179483_b = EnumFacing.func_176741_a(random);
                BlockPos blockPos = new BlockPos(this.field_75457_a.field_70165_t, this.field_75457_a.field_70163_u + 0.5, this.field_75457_a.field_70161_v).func_177972_a(this.field_179483_b);
                IBlockState \u26032 = this.field_75457_a.field_70170_p.func_180495_p(blockPos);
                if (BlockSilverfish.func_196466_i(\u26032)) {
                    this.field_179484_c = true;
                    return true;
                }
            }
            this.field_179484_c = false;
            return super.func_75250_a();
        }

        @Override
        public boolean func_75253_b() {
            if (this.field_179484_c) {
                return false;
            }
            return super.func_75253_b();
        }

        @Override
        public void func_75249_e() {
            if (!this.field_179484_c) {
                super.func_75249_e();
                return;
            }
            World world = this.field_75457_a.field_70170_p;
            BlockPos \u26032 = new BlockPos(this.field_75457_a.field_70165_t, this.field_75457_a.field_70163_u + 0.5, this.field_75457_a.field_70161_v).func_177972_a(this.field_179483_b);
            IBlockState \u26033 = world.func_180495_p(\u26032);
            if (BlockSilverfish.func_196466_i(\u26033)) {
                world.func_180501_a(\u26032, BlockSilverfish.func_196467_h(\u26033.func_177230_c()), 3);
                this.field_75457_a.func_70656_aK();
                this.field_75457_a.func_70106_y();
            }
        }
    }

    static class AISummonSilverfish
    extends EntityAIBase {
        private final EntitySilverfish field_179464_a;
        private int field_179463_b;

        public AISummonSilverfish(EntitySilverfish entitySilverfish) {
            this.field_179464_a = entitySilverfish;
        }

        public void func_179462_f() {
            if (this.field_179463_b == 0) {
                this.field_179463_b = 20;
            }
        }

        @Override
        public boolean func_75250_a() {
            return this.field_179463_b > 0;
        }

        @Override
        public void func_75246_d() {
            --this.field_179463_b;
            if (this.field_179463_b <= 0) {
                World world = this.field_179464_a.field_70170_p;
                Random \u26032 = this.field_179464_a.func_70681_au();
                BlockPos \u26033 = new BlockPos(this.field_179464_a);
                int \u26034 = 0;
                block0: while (\u26034 <= 5 && \u26034 >= -5) {
                    int n = 0;
                    while (n <= 10 && n >= -10) {
                        \u26037 = 0;
                        while (\u26037 <= 10 && \u26037 >= -10) {
                            BlockPos blockPos = \u26033.func_177982_a(n, \u26034, \u26037);
                            IBlockState \u26035 = world.func_180495_p(blockPos);
                            Block \u26036 = \u26035.func_177230_c();
                            if (\u26036 instanceof BlockSilverfish) {
                                if (world.func_82736_K().func_82766_b("mobGriefing")) {
                                    world.func_175655_b(blockPos, true);
                                } else {
                                    world.func_180501_a(blockPos, ((BlockSilverfish)\u26036).func_196468_d().func_176223_P(), 3);
                                }
                                if (\u26032.nextBoolean()) break block0;
                            }
                            int \u26037 = (\u26037 <= 0 ? 1 : 0) - \u26037;
                        }
                        n = (n <= 0 ? 1 : 0) - n;
                    }
                    \u26034 = (\u26034 <= 0 ? 1 : 0) - \u26034;
                }
            }
        }
    }
}

