/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityPhantom
extends EntityFlying
implements IMob {
    private static final DataParameter<Integer> field_203035_a = EntityDataManager.func_187226_a(EntityPhantom.class, DataSerializers.field_187192_b);
    private Vec3d field_203036_b = Vec3d.field_186680_a;
    private BlockPos field_203037_c = BlockPos.field_177992_a;
    private AttackPhase field_203038_bx = AttackPhase.CIRCLE;

    public EntityPhantom(World world) {
        super(EntityType.field_203097_aH, world);
        this.field_70728_aV = 5;
        this.func_70105_a(0.9f, 0.5f);
        this.field_70765_h = new MoveHelper(this);
        this.field_70749_g = new LookHelper(this);
    }

    @Override
    protected EntityBodyHelper func_184650_s() {
        return new BodyHelper(this);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new AIPickAttack());
        this.field_70714_bg.func_75776_a(2, new AISweepAttack());
        this.field_70714_bg.func_75776_a(3, new AIOrbitPoint());
        this.field_70715_bh.func_75776_a(1, new AIAttackPlayer());
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_203035_a, 0);
    }

    public void func_203034_a(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 64) {
            n = 64;
        }
        this.field_70180_af.func_187227_b(field_203035_a, n);
        this.func_203033_m();
    }

    public void func_203033_m() {
        int n = this.field_70180_af.func_187225_a(field_203035_a);
        this.func_70105_a(0.9f + 0.2f * (float)n, 0.5f + 0.1f * (float)n);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6 + n);
    }

    public int func_203032_dq() {
        return this.field_70180_af.func_187225_a(field_203035_a);
    }

    @Override
    public float func_70047_e() {
        return this.field_70131_O * 0.35f;
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_203035_a.equals(dataParameter)) {
            this.func_203033_m();
        }
        super.func_184206_a(dataParameter);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            float f = MathHelper.func_76134_b((float)(this.func_145782_y() * 3 + this.field_70173_aa) * 0.13f + (float)Math.PI);
            \u2603 = MathHelper.func_76134_b((float)(this.func_145782_y() * 3 + this.field_70173_aa + 1) * 0.13f + (float)Math.PI);
            if (f > 0.0f && \u2603 <= 0.0f) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_206944_gn, this.func_184176_by(), 0.95f + this.field_70146_Z.nextFloat() * 0.05f, 0.95f + this.field_70146_Z.nextFloat() * 0.05f, false);
            }
            int \u26032 = this.func_203032_dq();
            \u2603 = MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180)) * (1.3f + 0.21f * (float)\u26032);
            \u2603 = MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180)) * (1.3f + 0.21f * (float)\u26032);
            \u2603 = (0.3f + f * 0.45f) * ((float)\u26032 * 0.2f + 1.0f);
            this.field_70170_p.func_195594_a(Particles.field_197596_G, this.field_70165_t + (double)\u2603, this.field_70163_u + (double)\u2603, this.field_70161_v + (double)\u2603, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a(Particles.field_197596_G, this.field_70165_t - (double)\u2603, this.field_70163_u + (double)\u2603, this.field_70161_v - (double)\u2603, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    @Override
    public void func_70636_d() {
        if (this.func_204609_dp()) {
            this.func_70015_d(8);
        }
        super.func_70636_d();
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    @Override
    public IEntityLivingData func_204210_a(DifficultyInstance difficultyInstance, @Nullable IEntityLivingData iEntityLivingData, @Nullable NBTTagCompound nBTTagCompound) {
        this.field_203037_c = new BlockPos(this).func_177981_b(5);
        this.func_203034_a(0);
        return super.func_204210_a(difficultyInstance, iEntityLivingData, nBTTagCompound);
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        super.func_70037_a(nBTTagCompound);
        if (nBTTagCompound.func_74764_b("AX")) {
            this.field_203037_c = new BlockPos(nBTTagCompound.func_74762_e("AX"), nBTTagCompound.func_74762_e("AY"), nBTTagCompound.func_74762_e("AZ"));
        }
        this.func_203034_a(nBTTagCompound.func_74762_e("Size"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("AX", this.field_203037_c.func_177958_n());
        nBTTagCompound.func_74768_a("AY", this.field_203037_c.func_177956_o());
        nBTTagCompound.func_74768_a("AZ", this.field_203037_c.func_177952_p());
        nBTTagCompound.func_74768_a("Size", this.func_203032_dq());
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203256_ft;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_203259_fw;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203258_fv;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_203250_E;
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.UNDEAD;
    }

    @Override
    protected float func_70599_aP() {
        return 1.0f;
    }

    @Override
    public boolean func_70686_a(Class<? extends EntityLivingBase> clazz) {
        return true;
    }

    class AIAttackPlayer
    extends EntityAIBase {
        private int field_203142_b = 20;

        private AIAttackPlayer() {
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_203142_b > 0) {
                --this.field_203142_b;
                return false;
            }
            this.field_203142_b = 60;
            AxisAlignedBB axisAlignedBB = EntityPhantom.this.func_174813_aQ().func_72314_b(16.0, 64.0, 16.0);
            List<EntityPlayer> \u26032 = EntityPhantom.this.field_70170_p.func_72872_a(EntityPlayer.class, axisAlignedBB);
            if (!\u26032.isEmpty()) {
                \u26032.sort((entityPlayer, entityPlayer2) -> entityPlayer.field_70163_u > entityPlayer2.field_70163_u ? -1 : 1);
                for (EntityPlayer entityPlayer3 : \u26032) {
                    if (!EntityAITarget.func_179445_a(EntityPhantom.this, entityPlayer3, false, false)) continue;
                    EntityPhantom.this.func_70624_b(entityPlayer3);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean func_75253_b() {
            return EntityAITarget.func_179445_a(EntityPhantom.this, EntityPhantom.this.func_70638_az(), false, false);
        }
    }

    class AIPickAttack
    extends EntityAIBase {
        private int field_203145_b;

        private AIPickAttack() {
        }

        @Override
        public boolean func_75250_a() {
            return EntityAITarget.func_179445_a(EntityPhantom.this, EntityPhantom.this.func_70638_az(), false, false);
        }

        @Override
        public void func_75249_e() {
            this.field_203145_b = 10;
            EntityPhantom.this.field_203038_bx = AttackPhase.CIRCLE;
            this.func_203143_f();
        }

        @Override
        public void func_75251_c() {
            EntityPhantom.this.field_203037_c = EntityPhantom.this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EntityPhantom.this.field_203037_c).func_177981_b(10 + EntityPhantom.this.field_70146_Z.nextInt(20));
        }

        @Override
        public void func_75246_d() {
            if (EntityPhantom.this.field_203038_bx == AttackPhase.CIRCLE) {
                --this.field_203145_b;
                if (this.field_203145_b <= 0) {
                    EntityPhantom.this.field_203038_bx = AttackPhase.SWOOP;
                    this.func_203143_f();
                    this.field_203145_b = (8 + EntityPhantom.this.field_70146_Z.nextInt(4)) * 20;
                    EntityPhantom.this.func_184185_a(SoundEvents.field_203260_fx, 10.0f, 0.95f + EntityPhantom.this.field_70146_Z.nextFloat() * 0.1f);
                }
            }
        }

        private void func_203143_f() {
            EntityPhantom.this.field_203037_c = new BlockPos(EntityPhantom.this.func_70638_az()).func_177981_b(20 + EntityPhantom.this.field_70146_Z.nextInt(20));
            if (EntityPhantom.this.field_203037_c.func_177956_o() < EntityPhantom.this.field_70170_p.func_181545_F()) {
                EntityPhantom.this.field_203037_c = new BlockPos(EntityPhantom.this.field_203037_c.func_177958_n(), EntityPhantom.this.field_70170_p.func_181545_F() + 1, EntityPhantom.this.field_203037_c.func_177952_p());
            }
        }
    }

    class AISweepAttack
    extends AIMove {
        private AISweepAttack() {
        }

        @Override
        public boolean func_75250_a() {
            return EntityPhantom.this.func_70638_az() != null && EntityPhantom.this.field_203038_bx == AttackPhase.SWOOP;
        }

        @Override
        public boolean func_75253_b() {
            EntityLivingBase entityLivingBase = EntityPhantom.this.func_70638_az();
            if (entityLivingBase == null) {
                return false;
            }
            if (!entityLivingBase.func_70089_S()) {
                return false;
            }
            if (entityLivingBase instanceof EntityPlayer && (((EntityPlayer)entityLivingBase).func_175149_v() || ((EntityPlayer)entityLivingBase).func_184812_l_())) {
                return false;
            }
            return this.func_75250_a();
        }

        @Override
        public void func_75249_e() {
        }

        @Override
        public void func_75251_c() {
            EntityPhantom.this.func_70624_b(null);
            EntityPhantom.this.field_203038_bx = AttackPhase.CIRCLE;
        }

        @Override
        public void func_75246_d() {
            EntityLivingBase entityLivingBase = EntityPhantom.this.func_70638_az();
            EntityPhantom.this.field_203036_b = new Vec3d(entityLivingBase.field_70165_t, entityLivingBase.field_70163_u + (double)entityLivingBase.field_70131_O * 0.5, entityLivingBase.field_70161_v);
            if (EntityPhantom.this.func_174813_aQ().func_186662_g(0.2f).func_72326_a(entityLivingBase.func_174813_aQ())) {
                EntityPhantom.this.func_70652_k(entityLivingBase);
                EntityPhantom.this.field_203038_bx = AttackPhase.CIRCLE;
                EntityPhantom.this.field_70170_p.func_175718_b(1039, new BlockPos(EntityPhantom.this), 0);
            } else if (EntityPhantom.this.field_70123_F || EntityPhantom.this.field_70737_aN > 0) {
                EntityPhantom.this.field_203038_bx = AttackPhase.CIRCLE;
            }
        }
    }

    class AIOrbitPoint
    extends AIMove {
        private float field_203150_c;
        private float field_203151_d;
        private float field_203152_e;
        private float field_203153_f;

        private AIOrbitPoint() {
        }

        @Override
        public boolean func_75250_a() {
            return EntityPhantom.this.func_70638_az() == null || EntityPhantom.this.field_203038_bx == AttackPhase.CIRCLE;
        }

        @Override
        public void func_75249_e() {
            this.field_203151_d = 5.0f + EntityPhantom.this.field_70146_Z.nextFloat() * 10.0f;
            this.field_203152_e = -4.0f + EntityPhantom.this.field_70146_Z.nextFloat() * 9.0f;
            this.field_203153_f = EntityPhantom.this.field_70146_Z.nextBoolean() ? 1.0f : -1.0f;
            this.func_203148_i();
        }

        @Override
        public void func_75246_d() {
            if (EntityPhantom.this.field_70146_Z.nextInt(350) == 0) {
                this.field_203152_e = -4.0f + EntityPhantom.this.field_70146_Z.nextFloat() * 9.0f;
            }
            if (EntityPhantom.this.field_70146_Z.nextInt(250) == 0) {
                this.field_203151_d += 1.0f;
                if (this.field_203151_d > 15.0f) {
                    this.field_203151_d = 5.0f;
                    this.field_203153_f = -this.field_203153_f;
                }
            }
            if (EntityPhantom.this.field_70146_Z.nextInt(450) == 0) {
                this.field_203150_c = EntityPhantom.this.field_70146_Z.nextFloat() * 2.0f * (float)Math.PI;
                this.func_203148_i();
            }
            if (this.func_203146_f()) {
                this.func_203148_i();
            }
            if (((EntityPhantom)EntityPhantom.this).field_203036_b.field_72448_b < EntityPhantom.this.field_70163_u && !EntityPhantom.this.field_70170_p.func_175623_d(new BlockPos(EntityPhantom.this).func_177979_c(1))) {
                this.field_203152_e = Math.max(1.0f, this.field_203152_e);
                this.func_203148_i();
            }
            if (((EntityPhantom)EntityPhantom.this).field_203036_b.field_72448_b > EntityPhantom.this.field_70163_u && !EntityPhantom.this.field_70170_p.func_175623_d(new BlockPos(EntityPhantom.this).func_177981_b(1))) {
                this.field_203152_e = Math.min(-1.0f, this.field_203152_e);
                this.func_203148_i();
            }
        }

        private void func_203148_i() {
            if (BlockPos.field_177992_a.equals(EntityPhantom.this.field_203037_c)) {
                EntityPhantom.this.field_203037_c = new BlockPos(EntityPhantom.this);
            }
            this.field_203150_c += this.field_203153_f * 15.0f * ((float)Math.PI / 180);
            EntityPhantom.this.field_203036_b = new Vec3d(EntityPhantom.this.field_203037_c).func_72441_c(this.field_203151_d * MathHelper.func_76134_b(this.field_203150_c), -4.0f + this.field_203152_e, this.field_203151_d * MathHelper.func_76126_a(this.field_203150_c));
        }
    }

    abstract class AIMove
    extends EntityAIBase {
        public AIMove() {
            this.func_75248_a(1);
        }

        protected boolean func_203146_f() {
            return EntityPhantom.this.field_203036_b.func_186679_c(EntityPhantom.this.field_70165_t, EntityPhantom.this.field_70163_u, EntityPhantom.this.field_70161_v) < 4.0;
        }
    }

    class LookHelper
    extends EntityLookHelper {
        public LookHelper(EntityLiving entityLiving) {
            super(entityLiving);
        }

        @Override
        public void func_75649_a() {
        }
    }

    class BodyHelper
    extends EntityBodyHelper {
        public BodyHelper(EntityLivingBase entityLivingBase) {
            super(entityLivingBase);
        }

        @Override
        public void func_75664_a() {
            EntityPhantom.this.field_70759_as = EntityPhantom.this.field_70761_aq;
            EntityPhantom.this.field_70761_aq = EntityPhantom.this.field_70177_z;
        }
    }

    class MoveHelper
    extends EntityMoveHelper {
        private float field_203105_j;

        public MoveHelper(EntityLiving entityLiving) {
            super(entityLiving);
            this.field_203105_j = 0.1f;
        }

        @Override
        public void func_75641_c() {
            if (EntityPhantom.this.field_70123_F) {
                EntityPhantom.this.field_70177_z += 180.0f;
                this.field_203105_j = 0.1f;
            }
            float f = (float)(((EntityPhantom)EntityPhantom.this).field_203036_b.field_72450_a - EntityPhantom.this.field_70165_t);
            \u2603 = (float)(((EntityPhantom)EntityPhantom.this).field_203036_b.field_72448_b - EntityPhantom.this.field_70163_u);
            \u2603 = (float)(((EntityPhantom)EntityPhantom.this).field_203036_b.field_72449_c - EntityPhantom.this.field_70161_v);
            double \u26032 = MathHelper.func_76129_c(f * f + \u2603 * \u2603);
            double \u26033 = 1.0 - (double)MathHelper.func_76135_e(\u2603 * 0.7f) / \u26032;
            f = (float)((double)f * \u26033);
            \u2603 = (float)((double)\u2603 * \u26033);
            \u26032 = MathHelper.func_76129_c(f * f + \u2603 * \u2603);
            double \u26034 = MathHelper.func_76129_c(f * f + \u2603 * \u2603 + \u2603 * \u2603);
            \u2603 = EntityPhantom.this.field_70177_z;
            \u2603 = (float)MathHelper.func_181159_b(\u2603, f);
            \u2603 = MathHelper.func_76142_g(EntityPhantom.this.field_70177_z + 90.0f);
            \u2603 = MathHelper.func_76142_g(\u2603 * 57.295776f);
            EntityPhantom.this.field_70761_aq = EntityPhantom.this.field_70177_z = MathHelper.func_203303_c(\u2603, \u2603, 4.0f) - 90.0f;
            this.field_203105_j = MathHelper.func_203301_d(\u2603, EntityPhantom.this.field_70177_z) < 3.0f ? MathHelper.func_203300_b(this.field_203105_j, 1.8f, 0.005f * (1.8f / this.field_203105_j)) : MathHelper.func_203300_b(this.field_203105_j, 0.2f, 0.025f);
            EntityPhantom.this.field_70125_A = \u2603 = (float)(-(MathHelper.func_181159_b(-\u2603, \u26032) * 57.2957763671875));
            \u2603 = EntityPhantom.this.field_70177_z + 90.0f;
            double \u26035 = (double)(this.field_203105_j * MathHelper.func_76134_b(\u2603 * ((float)Math.PI / 180))) * Math.abs((double)f / \u26034);
            double \u26036 = (double)(this.field_203105_j * MathHelper.func_76126_a(\u2603 * ((float)Math.PI / 180))) * Math.abs((double)\u2603 / \u26034);
            double \u26037 = (double)(this.field_203105_j * MathHelper.func_76126_a(\u2603 * ((float)Math.PI / 180))) * Math.abs((double)\u2603 / \u26034);
            EntityPhantom.this.field_70159_w += (\u26035 - EntityPhantom.this.field_70159_w) * 0.2;
            EntityPhantom.this.field_70181_x += (\u26037 - EntityPhantom.this.field_70181_x) * 0.2;
            EntityPhantom.this.field_70179_y += (\u26036 - EntityPhantom.this.field_70179_y) * 0.2;
        }
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }
}

