/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIZombieAttack;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityTurtle;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTrident;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityDrowned
extends EntityZombie
implements IRangedAttackMob {
    private boolean field_204718_bx;
    protected final PathNavigateSwimmer field_204716_a;
    protected final PathNavigateGround field_204717_b;

    public EntityDrowned(World world) {
        super(EntityType.field_204724_o, world);
        this.field_70138_W = 1.0f;
        this.field_70765_h = new MoveHelper(this);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_204716_a = new PathNavigateSwimmer(this, world);
        this.field_204717_b = new PathNavigateGround(this, world);
    }

    @Override
    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(1, new AIGoToWater(this, 1.0));
        this.field_70714_bg.func_75776_a(2, new AITridentAttack(this, 1.0, 40, 10.0f));
        this.field_70714_bg.func_75776_a(2, new AIAttack(this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, new AIGoToBeach(this, 1.0));
        this.field_70714_bg.func_75776_a(6, new AISwimUp(this, 1.0, this.field_70170_p.func_181545_F()));
        this.field_70714_bg.func_75776_a(7, new EntityAIWander(this, 1.0));
        this.field_70715_bh.func_75776_a(1, new EntityAIHurtByTarget((EntityCreature)this, true, EntityDrowned.class));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestAttackableTarget<EntityPlayer>(this, EntityPlayer.class, 10, true, false, new AttackTargetPredicate(this)));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestAttackableTarget<EntityVillager>((EntityCreature)this, EntityVillager.class, false));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestAttackableTarget<EntityIronGolem>((EntityCreature)this, EntityIronGolem.class, true));
        this.field_70715_bh.func_75776_a(5, new EntityAINearestAttackableTarget<Entity>(this, EntityTurtle.class, 10, true, false, EntityTurtle.field_203029_bx));
    }

    @Override
    protected PathNavigate func_175447_b(World world) {
        return super.func_175447_b(world);
    }

    @Override
    public IEntityLivingData func_204210_a(DifficultyInstance difficultyInstance, @Nullable IEntityLivingData iEntityLivingData2, @Nullable NBTTagCompound nBTTagCompound) {
        IEntityLivingData iEntityLivingData2 = super.func_204210_a(difficultyInstance, iEntityLivingData2, nBTTagCompound);
        if (this.func_184582_a(EntityEquipmentSlot.OFFHAND).func_190926_b() && this.field_70146_Z.nextFloat() < 0.03f) {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_205157_eZ));
            this.field_82174_bp[EntityEquipmentSlot.OFFHAND.func_188454_b()] = 2.0f;
        }
        return iEntityLivingData2;
    }

    @Override
    public boolean func_205020_a(IWorld iWorld, boolean bl) {
        Biome biome = iWorld.func_180494_b(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v));
        if (biome == Biomes.field_76781_i || biome == Biomes.field_76777_m) {
            return this.field_70146_Z.nextInt(15) == 0 && super.func_205020_a(iWorld, bl);
        }
        return this.field_70146_Z.nextInt(40) == 0 && this.func_204712_dC() && super.func_205020_a(iWorld, bl);
    }

    private boolean func_204712_dC() {
        return this.func_174813_aQ().field_72338_b < (double)(this.field_70170_p.func_181545_F() - 5);
    }

    @Override
    protected boolean func_204900_dz() {
        return false;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_204770_aM;
    }

    @Override
    protected SoundEvent func_184639_G() {
        if (this.func_70090_H()) {
            return SoundEvents.field_204775_aZ;
        }
        return SoundEvents.field_204774_aY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        if (this.func_70090_H()) {
            return SoundEvents.field_204779_bd;
        }
        return SoundEvents.field_204778_bc;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        if (this.func_70090_H()) {
            return SoundEvents.field_204777_bb;
        }
        return SoundEvents.field_204776_ba;
    }

    @Override
    protected SoundEvent func_190731_di() {
        return SoundEvents.field_204781_bf;
    }

    @Override
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_204782_bg;
    }

    @Override
    protected ItemStack func_190732_dj() {
        return ItemStack.field_190927_a;
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        if ((double)this.field_70146_Z.nextFloat() > 0.9) {
            int n = this.field_70146_Z.nextInt(16);
            if (n < 10) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_203184_eO));
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151112_aM));
            }
        }
    }

    @Override
    protected boolean func_208003_a(ItemStack itemStack, ItemStack itemStack2, EntityEquipmentSlot entityEquipmentSlot) {
        if (itemStack2.func_77973_b() == Items.field_205157_eZ) {
            return false;
        }
        if (itemStack2.func_77973_b() == Items.field_203184_eO) {
            if (itemStack.func_77973_b() == Items.field_203184_eO) {
                return itemStack.func_77952_i() < itemStack2.func_77952_i();
            }
            return false;
        }
        if (itemStack.func_77973_b() == Items.field_203184_eO) {
            return true;
        }
        return super.func_208003_a(itemStack, itemStack2, entityEquipmentSlot);
    }

    @Override
    protected boolean func_204703_dA() {
        return false;
    }

    @Override
    public boolean func_205019_a(IWorldReaderBase iWorldReaderBase) {
        return iWorldReaderBase.func_195587_c(this, this.func_174813_aQ()) && iWorldReaderBase.func_195586_b(this, this.func_174813_aQ());
    }

    public boolean func_204714_e(@Nullable EntityLivingBase entityLivingBase) {
        if (entityLivingBase != null) {
            return !this.field_70170_p.func_72935_r() || entityLivingBase.func_70090_H();
        }
        return false;
    }

    @Override
    public boolean func_96092_aw() {
        return !this.func_203007_ba();
    }

    private boolean func_204715_dF() {
        if (this.field_204718_bx) {
            return true;
        }
        EntityLivingBase entityLivingBase = this.func_70638_az();
        return entityLivingBase != null && entityLivingBase.func_70090_H();
    }

    @Override
    public void func_191986_a(float f, float f2, float f3) {
        if (this.func_70613_aW() && this.func_70090_H() && this.func_204715_dF()) {
            this.func_191958_b(f, f2, f3, 0.01f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
        } else {
            super.func_191986_a(f, f2, f3);
        }
    }

    @Override
    public void func_205343_av() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70613_aW() && this.func_70090_H() && this.func_204715_dF()) {
                this.field_70699_by = this.field_204716_a;
                this.func_204711_a(true);
            } else {
                this.field_70699_by = this.field_204717_b;
                this.func_204711_a(false);
            }
        }
    }

    protected boolean func_204710_dB() {
        Path path = this.func_70661_as().func_75505_d();
        return path != null && (\u2603 = path.func_189964_i()) != null && (\u2603 = this.func_70092_e(\u2603.field_75839_a, \u2603.field_75837_b, \u2603.field_75838_c)) < 4.0;
    }

    @Override
    public void func_82196_d(EntityLivingBase entityLivingBase, float f) {
        EntityTrident entityTrident = new EntityTrident(this.field_70170_p, (EntityLivingBase)this, new ItemStack(Items.field_203184_eO));
        double \u26032 = entityLivingBase.field_70165_t - this.field_70165_t;
        double \u26033 = entityLivingBase.func_174813_aQ().field_72338_b + (double)(entityLivingBase.field_70131_O / 3.0f) - entityTrident.field_70163_u;
        double \u26034 = entityLivingBase.field_70161_v - this.field_70161_v;
        double \u26035 = MathHelper.func_76133_a(\u26032 * \u26032 + \u26034 * \u26034);
        entityTrident.func_70186_c(\u26032, \u26033 + \u26035 * (double)0.2f, \u26034, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        this.func_184185_a(SoundEvents.field_204780_be, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d(entityTrident);
    }

    public void func_204713_s(boolean bl) {
        this.field_204718_bx = bl;
    }

    static class AttackTargetPredicate
    implements Predicate<EntityPlayer> {
        private final EntityDrowned field_204740_a;

        public AttackTargetPredicate(EntityDrowned entityDrowned) {
            this.field_204740_a = entityDrowned;
        }

        @Override
        public boolean test(@Nullable EntityPlayer entityPlayer) {
            return this.field_204740_a.func_204714_e(entityPlayer);
        }

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.test((EntityPlayer)object);
        }
    }

    static class MoveHelper
    extends EntityMoveHelper {
        private final EntityDrowned field_204725_i;

        public MoveHelper(EntityDrowned entityDrowned) {
            super(entityDrowned);
            this.field_204725_i = entityDrowned;
        }

        @Override
        public void func_75641_c() {
            EntityLivingBase entityLivingBase = this.field_204725_i.func_70638_az();
            if (this.field_204725_i.func_204715_dF() && this.field_204725_i.func_70090_H()) {
                if (entityLivingBase != null && entityLivingBase.field_70163_u > this.field_204725_i.field_70163_u || this.field_204725_i.field_204718_bx) {
                    this.field_204725_i.field_70181_x += 0.002;
                }
                if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO || this.field_204725_i.func_70661_as().func_75500_f()) {
                    this.field_204725_i.func_70659_e(0.0f);
                    return;
                }
                double d = this.field_75646_b - this.field_204725_i.field_70165_t;
                \u2603 = this.field_75647_c - this.field_204725_i.field_70163_u;
                \u2603 = this.field_75644_d - this.field_204725_i.field_70161_v;
                \u2603 = MathHelper.func_76133_a(d * d + \u2603 * \u2603 + \u2603 * \u2603);
                float \u26032 = (float)(MathHelper.func_181159_b(\u2603, d) * 57.2957763671875) - 90.0f;
                this.field_204725_i.field_70761_aq = this.field_204725_i.field_70177_z = this.func_75639_a(this.field_204725_i.field_70177_z, \u26032, 90.0f);
                float \u26033 = (float)(this.field_75645_e * this.field_204725_i.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.field_204725_i.func_70659_e(this.field_204725_i.func_70689_ay() + (\u26033 - this.field_204725_i.func_70689_ay()) * 0.125f);
                this.field_204725_i.field_70181_x += (double)this.field_204725_i.func_70689_ay() * (\u2603 /= \u2603) * 0.1;
                this.field_204725_i.field_70159_w += (double)this.field_204725_i.func_70689_ay() * d * 0.005;
                this.field_204725_i.field_70179_y += (double)this.field_204725_i.func_70689_ay() * \u2603 * 0.005;
            } else {
                if (!this.field_204725_i.field_70122_E) {
                    this.field_204725_i.field_70181_x -= 0.008;
                }
                super.func_75641_c();
            }
        }
    }

    static class AIAttack
    extends EntityAIZombieAttack {
        private final EntityDrowned field_204726_g;

        public AIAttack(EntityDrowned entityDrowned, double d, boolean bl) {
            super(entityDrowned, d, bl);
            this.field_204726_g = entityDrowned;
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && this.field_204726_g.func_204714_e(this.field_204726_g.func_70638_az());
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && this.field_204726_g.func_204714_e(this.field_204726_g.func_70638_az());
        }
    }

    static class AIGoToWater
    extends EntityAIBase {
        private final EntityCreature field_204730_a;
        private double field_204731_b;
        private double field_204732_c;
        private double field_204733_d;
        private final double field_204734_e;
        private final World field_204735_f;

        public AIGoToWater(EntityCreature entityCreature, double d) {
            this.field_204730_a = entityCreature;
            this.field_204734_e = d;
            this.field_204735_f = entityCreature.field_70170_p;
            this.func_75248_a(1);
        }

        @Override
        public boolean func_75250_a() {
            if (!this.field_204735_f.func_72935_r()) {
                return false;
            }
            if (this.field_204730_a.func_70090_H()) {
                return false;
            }
            Vec3d vec3d = this.func_204729_f();
            if (vec3d == null) {
                return false;
            }
            this.field_204731_b = vec3d.field_72450_a;
            this.field_204732_c = vec3d.field_72448_b;
            this.field_204733_d = vec3d.field_72449_c;
            return true;
        }

        @Override
        public boolean func_75253_b() {
            return !this.field_204730_a.func_70661_as().func_75500_f();
        }

        @Override
        public void func_75249_e() {
            this.field_204730_a.func_70661_as().func_75492_a(this.field_204731_b, this.field_204732_c, this.field_204733_d, this.field_204734_e);
        }

        @Nullable
        private Vec3d func_204729_f() {
            Random random = this.field_204730_a.func_70681_au();
            BlockPos \u26032 = new BlockPos(this.field_204730_a.field_70165_t, this.field_204730_a.func_174813_aQ().field_72338_b, this.field_204730_a.field_70161_v);
            for (int i = 0; i < 10; ++i) {
                BlockPos blockPos = \u26032.func_177982_a(random.nextInt(20) - 10, 2 - random.nextInt(8), random.nextInt(20) - 10);
                if (this.field_204735_f.func_180495_p(blockPos).func_177230_c() != Blocks.field_150355_j) continue;
                return new Vec3d(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            }
            return null;
        }
    }

    static class AIGoToBeach
    extends EntityAIMoveToBlock {
        private final EntityDrowned field_204727_f;

        public AIGoToBeach(EntityDrowned entityDrowned, double d) {
            super(entityDrowned, d, 8, 2);
            this.field_204727_f = entityDrowned;
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_204727_f.field_70170_p.func_72935_r() && this.field_204727_f.func_70090_H() && this.field_204727_f.field_70163_u >= (double)(this.field_204727_f.field_70170_p.func_181545_F() - 3);
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        @Override
        protected boolean func_179488_a(IWorldReaderBase iWorldReaderBase, BlockPos blockPos) {
            \u2603 = blockPos.func_177984_a();
            if (!iWorldReaderBase.func_175623_d(\u2603) || !iWorldReaderBase.func_175623_d(\u2603.func_177984_a())) {
                return false;
            }
            return iWorldReaderBase.func_180495_p(blockPos).func_185896_q();
        }

        @Override
        public void func_75249_e() {
            this.field_204727_f.func_204713_s(false);
            this.field_204727_f.field_70699_by = this.field_204727_f.field_204717_b;
            super.func_75249_e();
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
        }
    }

    static class AISwimUp
    extends EntityAIBase {
        private final EntityDrowned field_204736_a;
        private final double field_204737_b;
        private final int field_204738_c;
        private boolean field_204739_d;

        public AISwimUp(EntityDrowned entityDrowned, double d, int n) {
            this.field_204736_a = entityDrowned;
            this.field_204737_b = d;
            this.field_204738_c = n;
        }

        @Override
        public boolean func_75250_a() {
            return !this.field_204736_a.field_70170_p.func_72935_r() && this.field_204736_a.func_70090_H() && this.field_204736_a.field_70163_u < (double)(this.field_204738_c - 2);
        }

        @Override
        public boolean func_75253_b() {
            return this.func_75250_a() && !this.field_204739_d;
        }

        @Override
        public void func_75246_d() {
            if (this.field_204736_a.field_70163_u < (double)(this.field_204738_c - 1) && (this.field_204736_a.func_70661_as().func_75500_f() || this.field_204736_a.func_204710_dB())) {
                Vec3d vec3d = RandomPositionGenerator.func_75464_a(this.field_204736_a, 4, 8, new Vec3d(this.field_204736_a.field_70165_t, this.field_204738_c - 1, this.field_204736_a.field_70161_v));
                if (vec3d == null) {
                    this.field_204739_d = true;
                    return;
                }
                this.field_204736_a.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.field_204737_b);
            }
        }

        @Override
        public void func_75249_e() {
            this.field_204736_a.func_204713_s(true);
            this.field_204739_d = false;
        }

        @Override
        public void func_75251_c() {
            this.field_204736_a.func_204713_s(false);
        }
    }

    static class AITridentAttack
    extends EntityAIAttackRanged {
        private final EntityDrowned field_204728_a;

        public AITridentAttack(IRangedAttackMob iRangedAttackMob, double d, int n, float f) {
            super(iRangedAttackMob, d, n, f);
            this.field_204728_a = (EntityDrowned)iRangedAttackMob;
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && this.field_204728_a.func_184614_ca().func_77973_b() == Items.field_203184_eO;
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.field_204728_a.func_184724_a(true);
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.field_204728_a.func_184724_a(false);
        }
    }
}

