/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.IAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityDragonFireball;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.entity.projectile.EntityTrident;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.server.SPacketEntity;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityEquipment;
import net.minecraft.network.play.server.SPacketEntityHeadLook;
import net.minecraft.network.play.server.SPacketEntityMetadata;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.network.play.server.SPacketEntityTeleport;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.network.play.server.SPacketSpawnExperienceOrb;
import net.minecraft.network.play.server.SPacketSpawnMob;
import net.minecraft.network.play.server.SPacketSpawnObject;
import net.minecraft.network.play.server.SPacketSpawnPainting;
import net.minecraft.network.play.server.SPacketSpawnPlayer;
import net.minecraft.network.play.server.SPacketUseBed;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.MapData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityTrackerEntry {
    private static final Logger field_151262_p = LogManager.getLogger();
    private final Entity field_73132_a;
    private final int field_73130_b;
    private int field_187262_f;
    private final int field_73131_c;
    private long field_73128_d;
    private long field_73129_e;
    private long field_73126_f;
    private int field_73127_g;
    private int field_73139_h;
    private int field_73140_i;
    private double field_73137_j;
    private double field_73138_k;
    private double field_73135_l;
    public int field_73136_m;
    private double field_73147_p;
    private double field_73146_q;
    private double field_73145_r;
    private boolean field_73144_s;
    private final boolean field_73143_t;
    private int field_73142_u;
    private List<Entity> field_187263_w = Collections.emptyList();
    private boolean field_73141_v;
    private boolean field_180234_y;
    public boolean field_73133_n;
    private final Set<EntityPlayerMP> field_73134_o = Sets.newHashSet();

    public EntityTrackerEntry(Entity entity, int n, int n2, int n3, boolean bl) {
        this.field_73132_a = entity;
        this.field_73130_b = n;
        this.field_187262_f = n2;
        this.field_73131_c = n3;
        this.field_73143_t = bl;
        this.field_73128_d = EntityTracker.func_187253_a(entity.field_70165_t);
        this.field_73129_e = EntityTracker.func_187253_a(entity.field_70163_u);
        this.field_73126_f = EntityTracker.func_187253_a(entity.field_70161_v);
        this.field_73127_g = MathHelper.func_76141_d(entity.field_70177_z * 256.0f / 360.0f);
        this.field_73139_h = MathHelper.func_76141_d(entity.field_70125_A * 256.0f / 360.0f);
        this.field_73140_i = MathHelper.func_76141_d(entity.func_70079_am() * 256.0f / 360.0f);
        this.field_180234_y = entity.field_70122_E;
    }

    public boolean equals(Object object) {
        if (object instanceof EntityTrackerEntry) {
            return ((EntityTrackerEntry)object).field_73132_a.func_145782_y() == this.field_73132_a.func_145782_y();
        }
        return false;
    }

    public int hashCode() {
        return this.field_73132_a.func_145782_y();
    }

    public void func_73122_a(List<EntityPlayer> list) {
        this.field_73133_n = false;
        if (!this.field_73144_s || this.field_73132_a.func_70092_e(this.field_73147_p, this.field_73146_q, this.field_73145_r) > 16.0) {
            this.field_73147_p = this.field_73132_a.field_70165_t;
            this.field_73146_q = this.field_73132_a.field_70163_u;
            this.field_73145_r = this.field_73132_a.field_70161_v;
            this.field_73144_s = true;
            this.field_73133_n = true;
            this.func_73125_b(list);
        }
        if (!(\u2603 = this.field_73132_a.func_184188_bt()).equals(this.field_187263_w)) {
            this.field_187263_w = \u2603;
            this.func_151259_a(new SPacketSetPassengers(this.field_73132_a));
        }
        if (this.field_73132_a instanceof EntityItemFrame && this.field_73136_m % 10 == 0) {
            EntityItemFrame entityItemFrame = (EntityItemFrame)this.field_73132_a;
            ItemStack \u26032 = entityItemFrame.func_82335_i();
            if (\u26032.func_77973_b() instanceof ItemMap) {
                MapData mapData = ItemMap.func_195950_a(\u26032, this.field_73132_a.field_70170_p);
                for (EntityPlayer entityPlayer : list) {
                    EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entityPlayer;
                    mapData.func_76191_a(entityPlayerMP, \u26032);
                    Packet<?> \u26033 = ((ItemMap)\u26032.func_77973_b()).func_150911_c(\u26032, this.field_73132_a.field_70170_p, entityPlayerMP);
                    if (\u26033 == null) continue;
                    entityPlayerMP.field_71135_a.func_147359_a(\u26033);
                }
            }
            this.func_111190_b();
        }
        if (this.field_73136_m % this.field_73131_c == 0 || this.field_73132_a.field_70160_al || this.field_73132_a.func_184212_Q().func_187223_a()) {
            if (this.field_73132_a.func_184218_aH()) {
                int n = MathHelper.func_76141_d(this.field_73132_a.field_70177_z * 256.0f / 360.0f);
                \u2603 = MathHelper.func_76141_d(this.field_73132_a.field_70125_A * 256.0f / 360.0f);
                boolean bl = \u2603 = Math.abs(n - this.field_73127_g) >= 1 || Math.abs(\u2603 - this.field_73139_h) >= 1;
                if (\u2603) {
                    this.func_151259_a(new SPacketEntity.Look(this.field_73132_a.func_145782_y(), (byte)n, (byte)\u2603, this.field_73132_a.field_70122_E));
                    this.field_73127_g = n;
                    this.field_73139_h = \u2603;
                }
                this.field_73128_d = EntityTracker.func_187253_a(this.field_73132_a.field_70165_t);
                this.field_73129_e = EntityTracker.func_187253_a(this.field_73132_a.field_70163_u);
                this.field_73126_f = EntityTracker.func_187253_a(this.field_73132_a.field_70161_v);
                this.func_111190_b();
                this.field_73141_v = true;
            } else {
                boolean bl;
                boolean bl2;
                ++this.field_73142_u;
                long l = EntityTracker.func_187253_a(this.field_73132_a.field_70165_t);
                \u2603 = EntityTracker.func_187253_a(this.field_73132_a.field_70163_u);
                \u2603 = EntityTracker.func_187253_a(this.field_73132_a.field_70161_v);
                int \u26034 = MathHelper.func_76141_d(this.field_73132_a.field_70177_z * 256.0f / 360.0f);
                int \u26035 = MathHelper.func_76141_d(this.field_73132_a.field_70125_A * 256.0f / 360.0f);
                \u2603 = l - this.field_73128_d;
                \u2603 = \u2603 - this.field_73129_e;
                \u2603 = \u2603 - this.field_73126_f;
                Packet<INetHandlerPlayClient> \u26036 = null;
                boolean \u26037 = \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603 >= 128L || this.field_73136_m % 60 == 0;
                boolean bl3 = bl = Math.abs(\u26034 - this.field_73127_g) >= 1 || Math.abs(\u26035 - this.field_73139_h) >= 1;
                if (this.field_73136_m > 0 || this.field_73132_a instanceof EntityArrow) {
                    if (\u2603 < -32768L || \u2603 >= 32768L || \u2603 < -32768L || \u2603 >= 32768L || \u2603 < -32768L || \u2603 >= 32768L || this.field_73142_u > 400 || this.field_73141_v || this.field_180234_y != this.field_73132_a.field_70122_E) {
                        this.field_180234_y = this.field_73132_a.field_70122_E;
                        this.field_73142_u = 0;
                        this.func_187261_c();
                        \u26036 = new SPacketEntityTeleport(this.field_73132_a);
                    } else if (\u26037 && bl || this.field_73132_a instanceof EntityArrow) {
                        \u26036 = new SPacketEntity.Move(this.field_73132_a.func_145782_y(), \u2603, \u2603, \u2603, (byte)\u26034, (byte)\u26035, this.field_73132_a.field_70122_E);
                    } else if (\u26037) {
                        \u26036 = new SPacketEntity.RelMove(this.field_73132_a.func_145782_y(), \u2603, \u2603, \u2603, this.field_73132_a.field_70122_E);
                    } else if (bl) {
                        \u26036 = new SPacketEntity.Look(this.field_73132_a.func_145782_y(), (byte)\u26034, (byte)\u26035, this.field_73132_a.field_70122_E);
                    }
                }
                boolean bl4 = bl2 = this.field_73143_t || this.field_73132_a.field_70160_al;
                if (this.field_73132_a instanceof EntityLivingBase && ((EntityLivingBase)this.field_73132_a).func_184613_cA()) {
                    bl2 = true;
                }
                if (bl2 && this.field_73136_m > 0) {
                    double d = this.field_73132_a.field_70159_w - this.field_73137_j;
                    \u2603 = this.field_73132_a.field_70181_x - this.field_73138_k;
                    \u2603 = this.field_73132_a.field_70179_y - this.field_73135_l;
                    \u2603 = 0.02;
                    \u2603 = d * d + \u2603 * \u2603 + \u2603 * \u2603;
                    if (\u2603 > 4.0E-4 || \u2603 > 0.0 && this.field_73132_a.field_70159_w == 0.0 && this.field_73132_a.field_70181_x == 0.0 && this.field_73132_a.field_70179_y == 0.0) {
                        this.field_73137_j = this.field_73132_a.field_70159_w;
                        this.field_73138_k = this.field_73132_a.field_70181_x;
                        this.field_73135_l = this.field_73132_a.field_70179_y;
                        this.func_151259_a(new SPacketEntityVelocity(this.field_73132_a.func_145782_y(), this.field_73137_j, this.field_73138_k, this.field_73135_l));
                    }
                }
                if (\u26036 != null) {
                    this.func_151259_a(\u26036);
                }
                this.func_111190_b();
                if (\u26037) {
                    this.field_73128_d = l;
                    this.field_73129_e = \u2603;
                    this.field_73126_f = \u2603;
                }
                if (bl) {
                    this.field_73127_g = \u26034;
                    this.field_73139_h = \u26035;
                }
                this.field_73141_v = false;
            }
            int n = MathHelper.func_76141_d(this.field_73132_a.func_70079_am() * 256.0f / 360.0f);
            if (Math.abs(n - this.field_73140_i) >= 1) {
                this.func_151259_a(new SPacketEntityHeadLook(this.field_73132_a, (byte)n));
                this.field_73140_i = n;
            }
            this.field_73132_a.field_70160_al = false;
        }
        ++this.field_73136_m;
        if (this.field_73132_a.field_70133_I) {
            this.func_151261_b(new SPacketEntityVelocity(this.field_73132_a));
            this.field_73132_a.field_70133_I = false;
        }
    }

    private void func_111190_b() {
        EntityDataManager entityDataManager = this.field_73132_a.func_184212_Q();
        if (entityDataManager.func_187223_a()) {
            this.func_151261_b(new SPacketEntityMetadata(this.field_73132_a.func_145782_y(), entityDataManager, false));
        }
        if (this.field_73132_a instanceof EntityLivingBase) {
            AttributeMap attributeMap = (AttributeMap)((EntityLivingBase)this.field_73132_a).func_110140_aT();
            Set<IAttributeInstance> \u26032 = attributeMap.func_111161_b();
            if (!\u26032.isEmpty()) {
                this.func_151261_b(new SPacketEntityProperties(this.field_73132_a.func_145782_y(), \u26032));
            }
            \u26032.clear();
        }
    }

    public void func_151259_a(Packet<?> packet) {
        for (EntityPlayerMP entityPlayerMP : this.field_73134_o) {
            entityPlayerMP.field_71135_a.func_147359_a(packet);
        }
    }

    public void func_151261_b(Packet<?> packet) {
        this.func_151259_a(packet);
        if (this.field_73132_a instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.field_73132_a).field_71135_a.func_147359_a(packet);
        }
    }

    public void func_73119_a() {
        for (EntityPlayerMP entityPlayerMP : this.field_73134_o) {
            this.field_73132_a.func_184203_c(entityPlayerMP);
            entityPlayerMP.func_152339_d(this.field_73132_a);
        }
    }

    public void func_73118_a(EntityPlayerMP entityPlayerMP) {
        if (this.field_73134_o.contains(entityPlayerMP)) {
            this.field_73132_a.func_184203_c(entityPlayerMP);
            entityPlayerMP.func_152339_d(this.field_73132_a);
            this.field_73134_o.remove(entityPlayerMP);
        }
    }

    public void func_73117_b(EntityPlayerMP entityPlayerMP2) {
        EntityPlayerMP entityPlayerMP2;
        if (entityPlayerMP2 == this.field_73132_a) {
            return;
        }
        if (this.func_180233_c(entityPlayerMP2)) {
            if (!this.field_73134_o.contains(entityPlayerMP2) && (this.func_73121_d(entityPlayerMP2) || this.field_73132_a.field_98038_p)) {
                Object object;
                this.field_73134_o.add(entityPlayerMP2);
                Packet<?> packet = this.func_151260_c();
                entityPlayerMP2.field_71135_a.func_147359_a(packet);
                if (!this.field_73132_a.func_184212_Q().func_187228_d()) {
                    entityPlayerMP2.field_71135_a.func_147359_a(new SPacketEntityMetadata(this.field_73132_a.func_145782_y(), this.field_73132_a.func_184212_Q(), true));
                }
                boolean \u26032 = this.field_73143_t;
                if (this.field_73132_a instanceof EntityLivingBase) {
                    object = (EntityEquipmentSlot[])((EntityLivingBase)this.field_73132_a).func_110140_aT();
                    Collection<IAttributeInstance> \u26033 = ((AttributeMap)object).func_111160_c();
                    if (!\u26033.isEmpty()) {
                        entityPlayerMP2.field_71135_a.func_147359_a(new SPacketEntityProperties(this.field_73132_a.func_145782_y(), \u26033));
                    }
                    if (((EntityLivingBase)this.field_73132_a).func_184613_cA()) {
                        \u26032 = true;
                    }
                }
                this.field_73137_j = this.field_73132_a.field_70159_w;
                this.field_73138_k = this.field_73132_a.field_70181_x;
                this.field_73135_l = this.field_73132_a.field_70179_y;
                if (\u26032 && !(packet instanceof SPacketSpawnMob)) {
                    entityPlayerMP2.field_71135_a.func_147359_a(new SPacketEntityVelocity(this.field_73132_a.func_145782_y(), this.field_73132_a.field_70159_w, this.field_73132_a.field_70181_x, this.field_73132_a.field_70179_y));
                }
                if (this.field_73132_a instanceof EntityLivingBase) {
                    object = EntityEquipmentSlot.values();
                    int n = ((EntityEquipmentSlot[])object).length;
                    for (int i = 0; i < n; ++i) {
                        \u2603 = object[i];
                        ItemStack itemStack = ((EntityLivingBase)this.field_73132_a).func_184582_a((EntityEquipmentSlot)((Object)\u2603));
                        if (itemStack.func_190926_b()) continue;
                        entityPlayerMP2.field_71135_a.func_147359_a(new SPacketEntityEquipment(this.field_73132_a.func_145782_y(), (EntityEquipmentSlot)((Object)\u2603), itemStack));
                    }
                }
                if (this.field_73132_a instanceof EntityPlayer && ((EntityPlayer)(object = (EntityPlayer)this.field_73132_a)).func_70608_bn()) {
                    entityPlayerMP2.field_71135_a.func_147359_a(new SPacketUseBed((EntityPlayer)object, new BlockPos(this.field_73132_a)));
                }
                if (this.field_73132_a instanceof EntityLivingBase) {
                    object = (EntityLivingBase)this.field_73132_a;
                    for (PotionEffect potionEffect : ((EntityLivingBase)object).func_70651_bq()) {
                        entityPlayerMP2.field_71135_a.func_147359_a(new SPacketEntityEffect(this.field_73132_a.func_145782_y(), potionEffect));
                    }
                }
                if (!this.field_73132_a.func_184188_bt().isEmpty()) {
                    entityPlayerMP2.field_71135_a.func_147359_a(new SPacketSetPassengers(this.field_73132_a));
                }
                if (this.field_73132_a.func_184218_aH()) {
                    entityPlayerMP2.field_71135_a.func_147359_a(new SPacketSetPassengers(this.field_73132_a.func_184187_bx()));
                }
                this.field_73132_a.func_184178_b(entityPlayerMP2);
                entityPlayerMP2.func_184848_d(this.field_73132_a);
            }
        } else if (this.field_73134_o.contains(entityPlayerMP2)) {
            this.field_73134_o.remove(entityPlayerMP2);
            this.field_73132_a.func_184203_c(entityPlayerMP2);
            entityPlayerMP2.func_152339_d(this.field_73132_a);
        }
    }

    public boolean func_180233_c(EntityPlayerMP entityPlayerMP) {
        double d = entityPlayerMP.field_70165_t - (double)this.field_73128_d / 4096.0;
        \u2603 = entityPlayerMP.field_70161_v - (double)this.field_73126_f / 4096.0;
        int \u26032 = Math.min(this.field_73130_b, this.field_187262_f);
        return d >= (double)(-\u26032) && d <= (double)\u26032 && \u2603 >= (double)(-\u26032) && \u2603 <= (double)\u26032 && this.field_73132_a.func_174827_a(entityPlayerMP);
    }

    private boolean func_73121_d(EntityPlayerMP entityPlayerMP) {
        return entityPlayerMP.func_71121_q().func_184164_w().func_72694_a(entityPlayerMP, this.field_73132_a.field_70176_ah, this.field_73132_a.field_70164_aj);
    }

    public void func_73125_b(List<EntityPlayer> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.func_73117_b((EntityPlayerMP)list.get(i));
        }
    }

    private Packet<?> func_151260_c() {
        if (this.field_73132_a.field_70128_L) {
            field_151262_p.warn("Fetching addPacket for removed entity");
        }
        if (this.field_73132_a instanceof EntityPlayerMP) {
            return new SPacketSpawnPlayer((EntityPlayer)this.field_73132_a);
        }
        if (this.field_73132_a instanceof IAnimal) {
            this.field_73140_i = MathHelper.func_76141_d(this.field_73132_a.func_70079_am() * 256.0f / 360.0f);
            return new SPacketSpawnMob((EntityLivingBase)this.field_73132_a);
        }
        if (this.field_73132_a instanceof EntityPainting) {
            return new SPacketSpawnPainting((EntityPainting)this.field_73132_a);
        }
        if (this.field_73132_a instanceof EntityItem) {
            return new SPacketSpawnObject(this.field_73132_a, 2, 1);
        }
        if (this.field_73132_a instanceof EntityMinecart) {
            EntityMinecart entityMinecart = (EntityMinecart)this.field_73132_a;
            return new SPacketSpawnObject(this.field_73132_a, 10, entityMinecart.func_184264_v().func_184956_a());
        }
        if (this.field_73132_a instanceof EntityBoat) {
            return new SPacketSpawnObject(this.field_73132_a, 1);
        }
        if (this.field_73132_a instanceof EntityXPOrb) {
            return new SPacketSpawnExperienceOrb((EntityXPOrb)this.field_73132_a);
        }
        if (this.field_73132_a instanceof EntityFishHook) {
            EntityPlayer entityPlayer = ((EntityFishHook)this.field_73132_a).func_190619_l();
            return new SPacketSpawnObject(this.field_73132_a, 90, entityPlayer == null ? this.field_73132_a.func_145782_y() : entityPlayer.func_145782_y());
        }
        if (this.field_73132_a instanceof EntitySpectralArrow) {
            Entity entity = ((EntitySpectralArrow)this.field_73132_a).func_212360_k();
            return new SPacketSpawnObject(this.field_73132_a, 91, 1 + (entity == null ? this.field_73132_a.func_145782_y() : entity.func_145782_y()));
        }
        if (this.field_73132_a instanceof EntityTippedArrow) {
            Entity entity = ((EntityArrow)this.field_73132_a).func_212360_k();
            return new SPacketSpawnObject(this.field_73132_a, 60, 1 + (entity == null ? this.field_73132_a.func_145782_y() : entity.func_145782_y()));
        }
        if (this.field_73132_a instanceof EntitySnowball) {
            return new SPacketSpawnObject(this.field_73132_a, 61);
        }
        if (this.field_73132_a instanceof EntityTrident) {
            Entity entity = ((EntityArrow)this.field_73132_a).func_212360_k();
            return new SPacketSpawnObject(this.field_73132_a, 94, 1 + (entity == null ? this.field_73132_a.func_145782_y() : entity.func_145782_y()));
        }
        if (this.field_73132_a instanceof EntityLlamaSpit) {
            return new SPacketSpawnObject(this.field_73132_a, 68);
        }
        if (this.field_73132_a instanceof EntityPotion) {
            return new SPacketSpawnObject(this.field_73132_a, 73);
        }
        if (this.field_73132_a instanceof EntityExpBottle) {
            return new SPacketSpawnObject(this.field_73132_a, 75);
        }
        if (this.field_73132_a instanceof EntityEnderPearl) {
            return new SPacketSpawnObject(this.field_73132_a, 65);
        }
        if (this.field_73132_a instanceof EntityEnderEye) {
            return new SPacketSpawnObject(this.field_73132_a, 72);
        }
        if (this.field_73132_a instanceof EntityFireworkRocket) {
            return new SPacketSpawnObject(this.field_73132_a, 76);
        }
        if (this.field_73132_a instanceof EntityFireball) {
            EntityFireball entityFireball = (EntityFireball)this.field_73132_a;
            int \u26032 = 63;
            if (this.field_73132_a instanceof EntitySmallFireball) {
                \u26032 = 64;
            } else if (this.field_73132_a instanceof EntityDragonFireball) {
                \u26032 = 93;
            } else if (this.field_73132_a instanceof EntityWitherSkull) {
                \u26032 = 66;
            }
            SPacketSpawnObject \u26033 = entityFireball.field_70235_a == null ? new SPacketSpawnObject(this.field_73132_a, \u26032, 0) : new SPacketSpawnObject(this.field_73132_a, \u26032, ((EntityFireball)this.field_73132_a).field_70235_a.func_145782_y());
            \u26033.func_149003_d((int)(entityFireball.field_70232_b * 8000.0));
            \u26033.func_149000_e((int)(entityFireball.field_70233_c * 8000.0));
            \u26033.func_149007_f((int)(entityFireball.field_70230_d * 8000.0));
            return \u26033;
        }
        if (this.field_73132_a instanceof EntityShulkerBullet) {
            SPacketSpawnObject \u26034 = new SPacketSpawnObject(this.field_73132_a, 67, 0);
            \u26034.func_149003_d((int)(this.field_73132_a.field_70159_w * 8000.0));
            \u26034.func_149000_e((int)(this.field_73132_a.field_70181_x * 8000.0));
            \u26034.func_149007_f((int)(this.field_73132_a.field_70179_y * 8000.0));
            return \u26034;
        }
        if (this.field_73132_a instanceof EntityEgg) {
            return new SPacketSpawnObject(this.field_73132_a, 62);
        }
        if (this.field_73132_a instanceof EntityEvokerFangs) {
            return new SPacketSpawnObject(this.field_73132_a, 79);
        }
        if (this.field_73132_a instanceof EntityTNTPrimed) {
            return new SPacketSpawnObject(this.field_73132_a, 50);
        }
        if (this.field_73132_a instanceof EntityEnderCrystal) {
            return new SPacketSpawnObject(this.field_73132_a, 51);
        }
        if (this.field_73132_a instanceof EntityFallingBlock) {
            EntityFallingBlock \u26035 = (EntityFallingBlock)this.field_73132_a;
            return new SPacketSpawnObject(this.field_73132_a, 70, Block.func_196246_j(\u26035.func_195054_l()));
        }
        if (this.field_73132_a instanceof EntityArmorStand) {
            return new SPacketSpawnObject(this.field_73132_a, 78);
        }
        if (this.field_73132_a instanceof EntityItemFrame) {
            EntityItemFrame \u26036 = (EntityItemFrame)this.field_73132_a;
            return new SPacketSpawnObject(this.field_73132_a, 71, \u26036.field_174860_b.func_176745_a(), \u26036.func_174857_n());
        }
        if (this.field_73132_a instanceof EntityLeashKnot) {
            EntityLeashKnot \u26037 = (EntityLeashKnot)this.field_73132_a;
            return new SPacketSpawnObject(this.field_73132_a, 77, 0, \u26037.func_174857_n());
        }
        if (this.field_73132_a instanceof EntityAreaEffectCloud) {
            return new SPacketSpawnObject(this.field_73132_a, 3);
        }
        throw new IllegalArgumentException("Don't know how to add " + this.field_73132_a.getClass() + "!");
    }

    public void func_73123_c(EntityPlayerMP entityPlayerMP) {
        if (this.field_73134_o.contains(entityPlayerMP)) {
            this.field_73134_o.remove(entityPlayerMP);
            this.field_73132_a.func_184203_c(entityPlayerMP);
            entityPlayerMP.func_152339_d(this.field_73132_a);
        }
    }

    public Entity func_187260_b() {
        return this.field_73132_a;
    }

    public void func_187259_a(int n) {
        this.field_187262_f = n;
    }

    public void func_187261_c() {
        this.field_73144_s = false;
    }
}

