/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.IAnimal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityAttach;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityTracker {
    private static final Logger field_151249_a = LogManager.getLogger();
    private final WorldServer field_72795_a;
    private final Set<EntityTrackerEntry> field_72793_b = Sets.newHashSet();
    private final IntHashMap<EntityTrackerEntry> field_72794_c = new IntHashMap();
    private int field_72792_d;

    public EntityTracker(WorldServer worldServer) {
        this.field_72795_a = worldServer;
        this.field_72792_d = worldServer.func_73046_m().func_184103_al().func_72372_a();
    }

    public static long func_187253_a(double d) {
        return MathHelper.func_76124_d(d * 4096.0);
    }

    public void func_72786_a(Entity entity2) {
        Entity entity2;
        if (entity2 instanceof EntityPlayerMP) {
            this.func_72791_a(entity2, 512, 2);
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entity2;
            for (EntityTrackerEntry entityTrackerEntry : this.field_72793_b) {
                if (entityTrackerEntry.func_187260_b() == entityPlayerMP) continue;
                entityTrackerEntry.func_73117_b(entityPlayerMP);
            }
        } else if (entity2 instanceof EntityFishHook) {
            this.func_72785_a(entity2, 64, 5, true);
        } else if (entity2 instanceof EntityArrow) {
            this.func_72785_a(entity2, 64, 20, false);
        } else if (entity2 instanceof EntitySmallFireball) {
            this.func_72785_a(entity2, 64, 10, false);
        } else if (entity2 instanceof EntityFireball) {
            this.func_72785_a(entity2, 64, 10, true);
        } else if (entity2 instanceof EntitySnowball) {
            this.func_72785_a(entity2, 64, 10, true);
        } else if (entity2 instanceof EntityLlamaSpit) {
            this.func_72785_a(entity2, 64, 10, false);
        } else if (entity2 instanceof EntityEnderPearl) {
            this.func_72785_a(entity2, 64, 10, true);
        } else if (entity2 instanceof EntityEnderEye) {
            this.func_72785_a(entity2, 64, 4, true);
        } else if (entity2 instanceof EntityEgg) {
            this.func_72785_a(entity2, 64, 10, true);
        } else if (entity2 instanceof EntityPotion) {
            this.func_72785_a(entity2, 64, 10, true);
        } else if (entity2 instanceof EntityExpBottle) {
            this.func_72785_a(entity2, 64, 10, true);
        } else if (entity2 instanceof EntityFireworkRocket) {
            this.func_72785_a(entity2, 64, 10, true);
        } else if (entity2 instanceof EntityItem) {
            this.func_72785_a(entity2, 64, 20, true);
        } else if (entity2 instanceof EntityMinecart) {
            this.func_72785_a(entity2, 80, 3, true);
        } else if (entity2 instanceof EntityBoat) {
            this.func_72785_a(entity2, 80, 3, true);
        } else if (entity2 instanceof EntitySquid) {
            this.func_72785_a(entity2, 64, 3, true);
        } else if (entity2 instanceof EntityWither) {
            this.func_72785_a(entity2, 80, 3, false);
        } else if (entity2 instanceof EntityShulkerBullet) {
            this.func_72785_a(entity2, 80, 3, true);
        } else if (entity2 instanceof EntityBat) {
            this.func_72785_a(entity2, 80, 3, false);
        } else if (entity2 instanceof EntityDragon) {
            this.func_72785_a(entity2, 160, 3, true);
        } else if (entity2 instanceof IAnimal) {
            this.func_72785_a(entity2, 80, 3, true);
        } else if (entity2 instanceof EntityTNTPrimed) {
            this.func_72785_a(entity2, 160, 10, true);
        } else if (entity2 instanceof EntityFallingBlock) {
            this.func_72785_a(entity2, 160, 20, true);
        } else if (entity2 instanceof EntityHanging) {
            this.func_72785_a(entity2, 160, Integer.MAX_VALUE, false);
        } else if (entity2 instanceof EntityArmorStand) {
            this.func_72785_a(entity2, 160, 3, true);
        } else if (entity2 instanceof EntityXPOrb) {
            this.func_72785_a(entity2, 160, 20, true);
        } else if (entity2 instanceof EntityAreaEffectCloud) {
            this.func_72785_a(entity2, 160, Integer.MAX_VALUE, true);
        } else if (entity2 instanceof EntityEnderCrystal) {
            this.func_72785_a(entity2, 256, Integer.MAX_VALUE, false);
        } else if (entity2 instanceof EntityEvokerFangs) {
            this.func_72785_a(entity2, 160, 2, false);
        }
    }

    public void func_72791_a(Entity entity, int n, int n2) {
        this.func_72785_a(entity, n, n2, false);
    }

    public void func_72785_a(Entity entity, int n, int n2, boolean bl) {
        try {
            if (this.field_72794_c.func_76037_b(entity.func_145782_y())) {
                throw new IllegalStateException("Entity is already tracked!");
            }
            EntityTrackerEntry entityTrackerEntry = new EntityTrackerEntry(entity, n, this.field_72792_d, n2, bl);
            this.field_72793_b.add(entityTrackerEntry);
            this.field_72794_c.func_76038_a(entity.func_145782_y(), entityTrackerEntry);
            entityTrackerEntry.func_73125_b(this.field_72795_a.field_73010_i);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Adding entity to track");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Entity To Track");
            \u26032.func_71507_a("Tracking range", n + " blocks");
            \u26032.func_189529_a("Update interval", () -> {
                String string = "Once per " + n2 + " ticks";
                if (n2 == Integer.MAX_VALUE) {
                    string = "Maximum (" + string + ")";
                }
                return string;
            });
            entity.func_85029_a(\u26032);
            this.field_72794_c.func_76041_a(entity.func_145782_y()).func_187260_b().func_85029_a(crashReport.func_85058_a("Entity That Is Already Tracked"));
            try {
                throw new ReportedException(crashReport);
            }
            catch (ReportedException \u26033) {
                field_151249_a.error("\"Silently\" catching entity tracking error.", (Throwable)\u26033);
            }
        }
    }

    public void func_72790_b(Entity entity) {
        Object object;
        if (entity instanceof EntityPlayerMP) {
            object = (EntityPlayerMP)entity;
            for (EntityTrackerEntry entityTrackerEntry : this.field_72793_b) {
                entityTrackerEntry.func_73118_a((EntityPlayerMP)object);
            }
        }
        if ((object = this.field_72794_c.func_76049_d(entity.func_145782_y())) != null) {
            this.field_72793_b.remove(object);
            ((EntityTrackerEntry)object).func_73119_a();
        }
    }

    public void func_72788_a() {
        ArrayList arrayList = Lists.newArrayList();
        for (EntityTrackerEntry entityTrackerEntry : this.field_72793_b) {
            Entity entity;
            entityTrackerEntry.func_73122_a(this.field_72795_a.field_73010_i);
            if (!entityTrackerEntry.field_73133_n || !((entity = entityTrackerEntry.func_187260_b()) instanceof EntityPlayerMP)) continue;
            arrayList.add((EntityPlayerMP)entity);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)arrayList.get(i);
            for (EntityTrackerEntry entityTrackerEntry : this.field_72793_b) {
                if (entityTrackerEntry.func_187260_b() == entityPlayerMP) continue;
                entityTrackerEntry.func_73117_b(entityPlayerMP);
            }
        }
    }

    public void func_180245_a(EntityPlayerMP entityPlayerMP) {
        for (EntityTrackerEntry entityTrackerEntry : this.field_72793_b) {
            if (entityTrackerEntry.func_187260_b() == entityPlayerMP) {
                entityTrackerEntry.func_73125_b(this.field_72795_a.field_73010_i);
                continue;
            }
            entityTrackerEntry.func_73117_b(entityPlayerMP);
        }
    }

    public void func_151247_a(Entity entity, Packet<?> packet) {
        EntityTrackerEntry entityTrackerEntry = this.field_72794_c.func_76041_a(entity.func_145782_y());
        if (entityTrackerEntry != null) {
            entityTrackerEntry.func_151259_a(packet);
        }
    }

    public void func_151248_b(Entity entity, Packet<?> packet) {
        EntityTrackerEntry entityTrackerEntry = this.field_72794_c.func_76041_a(entity.func_145782_y());
        if (entityTrackerEntry != null) {
            entityTrackerEntry.func_151261_b(packet);
        }
    }

    public void func_72787_a(EntityPlayerMP entityPlayerMP) {
        for (EntityTrackerEntry entityTrackerEntry : this.field_72793_b) {
            entityTrackerEntry.func_73123_c(entityPlayerMP);
        }
    }

    public void func_85172_a(EntityPlayerMP entityPlayerMP, Chunk chunk) {
        ArrayList arrayList2 = Lists.newArrayList();
        ArrayList arrayList = Lists.newArrayList();
        for (EntityTrackerEntry entityTrackerEntry : this.field_72793_b) {
            Entity entity = entityTrackerEntry.func_187260_b();
            if (entity == entityPlayerMP || entity.field_70176_ah != chunk.field_76635_g || entity.field_70164_aj != chunk.field_76647_h) continue;
            entityTrackerEntry.func_73117_b(entityPlayerMP);
            if (entity instanceof EntityLiving && ((EntityLiving)entity).func_110166_bE() != null) {
                arrayList2.add(entity);
            }
            if (entity.func_184188_bt().isEmpty()) continue;
            arrayList.add(entity);
        }
        if (!arrayList2.isEmpty()) {
            for (Entity entity : arrayList2) {
                entityPlayerMP.field_71135_a.func_147359_a(new SPacketEntityAttach(entity, ((EntityLiving)entity).func_110166_bE()));
            }
        }
        if (!arrayList.isEmpty()) {
            for (Entity entity : arrayList) {
                entityPlayerMP.field_71135_a.func_147359_a(new SPacketSetPassengers(entity));
            }
        }
    }

    public void func_187252_a(int n) {
        this.field_72792_d = (n - 1) * 16;
        for (EntityTrackerEntry entityTrackerEntry : this.field_72793_b) {
            entityTrackerEntry.func_187259_a(this.field_72792_d);
        }
    }
}

