/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.command.arguments.ParticleArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.init.Particles;
import net.minecraft.init.PotionTypes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityAreaEffectCloud
extends Entity {
    private static final Logger field_195060_a = LogManager.getLogger();
    private static final DataParameter<Float> field_184498_a = EntityDataManager.func_187226_a(EntityAreaEffectCloud.class, DataSerializers.field_187193_c);
    private static final DataParameter<Integer> field_184499_b = EntityDataManager.func_187226_a(EntityAreaEffectCloud.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_184500_c = EntityDataManager.func_187226_a(EntityAreaEffectCloud.class, DataSerializers.field_187198_h);
    private static final DataParameter<IParticleData> field_184501_d = EntityDataManager.func_187226_a(EntityAreaEffectCloud.class, DataSerializers.field_198166_i);
    private PotionType field_184502_e = PotionTypes.field_185229_a;
    private final List<PotionEffect> field_184503_f = Lists.newArrayList();
    private final Map<Entity, Integer> field_184504_g = Maps.newHashMap();
    private int field_184505_h = 600;
    private int field_184506_as = 20;
    private int field_184507_at = 20;
    private boolean field_184508_au;
    private int field_184509_av;
    private float field_184510_aw;
    private float field_184511_ax;
    private EntityLivingBase field_184512_ay;
    private UUID field_184513_az;

    public EntityAreaEffectCloud(World world) {
        super(EntityType.field_200788_b, world);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.func_184483_a(3.0f);
    }

    public EntityAreaEffectCloud(World world, double d, double d2, double d3) {
        this(world);
        this.func_70107_b(d, d2, d3);
    }

    @Override
    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(field_184499_b, 0);
        this.func_184212_Q().func_187214_a(field_184498_a, Float.valueOf(0.5f));
        this.func_184212_Q().func_187214_a(field_184500_c, false);
        this.func_184212_Q().func_187214_a(field_184501_d, Particles.field_197625_r);
    }

    public void func_184483_a(float f) {
        double d = this.field_70165_t;
        \u2603 = this.field_70163_u;
        \u2603 = this.field_70161_v;
        this.func_70105_a(f * 2.0f, 0.5f);
        this.func_70107_b(d, \u2603, \u2603);
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(field_184498_a, Float.valueOf(f));
        }
    }

    public float func_184490_j() {
        return this.func_184212_Q().func_187225_a(field_184498_a).floatValue();
    }

    public void func_184484_a(PotionType potionType) {
        this.field_184502_e = potionType;
        if (!this.field_184508_au) {
            this.func_190618_C();
        }
    }

    private void func_190618_C() {
        if (this.field_184502_e == PotionTypes.field_185229_a && this.field_184503_f.isEmpty()) {
            this.func_184212_Q().func_187227_b(field_184499_b, 0);
        } else {
            this.func_184212_Q().func_187227_b(field_184499_b, PotionUtils.func_185181_a(PotionUtils.func_185186_a(this.field_184502_e, this.field_184503_f)));
        }
    }

    public void func_184496_a(PotionEffect potionEffect) {
        this.field_184503_f.add(potionEffect);
        if (!this.field_184508_au) {
            this.func_190618_C();
        }
    }

    public int func_184492_k() {
        return this.func_184212_Q().func_187225_a(field_184499_b);
    }

    public void func_184482_a(int n) {
        this.field_184508_au = true;
        this.func_184212_Q().func_187227_b(field_184499_b, n);
    }

    public IParticleData func_195058_l() {
        return this.func_184212_Q().func_187225_a(field_184501_d);
    }

    public void func_195059_a(IParticleData iParticleData) {
        this.func_184212_Q().func_187227_b(field_184501_d, iParticleData);
    }

    protected void func_184488_a(boolean bl) {
        this.func_184212_Q().func_187227_b(field_184500_c, bl);
    }

    public boolean func_184497_n() {
        return this.func_184212_Q().func_187225_a(field_184500_c);
    }

    public int func_184489_o() {
        return this.field_184505_h;
    }

    public void func_184486_b(int n) {
        this.field_184505_h = n;
    }

    @Override
    public void func_70071_h_() {
        block23: {
            boolean bl;
            float \u26032;
            block21: {
                IParticleData \u26033;
                block22: {
                    super.func_70071_h_();
                    boolean bl2 = this.func_184497_n();
                    \u26032 = this.func_184490_j();
                    if (!this.field_70170_p.field_72995_K) break block21;
                    \u26033 = this.func_195058_l();
                    if (!bl2) break block22;
                    if (!this.field_70146_Z.nextBoolean()) break block23;
                    for (int i = 0; i < 2; ++i) {
                        float f;
                        float f2 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                        \u2603 = MathHelper.func_76129_c(this.field_70146_Z.nextFloat()) * 0.2f;
                        f = MathHelper.func_76134_b(f2) * \u2603;
                        \u2603 = MathHelper.func_76126_a(f2) * \u2603;
                        if (\u26033.func_197554_b() == Particles.field_197625_r) {
                            int n = this.field_70146_Z.nextBoolean() ? 0xFFFFFF : this.func_184492_k();
                            \u2603 = n >> 16 & 0xFF;
                            \u2603 = n >> 8 & 0xFF;
                            \u2603 = n & 0xFF;
                            this.field_70170_p.func_195589_b(\u26033, this.field_70165_t + (double)f, this.field_70163_u, this.field_70161_v + (double)\u2603, (float)\u2603 / 255.0f, (float)\u2603 / 255.0f, (float)\u2603 / 255.0f);
                            continue;
                        }
                        this.field_70170_p.func_195589_b(\u26033, this.field_70165_t + (double)f, this.field_70163_u, this.field_70161_v + (double)\u2603, 0.0, 0.0, 0.0);
                    }
                    break block23;
                }
                float f = (float)Math.PI * \u26032 * \u26032;
                int \u26034 = 0;
                while ((float)\u26034 < f) {
                    \u2603 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                    \u2603 = MathHelper.func_76129_c(this.field_70146_Z.nextFloat()) * \u26032;
                    f3 = MathHelper.func_76134_b(\u2603) * \u2603;
                    \u2603 = MathHelper.func_76126_a(\u2603) * \u2603;
                    if (\u26033.func_197554_b() == Particles.field_197625_r) {
                        int n = this.func_184492_k();
                        \u2603 = n >> 16 & 0xFF;
                        \u2603 = n >> 8 & 0xFF;
                        \u2603 = n & 0xFF;
                        this.field_70170_p.func_195589_b(\u26033, this.field_70165_t + (double)f3, this.field_70163_u, this.field_70161_v + (double)\u2603, (float)\u2603 / 255.0f, (float)\u2603 / 255.0f, (float)\u2603 / 255.0f);
                    } else {
                        float f3;
                        this.field_70170_p.func_195589_b(\u26033, this.field_70165_t + (double)f3, this.field_70163_u, this.field_70161_v + (double)\u2603, (0.5 - this.field_70146_Z.nextDouble()) * 0.15, 0.01f, (0.5 - this.field_70146_Z.nextDouble()) * 0.15);
                    }
                    ++\u26034;
                }
                break block23;
            }
            if (this.field_70173_aa >= this.field_184506_as + this.field_184505_h) {
                this.func_70106_y();
                return;
            }
            boolean bl3 = bl = this.field_70173_aa < this.field_184506_as;
            if (bl2 != bl) {
                this.func_184488_a(bl);
            }
            if (bl) {
                return;
            }
            if (this.field_184511_ax != 0.0f) {
                if ((\u26032 += this.field_184511_ax) < 0.5f) {
                    this.func_70106_y();
                    return;
                }
                this.func_184483_a(\u26032);
            }
            if (this.field_70173_aa % 5 == 0) {
                List<EntityLivingBase> list;
                Object object = this.field_184504_g.entrySet().iterator();
                while (object.hasNext()) {
                    list = object.next();
                    if (this.field_70173_aa < list.getValue()) continue;
                    object.remove();
                }
                object = Lists.newArrayList();
                for (PotionEffect potionEffect : this.field_184502_e.func_185170_a()) {
                    object.add(new PotionEffect(potionEffect.func_188419_a(), potionEffect.func_76459_b() / 4, potionEffect.func_76458_c(), potionEffect.func_82720_e(), potionEffect.func_188418_e()));
                }
                object.addAll(this.field_184503_f);
                if (object.isEmpty()) {
                    this.field_184504_g.clear();
                } else {
                    list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ());
                    if (!list.isEmpty()) {
                        for (EntityLivingBase entityLivingBase : list) {
                            if (this.field_184504_g.containsKey(entityLivingBase) || !entityLivingBase.func_184603_cC() || !((\u2603 = (\u2603 = entityLivingBase.field_70165_t - this.field_70165_t) * \u2603 + (\u2603 = entityLivingBase.field_70161_v - this.field_70161_v) * \u2603) <= (double)(\u26032 * \u26032))) continue;
                            this.field_184504_g.put(entityLivingBase, this.field_70173_aa + this.field_184507_at);
                            Iterator iterator = object.iterator();
                            while (iterator.hasNext()) {
                                PotionEffect potionEffect = (PotionEffect)iterator.next();
                                if (potionEffect.func_188419_a().func_76403_b()) {
                                    potionEffect.func_188419_a().func_180793_a(this, this.func_184494_w(), entityLivingBase, potionEffect.func_76458_c(), 0.5);
                                    continue;
                                }
                                entityLivingBase.func_195064_c(new PotionEffect(potionEffect));
                            }
                            if (this.field_184510_aw != 0.0f) {
                                if ((\u26032 += this.field_184510_aw) < 0.5f) {
                                    this.func_70106_y();
                                    return;
                                }
                                this.func_184483_a(\u26032);
                            }
                            if (this.field_184509_av == 0) continue;
                            this.field_184505_h += this.field_184509_av;
                            if (this.field_184505_h > 0) continue;
                            this.func_70106_y();
                            return;
                        }
                    }
                }
            }
        }
    }

    public void func_184495_b(float f) {
        this.field_184510_aw = f;
    }

    public void func_184487_c(float f) {
        this.field_184511_ax = f;
    }

    public void func_184485_d(int n) {
        this.field_184506_as = n;
    }

    public void func_184481_a(@Nullable EntityLivingBase entityLivingBase) {
        this.field_184512_ay = entityLivingBase;
        this.field_184513_az = entityLivingBase == null ? null : entityLivingBase.func_110124_au();
    }

    @Nullable
    public EntityLivingBase func_184494_w() {
        Entity entity;
        if (this.field_184512_ay == null && this.field_184513_az != null && this.field_70170_p instanceof WorldServer && (entity = ((WorldServer)this.field_70170_p).func_175733_a(this.field_184513_az)) instanceof EntityLivingBase) {
            this.field_184512_ay = (EntityLivingBase)entity;
        }
        return this.field_184512_ay;
    }

    @Override
    protected void func_70037_a(NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        this.field_70173_aa = nBTTagCompound2.func_74762_e("Age");
        this.field_184505_h = nBTTagCompound2.func_74762_e("Duration");
        this.field_184506_as = nBTTagCompound2.func_74762_e("WaitTime");
        this.field_184507_at = nBTTagCompound2.func_74762_e("ReapplicationDelay");
        this.field_184509_av = nBTTagCompound2.func_74762_e("DurationOnUse");
        this.field_184510_aw = nBTTagCompound2.func_74760_g("RadiusOnUse");
        this.field_184511_ax = nBTTagCompound2.func_74760_g("RadiusPerTick");
        this.func_184483_a(nBTTagCompound2.func_74760_g("Radius"));
        this.field_184513_az = nBTTagCompound2.func_186857_a("OwnerUUID");
        if (nBTTagCompound2.func_150297_b("Particle", 8)) {
            try {
                this.func_195059_a(ParticleArgument.func_197189_a(new StringReader(nBTTagCompound2.func_74779_i("Particle"))));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                field_195060_a.warn("Couldn't load custom particle {}", (Object)nBTTagCompound2.func_74779_i("Particle"), (Object)commandSyntaxException);
            }
        }
        if (nBTTagCompound2.func_150297_b("Color", 99)) {
            this.func_184482_a(nBTTagCompound2.func_74762_e("Color"));
        }
        if (nBTTagCompound2.func_150297_b("Potion", 8)) {
            this.func_184484_a(PotionUtils.func_185187_c(nBTTagCompound2));
        }
        if (nBTTagCompound2.func_150297_b("Effects", 9)) {
            NBTTagList nBTTagList = nBTTagCompound2.func_150295_c("Effects", 10);
            this.field_184503_f.clear();
            for (int i = 0; i < nBTTagList.size(); ++i) {
                PotionEffect potionEffect = PotionEffect.func_82722_b(nBTTagList.func_150305_b(i));
                if (potionEffect == null) continue;
                this.func_184496_a(potionEffect);
            }
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound nBTTagCompound2) {
        nBTTagCompound2.func_74768_a("Age", this.field_70173_aa);
        nBTTagCompound2.func_74768_a("Duration", this.field_184505_h);
        nBTTagCompound2.func_74768_a("WaitTime", this.field_184506_as);
        nBTTagCompound2.func_74768_a("ReapplicationDelay", this.field_184507_at);
        nBTTagCompound2.func_74768_a("DurationOnUse", this.field_184509_av);
        nBTTagCompound2.func_74776_a("RadiusOnUse", this.field_184510_aw);
        nBTTagCompound2.func_74776_a("RadiusPerTick", this.field_184511_ax);
        nBTTagCompound2.func_74776_a("Radius", this.func_184490_j());
        nBTTagCompound2.func_74778_a("Particle", this.func_195058_l().func_197555_a());
        if (this.field_184513_az != null) {
            nBTTagCompound2.func_186854_a("OwnerUUID", this.field_184513_az);
        }
        if (this.field_184508_au) {
            nBTTagCompound2.func_74768_a("Color", this.func_184492_k());
        }
        if (this.field_184502_e != PotionTypes.field_185229_a && this.field_184502_e != null) {
            nBTTagCompound2.func_74778_a("Potion", IRegistry.field_212621_j.func_177774_c(this.field_184502_e).toString());
        }
        if (!this.field_184503_f.isEmpty()) {
            NBTTagCompound nBTTagCompound2;
            NBTTagList nBTTagList = new NBTTagList();
            for (PotionEffect potionEffect : this.field_184503_f) {
                nBTTagList.add(potionEffect.func_82719_a(new NBTTagCompound()));
            }
            nBTTagCompound2.func_74782_a("Effects", nBTTagList);
        }
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_184498_a.equals(dataParameter)) {
            this.func_184483_a(this.func_184490_j());
        }
        super.func_184206_a(dataParameter);
    }

    @Override
    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }
}

