/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.stream.Collectors;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.data.AdvancementProvider;
import net.minecraft.data.BlockListReport;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.CommandsReport;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.FluidTagsProvider;
import net.minecraft.data.ItemListReport;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.data.NBTToSNBTConverter;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.SNBTToNBTConverter;

public class Main {
    public static void main(String[] stringArray) throws IOException {
        OptionParser optionParser = new OptionParser();
        AbstractOptionSpec \u26032 = optionParser.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder \u26033 = optionParser.accepts("server", "Include server generators");
        OptionSpecBuilder \u26034 = optionParser.accepts("client", "Include client generators");
        OptionSpecBuilder \u26035 = optionParser.accepts("dev", "Include development tools");
        OptionSpecBuilder \u26036 = optionParser.accepts("reports", "Include data reports");
        OptionSpecBuilder \u26037 = optionParser.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec \u26038 = optionParser.accepts("output", "Output folder").withRequiredArg().defaultsTo((Object)"generated", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u26039 = optionParser.accepts("input", "Input folder").withRequiredArg();
        OptionSet \u260310 = optionParser.parse(stringArray);
        if (\u260310.has((OptionSpec)\u26032) || !\u260310.hasOptions()) {
            optionParser.printHelpOn((OutputStream)System.out);
            return;
        }
        Path \u260311 = Paths.get((String)\u26038.value(\u260310), new String[0]);
        boolean \u260312 = \u260310.has((OptionSpec)\u26034) || \u260310.has((OptionSpec)\u26037);
        boolean \u260313 = \u260310.has((OptionSpec)\u26033) || \u260310.has((OptionSpec)\u26037);
        boolean \u260314 = \u260310.has((OptionSpec)\u26035) || \u260310.has((OptionSpec)\u26037);
        boolean \u260315 = \u260310.has((OptionSpec)\u26036) || \u260310.has((OptionSpec)\u26037);
        DataGenerator \u260316 = Main.func_200264_a(\u260311, \u260310.valuesOf((OptionSpec)\u26039).stream().map(string -> Paths.get(string, new String[0])).collect(Collectors.toList()), \u260312, \u260313, \u260314, \u260315);
        \u260316.func_200392_c();
    }

    public static DataGenerator func_200264_a(Path path, Collection<Path> collection, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        DataGenerator dataGenerator = new DataGenerator(path, collection);
        if (bl || bl2) {
            dataGenerator.func_200390_a(new SNBTToNBTConverter(dataGenerator));
        }
        if (bl2) {
            dataGenerator.func_200390_a(new FluidTagsProvider(dataGenerator));
            dataGenerator.func_200390_a(new BlockTagsProvider(dataGenerator));
            dataGenerator.func_200390_a(new ItemTagsProvider(dataGenerator));
            dataGenerator.func_200390_a(new RecipeProvider(dataGenerator));
            dataGenerator.func_200390_a(new AdvancementProvider(dataGenerator));
        }
        if (bl3) {
            dataGenerator.func_200390_a(new NBTToSNBTConverter(dataGenerator));
        }
        if (bl4) {
            dataGenerator.func_200390_a(new BlockListReport(dataGenerator));
            dataGenerator.func_200390_a(new ItemListReport(dataGenerator));
            dataGenerator.func_200390_a(new CommandsReport(dataGenerator));
        }
        return dataGenerator;
    }
}

