/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.crash;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.util.math.BlockPos;

public class CrashReportCategory {
    private final CrashReport field_85078_a;
    private final String field_85076_b;
    private final List<Entry> field_85077_c = Lists.newArrayList();
    private StackTraceElement[] field_85075_d = new StackTraceElement[0];

    public CrashReportCategory(CrashReport crashReport, String string) {
        this.field_85078_a = crashReport;
        this.field_85076_b = string;
    }

    public static String func_180522_a(BlockPos blockPos) {
        return CrashReportCategory.func_184876_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public static String func_184876_a(int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append(String.format("World: (%d,%d,%d)", n, n2, n3));
        }
        catch (Throwable \u26032) {
            stringBuilder.append("(Error finding world loc)");
        }
        stringBuilder.append(", ");
        try {
            int n4 = n >> 4;
            \u2603 = n3 >> 4;
            \u2603 = n & 0xF;
            \u2603 = n2 >> 4;
            \u2603 = n3 & 0xF;
            \u2603 = n4 << 4;
            \u2603 = \u2603 << 4;
            \u2603 = (n4 + 1 << 4) - 1;
            \u2603 = (\u2603 + 1 << 4) - 1;
            stringBuilder.append(String.format("Chunk: (at %d,%d,%d in %d,%d; contains blocks %d,0,%d to %d,255,%d)", \u2603, \u2603, \u2603, n4, \u2603, \u2603, \u2603, \u2603, \u2603));
        }
        catch (Throwable throwable) {
            stringBuilder.append("(Error finding chunk loc)");
        }
        stringBuilder.append(", ");
        try {
            int n5 = n >> 9;
            \u2603 = n3 >> 9;
            \u2603 = n5 << 5;
            \u2603 = \u2603 << 5;
            \u2603 = (n5 + 1 << 5) - 1;
            \u2603 = (\u2603 + 1 << 5) - 1;
            \u2603 = n5 << 9;
            \u2603 = \u2603 << 9;
            \u2603 = (n5 + 1 << 9) - 1;
            \u2603 = (\u2603 + 1 << 9) - 1;
            stringBuilder.append(String.format("Region: (%d,%d; contains chunks %d,%d to %d,%d, blocks %d,0,%d to %d,255,%d)", n5, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603));
        }
        catch (Throwable throwable) {
            stringBuilder.append("(Error finding world loc)");
        }
        return stringBuilder.toString();
    }

    public void func_189529_a(String string, ICrashReportDetail<String> iCrashReportDetail) {
        try {
            this.func_71507_a(string, iCrashReportDetail.call());
        }
        catch (Throwable throwable) {
            this.func_71499_a(string, throwable);
        }
    }

    public void func_71507_a(String string, Object object) {
        this.field_85077_c.add(new Entry(string, object));
    }

    public void func_71499_a(String string, Throwable throwable) {
        this.func_71507_a(string, throwable);
    }

    public int func_85073_a(int n) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray.length <= 0) {
            return 0;
        }
        this.field_85075_d = new StackTraceElement[stackTraceElementArray.length - 3 - n];
        System.arraycopy(stackTraceElementArray, 3 + n, this.field_85075_d, 0, this.field_85075_d.length);
        return this.field_85075_d.length;
    }

    public boolean func_85069_a(StackTraceElement stackTraceElement, StackTraceElement stackTraceElement2) {
        if (this.field_85075_d.length == 0 || stackTraceElement == null) {
            return false;
        }
        \u2603 = this.field_85075_d[0];
        if (!(\u2603.isNativeMethod() == stackTraceElement.isNativeMethod() && \u2603.getClassName().equals(stackTraceElement.getClassName()) && \u2603.getFileName().equals(stackTraceElement.getFileName()) && \u2603.getMethodName().equals(stackTraceElement.getMethodName()))) {
            return false;
        }
        if (stackTraceElement2 != null != this.field_85075_d.length > 1) {
            return false;
        }
        if (stackTraceElement2 != null && !this.field_85075_d[1].equals(stackTraceElement2)) {
            return false;
        }
        this.field_85075_d[0] = stackTraceElement;
        return true;
    }

    public void func_85070_b(int n) {
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[this.field_85075_d.length - n];
        System.arraycopy(this.field_85075_d, 0, stackTraceElementArray, 0, stackTraceElementArray.length);
        this.field_85075_d = stackTraceElementArray;
    }

    public void func_85072_a(StringBuilder stringBuilder2) {
        stringBuilder2.append("-- ").append(this.field_85076_b).append(" --\n");
        stringBuilder2.append("Details:");
        for (Entry entry : this.field_85077_c) {
            stringBuilder2.append("\n\t");
            stringBuilder2.append(entry.func_85089_a());
            stringBuilder2.append(": ");
            stringBuilder2.append(entry.func_85090_b());
        }
        if (this.field_85075_d != null && this.field_85075_d.length > 0) {
            StringBuilder stringBuilder2;
            stringBuilder2.append("\nStacktrace:");
            for (StackTraceElement stackTraceElement : this.field_85075_d) {
                stringBuilder2.append("\n\tat ");
                stringBuilder2.append(stackTraceElement);
            }
        }
    }

    public StackTraceElement[] func_147152_a() {
        return this.field_85075_d;
    }

    public static void func_175750_a(CrashReportCategory crashReportCategory, BlockPos blockPos, @Nullable IBlockState iBlockState) {
        if (iBlockState != null) {
            crashReportCategory.func_189529_a("Block", iBlockState::toString);
        }
        crashReportCategory.func_189529_a("Block location", () -> CrashReportCategory.func_180522_a(blockPos));
    }

    static class Entry {
        private final String field_85092_a;
        private final String field_85091_b;

        public Entry(String string, Object object2) {
            this.field_85092_a = string;
            if (object2 == null) {
                this.field_85091_b = "~~NULL~~";
            } else if (object2 instanceof Throwable) {
                Throwable throwable = (Throwable)object2;
                this.field_85091_b = "~~ERROR~~ " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
            } else {
                Object object2;
                this.field_85091_b = object2.toString();
            }
        }

        public String func_85089_a() {
            return this.field_85092_a;
        }

        public String func_85090_b() {
            return this.field_85091_b;
        }
    }
}

