/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ComponentArgument;
import net.minecraft.command.arguments.ObjectiveArgument;
import net.minecraft.command.arguments.ObjectiveCriteriaArgument;
import net.minecraft.command.arguments.OperationArgument;
import net.minecraft.command.arguments.ScoreHolderArgument;
import net.minecraft.command.arguments.ScoreboardSlotArgument;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextComponentUtils;

public class ScoreboardCommand {
    private static final SimpleCommandExceptionType field_198663_a = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.scoreboard.objectives.add.duplicate", new Object[0]));
    private static final SimpleCommandExceptionType field_198666_d = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.scoreboard.objectives.display.alreadyEmpty", new Object[0]));
    private static final SimpleCommandExceptionType field_198667_e = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.scoreboard.objectives.display.alreadySet", new Object[0]));
    private static final SimpleCommandExceptionType field_198668_f = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.scoreboard.players.enable.failed", new Object[0]));
    private static final SimpleCommandExceptionType field_198669_g = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.scoreboard.players.enable.invalid", new Object[0]));
    private static final Dynamic2CommandExceptionType field_198670_h = new Dynamic2CommandExceptionType((object, object2) -> new TextComponentTranslation("commands.scoreboard.players.get.null", object, object2));

    public static void func_198647_a(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("scoreboard").requires(commandSource -> commandSource.func_197034_c(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("objectives").then(Commands.func_197057_a("list").executes(commandContext -> ScoreboardCommand.func_198662_b((CommandSource)commandContext.getSource())))).then(Commands.func_197057_a("add").then(Commands.func_197056_a("objective", StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.func_197056_a("criteria", ObjectiveCriteriaArgument.func_197162_a()).executes(commandContext -> ScoreboardCommand.func_198629_a((CommandSource)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"objective"), ObjectiveCriteriaArgument.func_197161_a((CommandContext<CommandSource>)commandContext, "criteria"), new TextComponentString(StringArgumentType.getString((CommandContext)commandContext, (String)"objective"))))).then(Commands.func_197056_a("displayName", ComponentArgument.func_197067_a()).executes(commandContext -> ScoreboardCommand.func_198629_a((CommandSource)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"objective"), ObjectiveCriteriaArgument.func_197161_a((CommandContext<CommandSource>)commandContext, "criteria"), ComponentArgument.func_197068_a((CommandContext<CommandSource>)commandContext, "displayName")))))))).then(Commands.func_197057_a("modify").then(((RequiredArgumentBuilder)Commands.func_197056_a("objective", ObjectiveArgument.func_197157_a()).then(Commands.func_197057_a("displayname").then(Commands.func_197056_a("displayName", ComponentArgument.func_197067_a()).executes(commandContext -> ScoreboardCommand.func_211749_a((CommandSource)commandContext.getSource(), ObjectiveArgument.func_197158_a((CommandContext<CommandSource>)commandContext, "objective"), ComponentArgument.func_197068_a((CommandContext<CommandSource>)commandContext, "displayName")))))).then(ScoreboardCommand.func_211915_a())))).then(Commands.func_197057_a("remove").then(Commands.func_197056_a("objective", ObjectiveArgument.func_197157_a()).executes(commandContext -> ScoreboardCommand.func_198637_a((CommandSource)commandContext.getSource(), ObjectiveArgument.func_197158_a((CommandContext<CommandSource>)commandContext, "objective")))))).then(Commands.func_197057_a("setdisplay").then(((RequiredArgumentBuilder)Commands.func_197056_a("slot", ScoreboardSlotArgument.func_197219_a()).executes(commandContext -> ScoreboardCommand.func_198632_a((CommandSource)commandContext.getSource(), ScoreboardSlotArgument.func_197217_a((CommandContext<CommandSource>)commandContext, "slot")))).then(Commands.func_197056_a("objective", ObjectiveArgument.func_197157_a()).executes(commandContext -> ScoreboardCommand.func_198659_a((CommandSource)commandContext.getSource(), ScoreboardSlotArgument.func_197217_a((CommandContext<CommandSource>)commandContext, "slot"), ObjectiveArgument.func_197158_a((CommandContext<CommandSource>)commandContext, "objective")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("players").then(((LiteralArgumentBuilder)Commands.func_197057_a("list").executes(commandContext -> ScoreboardCommand.func_198661_a((CommandSource)commandContext.getSource()))).then(Commands.func_197056_a("target", ScoreHolderArgument.func_197209_a()).suggests(ScoreHolderArgument.field_201326_a).executes(commandContext -> ScoreboardCommand.func_198643_a((CommandSource)commandContext.getSource(), ScoreHolderArgument.func_197211_a((CommandContext<CommandSource>)commandContext, "target")))))).then(Commands.func_197057_a("set").then(Commands.func_197056_a("targets", ScoreHolderArgument.func_197214_b()).suggests(ScoreHolderArgument.field_201326_a).then(Commands.func_197056_a("objective", ObjectiveArgument.func_197157_a()).then(Commands.func_197056_a("score", IntegerArgumentType.integer()).executes(commandContext -> ScoreboardCommand.func_198653_a((CommandSource)commandContext.getSource(), ScoreHolderArgument.func_211707_c((CommandContext<CommandSource>)commandContext, "targets"), ObjectiveArgument.func_197156_b((CommandContext<CommandSource>)commandContext, "objective"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"score")))))))).then(Commands.func_197057_a("get").then(Commands.func_197056_a("target", ScoreHolderArgument.func_197209_a()).suggests(ScoreHolderArgument.field_201326_a).then(Commands.func_197056_a("objective", ObjectiveArgument.func_197157_a()).executes(commandContext -> ScoreboardCommand.func_198634_a((CommandSource)commandContext.getSource(), ScoreHolderArgument.func_197211_a((CommandContext<CommandSource>)commandContext, "target"), ObjectiveArgument.func_197158_a((CommandContext<CommandSource>)commandContext, "objective"))))))).then(Commands.func_197057_a("add").then(Commands.func_197056_a("targets", ScoreHolderArgument.func_197214_b()).suggests(ScoreHolderArgument.field_201326_a).then(Commands.func_197056_a("objective", ObjectiveArgument.func_197157_a()).then(Commands.func_197056_a("score", IntegerArgumentType.integer((int)0)).executes(commandContext -> ScoreboardCommand.func_198633_b((CommandSource)commandContext.getSource(), ScoreHolderArgument.func_211707_c((CommandContext<CommandSource>)commandContext, "targets"), ObjectiveArgument.func_197156_b((CommandContext<CommandSource>)commandContext, "objective"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"score")))))))).then(Commands.func_197057_a("remove").then(Commands.func_197056_a("targets", ScoreHolderArgument.func_197214_b()).suggests(ScoreHolderArgument.field_201326_a).then(Commands.func_197056_a("objective", ObjectiveArgument.func_197157_a()).then(Commands.func_197056_a("score", IntegerArgumentType.integer((int)0)).executes(commandContext -> ScoreboardCommand.func_198651_c((CommandSource)commandContext.getSource(), ScoreHolderArgument.func_211707_c((CommandContext<CommandSource>)commandContext, "targets"), ObjectiveArgument.func_197156_b((CommandContext<CommandSource>)commandContext, "objective"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"score")))))))).then(Commands.func_197057_a("reset").then(((RequiredArgumentBuilder)Commands.func_197056_a("targets", ScoreHolderArgument.func_197214_b()).suggests(ScoreHolderArgument.field_201326_a).executes(commandContext -> ScoreboardCommand.func_198654_a((CommandSource)commandContext.getSource(), ScoreHolderArgument.func_211707_c((CommandContext<CommandSource>)commandContext, "targets")))).then(Commands.func_197056_a("objective", ObjectiveArgument.func_197157_a()).executes(commandContext -> ScoreboardCommand.func_198656_b((CommandSource)commandContext.getSource(), ScoreHolderArgument.func_211707_c((CommandContext<CommandSource>)commandContext, "targets"), ObjectiveArgument.func_197158_a((CommandContext<CommandSource>)commandContext, "objective"))))))).then(Commands.func_197057_a("enable").then(Commands.func_197056_a("targets", ScoreHolderArgument.func_197214_b()).suggests(ScoreHolderArgument.field_201326_a).then(Commands.func_197056_a("objective", ObjectiveArgument.func_197157_a()).suggests((commandContext, suggestionsBuilder) -> ScoreboardCommand.func_198641_a((CommandSource)commandContext.getSource(), ScoreHolderArgument.func_211707_c((CommandContext<CommandSource>)commandContext, "targets"), suggestionsBuilder)).executes(commandContext -> ScoreboardCommand.func_198644_a((CommandSource)commandContext.getSource(), ScoreHolderArgument.func_211707_c((CommandContext<CommandSource>)commandContext, "targets"), ObjectiveArgument.func_197158_a((CommandContext<CommandSource>)commandContext, "objective"))))))).then(Commands.func_197057_a("operation").then(Commands.func_197056_a("targets", ScoreHolderArgument.func_197214_b()).suggests(ScoreHolderArgument.field_201326_a).then(Commands.func_197056_a("targetObjective", ObjectiveArgument.func_197157_a()).then(Commands.func_197056_a("operation", OperationArgument.func_197184_a()).then(Commands.func_197056_a("source", ScoreHolderArgument.func_197214_b()).suggests(ScoreHolderArgument.field_201326_a).then(Commands.func_197056_a("sourceObjective", ObjectiveArgument.func_197157_a()).executes(commandContext -> ScoreboardCommand.func_198658_a((CommandSource)commandContext.getSource(), ScoreHolderArgument.func_211707_c((CommandContext<CommandSource>)commandContext, "targets"), ObjectiveArgument.func_197156_b((CommandContext<CommandSource>)commandContext, "targetObjective"), OperationArgument.func_197179_a((CommandContext<CommandSource>)commandContext, "operation"), ScoreHolderArgument.func_211707_c((CommandContext<CommandSource>)commandContext, "source"), ObjectiveArgument.func_197158_a((CommandContext<CommandSource>)commandContext, "sourceObjective")))))))))));
    }

    private static LiteralArgumentBuilder<CommandSource> func_211915_a() {
        LiteralArgumentBuilder<CommandSource> literalArgumentBuilder = Commands.func_197057_a("rendertype");
        for (ScoreCriteria.RenderType renderType : ScoreCriteria.RenderType.values()) {
            literalArgumentBuilder.then(Commands.func_197057_a(renderType.func_211838_a()).executes(commandContext -> ScoreboardCommand.func_211910_a((CommandSource)commandContext.getSource(), ObjectiveArgument.func_197158_a((CommandContext<CommandSource>)commandContext, "objective"), renderType)));
        }
        return literalArgumentBuilder;
    }

    private static CompletableFuture<Suggestions> func_198641_a(CommandSource commandSource, Collection<String> collection, SuggestionsBuilder suggestionsBuilder) {
        ArrayList arrayList = Lists.newArrayList();
        ServerScoreboard \u26032 = commandSource.func_197028_i().func_200251_aP();
        for (ScoreObjective scoreObjective : \u26032.func_96514_c()) {
            if (scoreObjective.func_96680_c() != ScoreCriteria.field_178791_c) continue;
            boolean bl = false;
            for (String string : collection) {
                if (\u26032.func_178819_b(string, scoreObjective) && !\u26032.func_96529_a(string, scoreObjective).func_178816_g()) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList.add(scoreObjective.func_96679_b());
        }
        return ISuggestionProvider.func_197005_b(arrayList, suggestionsBuilder);
    }

    private static int func_198634_a(CommandSource commandSource, String string, ScoreObjective scoreObjective) throws CommandSyntaxException {
        ServerScoreboard serverScoreboard = commandSource.func_197028_i().func_200251_aP();
        if (!serverScoreboard.func_178819_b(string, scoreObjective)) {
            throw field_198670_h.create((Object)scoreObjective.func_96679_b(), (Object)string);
        }
        Score \u26032 = serverScoreboard.func_96529_a(string, scoreObjective);
        commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.get.success", string, \u26032.func_96652_c(), scoreObjective.func_197890_e()), false);
        return \u26032.func_96652_c();
    }

    private static int func_198658_a(CommandSource commandSource, Collection<String> collection3, ScoreObjective scoreObjective, OperationArgument.IOperation iOperation, Collection<String> collection2, ScoreObjective scoreObjective2) throws CommandSyntaxException {
        Collection<String> collection3;
        ServerScoreboard serverScoreboard = commandSource.func_197028_i().func_200251_aP();
        int \u26032 = 0;
        for (String string : collection3) {
            Score score = serverScoreboard.func_96529_a(string, scoreObjective);
            for (String string2 : collection2) {
                Score score2 = serverScoreboard.func_96529_a(string2, scoreObjective2);
                iOperation.apply(score, score2);
            }
            \u26032 += score.func_96652_c();
        }
        if (collection3.size() == 1) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.operation.success.single", scoreObjective.func_197890_e(), collection3.iterator().next(), \u26032), true);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.operation.success.multiple", scoreObjective.func_197890_e(), collection3.size()), true);
        }
        return \u26032;
    }

    private static int func_198644_a(CommandSource commandSource, Collection<String> collection2, ScoreObjective scoreObjective) throws CommandSyntaxException {
        Collection<String> collection2;
        if (scoreObjective.func_96680_c() != ScoreCriteria.field_178791_c) {
            throw field_198669_g.create();
        }
        ServerScoreboard serverScoreboard = commandSource.func_197028_i().func_200251_aP();
        int \u26032 = 0;
        for (String string : collection2) {
            Score score = serverScoreboard.func_96529_a(string, scoreObjective);
            if (!score.func_178816_g()) continue;
            score.func_178815_a(false);
            ++\u26032;
        }
        if (\u26032 == 0) {
            throw field_198668_f.create();
        }
        if (collection2.size() == 1) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.enable.success.single", scoreObjective.func_197890_e(), collection2.iterator().next()), true);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.enable.success.multiple", scoreObjective.func_197890_e(), collection2.size()), true);
        }
        return \u26032;
    }

    private static int func_198654_a(CommandSource commandSource, Collection<String> collection2) {
        Collection<String> collection2;
        ServerScoreboard serverScoreboard = commandSource.func_197028_i().func_200251_aP();
        for (String string : collection2) {
            serverScoreboard.func_178822_d(string, null);
        }
        if (collection2.size() == 1) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.reset.all.single", collection2.iterator().next()), true);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.reset.all.multiple", collection2.size()), true);
        }
        return collection2.size();
    }

    private static int func_198656_b(CommandSource commandSource, Collection<String> collection2, ScoreObjective scoreObjective) {
        Collection<String> collection2;
        ServerScoreboard serverScoreboard = commandSource.func_197028_i().func_200251_aP();
        for (String string : collection2) {
            serverScoreboard.func_178822_d(string, scoreObjective);
        }
        if (collection2.size() == 1) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.reset.specific.single", scoreObjective.func_197890_e(), collection2.iterator().next()), true);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.reset.specific.multiple", scoreObjective.func_197890_e(), collection2.size()), true);
        }
        return collection2.size();
    }

    private static int func_198653_a(CommandSource commandSource, Collection<String> collection2, ScoreObjective scoreObjective, int n) {
        Collection<String> collection2;
        ServerScoreboard serverScoreboard = commandSource.func_197028_i().func_200251_aP();
        for (String string : collection2) {
            Score score = serverScoreboard.func_96529_a(string, scoreObjective);
            score.func_96647_c(n);
        }
        if (collection2.size() == 1) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.set.success.single", scoreObjective.func_197890_e(), collection2.iterator().next(), n), true);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.set.success.multiple", scoreObjective.func_197890_e(), collection2.size(), n), true);
        }
        return n * collection2.size();
    }

    private static int func_198633_b(CommandSource commandSource, Collection<String> collection2, ScoreObjective scoreObjective, int n) {
        Collection<String> collection2;
        ServerScoreboard serverScoreboard = commandSource.func_197028_i().func_200251_aP();
        int \u26032 = 0;
        for (String string : collection2) {
            Score score = serverScoreboard.func_96529_a(string, scoreObjective);
            score.func_96647_c(score.func_96652_c() + n);
            \u26032 += score.func_96652_c();
        }
        if (collection2.size() == 1) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.add.success.single", n, scoreObjective.func_197890_e(), collection2.iterator().next(), \u26032), true);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.add.success.multiple", n, scoreObjective.func_197890_e(), collection2.size()), true);
        }
        return \u26032;
    }

    private static int func_198651_c(CommandSource commandSource, Collection<String> collection2, ScoreObjective scoreObjective, int n) {
        Collection<String> collection2;
        ServerScoreboard serverScoreboard = commandSource.func_197028_i().func_200251_aP();
        int \u26032 = 0;
        for (String string : collection2) {
            Score score = serverScoreboard.func_96529_a(string, scoreObjective);
            score.func_96647_c(score.func_96652_c() - n);
            \u26032 += score.func_96652_c();
        }
        if (collection2.size() == 1) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.remove.success.single", n, scoreObjective.func_197890_e(), collection2.iterator().next(), \u26032), true);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.remove.success.multiple", n, scoreObjective.func_197890_e(), collection2.size()), true);
        }
        return \u26032;
    }

    private static int func_198661_a(CommandSource commandSource) {
        Collection<String> collection = commandSource.func_197028_i().func_200251_aP().func_96526_d();
        if (collection.isEmpty()) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.list.empty", new Object[0]), false);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.list.success", collection.size(), TextComponentUtils.func_197678_a(collection)), false);
        }
        return collection.size();
    }

    private static int func_198643_a(CommandSource commandSource, String string) {
        Map<ScoreObjective, Score> map = commandSource.func_197028_i().func_200251_aP().func_96510_d(string);
        if (map.isEmpty()) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.list.entity.empty", string), false);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.list.entity.success", string, map.size()), false);
            for (Map.Entry<ScoreObjective, Score> entry : map.entrySet()) {
                commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.players.list.entity.entry", entry.getKey().func_197890_e(), entry.getValue().func_96652_c()), false);
            }
        }
        return map.size();
    }

    private static int func_198632_a(CommandSource commandSource, int n) throws CommandSyntaxException {
        ServerScoreboard serverScoreboard = commandSource.func_197028_i().func_200251_aP();
        if (serverScoreboard.func_96539_a(n) == null) {
            throw field_198666_d.create();
        }
        ((Scoreboard)serverScoreboard).func_96530_a(n, null);
        commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.objectives.display.cleared", Scoreboard.func_178821_h()[n]), true);
        return 0;
    }

    private static int func_198659_a(CommandSource commandSource, int n, ScoreObjective scoreObjective) throws CommandSyntaxException {
        ServerScoreboard serverScoreboard = commandSource.func_197028_i().func_200251_aP();
        if (serverScoreboard.func_96539_a(n) == scoreObjective) {
            throw field_198667_e.create();
        }
        ((Scoreboard)serverScoreboard).func_96530_a(n, scoreObjective);
        commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.objectives.display.set", Scoreboard.func_178821_h()[n], scoreObjective.func_96678_d()), true);
        return 0;
    }

    private static int func_211749_a(CommandSource commandSource, ScoreObjective scoreObjective, ITextComponent iTextComponent) {
        if (!scoreObjective.func_96678_d().equals(iTextComponent)) {
            scoreObjective.func_199864_a(iTextComponent);
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.objectives.modify.displayname", scoreObjective.func_96679_b(), scoreObjective.func_197890_e()), true);
        }
        return 0;
    }

    private static int func_211910_a(CommandSource commandSource, ScoreObjective scoreObjective, ScoreCriteria.RenderType renderType) {
        if (scoreObjective.func_199865_f() != renderType) {
            scoreObjective.func_199866_a(renderType);
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.objectives.modify.rendertype", scoreObjective.func_197890_e()), true);
        }
        return 0;
    }

    private static int func_198637_a(CommandSource commandSource, ScoreObjective scoreObjective) {
        ServerScoreboard serverScoreboard = commandSource.func_197028_i().func_200251_aP();
        serverScoreboard.func_96519_k(scoreObjective);
        commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.objectives.remove.success", scoreObjective.func_197890_e()), true);
        return serverScoreboard.func_96514_c().size();
    }

    private static int func_198629_a(CommandSource commandSource, String string, ScoreCriteria scoreCriteria, ITextComponent iTextComponent) throws CommandSyntaxException {
        ServerScoreboard serverScoreboard = commandSource.func_197028_i().func_200251_aP();
        if (serverScoreboard.func_96518_b(string) != null) {
            throw field_198663_a.create();
        }
        if (string.length() > 16) {
            throw ObjectiveArgument.field_200379_a.create((Object)16);
        }
        serverScoreboard.func_199868_a(string, scoreCriteria, iTextComponent, scoreCriteria.func_178790_c());
        ScoreObjective \u26032 = serverScoreboard.func_96518_b(string);
        commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.objectives.add.success", \u26032.func_197890_e()), true);
        return serverScoreboard.func_96514_c().size();
    }

    private static int func_198662_b(CommandSource commandSource) {
        Collection<ScoreObjective> collection = commandSource.func_197028_i().func_200251_aP().func_96514_c();
        if (collection.isEmpty()) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.objectives.list.empty", new Object[0]), false);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.scoreboard.objectives.list.success", collection.size(), TextComponentUtils.func_197677_b(collection, ScoreObjective::func_197890_e)), false);
        }
        return collection.size();
    }
}

