/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ItemArgument;
import net.minecraft.command.arguments.SlotArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;

public class ReplaceItemCommand {
    private static final SimpleCommandExceptionType field_198608_a = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.replaceitem.block.failed", new Object[0]));
    private static final DynamicCommandExceptionType field_198609_b = new DynamicCommandExceptionType(object -> new TextComponentTranslation("commands.replaceitem.slot.inapplicable", object));
    private static final Dynamic2CommandExceptionType field_211412_c = new Dynamic2CommandExceptionType((object, object2) -> new TextComponentTranslation("commands.replaceitem.entity.failed", object, object2));

    public static void func_198602_a(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("replaceitem").requires(commandSource -> commandSource.func_197034_c(2))).then(Commands.func_197057_a("block").then(Commands.func_197056_a("pos", BlockPosArgument.func_197276_a()).then(Commands.func_197056_a("slot", SlotArgument.func_197223_a()).then(((RequiredArgumentBuilder)Commands.func_197056_a("item", ItemArgument.func_197317_a()).executes(commandContext -> ReplaceItemCommand.func_198603_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "pos"), SlotArgument.func_197221_a((CommandContext<CommandSource>)commandContext, "slot"), ItemArgument.func_197316_a(commandContext, "item").func_197320_a(1, false)))).then(Commands.func_197056_a("count", IntegerArgumentType.integer((int)1, (int)64)).executes(commandContext -> ReplaceItemCommand.func_198603_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "pos"), SlotArgument.func_197221_a((CommandContext<CommandSource>)commandContext, "slot"), ItemArgument.func_197316_a(commandContext, "item").func_197320_a(IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"count"), true))))))))).then(Commands.func_197057_a("entity").then(Commands.func_197056_a("targets", EntityArgument.func_197093_b()).then(Commands.func_197056_a("slot", SlotArgument.func_197223_a()).then(((RequiredArgumentBuilder)Commands.func_197056_a("item", ItemArgument.func_197317_a()).executes(commandContext -> ReplaceItemCommand.func_198604_a((CommandSource)commandContext.getSource(), EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "targets"), SlotArgument.func_197221_a((CommandContext<CommandSource>)commandContext, "slot"), ItemArgument.func_197316_a(commandContext, "item").func_197320_a(1, false)))).then(Commands.func_197056_a("count", IntegerArgumentType.integer((int)1, (int)64)).executes(commandContext -> ReplaceItemCommand.func_198604_a((CommandSource)commandContext.getSource(), EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "targets"), SlotArgument.func_197221_a((CommandContext<CommandSource>)commandContext, "slot"), ItemArgument.func_197316_a(commandContext, "item").func_197320_a(IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"count"), true)))))))));
    }

    private static int func_198603_a(CommandSource commandSource, BlockPos blockPos, int n, ItemStack itemStack) throws CommandSyntaxException {
        TileEntity tileEntity = commandSource.func_197023_e().func_175625_s(blockPos);
        if (!(tileEntity instanceof IInventory)) {
            throw field_198608_a.create();
        }
        IInventory \u26032 = (IInventory)((Object)tileEntity);
        if (n < 0 || n >= \u26032.func_70302_i_()) {
            throw field_198609_b.create((Object)n);
        }
        \u26032.func_70299_a(n, itemStack);
        commandSource.func_197030_a(new TextComponentTranslation("commands.replaceitem.block.success", blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), itemStack.func_151000_E()), true);
        return 1;
    }

    private static int func_198604_a(CommandSource commandSource, Collection<? extends Entity> collection, int n, ItemStack itemStack) throws CommandSyntaxException {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)collection.size());
        for (Entity entity : collection) {
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).field_71069_bz.func_75142_b();
            }
            if (!entity.func_174820_d(n, itemStack.func_77946_l())) continue;
            arrayList.add(entity);
            if (!(entity instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)entity).field_71069_bz.func_75142_b();
        }
        if (arrayList.isEmpty()) {
            throw field_211412_c.create((Object)itemStack.func_151000_E(), (Object)n);
        }
        if (arrayList.size() == 1) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.replaceitem.entity.success.single", ((Entity)arrayList.iterator().next()).func_145748_c_(), itemStack.func_151000_E()), true);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.replaceitem.entity.success.multiple", arrayList.size(), itemStack.func_151000_E()), true);
        }
        return arrayList.size();
    }
}

