/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.BlockPredicateArgument;
import net.minecraft.command.arguments.BlockStateArgument;
import net.minecraft.command.arguments.BlockStateInput;
import net.minecraft.command.impl.SetBlockCommand;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;

public class FillCommand {
    private static final Dynamic2CommandExceptionType field_198473_a = new Dynamic2CommandExceptionType((object, object2) -> new TextComponentTranslation("commands.fill.toobig", object, object2));
    private static final BlockStateInput field_198474_b = new BlockStateInput(Blocks.field_150350_a.func_176223_P(), Collections.emptySet(), null);
    private static final SimpleCommandExceptionType field_198475_c = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.fill.failed", new Object[0]));

    public static void func_198465_a(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("fill").requires(commandSource -> commandSource.func_197034_c(2))).then(Commands.func_197056_a("from", BlockPosArgument.func_197276_a()).then(Commands.func_197056_a("to", BlockPosArgument.func_197276_a()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a("block", BlockStateArgument.func_197239_a()).executes(commandContext -> FillCommand.func_198463_a((CommandSource)commandContext.getSource(), new MutableBoundingBox(BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "from"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "to")), BlockStateArgument.func_197238_a((CommandContext<CommandSource>)commandContext, "block"), Mode.REPLACE, null))).then(((LiteralArgumentBuilder)Commands.func_197057_a("replace").executes(commandContext -> FillCommand.func_198463_a((CommandSource)commandContext.getSource(), new MutableBoundingBox(BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "from"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "to")), BlockStateArgument.func_197238_a((CommandContext<CommandSource>)commandContext, "block"), Mode.REPLACE, null))).then(Commands.func_197056_a("filter", BlockPredicateArgument.func_199824_a()).executes(commandContext -> FillCommand.func_198463_a((CommandSource)commandContext.getSource(), new MutableBoundingBox(BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "from"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "to")), BlockStateArgument.func_197238_a((CommandContext<CommandSource>)commandContext, "block"), Mode.REPLACE, BlockPredicateArgument.func_199825_a((CommandContext<CommandSource>)commandContext, "filter")))))).then(Commands.func_197057_a("keep").executes(commandContext -> FillCommand.func_198463_a((CommandSource)commandContext.getSource(), new MutableBoundingBox(BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "from"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "to")), BlockStateArgument.func_197238_a((CommandContext<CommandSource>)commandContext, "block"), Mode.REPLACE, blockWorldState -> blockWorldState.func_196960_c().func_175623_d(blockWorldState.func_177508_d()))))).then(Commands.func_197057_a("outline").executes(commandContext -> FillCommand.func_198463_a((CommandSource)commandContext.getSource(), new MutableBoundingBox(BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "from"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "to")), BlockStateArgument.func_197238_a((CommandContext<CommandSource>)commandContext, "block"), Mode.OUTLINE, null)))).then(Commands.func_197057_a("hollow").executes(commandContext -> FillCommand.func_198463_a((CommandSource)commandContext.getSource(), new MutableBoundingBox(BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "from"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "to")), BlockStateArgument.func_197238_a((CommandContext<CommandSource>)commandContext, "block"), Mode.HOLLOW, null)))).then(Commands.func_197057_a("destroy").executes(commandContext -> FillCommand.func_198463_a((CommandSource)commandContext.getSource(), new MutableBoundingBox(BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "from"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "to")), BlockStateArgument.func_197238_a((CommandContext<CommandSource>)commandContext, "block"), Mode.DESTROY, null)))))));
    }

    private static int func_198463_a(CommandSource commandSource, MutableBoundingBox mutableBoundingBox, BlockStateInput blockStateInput, Mode mode, @Nullable Predicate<BlockWorldState> predicate) throws CommandSyntaxException {
        int n;
        int n2 = mutableBoundingBox.func_78883_b() * mutableBoundingBox.func_78882_c() * mutableBoundingBox.func_78880_d();
        if (n2 > 32768) {
            throw field_198473_a.create((Object)32768, (Object)n2);
        }
        ArrayList \u26032 = Lists.newArrayList();
        WorldServer \u26033 = commandSource.func_197023_e();
        n = 0;
        for (BlockPos blockPos : BlockPos.MutableBlockPos.func_191532_a(mutableBoundingBox.field_78897_a, mutableBoundingBox.field_78895_b, mutableBoundingBox.field_78896_c, mutableBoundingBox.field_78893_d, mutableBoundingBox.field_78894_e, mutableBoundingBox.field_78892_f)) {
            if (predicate != null && !predicate.test(new BlockWorldState(\u26033, blockPos, true)) || (object = mode.field_198459_e.filter(mutableBoundingBox, blockPos, blockStateInput, \u26033)) == null) continue;
            TileEntity tileEntity = \u26033.func_175625_s(blockPos);
            if (tileEntity != null && tileEntity instanceof IInventory) {
                ((IInventory)((Object)tileEntity)).func_174888_l();
            }
            if (!((BlockStateInput)object).func_197230_a(\u26033, blockPos, 2)) continue;
            \u26032.add(blockPos.func_185334_h());
            ++n;
        }
        for (BlockPos blockPos : \u26032) {
            Object object = \u26033.func_180495_p(blockPos).func_177230_c();
            \u26033.func_195592_c(blockPos, (Block)object);
        }
        if (n == 0) {
            throw field_198475_c.create();
        }
        commandSource.func_197030_a(new TextComponentTranslation("commands.fill.success", n), true);
        return n;
    }

    static enum Mode {
        REPLACE((mutableBoundingBox, blockPos, blockStateInput, worldServer) -> blockStateInput),
        OUTLINE((mutableBoundingBox, blockPos, blockStateInput, worldServer) -> {
            if (blockPos.func_177958_n() == mutableBoundingBox.field_78897_a || blockPos.func_177958_n() == mutableBoundingBox.field_78893_d || blockPos.func_177956_o() == mutableBoundingBox.field_78895_b || blockPos.func_177956_o() == mutableBoundingBox.field_78894_e || blockPos.func_177952_p() == mutableBoundingBox.field_78896_c || blockPos.func_177952_p() == mutableBoundingBox.field_78892_f) {
                return blockStateInput;
            }
            return null;
        }),
        HOLLOW((mutableBoundingBox, blockPos, blockStateInput, worldServer) -> {
            if (blockPos.func_177958_n() == mutableBoundingBox.field_78897_a || blockPos.func_177958_n() == mutableBoundingBox.field_78893_d || blockPos.func_177956_o() == mutableBoundingBox.field_78895_b || blockPos.func_177956_o() == mutableBoundingBox.field_78894_e || blockPos.func_177952_p() == mutableBoundingBox.field_78896_c || blockPos.func_177952_p() == mutableBoundingBox.field_78892_f) {
                return blockStateInput;
            }
            return field_198474_b;
        }),
        DESTROY((mutableBoundingBox, blockPos, blockStateInput, worldServer) -> {
            worldServer.func_175655_b(blockPos, true);
            return blockStateInput;
        });

        public final SetBlockCommand.IFilter field_198459_e;

        private Mode(SetBlockCommand.IFilter iFilter) {
            this.field_198459_e = iFilter;
        }
    }
}

