/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugCommand {
    private static final Logger field_198337_a = LogManager.getLogger();
    private static final SimpleCommandExceptionType field_198338_b = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.debug.notRunning", new Object[0]));
    private static final SimpleCommandExceptionType field_198339_c = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.debug.alreadyRunning", new Object[0]));

    public static void func_198330_a(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("debug").requires(commandSource -> commandSource.func_197034_c(3))).then(Commands.func_197057_a("start").executes(commandContext -> DebugCommand.func_198335_a((CommandSource)commandContext.getSource())))).then(Commands.func_197057_a("stop").executes(commandContext -> DebugCommand.func_198336_b((CommandSource)commandContext.getSource()))));
    }

    private static int func_198335_a(CommandSource commandSource) throws CommandSyntaxException {
        MinecraftServer minecraftServer = commandSource.func_197028_i();
        Profiler \u26032 = minecraftServer.field_71304_b;
        if (\u26032.func_199094_a()) {
            throw field_198339_c.create();
        }
        minecraftServer.func_71223_ag();
        commandSource.func_197030_a(new TextComponentTranslation("commands.debug.started", "Started the debug profiler. Type '/debug stop' to stop it."), true);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int func_198336_b(CommandSource commandSource) throws CommandSyntaxException {
        MinecraftServer minecraftServer = commandSource.func_197028_i();
        Profiler \u26032 = minecraftServer.field_71304_b;
        if (!\u26032.func_199094_a()) {
            throw field_198338_b.create();
        }
        long \u26033 = Util.func_211178_c();
        int \u26034 = minecraftServer.func_71259_af();
        long \u26035 = \u26033 - \u26032.func_199097_c();
        int \u26036 = \u26034 - \u26032.func_199096_d();
        File \u26037 = new File(minecraftServer.func_71209_f("debug"), "profile-results-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + ".txt");
        \u26037.getParentFile().mkdirs();
        OutputStreamWriter \u26038 = null;
        try {
            \u26038 = new OutputStreamWriter((OutputStream)new FileOutputStream(\u26037), StandardCharsets.UTF_8);
            \u26038.write(DebugCommand.func_198328_a(\u26035, \u26036, \u26032));
        }
        catch (Throwable \u26039) {
            try {
                field_198337_a.error("Could not save profiler results to {}", (Object)\u26037, (Object)\u26039);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(\u26038);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)\u26038);
        }
        IOUtils.closeQuietly((Writer)\u26038);
        \u26032.func_199098_b();
        float \u260310 = (float)\u26035 / 1.0E9f;
        float \u260311 = (float)\u26036 / \u260310;
        commandSource.func_197030_a(new TextComponentTranslation("commands.debug.stopped", String.format(Locale.ROOT, "%.2f", Float.valueOf(\u260310)), \u26036, String.format("%.2f", Float.valueOf(\u260311))), true);
        return MathHelper.func_76141_d(\u260311);
    }

    private static String func_198328_a(long l, int n, Profiler profiler) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("---- Minecraft Profiler Results ----\n");
        stringBuilder.append("// ");
        stringBuilder.append(DebugCommand.func_198331_a());
        stringBuilder.append("\n\n");
        stringBuilder.append("Time span: ").append(l).append(" ms\n");
        stringBuilder.append("Tick span: ").append(n).append(" ticks\n");
        stringBuilder.append("// This is approximately ").append(String.format(Locale.ROOT, "%.2f", Float.valueOf((float)n / ((float)l / 1.0E9f)))).append(" ticks per second. It should be ").append(20).append(" ticks per second\n\n");
        stringBuilder.append("--- BEGIN PROFILE DUMP ---\n\n");
        DebugCommand.func_198334_a(0, "root", stringBuilder, profiler);
        stringBuilder.append("--- END PROFILE DUMP ---\n\n");
        return stringBuilder.toString();
    }

    private static void func_198334_a(int n, String string, StringBuilder stringBuilder2, Profiler profiler) {
        List<Profiler.Result> list = profiler.func_76321_b(string);
        if (list == null || list.size() < 3) {
            return;
        }
        for (int i = 1; i < list.size(); ++i) {
            StringBuilder stringBuilder2;
            Profiler.Result result = list.get(i);
            stringBuilder2.append(String.format("[%02d] ", n));
            for (int j = 0; j < n; ++j) {
                stringBuilder2.append("|   ");
            }
            stringBuilder2.append(result.field_76331_c).append(" - ").append(String.format(Locale.ROOT, "%.2f", result.field_76332_a)).append("%/").append(String.format(Locale.ROOT, "%.2f", result.field_76330_b)).append("%\n");
            if ("unspecified".equals(result.field_76331_c)) continue;
            try {
                DebugCommand.func_198334_a(n + 1, string + "." + result.field_76331_c, stringBuilder2, profiler);
                continue;
            }
            catch (Exception \u26032) {
                stringBuilder2.append("[[ EXCEPTION ").append(\u26032).append(" ]]");
            }
        }
    }

    private static String func_198331_a() {
        String[] stringArray = new String[]{"Shiny numbers!", "Am I not running fast enough? :(", "I'm working as hard as I can!", "Will I ever be good enough for you? :(", "Speedy. Zoooooom!", "Hello world", "40% better than a crash report.", "Now with extra numbers", "Now with less numbers", "Now with the same numbers", "You should add flames to things, it makes them go faster!", "Do you feel the need for... optimization?", "*cracks redstone whip*", "Maybe if you treated it better then it'll have more motivation to work faster! Poor server."};
        try {
            return stringArray[(int)(Util.func_211178_c() % (long)stringArray.length)];
        }
        catch (Throwable \u26032) {
            return "Witty comment unavailable :(";
        }
    }
}

