/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.WorldInfo;

public class DataPackCommand {
    private static final DynamicCommandExceptionType field_198316_a = new DynamicCommandExceptionType(object -> new TextComponentTranslation("commands.datapack.unknown", object));
    private static final DynamicCommandExceptionType field_198317_b = new DynamicCommandExceptionType(object -> new TextComponentTranslation("commands.datapack.enable.failed", object));
    private static final DynamicCommandExceptionType field_198318_c = new DynamicCommandExceptionType(object -> new TextComponentTranslation("commands.datapack.disable.failed", object));
    private static final SuggestionProvider<CommandSource> field_198319_d = (commandContext, suggestionsBuilder) -> ISuggestionProvider.func_197013_a(((CommandSource)commandContext.getSource()).func_197028_i().func_195561_aH().func_198980_d().stream().map(ResourcePackInfo::func_195790_f).map(StringArgumentType::escapeIfRequired), suggestionsBuilder);
    private static final SuggestionProvider<CommandSource> field_198320_e = (commandContext, suggestionsBuilder) -> ISuggestionProvider.func_197013_a(((CommandSource)commandContext.getSource()).func_197028_i().func_195561_aH().func_198979_c().stream().map(ResourcePackInfo::func_195790_f).map(StringArgumentType::escapeIfRequired), suggestionsBuilder);

    public static void func_198299_a(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("datapack").requires(commandSource -> commandSource.func_197034_c(2))).then(Commands.func_197057_a("enable").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a("name", StringArgumentType.string()).suggests(field_198320_e).executes(commandContext -> DataPackCommand.func_198297_a((CommandSource)commandContext.getSource(), DataPackCommand.func_198303_a((CommandContext<CommandSource>)commandContext, "name", true), (list, resourcePackInfo2) -> resourcePackInfo2.func_195792_i().func_198993_a(list, resourcePackInfo2, resourcePackInfo -> resourcePackInfo, false)))).then(Commands.func_197057_a("after").then(Commands.func_197056_a("existing", StringArgumentType.string()).suggests(field_198319_d).executes(commandContext -> DataPackCommand.func_198297_a((CommandSource)commandContext.getSource(), DataPackCommand.func_198303_a((CommandContext<CommandSource>)commandContext, "name", true), (list, resourcePackInfo) -> list.add(list.indexOf(DataPackCommand.func_198303_a((CommandContext<CommandSource>)commandContext, "existing", false)) + 1, resourcePackInfo)))))).then(Commands.func_197057_a("before").then(Commands.func_197056_a("existing", StringArgumentType.string()).suggests(field_198319_d).executes(commandContext -> DataPackCommand.func_198297_a((CommandSource)commandContext.getSource(), DataPackCommand.func_198303_a((CommandContext<CommandSource>)commandContext, "name", true), (list, resourcePackInfo) -> list.add(list.indexOf(DataPackCommand.func_198303_a((CommandContext<CommandSource>)commandContext, "existing", false)), resourcePackInfo)))))).then(Commands.func_197057_a("last").executes(commandContext -> DataPackCommand.func_198297_a((CommandSource)commandContext.getSource(), DataPackCommand.func_198303_a((CommandContext<CommandSource>)commandContext, "name", true), List::add)))).then(Commands.func_197057_a("first").executes(commandContext -> DataPackCommand.func_198297_a((CommandSource)commandContext.getSource(), DataPackCommand.func_198303_a((CommandContext<CommandSource>)commandContext, "name", true), (list, resourcePackInfo) -> list.add(0, resourcePackInfo))))))).then(Commands.func_197057_a("disable").then(Commands.func_197056_a("name", StringArgumentType.string()).suggests(field_198319_d).executes(commandContext -> DataPackCommand.func_198312_a((CommandSource)commandContext.getSource(), DataPackCommand.func_198303_a((CommandContext<CommandSource>)commandContext, "name", false)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("list").executes(commandContext -> DataPackCommand.func_198313_a((CommandSource)commandContext.getSource()))).then(Commands.func_197057_a("available").executes(commandContext -> DataPackCommand.func_198314_b((CommandSource)commandContext.getSource())))).then(Commands.func_197057_a("enabled").executes(commandContext -> DataPackCommand.func_198315_c((CommandSource)commandContext.getSource())))));
    }

    private static int func_198297_a(CommandSource commandSource, ResourcePackInfo resourcePackInfo2, IHandler iHandler) throws CommandSyntaxException {
        ResourcePackList<ResourcePackInfo> resourcePackList = commandSource.func_197028_i().func_195561_aH();
        ArrayList \u26032 = Lists.newArrayList(resourcePackList.func_198980_d());
        iHandler.apply(\u26032, resourcePackInfo2);
        resourcePackList.func_198985_a(\u26032);
        WorldInfo \u26033 = commandSource.func_197028_i().func_71218_a(DimensionType.OVERWORLD).func_72912_H();
        \u26033.func_197720_O().clear();
        resourcePackList.func_198980_d().forEach(resourcePackInfo -> \u26033.func_197720_O().add(resourcePackInfo.func_195790_f()));
        \u26033.func_197719_N().remove(resourcePackInfo2.func_195790_f());
        commandSource.func_197030_a(new TextComponentTranslation("commands.datapack.enable.success", resourcePackInfo2.func_195794_a(true)), true);
        commandSource.func_197028_i().func_193031_aM();
        return resourcePackList.func_198980_d().size();
    }

    private static int func_198312_a(CommandSource commandSource, ResourcePackInfo resourcePackInfo2) {
        ResourcePackList<ResourcePackInfo> resourcePackList = commandSource.func_197028_i().func_195561_aH();
        ArrayList \u26032 = Lists.newArrayList(resourcePackList.func_198980_d());
        \u26032.remove(resourcePackInfo2);
        resourcePackList.func_198985_a(\u26032);
        WorldInfo \u26033 = commandSource.func_197028_i().func_71218_a(DimensionType.OVERWORLD).func_72912_H();
        \u26033.func_197720_O().clear();
        resourcePackList.func_198980_d().forEach(resourcePackInfo -> \u26033.func_197720_O().add(resourcePackInfo.func_195790_f()));
        \u26033.func_197719_N().add(resourcePackInfo2.func_195790_f());
        commandSource.func_197030_a(new TextComponentTranslation("commands.datapack.disable.success", resourcePackInfo2.func_195794_a(true)), true);
        commandSource.func_197028_i().func_193031_aM();
        return resourcePackList.func_198980_d().size();
    }

    private static int func_198313_a(CommandSource commandSource) {
        return DataPackCommand.func_198315_c(commandSource) + DataPackCommand.func_198314_b(commandSource);
    }

    private static int func_198314_b(CommandSource commandSource) {
        ResourcePackList<ResourcePackInfo> resourcePackList = commandSource.func_197028_i().func_195561_aH();
        if (resourcePackList.func_198979_c().isEmpty()) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.datapack.list.available.none", new Object[0]), false);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.datapack.list.available.success", resourcePackList.func_198979_c().size(), TextComponentUtils.func_197677_b(resourcePackList.func_198979_c(), resourcePackInfo -> resourcePackInfo.func_195794_a(false))), false);
        }
        return resourcePackList.func_198979_c().size();
    }

    private static int func_198315_c(CommandSource commandSource) {
        ResourcePackList<ResourcePackInfo> resourcePackList = commandSource.func_197028_i().func_195561_aH();
        if (resourcePackList.func_198980_d().isEmpty()) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.datapack.list.enabled.none", new Object[0]), false);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.datapack.list.enabled.success", resourcePackList.func_198980_d().size(), TextComponentUtils.func_197677_b(resourcePackList.func_198980_d(), resourcePackInfo -> resourcePackInfo.func_195794_a(true))), false);
        }
        return resourcePackList.func_198980_d().size();
    }

    private static ResourcePackInfo func_198303_a(CommandContext<CommandSource> commandContext, String string, boolean bl) throws CommandSyntaxException {
        String string2 = StringArgumentType.getString(commandContext, (String)string);
        ResourcePackList<ResourcePackInfo> \u26032 = ((CommandSource)commandContext.getSource()).func_197028_i().func_195561_aH();
        ResourcePackInfo \u26033 = \u26032.func_198981_a(string2);
        if (\u26033 == null) {
            throw field_198316_a.create((Object)string2);
        }
        boolean \u26034 = \u26032.func_198980_d().contains(\u26033);
        if (bl && \u26034) {
            throw field_198317_b.create((Object)string2);
        }
        if (!bl && !\u26034) {
            throw field_198318_c.create((Object)string2);
        }
        return \u26033;
    }

    static interface IHandler {
        public void apply(List<ResourcePackInfo> var1, ResourcePackInfo var2) throws CommandSyntaxException;
    }
}

