/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.BlockPredicateArgument;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.ServerTickList;
import net.minecraft.world.WorldServer;

public class CloneCommand {
    private static final SimpleCommandExceptionType field_198284_b = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.clone.overlap", new Object[0]));
    private static final Dynamic2CommandExceptionType field_198285_c = new Dynamic2CommandExceptionType((object, object2) -> new TextComponentTranslation("commands.clone.toobig", object, object2));
    private static final SimpleCommandExceptionType field_198286_d = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.clone.failed", new Object[0]));
    public static final Predicate<BlockWorldState> field_198283_a = blockWorldState -> !blockWorldState.func_177509_a().func_196958_f();

    public static void func_198265_a(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("clone").requires(commandSource -> commandSource.func_197034_c(2))).then(Commands.func_197056_a("begin", BlockPosArgument.func_197276_a()).then(Commands.func_197056_a("end", BlockPosArgument.func_197276_a()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a("destination", BlockPosArgument.func_197276_a()).executes(commandContext -> CloneCommand.func_198274_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "begin"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "end"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "destination"), blockWorldState -> true, Mode.NORMAL))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("replace").executes(commandContext -> CloneCommand.func_198274_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "begin"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "end"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "destination"), blockWorldState -> true, Mode.NORMAL))).then(Commands.func_197057_a("force").executes(commandContext -> CloneCommand.func_198274_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "begin"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "end"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "destination"), blockWorldState -> true, Mode.FORCE)))).then(Commands.func_197057_a("move").executes(commandContext -> CloneCommand.func_198274_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "begin"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "end"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "destination"), blockWorldState -> true, Mode.MOVE)))).then(Commands.func_197057_a("normal").executes(commandContext -> CloneCommand.func_198274_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "begin"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "end"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "destination"), blockWorldState -> true, Mode.NORMAL))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("masked").executes(commandContext -> CloneCommand.func_198274_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "begin"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "end"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "destination"), field_198283_a, Mode.NORMAL))).then(Commands.func_197057_a("force").executes(commandContext -> CloneCommand.func_198274_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "begin"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "end"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "destination"), field_198283_a, Mode.FORCE)))).then(Commands.func_197057_a("move").executes(commandContext -> CloneCommand.func_198274_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "begin"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "end"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "destination"), field_198283_a, Mode.MOVE)))).then(Commands.func_197057_a("normal").executes(commandContext -> CloneCommand.func_198274_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "begin"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "end"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "destination"), field_198283_a, Mode.NORMAL))))).then(Commands.func_197057_a("filtered").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a("filter", BlockPredicateArgument.func_199824_a()).executes(commandContext -> CloneCommand.func_198274_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "begin"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "end"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "destination"), BlockPredicateArgument.func_199825_a((CommandContext<CommandSource>)commandContext, "filter"), Mode.NORMAL))).then(Commands.func_197057_a("force").executes(commandContext -> CloneCommand.func_198274_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "begin"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "end"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "destination"), BlockPredicateArgument.func_199825_a((CommandContext<CommandSource>)commandContext, "filter"), Mode.FORCE)))).then(Commands.func_197057_a("move").executes(commandContext -> CloneCommand.func_198274_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "begin"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "end"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "destination"), BlockPredicateArgument.func_199825_a((CommandContext<CommandSource>)commandContext, "filter"), Mode.MOVE)))).then(Commands.func_197057_a("normal").executes(commandContext -> CloneCommand.func_198274_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "begin"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "end"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "destination"), BlockPredicateArgument.func_199825_a((CommandContext<CommandSource>)commandContext, "filter"), Mode.NORMAL)))))))));
    }

    private static int func_198274_a(CommandSource commandSource, BlockPos blockPos, BlockPos blockPos2, BlockPos blockPos3, Predicate<BlockWorldState> predicate, Mode mode2) throws CommandSyntaxException {
        Mode mode2;
        MutableBoundingBox mutableBoundingBox = new MutableBoundingBox(blockPos, blockPos2);
        \u2603 = new MutableBoundingBox(blockPos3, blockPos3.func_177971_a(mutableBoundingBox.func_175896_b()));
        if (!mode2.func_198254_a() && \u2603.func_78884_a(mutableBoundingBox)) {
            throw field_198284_b.create();
        }
        int \u26032 = mutableBoundingBox.func_78883_b() * mutableBoundingBox.func_78882_c() * mutableBoundingBox.func_78880_d();
        if (\u26032 > 32768) {
            throw field_198285_c.create((Object)32768, (Object)\u26032);
        }
        WorldServer \u26033 = commandSource.func_197023_e();
        if (!\u26033.func_175711_a(mutableBoundingBox) || !\u26033.func_175711_a(\u2603)) {
            throw BlockPosArgument.field_197278_b.create();
        }
        ArrayList \u26034 = Lists.newArrayList();
        ArrayList \u26035 = Lists.newArrayList();
        ArrayList \u26036 = Lists.newArrayList();
        LinkedList \u26037 = Lists.newLinkedList();
        BlockPos \u26038 = new BlockPos(\u2603.field_78897_a - mutableBoundingBox.field_78897_a, \u2603.field_78895_b - mutableBoundingBox.field_78895_b, \u2603.field_78896_c - mutableBoundingBox.field_78896_c);
        for (int i = mutableBoundingBox.field_78896_c; i <= mutableBoundingBox.field_78892_f; ++i) {
            for (\u2603 = mutableBoundingBox.field_78895_b; \u2603 <= mutableBoundingBox.field_78894_e; ++\u2603) {
                for (\u2603 = mutableBoundingBox.field_78897_a; \u2603 <= mutableBoundingBox.field_78893_d; ++\u2603) {
                    Object object = new BlockPos(\u2603, \u2603, i);
                    object = ((BlockPos)object).func_177971_a(\u26038);
                    \u2603 = new BlockWorldState(\u26033, (BlockPos)object, false);
                    IBlockState \u26039 = ((BlockWorldState)\u2603).func_177509_a();
                    if (!predicate.test((BlockWorldState)\u2603)) continue;
                    TileEntity \u260310 = \u26033.func_175625_s((BlockPos)object);
                    if (\u260310 != null) {
                        NBTTagCompound nBTTagCompound = \u260310.func_189515_b(new NBTTagCompound());
                        \u26035.add(new BlockInfo((BlockPos)object, \u26039, nBTTagCompound));
                        \u26037.addLast(object);
                        continue;
                    }
                    if (\u26039.func_200015_d(\u26033, (BlockPos)object) || \u26039.func_185917_h()) {
                        \u26034.add(new BlockInfo((BlockPos)object, \u26039, null));
                        \u26037.addLast(object);
                        continue;
                    }
                    \u26036.add(new BlockInfo((BlockPos)object, \u26039, null));
                    \u26037.addFirst(object);
                }
            }
        }
        if (mode2 == Mode.MOVE) {
            for (BlockPos blockPos4 : \u26037) {
                TileEntity tileEntity = \u26033.func_175625_s(blockPos4);
                if (tileEntity instanceof IInventory) {
                    ((IInventory)((Object)tileEntity)).func_174888_l();
                }
                \u26033.func_180501_a(blockPos4, Blocks.field_180401_cv.func_176223_P(), 2);
            }
            for (BlockPos blockPos5 : \u26037) {
                \u26033.func_180501_a(blockPos5, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(\u26034);
        arrayList.addAll(\u26035);
        arrayList.addAll(\u26036);
        List \u260311 = Lists.reverse((List)arrayList);
        for (Object object : \u260311) {
            object = \u26033.func_175625_s(((BlockInfo)object).field_198251_a);
            if (object instanceof IInventory) {
                ((IInventory)object).func_174888_l();
            }
            \u26033.func_180501_a(((BlockInfo)object).field_198251_a, Blocks.field_180401_cv.func_176223_P(), 2);
        }
        int n = 0;
        for (Object object : arrayList) {
            if (!\u26033.func_180501_a(((BlockInfo)object).field_198251_a, ((BlockInfo)object).field_198252_b, 2)) continue;
            ++n;
        }
        for (Object object : \u26035) {
            \u2603 = \u26033.func_175625_s(((BlockInfo)object).field_198251_a);
            if (((BlockInfo)object).field_198253_c != null && \u2603 != null) {
                ((BlockInfo)object).field_198253_c.func_74768_a("x", ((BlockInfo)object).field_198251_a.func_177958_n());
                ((BlockInfo)object).field_198253_c.func_74768_a("y", ((BlockInfo)object).field_198251_a.func_177956_o());
                ((BlockInfo)object).field_198253_c.func_74768_a("z", ((BlockInfo)object).field_198251_a.func_177952_p());
                ((TileEntity)\u2603).func_145839_a(((BlockInfo)object).field_198253_c);
                ((TileEntity)\u2603).func_70296_d();
            }
            \u26033.func_180501_a(((BlockInfo)object).field_198251_a, ((BlockInfo)object).field_198252_b, 2);
        }
        for (Object object : \u260311) {
            \u26033.func_195592_c(((BlockInfo)object).field_198251_a, ((BlockInfo)object).field_198252_b.func_177230_c());
        }
        ((ServerTickList)\u26033.func_205220_G_()).func_205368_a(mutableBoundingBox, \u26038);
        if (n == 0) {
            throw field_198286_d.create();
        }
        commandSource.func_197030_a(new TextComponentTranslation("commands.clone.success", n), true);
        return n;
    }

    static class BlockInfo {
        public final BlockPos field_198251_a;
        public final IBlockState field_198252_b;
        @Nullable
        public final NBTTagCompound field_198253_c;

        public BlockInfo(BlockPos blockPos, IBlockState iBlockState, @Nullable NBTTagCompound nBTTagCompound) {
            this.field_198251_a = blockPos;
            this.field_198252_b = iBlockState;
            this.field_198253_c = nBTTagCompound;
        }
    }

    static enum Mode {
        FORCE(true),
        MOVE(true),
        NORMAL(false);

        private final boolean field_198259_d;

        private Mode(boolean bl) {
            this.field_198259_d = bl;
        }

        public boolean func_198254_a() {
            return this.field_198259_d;
        }
    }
}

