/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCollection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextComponentTranslation;

public class NBTPathArgument
implements ArgumentType<NBTPath> {
    private static final Collection<String> field_201316_a = Arrays.asList("foo", "foo.bar", "foo[0]", "[0]", ".");
    private static final DynamicCommandExceptionType field_197153_a = new DynamicCommandExceptionType(object -> new TextComponentTranslation("arguments.nbtpath.child.invalid", object));
    private static final DynamicCommandExceptionType field_197154_b = new DynamicCommandExceptionType(object -> new TextComponentTranslation("arguments.nbtpath.element.invalid", object));
    private static final SimpleCommandExceptionType field_201948_d = new SimpleCommandExceptionType((Message)new TextComponentTranslation("arguments.nbtpath.node.invalid", new Object[0]));

    public static NBTPathArgument func_197149_a() {
        return new NBTPathArgument();
    }

    public static NBTPath func_197148_a(CommandContext<CommandSource> commandContext, String string) {
        return (NBTPath)commandContext.getArgument(string, NBTPath.class);
    }

    public NBTPath parse(StringReader stringReader) throws CommandSyntaxException {
        ArrayList arrayList = Lists.newArrayList();
        int \u26032 = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            switch (stringReader.peek()) {
                case '[': {
                    stringReader.skip();
                    arrayList.add(new ElementNode(stringReader.readInt()));
                    stringReader.expect(']');
                    break;
                }
                case '\"': {
                    arrayList.add(new ChildNode(stringReader.readString()));
                    break;
                }
                default: {
                    arrayList.add(new ChildNode(this.func_197151_a(stringReader)));
                }
            }
            if (!stringReader.canRead() || (\u2603 = stringReader.peek()) == ' ' || \u2603 == '[') continue;
            stringReader.expect('.');
        }
        return new NBTPath(stringReader.getString().substring(\u26032, stringReader.getCursor()), arrayList.toArray(new INode[0]));
    }

    private String func_197151_a(StringReader stringReader) throws CommandSyntaxException {
        int n = stringReader.getCursor();
        while (stringReader.canRead() && NBTPathArgument.func_197146_a(stringReader.peek())) {
            stringReader.skip();
        }
        if (stringReader.getCursor() == n) {
            throw field_201948_d.createWithContext((ImmutableStringReader)stringReader);
        }
        return stringReader.getString().substring(n, stringReader.getCursor());
    }

    public Collection<String> getExamples() {
        return field_201316_a;
    }

    private static boolean func_197146_a(char c) {
        return c != ' ' && c != '\"' && c != '[' && c != ']' && c != '.';
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    static class ElementNode
    implements INode {
        private final int field_197138_a;

        public ElementNode(int n) {
            this.field_197138_a = n;
        }

        @Override
        public INBTBase func_197137_a(INBTBase iNBTBase) throws CommandSyntaxException {
            if (iNBTBase instanceof NBTTagCollection && (\u2603 = (NBTTagCollection)iNBTBase).size() > this.field_197138_a) {
                return \u2603.func_197647_c(this.field_197138_a);
            }
            throw field_197154_b.create((Object)this.field_197138_a);
        }

        @Override
        public INBTBase func_197135_a(INBTBase iNBTBase, Supplier<INBTBase> supplier) throws CommandSyntaxException {
            return this.func_197137_a(iNBTBase);
        }

        @Override
        public INBTBase func_197134_a() {
            return new NBTTagList();
        }

        @Override
        public void func_197136_a(INBTBase iNBTBase, INBTBase iNBTBase2) throws CommandSyntaxException {
            if (iNBTBase instanceof NBTTagCollection && (\u2603 = (NBTTagCollection)iNBTBase).size() > this.field_197138_a) {
                \u2603.func_197648_a(this.field_197138_a, iNBTBase2);
                return;
            }
            throw field_197154_b.create((Object)this.field_197138_a);
        }

        @Override
        public void func_197133_b(INBTBase iNBTBase) throws CommandSyntaxException {
            if (iNBTBase instanceof NBTTagCollection && (\u2603 = (NBTTagCollection)iNBTBase).size() > this.field_197138_a) {
                \u2603.func_197649_b(this.field_197138_a);
                return;
            }
            throw field_197154_b.create((Object)this.field_197138_a);
        }
    }

    static class ChildNode
    implements INode {
        private final String field_197139_a;

        public ChildNode(String string) {
            this.field_197139_a = string;
        }

        @Override
        public INBTBase func_197137_a(INBTBase iNBTBase) throws CommandSyntaxException {
            if (iNBTBase instanceof NBTTagCompound) {
                return ((NBTTagCompound)iNBTBase).func_74781_a(this.field_197139_a);
            }
            throw field_197153_a.create((Object)this.field_197139_a);
        }

        @Override
        public INBTBase func_197135_a(INBTBase iNBTBase, Supplier<INBTBase> supplier) throws CommandSyntaxException {
            if (iNBTBase instanceof NBTTagCompound) {
                NBTTagCompound nBTTagCompound = (NBTTagCompound)iNBTBase;
                if (nBTTagCompound.func_74764_b(this.field_197139_a)) {
                    return nBTTagCompound.func_74781_a(this.field_197139_a);
                }
                INBTBase \u26032 = supplier.get();
                nBTTagCompound.func_74782_a(this.field_197139_a, \u26032);
                return \u26032;
            }
            throw field_197153_a.create((Object)this.field_197139_a);
        }

        @Override
        public INBTBase func_197134_a() {
            return new NBTTagCompound();
        }

        @Override
        public void func_197136_a(INBTBase iNBTBase, INBTBase iNBTBase2) throws CommandSyntaxException {
            if (iNBTBase instanceof NBTTagCompound) {
                NBTTagCompound nBTTagCompound = (NBTTagCompound)iNBTBase;
                nBTTagCompound.func_74782_a(this.field_197139_a, iNBTBase2);
                return;
            }
            throw field_197153_a.create((Object)this.field_197139_a);
        }

        @Override
        public void func_197133_b(INBTBase iNBTBase) throws CommandSyntaxException {
            if (iNBTBase instanceof NBTTagCompound && (\u2603 = (NBTTagCompound)iNBTBase).func_74764_b(this.field_197139_a)) {
                \u2603.func_82580_o(this.field_197139_a);
                return;
            }
            throw field_197153_a.create((Object)this.field_197139_a);
        }
    }

    static interface INode {
        public INBTBase func_197137_a(INBTBase var1) throws CommandSyntaxException;

        public INBTBase func_197135_a(INBTBase var1, Supplier<INBTBase> var2) throws CommandSyntaxException;

        public INBTBase func_197134_a();

        public void func_197136_a(INBTBase var1, INBTBase var2) throws CommandSyntaxException;

        public void func_197133_b(INBTBase var1) throws CommandSyntaxException;
    }

    public static class NBTPath {
        private final String field_197144_a;
        private final INode[] field_197145_b;

        public NBTPath(String string, INode[] iNodeArray) {
            this.field_197144_a = string;
            this.field_197145_b = iNodeArray;
        }

        public INBTBase func_197143_a(INBTBase iNBTBase2) throws CommandSyntaxException {
            INBTBase iNBTBase2;
            for (INode iNode : this.field_197145_b) {
                iNBTBase2 = iNode.func_197137_a(iNBTBase2);
            }
            return iNBTBase2;
        }

        public INBTBase func_197142_a(INBTBase \u260322, INBTBase iNBTBase) throws CommandSyntaxException {
            INBTBase \u260322;
            for (int i = 0; i < this.field_197145_b.length; ++i) {
                INode iNode = this.field_197145_b[i];
                if (i < this.field_197145_b.length - 1) {
                    int n = i + 1;
                    \u260322 = iNode.func_197135_a(\u260322, () -> this.field_197145_b[n].func_197134_a());
                    continue;
                }
                iNode.func_197136_a(\u260322, iNBTBase);
            }
            return \u260322;
        }

        public String toString() {
            return this.field_197144_a;
        }

        public void func_197140_b(INBTBase iNBTBase2) throws CommandSyntaxException {
            for (int i = 0; i < this.field_197145_b.length; ++i) {
                INode iNode = this.field_197145_b[i];
                if (i < this.field_197145_b.length - 1) {
                    INBTBase iNBTBase2 = iNode.func_197137_a(iNBTBase2);
                    continue;
                }
                iNode.func_197133_b(iNBTBase2);
            }
        }
    }
}

