/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.TextComponentTranslation;

public class BlockStateParser {
    public static final SimpleCommandExceptionType field_199831_a = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.block.tag.disallowed", new Object[0]));
    public static final DynamicCommandExceptionType field_197259_a = new DynamicCommandExceptionType(object -> new TextComponentTranslation("argument.block.id.invalid", object));
    public static final Dynamic2CommandExceptionType field_197260_b = new Dynamic2CommandExceptionType((object, object2) -> new TextComponentTranslation("argument.block.property.unknown", object, object2));
    public static final Dynamic2CommandExceptionType field_197261_c = new Dynamic2CommandExceptionType((object, object2) -> new TextComponentTranslation("argument.block.property.duplicate", object2, object));
    public static final Dynamic3CommandExceptionType field_197262_d = new Dynamic3CommandExceptionType((object, object2, object3) -> new TextComponentTranslation("argument.block.property.invalid", object, object3, object2));
    public static final Dynamic2CommandExceptionType field_197263_e = new Dynamic2CommandExceptionType((object, object2) -> new TextComponentTranslation("argument.block.property.novalue", object, object2));
    public static final SimpleCommandExceptionType field_197264_f = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.block.property.unclosed", new Object[0]));
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> field_197265_g = SuggestionsBuilder::buildFuture;
    private final StringReader field_197266_h;
    private final boolean field_199832_j;
    private final Map<IProperty<?>, Comparable<?>> field_197267_i = Maps.newHashMap();
    private final Map<String, String> field_200141_l = Maps.newHashMap();
    private ResourceLocation field_197268_j = new ResourceLocation("");
    private StateContainer<Block, IBlockState> field_197269_k;
    private IBlockState field_197270_l;
    @Nullable
    private NBTTagCompound field_197271_m;
    private ResourceLocation field_199833_p = new ResourceLocation("");
    private int field_201954_r;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> field_197272_n = field_197265_g;

    public BlockStateParser(StringReader stringReader, boolean bl) {
        this.field_197266_h = stringReader;
        this.field_199832_j = bl;
    }

    public Map<IProperty<?>, Comparable<?>> func_197254_a() {
        return this.field_197267_i;
    }

    @Nullable
    public IBlockState func_197249_b() {
        return this.field_197270_l;
    }

    @Nullable
    public NBTTagCompound func_197241_c() {
        return this.field_197271_m;
    }

    @Nullable
    public ResourceLocation func_199829_d() {
        return this.field_199833_p;
    }

    public BlockStateParser func_197243_a(boolean bl) throws CommandSyntaxException {
        this.field_197272_n = this::func_197250_h;
        if (this.field_197266_h.canRead() && this.field_197266_h.peek() == '#') {
            this.func_199827_f();
            this.field_197272_n = this::func_212599_i;
            if (this.field_197266_h.canRead() && this.field_197266_h.peek() == '[') {
                this.func_200137_h();
                this.field_197272_n = this::func_197244_d;
            }
        } else {
            this.func_197258_d();
            this.field_197272_n = this::func_197255_g;
            if (this.field_197266_h.canRead() && this.field_197266_h.peek() == '[') {
                this.func_197257_e();
                this.field_197272_n = this::func_197244_d;
            }
        }
        if (bl && this.field_197266_h.canRead() && this.field_197266_h.peek() == '{') {
            this.field_197272_n = field_197265_g;
            this.func_197240_f();
        }
        return this;
    }

    private CompletableFuture<Suggestions> func_197252_b(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf(']'));
        }
        return this.func_197256_c(suggestionsBuilder);
    }

    private CompletableFuture<Suggestions> func_200136_c(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf(']'));
        }
        return this.func_200134_e(suggestionsBuilder);
    }

    private CompletableFuture<Suggestions> func_197256_c(SuggestionsBuilder suggestionsBuilder2) {
        SuggestionsBuilder suggestionsBuilder2;
        String string = suggestionsBuilder2.getRemaining().toLowerCase(Locale.ROOT);
        for (IProperty<?> iProperty : this.field_197270_l.func_206869_a()) {
            if (this.field_197267_i.containsKey(iProperty) || !iProperty.func_177701_a().startsWith(string)) continue;
            suggestionsBuilder2.suggest(iProperty.func_177701_a() + '=');
        }
        return suggestionsBuilder2.buildFuture();
    }

    private CompletableFuture<Suggestions> func_200134_e(SuggestionsBuilder suggestionsBuilder2) {
        SuggestionsBuilder suggestionsBuilder2;
        String string = suggestionsBuilder2.getRemaining().toLowerCase(Locale.ROOT);
        if (this.field_199833_p != null && !this.field_199833_p.func_110623_a().isEmpty() && (\u2603 = BlockTags.func_199896_a().func_199910_a(this.field_199833_p)) != null) {
            for (Block block : \u2603.func_199885_a()) {
                for (IProperty<?> iProperty : block.func_176194_O().func_177623_d()) {
                    if (this.field_200141_l.containsKey(iProperty.func_177701_a()) || !iProperty.func_177701_a().startsWith(string)) continue;
                    suggestionsBuilder2.suggest(iProperty.func_177701_a() + '=');
                }
            }
        }
        return suggestionsBuilder2.buildFuture();
    }

    private CompletableFuture<Suggestions> func_197244_d(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty() && this.func_212598_k()) {
            suggestionsBuilder.suggest(String.valueOf('{'));
        }
        return suggestionsBuilder.buildFuture();
    }

    private boolean func_212598_k() {
        Tag<Block> tag;
        if (this.field_197270_l != null) {
            return this.field_197270_l.func_177230_c().func_149716_u();
        }
        if (this.field_199833_p != null && (tag = BlockTags.func_199896_a().func_199910_a(this.field_199833_p)) != null) {
            for (Block block : tag.func_199885_a()) {
                if (!block.func_149716_u()) continue;
                return true;
            }
        }
        return false;
    }

    private CompletableFuture<Suggestions> func_197246_e(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf('='));
        }
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> func_197248_f(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf(']'));
        }
        if (suggestionsBuilder.getRemaining().isEmpty() && this.field_197267_i.size() < this.field_197270_l.func_206869_a().size()) {
            suggestionsBuilder.suggest(String.valueOf(','));
        }
        return suggestionsBuilder.buildFuture();
    }

    private static <T extends Comparable<T>> SuggestionsBuilder func_201037_a(SuggestionsBuilder suggestionsBuilder2, IProperty<T> iProperty) {
        SuggestionsBuilder suggestionsBuilder2;
        for (Comparable comparable : iProperty.func_177700_c()) {
            if (comparable instanceof Integer) {
                suggestionsBuilder2.suggest(((Integer)comparable).intValue());
                continue;
            }
            suggestionsBuilder2.suggest(iProperty.func_177702_a(comparable));
        }
        return suggestionsBuilder2;
    }

    private CompletableFuture<Suggestions> func_200140_a(SuggestionsBuilder suggestionsBuilder, String string) {
        boolean bl = false;
        if (this.field_199833_p != null && !this.field_199833_p.func_110623_a().isEmpty() && (\u2603 = BlockTags.func_199896_a().func_199910_a(this.field_199833_p)) != null) {
            block0: for (Block block : \u2603.func_199885_a()) {
                IProperty<?> iProperty = block.func_176194_O().func_185920_a(string);
                if (iProperty != null) {
                    BlockStateParser.func_201037_a(suggestionsBuilder, iProperty);
                }
                if (bl) continue;
                for (IProperty<?> iProperty2 : block.func_176194_O().func_177623_d()) {
                    if (this.field_200141_l.containsKey(iProperty2.func_177701_a())) continue;
                    bl = true;
                    continue block0;
                }
            }
        }
        if (bl) {
            suggestionsBuilder.suggest(String.valueOf(','));
        }
        suggestionsBuilder.suggest(String.valueOf(']'));
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> func_212599_i(SuggestionsBuilder suggestionsBuilder2) {
        SuggestionsBuilder suggestionsBuilder2;
        if (suggestionsBuilder2.getRemaining().isEmpty() && (\u2603 = BlockTags.func_199896_a().func_199910_a(this.field_199833_p)) != null) {
            boolean bl = false;
            \u2603 = false;
            Iterator<Block> iterator = \u2603.func_199885_a().iterator();
            while (!(!iterator.hasNext() || (bl |= !(\u2603 = iterator.next()).func_176194_O().func_177623_d().isEmpty()) && (\u2603 |= \u2603.func_149716_u()))) {
            }
            if (bl) {
                suggestionsBuilder2.suggest(String.valueOf('['));
            }
            if (\u2603) {
                suggestionsBuilder2.suggest(String.valueOf('{'));
            }
        }
        return this.func_201953_j(suggestionsBuilder2);
    }

    private CompletableFuture<Suggestions> func_197255_g(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            if (!this.field_197270_l.func_177230_c().func_176194_O().func_177623_d().isEmpty()) {
                suggestionsBuilder.suggest(String.valueOf('['));
            }
            if (this.field_197270_l.func_177230_c().func_149716_u()) {
                suggestionsBuilder.suggest(String.valueOf('{'));
            }
        }
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> func_201953_j(SuggestionsBuilder suggestionsBuilder) {
        return ISuggestionProvider.func_197014_a(BlockTags.func_199896_a().func_199908_a(), suggestionsBuilder.createOffset(this.field_201954_r).add(suggestionsBuilder));
    }

    private CompletableFuture<Suggestions> func_197250_h(SuggestionsBuilder suggestionsBuilder) {
        if (this.field_199832_j) {
            ISuggestionProvider.func_197006_a(BlockTags.func_199896_a().func_199908_a(), suggestionsBuilder, String.valueOf('#'));
        }
        ISuggestionProvider.func_197014_a(IRegistry.field_212618_g.func_148742_b(), suggestionsBuilder);
        return suggestionsBuilder.buildFuture();
    }

    public void func_197258_d() throws CommandSyntaxException {
        int n = this.field_197266_h.getCursor();
        this.field_197268_j = ResourceLocation.func_195826_a(this.field_197266_h);
        if (!IRegistry.field_212618_g.func_212607_c(this.field_197268_j)) {
            this.field_197266_h.setCursor(n);
            throw field_197259_a.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString());
        }
        Block \u26032 = IRegistry.field_212618_g.func_82594_a(this.field_197268_j);
        this.field_197269_k = \u26032.func_176194_O();
        this.field_197270_l = \u26032.func_176223_P();
    }

    public void func_199827_f() throws CommandSyntaxException {
        if (!this.field_199832_j) {
            throw field_199831_a.create();
        }
        this.field_197272_n = this::func_201953_j;
        this.field_197266_h.expect('#');
        this.field_201954_r = this.field_197266_h.getCursor();
        this.field_199833_p = ResourceLocation.func_195826_a(this.field_197266_h);
    }

    public void func_197257_e() throws CommandSyntaxException {
        this.field_197266_h.skip();
        this.field_197272_n = this::func_197252_b;
        this.field_197266_h.skipWhitespace();
        while (this.field_197266_h.canRead() && this.field_197266_h.peek() != ']') {
            this.field_197266_h.skipWhitespace();
            int n = this.field_197266_h.getCursor();
            String \u26032 = this.field_197266_h.readString();
            IProperty<?> \u26033 = this.field_197269_k.func_185920_a(\u26032);
            if (\u26033 == null) {
                this.field_197266_h.setCursor(n);
                throw field_197260_b.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)\u26032);
            }
            if (this.field_197267_i.containsKey(\u26033)) {
                this.field_197266_h.setCursor(n);
                throw field_197261_c.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)\u26032);
            }
            this.field_197266_h.skipWhitespace();
            this.field_197272_n = this::func_197246_e;
            if (!this.field_197266_h.canRead() || this.field_197266_h.peek() != '=') {
                throw field_197263_e.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)\u26032);
            }
            this.field_197266_h.skip();
            this.field_197266_h.skipWhitespace();
            this.field_197272_n = suggestionsBuilder -> BlockStateParser.func_201037_a(suggestionsBuilder, \u26033).buildFuture();
            \u2603 = this.field_197266_h.getCursor();
            this.func_197253_a(\u26033, this.field_197266_h.readString(), \u2603);
            this.field_197272_n = this::func_197248_f;
            this.field_197266_h.skipWhitespace();
            if (!this.field_197266_h.canRead()) continue;
            if (this.field_197266_h.peek() == ',') {
                this.field_197266_h.skip();
                this.field_197272_n = this::func_197256_c;
                continue;
            }
            if (this.field_197266_h.peek() == ']') break;
            throw field_197264_f.createWithContext((ImmutableStringReader)this.field_197266_h);
        }
        if (!this.field_197266_h.canRead()) {
            throw field_197264_f.createWithContext((ImmutableStringReader)this.field_197266_h);
        }
        this.field_197266_h.skip();
    }

    public void func_200137_h() throws CommandSyntaxException {
        this.field_197266_h.skip();
        this.field_197272_n = this::func_200136_c;
        int \u26032 = -1;
        this.field_197266_h.skipWhitespace();
        while (this.field_197266_h.canRead() && this.field_197266_h.peek() != ']') {
            this.field_197266_h.skipWhitespace();
            \u2603 = this.field_197266_h.getCursor();
            String string = this.field_197266_h.readString();
            if (this.field_200141_l.containsKey(string)) {
                this.field_197266_h.setCursor(\u2603);
                throw field_197261_c.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)string);
            }
            this.field_197266_h.skipWhitespace();
            if (!this.field_197266_h.canRead() || this.field_197266_h.peek() != '=') {
                this.field_197266_h.setCursor(\u2603);
                throw field_197263_e.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)string);
            }
            this.field_197266_h.skip();
            this.field_197266_h.skipWhitespace();
            this.field_197272_n = suggestionsBuilder -> this.func_200140_a((SuggestionsBuilder)suggestionsBuilder, string);
            \u26032 = this.field_197266_h.getCursor();
            String string2 = this.field_197266_h.readString();
            this.field_200141_l.put(string, string2);
            this.field_197266_h.skipWhitespace();
            if (!this.field_197266_h.canRead()) continue;
            \u26032 = -1;
            if (this.field_197266_h.peek() == ',') {
                this.field_197266_h.skip();
                this.field_197272_n = this::func_200134_e;
                continue;
            }
            if (this.field_197266_h.peek() == ']') break;
            throw field_197264_f.createWithContext((ImmutableStringReader)this.field_197266_h);
        }
        if (!this.field_197266_h.canRead()) {
            if (\u26032 >= 0) {
                this.field_197266_h.setCursor(\u26032);
            }
            throw field_197264_f.createWithContext((ImmutableStringReader)this.field_197266_h);
        }
        this.field_197266_h.skip();
    }

    public void func_197240_f() throws CommandSyntaxException {
        this.field_197271_m = new JsonToNBT(this.field_197266_h).func_193593_f();
    }

    private <T extends Comparable<T>> void func_197253_a(IProperty<T> iProperty, String string, int n) throws CommandSyntaxException {
        Optional<T> optional = iProperty.func_185929_b(string);
        if (!optional.isPresent()) {
            this.field_197266_h.setCursor(n);
            throw field_197262_d.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)iProperty.func_177701_a(), (Object)string);
        }
        this.field_197270_l = (IBlockState)this.field_197270_l.func_206870_a(iProperty, (Comparable)optional.get());
        this.field_197267_i.put(iProperty, (Comparable<?>)optional.get());
    }

    public static String func_197247_a(IBlockState iBlockState, @Nullable NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        StringBuilder stringBuilder = new StringBuilder(IRegistry.field_212618_g.func_177774_c(iBlockState.func_177230_c()).toString());
        if (!iBlockState.func_206869_a().isEmpty()) {
            stringBuilder.append('[');
            boolean bl = false;
            for (Map.Entry entry : iBlockState.func_206871_b().entrySet()) {
                if (bl) {
                    stringBuilder.append(',');
                }
                BlockStateParser.func_211375_a(stringBuilder, (IProperty)entry.getKey(), (Comparable)entry.getValue());
                bl = true;
            }
            stringBuilder.append(']');
        }
        if (nBTTagCompound2 != null) {
            stringBuilder.append(nBTTagCompound2);
        }
        return stringBuilder.toString();
    }

    private static <T extends Comparable<T>> void func_211375_a(StringBuilder stringBuilder, IProperty<T> iProperty, Comparable<?> comparable) {
        stringBuilder.append(iProperty.func_177701_a());
        stringBuilder.append('=');
        stringBuilder.append(iProperty.func_177702_a(comparable));
    }

    public CompletableFuture<Suggestions> func_197245_a(SuggestionsBuilder suggestionsBuilder) {
        return this.field_197272_n.apply(suggestionsBuilder.createOffset(this.field_197266_h.getCursor()));
    }

    public Map<String, String> func_200139_j() {
        return this.field_200141_l;
    }
}

