/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;

public interface ISuggestionProvider {
    public Collection<String> func_197011_j();

    default public Collection<String> func_211270_p() {
        return Collections.emptyList();
    }

    public Collection<String> func_197012_k();

    public Collection<ResourceLocation> func_197010_l();

    public Collection<ResourceLocation> func_199612_m();

    public CompletableFuture<Suggestions> func_197009_a(CommandContext<ISuggestionProvider> var1, SuggestionsBuilder var2);

    public Collection<Coordinates> func_199613_a(boolean var1);

    public boolean func_197034_c(int var1);

    public static <T> void func_210512_a(Iterable<T> iterable, String string, Function<T, ResourceLocation> function, Consumer<T> consumer) {
        boolean bl = string.indexOf(58) > -1;
        for (T t : iterable) {
            ResourceLocation resourceLocation = function.apply(t);
            if (bl) {
                String string2 = resourceLocation.toString();
                if (!string2.startsWith(string)) continue;
                consumer.accept(t);
                continue;
            }
            if (!resourceLocation.func_110624_b().startsWith(string) && (!resourceLocation.func_110624_b().equals("minecraft") || !resourceLocation.func_110623_a().startsWith(string))) continue;
            consumer.accept(t);
        }
    }

    public static <T> void func_210511_a(Iterable<T> iterable, String string, String string2, Function<T, ResourceLocation> function, Consumer<T> consumer) {
        if (string.isEmpty()) {
            iterable.forEach(consumer);
        } else {
            String string3 = Strings.commonPrefix((CharSequence)string, (CharSequence)string2);
            if (!string3.isEmpty()) {
                \u2603 = string.substring(string3.length());
                ISuggestionProvider.func_210512_a(iterable, \u2603, function, consumer);
            }
        }
    }

    public static CompletableFuture<Suggestions> func_197006_a(Iterable<ResourceLocation> iterable, SuggestionsBuilder suggestionsBuilder, String string) {
        \u2603 = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
        ISuggestionProvider.func_210511_a(iterable, \u2603, string, resourceLocation -> resourceLocation, resourceLocation -> suggestionsBuilder.suggest(string + resourceLocation));
        return suggestionsBuilder.buildFuture();
    }

    public static CompletableFuture<Suggestions> func_197014_a(Iterable<ResourceLocation> iterable, SuggestionsBuilder suggestionsBuilder) {
        String string = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
        ISuggestionProvider.func_210512_a(iterable, string, resourceLocation -> resourceLocation, resourceLocation -> suggestionsBuilder.suggest(resourceLocation.toString()));
        return suggestionsBuilder.buildFuture();
    }

    public static <T> CompletableFuture<Suggestions> func_210514_a(Iterable<T> iterable, SuggestionsBuilder suggestionsBuilder, Function<T, ResourceLocation> function, Function<T, Message> function2) {
        String string = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
        ISuggestionProvider.func_210512_a(iterable, string, function, object -> suggestionsBuilder.suggest(((ResourceLocation)function.apply(object)).toString(), (Message)function2.apply(object)));
        return suggestionsBuilder.buildFuture();
    }

    public static CompletableFuture<Suggestions> func_212476_a(Stream<ResourceLocation> stream, SuggestionsBuilder suggestionsBuilder) {
        return ISuggestionProvider.func_197014_a(stream::iterator, suggestionsBuilder);
    }

    public static <T> CompletableFuture<Suggestions> func_201725_a(Stream<T> stream, SuggestionsBuilder suggestionsBuilder, Function<T, ResourceLocation> function, Function<T, Message> function2) {
        return ISuggestionProvider.func_210514_a(stream::iterator, suggestionsBuilder, function, function2);
    }

    public static CompletableFuture<Suggestions> func_209000_a(String string2, Collection<Coordinates> collection2, SuggestionsBuilder suggestionsBuilder, Predicate<String> predicate) {
        ArrayList arrayList;
        block4: {
            Collection<Coordinates> collection2;
            String[] \u26032;
            block5: {
                String string2;
                block3: {
                    arrayList = Lists.newArrayList();
                    if (!Strings.isNullOrEmpty((String)string2)) break block3;
                    for (Coordinates coordinates : collection2) {
                        String string3 = coordinates.field_209006_c + " " + coordinates.field_209007_d + " " + coordinates.field_209008_e;
                        if (!predicate.test(string3)) continue;
                        arrayList.add(coordinates.field_209006_c);
                        arrayList.add(coordinates.field_209006_c + " " + coordinates.field_209007_d);
                        arrayList.add(string3);
                    }
                    break block4;
                }
                \u26032 = string2.split(" ");
                if (\u26032.length != 1) break block5;
                for (Coordinates coordinates : collection2) {
                    String string4 = \u26032[0] + " " + coordinates.field_209007_d + " " + coordinates.field_209008_e;
                    if (!predicate.test(string4)) continue;
                    arrayList.add(\u26032[0] + " " + coordinates.field_209007_d);
                    arrayList.add(string4);
                }
                break block4;
            }
            if (\u26032.length != 2) break block4;
            for (Coordinates \u26033 : collection2) {
                String string5 = \u26032[0] + " " + \u26032[1] + " " + \u26033.field_209008_e;
                if (!predicate.test(string5)) continue;
                arrayList.add(string5);
            }
        }
        return ISuggestionProvider.func_197005_b(arrayList, suggestionsBuilder);
    }

    public static CompletableFuture<Suggestions> func_211269_a(String string2, Collection<Coordinates> collection, SuggestionsBuilder suggestionsBuilder, Predicate<String> predicate) {
        ArrayList arrayList;
        block3: {
            String string2;
            block2: {
                arrayList = Lists.newArrayList();
                if (!Strings.isNullOrEmpty((String)string2)) break block2;
                for (Coordinates coordinates : collection) {
                    String string3 = coordinates.field_209006_c + " " + coordinates.field_209008_e;
                    if (!predicate.test(string3)) continue;
                    arrayList.add(coordinates.field_209006_c);
                    arrayList.add(string3);
                }
                break block3;
            }
            String[] \u26032 = string2.split(" ");
            if (\u26032.length != 1) break block3;
            for (Coordinates coordinates : collection) {
                String string4 = \u26032[0] + " " + coordinates.field_209008_e;
                if (!predicate.test(string4)) continue;
                arrayList.add(string4);
            }
        }
        return ISuggestionProvider.func_197005_b(arrayList, suggestionsBuilder);
    }

    public static CompletableFuture<Suggestions> func_197005_b(Iterable<String> iterable, SuggestionsBuilder suggestionsBuilder) {
        String string = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
        for (String string2 : iterable) {
            if (!string2.toLowerCase(Locale.ROOT).startsWith(string)) continue;
            suggestionsBuilder.suggest(string2);
        }
        return suggestionsBuilder.buildFuture();
    }

    public static CompletableFuture<Suggestions> func_197013_a(Stream<String> stream, SuggestionsBuilder suggestionsBuilder) {
        String string = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
        stream.filter(string2 -> string2.toLowerCase(Locale.ROOT).startsWith(string)).forEach(arg_0 -> ((SuggestionsBuilder)suggestionsBuilder).suggest(arg_0));
        return suggestionsBuilder.buildFuture();
    }

    public static CompletableFuture<Suggestions> func_197008_a(String[] stringArray, SuggestionsBuilder suggestionsBuilder) {
        String string = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
        for (String string2 : stringArray) {
            if (!string2.toLowerCase(Locale.ROOT).startsWith(string)) continue;
            suggestionsBuilder.suggest(string2);
        }
        return suggestionsBuilder.buildFuture();
    }

    public static class Coordinates {
        public static final Coordinates field_209004_a = new Coordinates("^", "^", "^");
        public static final Coordinates field_209005_b = new Coordinates("~", "~", "~");
        public final String field_209006_c;
        public final String field_209007_d;
        public final String field_209008_e;

        public Coordinates(String string, String string2, String string3) {
            this.field_209006_c = string;
            this.field_209007_d = string2;
            this.field_209008_e = string3;
        }
    }
}

