/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.FunctionManager;
import net.minecraft.command.CommandSource;
import net.minecraft.util.ResourceLocation;

public class FunctionObject {
    private final Entry[] field_193530_b;
    private final ResourceLocation field_197002_b;

    public FunctionObject(ResourceLocation resourceLocation, Entry[] entryArray) {
        this.field_197002_b = resourceLocation;
        this.field_193530_b = entryArray;
    }

    public ResourceLocation func_197001_a() {
        return this.field_197002_b;
    }

    public Entry[] func_193528_a() {
        return this.field_193530_b;
    }

    public static FunctionObject func_197000_a(ResourceLocation resourceLocation, FunctionManager functionManager, List<String> list) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        for (int i = 0; i < list.size(); ++i) {
            \u2603 = i + 1;
            String string = list.get(i).trim();
            StringReader \u26032 = new StringReader(string);
            if (!\u26032.canRead() || \u26032.peek() == '#') continue;
            if (\u26032.peek() == '/') {
                \u26032.skip();
                if (\u26032.peek() == '/') {
                    throw new IllegalArgumentException("Unknown or invalid command '" + string + "' on line " + \u2603 + " (if you intended to make a comment, use '#' not '//')");
                }
                \u2603 = \u26032.readUnquotedString();
                throw new IllegalArgumentException("Unknown or invalid command '" + string + "' on line " + \u2603 + " (did you mean '" + \u2603 + "'? Do not use a preceding forwards slash.)");
            }
            try {
                \u2603 = functionManager.func_195450_a().func_195571_aL().func_197054_a().parse(\u26032, (Object)functionManager.func_195448_f());
                if (\u2603.getReader().canRead()) {
                    if (\u2603.getExceptions().size() == 1) {
                        throw (CommandSyntaxException)((Object)\u2603.getExceptions().values().iterator().next());
                    }
                    if (\u2603.getContext().getRange().isEmpty()) {
                        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(\u2603.getReader());
                    }
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(\u2603.getReader());
                }
                arrayList.add(new CommandEntry((ParseResults<CommandSource>)\u2603));
                continue;
            }
            catch (CommandSyntaxException \u26033) {
                throw new IllegalArgumentException("Whilst parsing command on line " + \u2603 + ": " + \u26033.getMessage());
            }
        }
        return new FunctionObject(resourceLocation, arrayList.toArray(new Entry[0]));
    }

    public static class CacheableFunction {
        public static final CacheableFunction field_193519_a = new CacheableFunction((ResourceLocation)null);
        @Nullable
        private final ResourceLocation field_193520_b;
        private boolean field_193521_c;
        private FunctionObject field_193522_d;

        public CacheableFunction(@Nullable ResourceLocation resourceLocation) {
            this.field_193520_b = resourceLocation;
        }

        public CacheableFunction(FunctionObject functionObject) {
            this.field_193520_b = null;
            this.field_193522_d = functionObject;
        }

        @Nullable
        public FunctionObject func_193518_a(FunctionManager functionManager) {
            if (!this.field_193521_c) {
                if (this.field_193520_b != null) {
                    this.field_193522_d = functionManager.func_193058_a(this.field_193520_b);
                }
                this.field_193521_c = true;
            }
            return this.field_193522_d;
        }

        @Nullable
        public ResourceLocation func_200376_a() {
            return this.field_193522_d != null ? this.field_193522_d.field_197002_b : this.field_193520_b;
        }
    }

    public static class FunctionEntry
    implements Entry {
        private final CacheableFunction field_193524_a;

        public FunctionEntry(FunctionObject functionObject) {
            this.field_193524_a = new CacheableFunction(functionObject);
        }

        @Override
        public void func_196998_a(FunctionManager functionManager, CommandSource commandSource, ArrayDeque<FunctionManager.QueuedCommand> arrayDeque, int n) {
            FunctionObject functionObject = this.field_193524_a.func_193518_a(functionManager);
            if (functionObject != null) {
                Entry[] entryArray = functionObject.func_193528_a();
                int \u26032 = n - arrayDeque.size();
                int \u26033 = Math.min(entryArray.length, \u26032);
                for (int i = \u26033 - 1; i >= 0; --i) {
                    arrayDeque.addFirst(new FunctionManager.QueuedCommand(functionManager, commandSource, entryArray[i]));
                }
            }
        }

        public String toString() {
            return "function " + this.field_193524_a.func_200376_a();
        }
    }

    public static class CommandEntry
    implements Entry {
        private final ParseResults<CommandSource> field_196999_a;

        public CommandEntry(ParseResults<CommandSource> parseResults) {
            this.field_196999_a = parseResults;
        }

        @Override
        public void func_196998_a(FunctionManager functionManager, CommandSource commandSource, ArrayDeque<FunctionManager.QueuedCommand> arrayDeque, int n) throws CommandSyntaxException {
            functionManager.func_195446_d().execute(new ParseResults(this.field_196999_a.getContext().withSource((Object)commandSource), this.field_196999_a.getStartIndex(), this.field_196999_a.getReader(), this.field_196999_a.getExceptions()));
        }

        public String toString() {
            return this.field_196999_a.getReader().getString();
        }
    }

    public static interface Entry {
        public void func_196998_a(FunctionManager var1, CommandSource var2, ArrayDeque<FunctionManager.QueuedCommand> var3, int var4) throws CommandSyntaxException;
    }
}

