/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockObserver;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockRedstoneWire
extends Block {
    public static final EnumProperty<RedstoneSide> field_176348_a = BlockStateProperties.field_208160_M;
    public static final EnumProperty<RedstoneSide> field_176347_b = BlockStateProperties.field_208159_L;
    public static final EnumProperty<RedstoneSide> field_176349_M = BlockStateProperties.field_208161_N;
    public static final EnumProperty<RedstoneSide> field_176350_N = BlockStateProperties.field_208162_O;
    public static final IntegerProperty field_176351_O = BlockStateProperties.field_208136_ak;
    public static final Map<EnumFacing, EnumProperty<RedstoneSide>> field_196498_A = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumFacing.NORTH, field_176348_a, (Object)EnumFacing.EAST, field_176347_b, (Object)EnumFacing.SOUTH, field_176349_M, (Object)EnumFacing.WEST, field_176350_N));
    protected static final VoxelShape[] field_196499_B = new VoxelShape[]{Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 1.0, 13.0), Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 1.0, 16.0), Block.func_208617_a(0.0, 0.0, 3.0, 13.0, 1.0, 13.0), Block.func_208617_a(0.0, 0.0, 3.0, 13.0, 1.0, 16.0), Block.func_208617_a(3.0, 0.0, 0.0, 13.0, 1.0, 13.0), Block.func_208617_a(3.0, 0.0, 0.0, 13.0, 1.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 13.0, 1.0, 13.0), Block.func_208617_a(0.0, 0.0, 0.0, 13.0, 1.0, 16.0), Block.func_208617_a(3.0, 0.0, 3.0, 16.0, 1.0, 13.0), Block.func_208617_a(3.0, 0.0, 3.0, 16.0, 1.0, 16.0), Block.func_208617_a(0.0, 0.0, 3.0, 16.0, 1.0, 13.0), Block.func_208617_a(0.0, 0.0, 3.0, 16.0, 1.0, 16.0), Block.func_208617_a(3.0, 0.0, 0.0, 16.0, 1.0, 13.0), Block.func_208617_a(3.0, 0.0, 0.0, 16.0, 1.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 1.0, 13.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0)};
    private boolean field_150181_a = true;
    private final Set<BlockPos> field_150179_b = Sets.newHashSet();

    public BlockRedstoneWire(Block.Properties properties) {
        super(properties);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176348_a, RedstoneSide.NONE)).func_206870_a(field_176347_b, RedstoneSide.NONE)).func_206870_a(field_176349_M, RedstoneSide.NONE)).func_206870_a(field_176350_N, RedstoneSide.NONE)).func_206870_a(field_176351_O, 0));
    }

    @Override
    public VoxelShape func_196244_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return field_196499_B[BlockRedstoneWire.func_185699_x(iBlockState)];
    }

    private static int func_185699_x(IBlockState iBlockState) {
        int n = 0;
        boolean \u26032 = iBlockState.func_177229_b(field_176348_a) != RedstoneSide.NONE;
        boolean \u26033 = iBlockState.func_177229_b(field_176347_b) != RedstoneSide.NONE;
        boolean \u26034 = iBlockState.func_177229_b(field_176349_M) != RedstoneSide.NONE;
        boolean bl = \u2603 = iBlockState.func_177229_b(field_176350_N) != RedstoneSide.NONE;
        if (\u26032 || \u26034 && !\u26032 && !\u26033 && !\u2603) {
            n |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (\u26033 || \u2603 && !\u26032 && !\u26033 && !\u26034) {
            n |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (\u26034 || \u26032 && !\u26033 && !\u26034 && !\u2603) {
            n |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (\u2603 || \u26033 && !\u26032 && !\u26034 && !\u2603) {
            n |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return n;
    }

    @Override
    public IBlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        World world = blockItemUseContext.func_195991_k();
        BlockPos \u26032 = blockItemUseContext.func_195995_a();
        return (IBlockState)((IBlockState)((IBlockState)((IBlockState)this.func_176223_P().func_206870_a(field_176350_N, this.func_208074_a(world, \u26032, EnumFacing.WEST))).func_206870_a(field_176347_b, this.func_208074_a(world, \u26032, EnumFacing.EAST))).func_206870_a(field_176348_a, this.func_208074_a(world, \u26032, EnumFacing.NORTH))).func_206870_a(field_176349_M, this.func_208074_a(world, \u26032, EnumFacing.SOUTH));
    }

    @Override
    public IBlockState func_196271_a(IBlockState iBlockState, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (enumFacing == EnumFacing.DOWN) {
            return iBlockState;
        }
        if (enumFacing == EnumFacing.UP) {
            return (IBlockState)((IBlockState)((IBlockState)((IBlockState)iBlockState.func_206870_a(field_176350_N, this.func_208074_a(iWorld, blockPos, EnumFacing.WEST))).func_206870_a(field_176347_b, this.func_208074_a(iWorld, blockPos, EnumFacing.EAST))).func_206870_a(field_176348_a, this.func_208074_a(iWorld, blockPos, EnumFacing.NORTH))).func_206870_a(field_176349_M, this.func_208074_a(iWorld, blockPos, EnumFacing.SOUTH));
        }
        return (IBlockState)iBlockState.func_206870_a(field_196498_A.get(enumFacing), this.func_208074_a(iWorld, blockPos, enumFacing));
    }

    @Override
    public void func_196248_b(IBlockState iBlockState, IWorld iWorld, BlockPos blockPos, int n) {
        try (BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
                Object \u26033;
                RedstoneSide redstoneSide = (RedstoneSide)iBlockState.func_177229_b(field_196498_A.get(enumFacing));
                if (redstoneSide == RedstoneSide.NONE || iWorld.func_180495_p(pooledMutableBlockPos.func_189533_g(blockPos).func_189536_c(enumFacing)).func_177230_c() == this) continue;
                pooledMutableBlockPos.func_189536_c(EnumFacing.DOWN);
                IBlockState \u26032 = iWorld.func_180495_p(pooledMutableBlockPos);
                if (\u26032.func_177230_c() != Blocks.field_190976_dk) {
                    \u26033 = pooledMutableBlockPos.func_177972_a(enumFacing.func_176734_d());
                    \u26034 = \u26032.func_196956_a(enumFacing.func_176734_d(), iWorld.func_180495_p((BlockPos)\u26033), iWorld, pooledMutableBlockPos, (BlockPos)\u26033);
                    BlockRedstoneWire.func_196263_a(\u26032, (IBlockState)\u26034, iWorld, pooledMutableBlockPos, n);
                }
                pooledMutableBlockPos.func_189533_g(blockPos).func_189536_c(enumFacing).func_189536_c(EnumFacing.UP);
                \u26033 = iWorld.func_180495_p(pooledMutableBlockPos);
                if (\u26033.func_177230_c() == Blocks.field_190976_dk) continue;
                Object \u26034 = pooledMutableBlockPos.func_177972_a(enumFacing.func_176734_d());
                IBlockState \u26035 = \u26033.func_196956_a(enumFacing.func_176734_d(), iWorld.func_180495_p((BlockPos)\u26034), iWorld, pooledMutableBlockPos, (BlockPos)\u26034);
                BlockRedstoneWire.func_196263_a((IBlockState)\u26033, \u26035, iWorld, pooledMutableBlockPos, n);
            }
        }
    }

    private RedstoneSide func_208074_a(IBlockReader iBlockReader, BlockPos blockPos, EnumFacing enumFacing) {
        BlockPos blockPos2 = blockPos.func_177972_a(enumFacing);
        IBlockState \u26032 = iBlockReader.func_180495_p(blockPos.func_177972_a(enumFacing));
        IBlockState \u26033 = iBlockReader.func_180495_p(blockPos.func_177984_a());
        if (!\u26033.func_185915_l()) {
            boolean bl = \u2603 = iBlockReader.func_180495_p(blockPos2).func_185896_q() || iBlockReader.func_180495_p(blockPos2).func_177230_c() == Blocks.field_150426_aN;
            if (\u2603 && BlockRedstoneWire.func_176346_d(iBlockReader.func_180495_p(blockPos2.func_177984_a()))) {
                if (\u26032.func_185898_k()) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        if (BlockRedstoneWire.func_176343_a(iBlockReader.func_180495_p(blockPos2), enumFacing) || !\u26032.func_185915_l() && BlockRedstoneWire.func_176346_d(iBlockReader.func_180495_p(blockPos2.func_177977_b()))) {
            return RedstoneSide.SIDE;
        }
        return RedstoneSide.NONE;
    }

    @Override
    public boolean func_149686_d(IBlockState iBlockState) {
        return false;
    }

    @Override
    public boolean func_196260_a(IBlockState iBlockState, IWorldReaderBase iWorldReaderBase, BlockPos blockPos) {
        IBlockState iBlockState2 = iWorldReaderBase.func_180495_p(blockPos.func_177977_b());
        return iBlockState2.func_185896_q() || iBlockState2.func_177230_c() == Blocks.field_150426_aN;
    }

    private IBlockState func_176338_e(World world, BlockPos blockPos, IBlockState iBlockState2) {
        IBlockState iBlockState2;
        iBlockState2 = this.func_212568_b(world, blockPos, iBlockState2);
        ArrayList arrayList = Lists.newArrayList(this.field_150179_b);
        this.field_150179_b.clear();
        for (BlockPos blockPos2 : arrayList) {
            world.func_195593_d(blockPos2, this);
        }
        return iBlockState2;
    }

    private IBlockState func_212568_b(World world2, BlockPos blockPos2, IBlockState iBlockState2) {
        IBlockState iBlockState2;
        int \u26034;
        \u2603 = iBlockState2;
        int n = \u2603.func_177229_b(field_176351_O);
        n2 = 0;
        n2 = this.func_212567_a(n2, \u2603);
        this.field_150181_a = false;
        \u2603 = world2.func_175687_A(blockPos2);
        this.field_150181_a = true;
        if (\u2603 > 0 && \u2603 > n2 - 1) {
            n2 = \u2603;
        }
        \u26034 = 0;
        for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockPos2;
            World world2;
            BlockPos blockPos3 = blockPos2.func_177972_a(enumFacing);
            boolean \u26032 = blockPos3.func_177958_n() != blockPos2.func_177958_n() || blockPos3.func_177952_p() != blockPos2.func_177952_p();
            IBlockState \u26033 = world2.func_180495_p(blockPos3);
            if (\u26032) {
                \u26034 = this.func_212567_a(\u26034, \u26033);
            }
            if (\u26033.func_185915_l() && !world2.func_180495_p(blockPos2.func_177984_a()).func_185915_l()) {
                if (!\u26032 || blockPos2.func_177956_o() < blockPos2.func_177956_o()) continue;
                \u26034 = this.func_212567_a(\u26034, world2.func_180495_p(blockPos3.func_177984_a()));
                continue;
            }
            if (\u26033.func_185915_l() || !\u26032 || blockPos2.func_177956_o() > blockPos2.func_177956_o()) continue;
            \u26034 = this.func_212567_a(\u26034, world2.func_180495_p(blockPos3.func_177977_b()));
        }
        int n2 = \u26034 > n2 ? \u26034 - 1 : (n2 > 0 ? --n2 : 0);
        if (\u2603 > n2 - 1) {
            n2 = \u2603;
        }
        if (n != n2) {
            iBlockState2 = (IBlockState)iBlockState2.func_206870_a(field_176351_O, n2);
            if (world2.func_180495_p(blockPos2) == \u2603) {
                world2.func_180501_a(blockPos2, iBlockState2, 2);
            }
            this.field_150179_b.add(blockPos2);
            for (EnumFacing enumFacing : EnumFacing.values()) {
                this.field_150179_b.add(blockPos2.func_177972_a(enumFacing));
            }
        }
        return iBlockState2;
    }

    private void func_176344_d(World world, BlockPos blockPos) {
        if (world.func_180495_p(blockPos).func_177230_c() != this) {
            return;
        }
        world.func_195593_d(blockPos, this);
        for (EnumFacing enumFacing : EnumFacing.values()) {
            world.func_195593_d(blockPos.func_177972_a(enumFacing), this);
        }
    }

    @Override
    public void func_196259_b(IBlockState iBlockState, World world, BlockPos blockPos, IBlockState iBlockState2) {
        if (iBlockState2.func_177230_c() == iBlockState.func_177230_c() || world.field_72995_K) {
            return;
        }
        this.func_176338_e(world, blockPos, iBlockState);
        for (EnumFacing enumFacing : EnumFacing.Plane.VERTICAL) {
            world.func_195593_d(blockPos.func_177972_a(enumFacing), this);
        }
        for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
            this.func_176344_d(world, blockPos.func_177972_a(enumFacing));
        }
        for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockPos2 = blockPos.func_177972_a(enumFacing);
            if (world.func_180495_p(blockPos2).func_185915_l()) {
                this.func_176344_d(world, blockPos2.func_177984_a());
                continue;
            }
            this.func_176344_d(world, blockPos2.func_177977_b());
        }
    }

    @Override
    public void func_196243_a(IBlockState iBlockState, World world2, BlockPos blockPos, IBlockState iBlockState2, boolean bl) {
        World world2;
        if (bl || iBlockState.func_177230_c() == iBlockState2.func_177230_c()) {
            return;
        }
        super.func_196243_a(iBlockState, world2, blockPos, iBlockState2, bl);
        if (world2.field_72995_K) {
            return;
        }
        for (EnumFacing enumFacing : EnumFacing.values()) {
            world2.func_195593_d(blockPos.func_177972_a(enumFacing), this);
        }
        this.func_176338_e(world2, blockPos, iBlockState);
        for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
            this.func_176344_d(world2, blockPos.func_177972_a(enumFacing));
        }
        for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockPos2 = blockPos.func_177972_a(enumFacing);
            if (world2.func_180495_p(blockPos2).func_185915_l()) {
                this.func_176344_d(world2, blockPos2.func_177984_a());
                continue;
            }
            this.func_176344_d(world2, blockPos2.func_177977_b());
        }
    }

    private int func_212567_a(int n, IBlockState iBlockState) {
        if (iBlockState.func_177230_c() != this) {
            return n;
        }
        int n2 = iBlockState.func_177229_b(field_176351_O);
        if (n2 > n) {
            return n2;
        }
        return n;
    }

    @Override
    public void func_189540_a(IBlockState iBlockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2) {
        if (world.field_72995_K) {
            return;
        }
        if (iBlockState.func_196955_c(world, blockPos)) {
            this.func_176338_e(world, blockPos, iBlockState);
        } else {
            iBlockState.func_196949_c(world, blockPos, 0);
            world.func_175698_g(blockPos);
        }
    }

    @Override
    public int func_176211_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, EnumFacing enumFacing) {
        if (!this.field_150181_a) {
            return 0;
        }
        return iBlockState.func_185911_a(iBlockReader, blockPos, enumFacing);
    }

    @Override
    public int func_180656_a(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, EnumFacing enumFacing2) {
        EnumFacing enumFacing2;
        if (!this.field_150181_a) {
            return 0;
        }
        int n = iBlockState.func_177229_b(field_176351_O);
        if (n == 0) {
            return 0;
        }
        if (enumFacing2 == EnumFacing.UP) {
            return n;
        }
        EnumSet<EnumFacing> \u26032 = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing enumFacing3 : EnumFacing.Plane.HORIZONTAL) {
            if (!this.func_176339_d(iBlockReader, blockPos, enumFacing3)) continue;
            \u26032.add(enumFacing3);
        }
        if (enumFacing2.func_176740_k().func_176722_c() && \u26032.isEmpty()) {
            return n;
        }
        if (\u26032.contains(enumFacing2) && !\u26032.contains(enumFacing2.func_176735_f()) && !\u26032.contains(enumFacing2.func_176746_e())) {
            return n;
        }
        return 0;
    }

    private boolean func_176339_d(IBlockReader iBlockReader, BlockPos blockPos, EnumFacing enumFacing) {
        BlockPos blockPos2 = blockPos.func_177972_a(enumFacing);
        IBlockState \u26032 = iBlockReader.func_180495_p(blockPos2);
        boolean \u26033 = \u26032.func_185915_l();
        boolean \u26034 = iBlockReader.func_180495_p(blockPos.func_177984_a()).func_185915_l();
        if (!\u26034 && \u26033 && BlockRedstoneWire.func_176340_e(iBlockReader, blockPos2.func_177984_a())) {
            return true;
        }
        if (BlockRedstoneWire.func_176343_a(\u26032, enumFacing)) {
            return true;
        }
        if (\u26032.func_177230_c() == Blocks.field_196633_cV && \u26032.func_177229_b(BlockRedstoneDiode.field_196348_c).booleanValue() && \u26032.func_177229_b(BlockRedstoneDiode.field_185512_D) == enumFacing) {
            return true;
        }
        return !\u26033 && BlockRedstoneWire.func_176340_e(iBlockReader, blockPos2.func_177977_b());
    }

    protected static boolean func_176340_e(IBlockReader iBlockReader, BlockPos blockPos) {
        return BlockRedstoneWire.func_176346_d(iBlockReader.func_180495_p(blockPos));
    }

    protected static boolean func_176346_d(IBlockState iBlockState) {
        return BlockRedstoneWire.func_176343_a(iBlockState, null);
    }

    protected static boolean func_176343_a(IBlockState iBlockState2, @Nullable EnumFacing enumFacing) {
        IBlockState iBlockState2;
        Block block = iBlockState2.func_177230_c();
        if (block == Blocks.field_150488_af) {
            return true;
        }
        if (iBlockState2.func_177230_c() == Blocks.field_196633_cV) {
            EnumFacing enumFacing2 = iBlockState2.func_177229_b(BlockRedstoneRepeater.field_185512_D);
            return enumFacing2 == enumFacing || enumFacing2.func_176734_d() == enumFacing;
        }
        if (Blocks.field_190976_dk == iBlockState2.func_177230_c()) {
            return enumFacing == iBlockState2.func_177229_b(BlockObserver.field_176387_N);
        }
        return iBlockState2.func_185897_m() && enumFacing != null;
    }

    @Override
    public boolean func_149744_f(IBlockState iBlockState) {
        return this.field_150181_a;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public IBlockState func_185499_a(IBlockState iBlockState, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)iBlockState.func_206870_a(field_176348_a, iBlockState.func_177229_b(field_176349_M))).func_206870_a(field_176347_b, iBlockState.func_177229_b(field_176350_N))).func_206870_a(field_176349_M, iBlockState.func_177229_b(field_176348_a))).func_206870_a(field_176350_N, iBlockState.func_177229_b(field_176347_b));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)iBlockState.func_206870_a(field_176348_a, iBlockState.func_177229_b(field_176347_b))).func_206870_a(field_176347_b, iBlockState.func_177229_b(field_176349_M))).func_206870_a(field_176349_M, iBlockState.func_177229_b(field_176350_N))).func_206870_a(field_176350_N, iBlockState.func_177229_b(field_176348_a));
            }
            case CLOCKWISE_90: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)iBlockState.func_206870_a(field_176348_a, iBlockState.func_177229_b(field_176350_N))).func_206870_a(field_176347_b, iBlockState.func_177229_b(field_176348_a))).func_206870_a(field_176349_M, iBlockState.func_177229_b(field_176347_b))).func_206870_a(field_176350_N, iBlockState.func_177229_b(field_176349_M));
            }
        }
        return iBlockState;
    }

    @Override
    public IBlockState func_185471_a(IBlockState iBlockState, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (IBlockState)((IBlockState)iBlockState.func_206870_a(field_176348_a, iBlockState.func_177229_b(field_176349_M))).func_206870_a(field_176349_M, iBlockState.func_177229_b(field_176348_a));
            }
            case FRONT_BACK: {
                return (IBlockState)((IBlockState)iBlockState.func_206870_a(field_176347_b, iBlockState.func_177229_b(field_176350_N))).func_206870_a(field_176350_N, iBlockState.func_177229_b(field_176347_b));
            }
        }
        return super.func_185471_a(iBlockState, mirror);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_176348_a, field_176347_b, field_176349_M, field_176350_N, field_176351_O);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader iBlockReader, IBlockState iBlockState, BlockPos blockPos, EnumFacing enumFacing) {
        return BlockFaceShape.UNDEFINED;
    }
}

