/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.StatList;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockLeaves
extends Block {
    public static final IntegerProperty field_208494_a = BlockStateProperties.field_208514_aa;
    public static final BooleanProperty field_208495_b = BlockStateProperties.field_208515_s;
    protected static boolean field_196478_c;

    public BlockLeaves(Block.Properties properties) {
        super(properties);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_208494_a, 7)).func_206870_a(field_208495_b, false));
    }

    @Override
    public boolean func_149653_t(IBlockState iBlockState) {
        return iBlockState.func_177229_b(field_208494_a) == 7 && iBlockState.func_177229_b(field_208495_b) == false;
    }

    @Override
    public void func_196265_a(IBlockState iBlockState, World world, BlockPos blockPos, Random random) {
        if (!iBlockState.func_177229_b(field_208495_b).booleanValue() && iBlockState.func_177229_b(field_208494_a) == 7) {
            iBlockState.func_196949_c(world, blockPos, 0);
            world.func_175698_g(blockPos);
        }
    }

    @Override
    public void func_196267_b(IBlockState iBlockState, World world, BlockPos blockPos, Random random) {
        world.func_180501_a(blockPos, BlockLeaves.func_208493_b(iBlockState, world, blockPos), 3);
    }

    @Override
    public int func_200011_d(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return 1;
    }

    @Override
    public IBlockState func_196271_a(IBlockState iBlockState, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        int n = BlockLeaves.func_208492_w(iBlockState2) + 1;
        if (n != 1 || iBlockState.func_177229_b(field_208494_a) != n) {
            iWorld.func_205220_G_().func_205360_a(blockPos, this, 1);
        }
        return iBlockState;
    }

    private static IBlockState func_208493_b(IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos) {
        IBlockState iBlockState2;
        int n = 7;
        try (BlockPos.PooledMutableBlockPos \u26032 = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (EnumFacing enumFacing : EnumFacing.values()) {
                \u26032.func_189533_g(blockPos).func_189536_c(enumFacing);
                n = Math.min(n, BlockLeaves.func_208492_w(iWorld.func_180495_p(\u26032)) + 1);
                if (n != 1) continue;
                break;
            }
        }
        return (IBlockState)iBlockState2.func_206870_a(field_208494_a, n);
    }

    private static int func_208492_w(IBlockState iBlockState) {
        if (BlockTags.field_200031_h.func_199685_a_(iBlockState.func_177230_c())) {
            return 0;
        }
        if (iBlockState.func_177230_c() instanceof BlockLeaves) {
            return iBlockState.func_177229_b(field_208494_a);
        }
        return 7;
    }

    @Override
    public int func_196264_a(IBlockState iBlockState, Random random) {
        return random.nextInt(20) == 0 ? 1 : 0;
    }

    @Override
    public IItemProvider func_199769_a(IBlockState iBlockState, World world, BlockPos blockPos, int n) {
        Block block = iBlockState.func_177230_c();
        if (block == Blocks.field_196642_W) {
            return Blocks.field_196674_t;
        }
        if (block == Blocks.field_196645_X) {
            return Blocks.field_196675_u;
        }
        if (block == Blocks.field_196647_Y) {
            return Blocks.field_196676_v;
        }
        if (block == Blocks.field_196648_Z) {
            return Blocks.field_196678_w;
        }
        if (block == Blocks.field_196572_aa) {
            return Blocks.field_196679_x;
        }
        if (block == Blocks.field_196574_ab) {
            return Blocks.field_196680_y;
        }
        return Blocks.field_196674_t;
    }

    @Override
    public void func_196255_a(IBlockState iBlockState, World world, BlockPos blockPos, float f, int n) {
        if (!world.field_72995_K) {
            \u2603 = this.func_196472_i(iBlockState);
            if (n > 0 && (\u2603 -= 2 << n) < 10) {
                \u2603 = 10;
            }
            if (world.field_73012_v.nextInt(\u2603) == 0) {
                BlockLeaves.func_180635_a(world, blockPos, new ItemStack(this.func_199769_a(iBlockState, world, blockPos, n)));
            }
            \u2603 = 200;
            if (n > 0 && (\u2603 -= 10 << n) < 40) {
                \u2603 = 40;
            }
            this.func_196474_a(world, blockPos, iBlockState, \u2603);
        }
    }

    protected void func_196474_a(World world, BlockPos blockPos, IBlockState iBlockState, int n) {
        if ((iBlockState.func_177230_c() == Blocks.field_196642_W || iBlockState.func_177230_c() == Blocks.field_196574_ab) && world.field_73012_v.nextInt(n) == 0) {
            BlockLeaves.func_180635_a(world, blockPos, new ItemStack(Items.field_151034_e));
        }
    }

    protected int func_196472_i(IBlockState iBlockState) {
        if (iBlockState.func_177230_c() == Blocks.field_196648_Z) {
            return 40;
        }
        return 20;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return field_196478_c ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.SOLID;
    }

    @Override
    public boolean func_176214_u(IBlockState iBlockState) {
        return false;
    }

    @Override
    public void func_180657_a(World world, EntityPlayer entityPlayer, BlockPos blockPos, IBlockState iBlockState, @Nullable TileEntity tileEntity, ItemStack itemStack) {
        if (!world.field_72995_K && itemStack.func_77973_b() == Items.field_151097_aZ) {
            entityPlayer.func_71029_a(StatList.field_188065_ae.func_199076_b(this));
            entityPlayer.func_71020_j(0.005f);
            BlockLeaves.func_180635_a(world, blockPos, new ItemStack(this));
            return;
        }
        super.func_180657_a(world, entityPlayer, blockPos, iBlockState, tileEntity, itemStack);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_208494_a, field_208495_b);
    }

    @Override
    public IBlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        return BlockLeaves.func_208493_b((IBlockState)this.func_176223_P().func_206870_a(field_208495_b, true), blockItemUseContext.func_195991_k(), blockItemUseContext.func_195995_a());
    }
}

