/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockFlowingFluid
extends Block
implements IBucketPickupHandler {
    public static final IntegerProperty field_176367_b = BlockStateProperties.field_208132_ag;
    protected final FlowingFluid field_204517_c;
    private final List<IFluidState> field_212565_c;
    private final Map<IBlockState, VoxelShape> field_196481_b = Maps.newIdentityHashMap();

    protected BlockFlowingFluid(FlowingFluid flowingFluid2, Block.Properties properties) {
        super(properties);
        FlowingFluid flowingFluid2;
        this.field_204517_c = flowingFluid2;
        this.field_212565_c = Lists.newArrayList();
        this.field_212565_c.add(flowingFluid2.func_207204_a(false));
        for (int i = 1; i < 8; ++i) {
            this.field_212565_c.add(flowingFluid2.func_207207_a(8 - i, false));
        }
        this.field_212565_c.add(flowingFluid2.func_207207_a(8, true));
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176367_b, 0));
    }

    @Override
    public void func_196265_a(IBlockState iBlockState, World world, BlockPos blockPos, Random random) {
        world.func_204610_c(blockPos).func_206891_b(world, blockPos, random);
    }

    @Override
    public boolean func_200123_i(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return false;
    }

    @Override
    public boolean func_196266_a(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return !this.field_204517_c.func_207185_a(FluidTags.field_206960_b);
    }

    @Override
    public IFluidState func_204507_t(IBlockState iBlockState) {
        int n = iBlockState.func_177229_b(field_176367_b);
        return this.field_212565_c.get(Math.min(n, 8));
    }

    @Override
    public boolean func_149686_d(IBlockState iBlockState) {
        return false;
    }

    @Override
    public boolean func_200293_a(IBlockState iBlockState) {
        return false;
    }

    @Override
    public VoxelShape func_196244_b(IBlockState iBlockState2, IBlockReader iBlockReader, BlockPos blockPos) {
        IFluidState iFluidState = iBlockReader.func_204610_c(blockPos.func_177984_a());
        if (iFluidState.func_206886_c().func_207187_a(this.field_204517_c)) {
            return VoxelShapes.func_197868_b();
        }
        return this.field_196481_b.computeIfAbsent(iBlockState2, iBlockState -> {
            IFluidState iFluidState = iBlockState.func_204520_s();
            return VoxelShapes.func_197873_a(0.0, 0.0, 0.0, 1.0, iFluidState.func_206885_f(), 1.0);
        });
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState iBlockState) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public IItemProvider func_199769_a(IBlockState iBlockState, World world, BlockPos blockPos, int n) {
        return Items.field_190931_a;
    }

    @Override
    public int func_149738_a(IWorldReaderBase iWorldReaderBase) {
        return this.field_204517_c.func_205569_a(iWorldReaderBase);
    }

    @Override
    public void func_196259_b(IBlockState iBlockState, World world, BlockPos blockPos, IBlockState iBlockState2) {
        if (this.func_204515_c(world, blockPos, iBlockState)) {
            world.func_205219_F_().func_205360_a(blockPos, iBlockState.func_204520_s().func_206886_c(), this.func_149738_a(world));
        }
    }

    @Override
    public IBlockState func_196271_a(IBlockState iBlockState, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (iBlockState.func_204520_s().func_206889_d() || iBlockState2.func_204520_s().func_206889_d()) {
            iWorld.func_205219_F_().func_205360_a(blockPos, iBlockState.func_204520_s().func_206886_c(), this.func_149738_a(iWorld));
        }
        return super.func_196271_a(iBlockState, enumFacing, iBlockState2, iWorld, blockPos, blockPos2);
    }

    @Override
    public void func_189540_a(IBlockState iBlockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2) {
        if (this.func_204515_c(world, blockPos, iBlockState)) {
            world.func_205219_F_().func_205360_a(blockPos, iBlockState.func_204520_s().func_206886_c(), this.func_149738_a(world));
        }
    }

    public boolean func_204515_c(World world, BlockPos blockPos, IBlockState iBlockState) {
        if (this.field_204517_c.func_207185_a(FluidTags.field_206960_b)) {
            boolean bl = false;
            for (EnumFacing enumFacing : EnumFacing.values()) {
                if (enumFacing == EnumFacing.DOWN || !world.func_204610_c(blockPos.func_177972_a(enumFacing)).func_206884_a(FluidTags.field_206959_a)) continue;
                bl = true;
                break;
            }
            if (bl) {
                IFluidState iFluidState = world.func_204610_c(blockPos);
                if (iFluidState.func_206889_d()) {
                    world.func_175656_a(blockPos, Blocks.field_150343_Z.func_176223_P());
                    this.func_180688_d(world, blockPos);
                    return false;
                }
                if (iFluidState.func_206885_f() >= 0.44444445f) {
                    world.func_175656_a(blockPos, Blocks.field_150347_e.func_176223_P());
                    this.func_180688_d(world, blockPos);
                    return false;
                }
            }
        }
        return true;
    }

    protected void func_180688_d(IWorld iWorld, BlockPos blockPos) {
        double d = blockPos.func_177958_n();
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p();
        iWorld.func_184133_a(null, blockPos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (iWorld.func_201674_k().nextFloat() - iWorld.func_201674_k().nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            iWorld.func_195594_a(Particles.field_197594_E, d + Math.random(), \u2603 + 1.2, \u2603 + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_176367_b);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader iBlockReader, IBlockState iBlockState, BlockPos blockPos, EnumFacing enumFacing) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public Fluid func_204508_a(IWorld iWorld, BlockPos blockPos, IBlockState iBlockState) {
        if (iBlockState.func_177229_b(field_176367_b) == 0) {
            iWorld.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 11);
            return this.field_204517_c;
        }
        return Fluids.field_204541_a;
    }
}

