/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Fluids;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockChest
extends BlockContainer
implements IBucketPickupHandler,
ILiquidContainer {
    public static final DirectionProperty field_176459_a = BlockHorizontal.field_185512_D;
    public static final EnumProperty<ChestType> field_196314_b = BlockStateProperties.field_208140_ao;
    public static final BooleanProperty field_204511_c = BlockStateProperties.field_208198_y;
    protected static final VoxelShape field_196316_c = Block.func_208617_a(1.0, 0.0, 0.0, 15.0, 14.0, 15.0);
    protected static final VoxelShape field_196317_y = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 14.0, 16.0);
    protected static final VoxelShape field_196318_z = Block.func_208617_a(0.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    protected static final VoxelShape field_196313_A = Block.func_208617_a(1.0, 0.0, 1.0, 16.0, 14.0, 15.0);
    protected static final VoxelShape field_196315_B = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 14.0, 15.0);

    protected BlockChest(Block.Properties properties) {
        super(properties);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176459_a, EnumFacing.NORTH)).func_206870_a(field_196314_b, ChestType.SINGLE)).func_206870_a(field_204511_c, false));
    }

    @Override
    public boolean func_149686_d(IBlockState iBlockState) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState iBlockState) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public IBlockState func_196271_a(IBlockState iBlockState3, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        IBlockState iBlockState3;
        if (iBlockState3.func_177229_b(field_204511_c).booleanValue()) {
            iWorld.func_205219_F_().func_205360_a(blockPos, Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a(iWorld));
        }
        if (iBlockState2.func_177230_c() == this && enumFacing.func_176740_k().func_176722_c()) {
            ChestType chestType = iBlockState2.func_177229_b(field_196314_b);
            if (iBlockState3.func_177229_b(field_196314_b) == ChestType.SINGLE && chestType != ChestType.SINGLE && iBlockState3.func_177229_b(field_176459_a) == iBlockState2.func_177229_b(field_176459_a) && BlockChest.func_196311_i(iBlockState2) == enumFacing.func_176734_d()) {
                return (IBlockState)iBlockState3.func_206870_a(field_196314_b, chestType.func_208081_a());
            }
        } else if (BlockChest.func_196311_i(iBlockState3) == enumFacing) {
            return (IBlockState)iBlockState3.func_206870_a(field_196314_b, ChestType.SINGLE);
        }
        return super.func_196271_a(iBlockState3, enumFacing, iBlockState2, iWorld, blockPos, blockPos2);
    }

    @Override
    public VoxelShape func_196244_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        if (iBlockState.func_177229_b(field_196314_b) == ChestType.SINGLE) {
            return field_196315_B;
        }
        switch (BlockChest.func_196311_i(iBlockState)) {
            default: {
                return field_196316_c;
            }
            case SOUTH: {
                return field_196317_y;
            }
            case WEST: {
                return field_196318_z;
            }
            case EAST: 
        }
        return field_196313_A;
    }

    public static EnumFacing func_196311_i(IBlockState iBlockState) {
        EnumFacing enumFacing = iBlockState.func_177229_b(field_176459_a);
        return iBlockState.func_177229_b(field_196314_b) == ChestType.LEFT ? enumFacing.func_176746_e() : enumFacing.func_176735_f();
    }

    @Override
    public IBlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        ChestType chestType = ChestType.SINGLE;
        EnumFacing \u26032 = blockItemUseContext.func_195992_f().func_176734_d();
        IFluidState \u26033 = blockItemUseContext.func_195991_k().func_204610_c(blockItemUseContext.func_195995_a());
        boolean \u26034 = blockItemUseContext.func_195998_g();
        EnumFacing \u26035 = blockItemUseContext.func_196000_l();
        if (\u26035.func_176740_k().func_176722_c() && \u26034 && (\u2603 = this.func_196312_a(blockItemUseContext, \u26035.func_176734_d())) != null && \u2603.func_176740_k() != \u26035.func_176740_k()) {
            \u26032 = \u2603;
            ChestType chestType2 = chestType = \u26032.func_176735_f() == \u26035.func_176734_d() ? ChestType.RIGHT : ChestType.LEFT;
        }
        if (chestType == ChestType.SINGLE && !\u26034) {
            if (\u26032 == this.func_196312_a(blockItemUseContext, \u26032.func_176746_e())) {
                chestType = ChestType.LEFT;
            } else if (\u26032 == this.func_196312_a(blockItemUseContext, \u26032.func_176735_f())) {
                chestType = ChestType.RIGHT;
            }
        }
        return (IBlockState)((IBlockState)((IBlockState)this.func_176223_P().func_206870_a(field_176459_a, \u26032)).func_206870_a(field_196314_b, chestType)).func_206870_a(field_204511_c, \u26033.func_206886_c() == Fluids.field_204546_a);
    }

    @Override
    public Fluid func_204508_a(IWorld iWorld, BlockPos blockPos, IBlockState iBlockState) {
        if (iBlockState.func_177229_b(field_204511_c).booleanValue()) {
            iWorld.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_204511_c, false), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    @Override
    public IFluidState func_204507_t(IBlockState iBlockState) {
        if (iBlockState.func_177229_b(field_204511_c).booleanValue()) {
            return Fluids.field_204546_a.func_207204_a(false);
        }
        return super.func_204507_t(iBlockState);
    }

    @Override
    public boolean func_204510_a(IBlockReader iBlockReader, BlockPos blockPos, IBlockState iBlockState, Fluid fluid) {
        return iBlockState.func_177229_b(field_204511_c) == false && fluid == Fluids.field_204546_a;
    }

    @Override
    public boolean func_204509_a(IWorld iWorld, BlockPos blockPos, IBlockState iBlockState, IFluidState iFluidState) {
        if (!iBlockState.func_177229_b(field_204511_c).booleanValue() && iFluidState.func_206886_c() == Fluids.field_204546_a) {
            if (!iWorld.func_201670_d()) {
                iWorld.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_204511_c, true), 3);
                iWorld.func_205219_F_().func_205360_a(blockPos, Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a(iWorld));
            }
            return true;
        }
        return false;
    }

    @Nullable
    private EnumFacing func_196312_a(BlockItemUseContext blockItemUseContext, EnumFacing enumFacing) {
        IBlockState iBlockState = blockItemUseContext.func_195991_k().func_180495_p(blockItemUseContext.func_195995_a().func_177972_a(enumFacing));
        return iBlockState.func_177230_c() == this && iBlockState.func_177229_b(field_196314_b) == ChestType.SINGLE ? iBlockState.func_177229_b(field_176459_a) : null;
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, IBlockState iBlockState, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        if (itemStack.func_82837_s() && (\u2603 = world.func_175625_s(blockPos)) instanceof TileEntityChest) {
            ((TileEntityChest)\u2603).func_200226_a(itemStack.func_200301_q());
        }
    }

    @Override
    public void func_196243_a(IBlockState iBlockState, World world, BlockPos blockPos, IBlockState iBlockState2, boolean bl) {
        if (iBlockState.func_177230_c() == iBlockState2.func_177230_c()) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof IInventory) {
            InventoryHelper.func_180175_a(world, blockPos, (IInventory)((Object)tileEntity));
            world.func_175666_e(blockPos, this);
        }
        super.func_196243_a(iBlockState, world, blockPos, iBlockState2, bl);
    }

    @Override
    public boolean func_196250_a(IBlockState iBlockState, World world, BlockPos blockPos, EntityPlayer entityPlayer, EnumHand enumHand, EnumFacing enumFacing, float f, float f2, float f3) {
        if (world.field_72995_K) {
            return true;
        }
        ILockableContainer iLockableContainer = this.func_196309_a(iBlockState, world, blockPos, false);
        if (iLockableContainer != null) {
            entityPlayer.func_71007_a(iLockableContainer);
            entityPlayer.func_71029_a(this.func_196310_d());
        }
        return true;
    }

    protected Stat<ResourceLocation> func_196310_d() {
        return StatList.field_199092_j.func_199076_b(StatList.field_188063_ac);
    }

    @Nullable
    public ILockableContainer func_196309_a(IBlockState iBlockState, World world, BlockPos blockPos, boolean bl) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!(tileEntity instanceof TileEntityChest)) {
            return null;
        }
        if (!bl && this.func_176457_m(world, blockPos)) {
            return null;
        }
        ILockableContainer \u26032 = (TileEntityChest)tileEntity;
        ChestType \u26033 = iBlockState.func_177229_b(field_196314_b);
        if (\u26033 == ChestType.SINGLE) {
            return \u26032;
        }
        BlockPos \u26034 = blockPos.func_177972_a(BlockChest.func_196311_i(iBlockState));
        IBlockState \u26035 = world.func_180495_p(\u26034);
        if (\u26035.func_177230_c() == this && (\u2603 = \u26035.func_177229_b(field_196314_b)) != ChestType.SINGLE && \u26033 != \u2603 && \u26035.func_177229_b(field_176459_a) == iBlockState.func_177229_b(field_176459_a)) {
            if (!bl && this.func_176457_m(world, \u26034)) {
                return null;
            }
            \u2603 = world.func_175625_s(\u26034);
            if (\u2603 instanceof TileEntityChest) {
                ILockableContainer iLockableContainer = \u26033 == ChestType.RIGHT ? \u26032 : (ILockableContainer)((Object)\u2603);
                \u2603 = \u26033 == ChestType.RIGHT ? (ILockableContainer)((Object)\u2603) : \u26032;
                \u26032 = new InventoryLargeChest(new TextComponentTranslation("container.chestDouble", new Object[0]), iLockableContainer, \u2603);
            }
        }
        return \u26032;
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new TileEntityChest();
    }

    private boolean func_176457_m(World world, BlockPos blockPos) {
        return this.func_176456_n(world, blockPos) || this.func_176453_o(world, blockPos);
    }

    private boolean func_176456_n(IBlockReader iBlockReader, BlockPos blockPos) {
        return iBlockReader.func_180495_p(blockPos.func_177984_a()).func_185915_l();
    }

    private boolean func_176453_o(World world, BlockPos blockPos) {
        List<EntityOcelot> list = world.func_72872_a(EntityOcelot.class, new AxisAlignedBB(blockPos.func_177958_n(), blockPos.func_177956_o() + 1, blockPos.func_177952_p(), blockPos.func_177958_n() + 1, blockPos.func_177956_o() + 2, blockPos.func_177952_p() + 1));
        if (!list.isEmpty()) {
            for (EntityOcelot entityOcelot : list) {
                if (!entityOcelot.func_70906_o()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_149740_M(IBlockState iBlockState) {
        return true;
    }

    @Override
    public int func_180641_l(IBlockState iBlockState, World world, BlockPos blockPos) {
        return Container.func_94526_b(this.func_196309_a(iBlockState, world, blockPos, false));
    }

    @Override
    public IBlockState func_185499_a(IBlockState iBlockState, Rotation rotation) {
        return (IBlockState)iBlockState.func_206870_a(field_176459_a, rotation.func_185831_a(iBlockState.func_177229_b(field_176459_a)));
    }

    @Override
    public IBlockState func_185471_a(IBlockState iBlockState, Mirror mirror) {
        return iBlockState.func_185907_a(mirror.func_185800_a(iBlockState.func_177229_b(field_176459_a)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_176459_a, field_196314_b, field_204511_c);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader iBlockReader, IBlockState iBlockState, BlockPos blockPos, EnumFacing enumFacing) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean func_196266_a(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }
}

