/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontalFace;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public abstract class BlockButton
extends BlockHorizontalFace {
    public static final BooleanProperty field_176584_b = BlockStateProperties.field_208194_u;
    protected static final VoxelShape field_196370_b = Block.func_208617_a(6.0, 14.0, 5.0, 10.0, 16.0, 11.0);
    protected static final VoxelShape field_196371_c = Block.func_208617_a(5.0, 14.0, 6.0, 11.0, 16.0, 10.0);
    protected static final VoxelShape field_196376_y = Block.func_208617_a(6.0, 0.0, 5.0, 10.0, 2.0, 11.0);
    protected static final VoxelShape field_196377_z = Block.func_208617_a(5.0, 0.0, 6.0, 11.0, 2.0, 10.0);
    protected static final VoxelShape field_185622_d = Block.func_208617_a(5.0, 6.0, 14.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape field_185624_e = Block.func_208617_a(5.0, 6.0, 0.0, 11.0, 10.0, 2.0);
    protected static final VoxelShape field_185626_f = Block.func_208617_a(14.0, 6.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape field_185628_g = Block.func_208617_a(0.0, 6.0, 5.0, 2.0, 10.0, 11.0);
    protected static final VoxelShape field_196372_E = Block.func_208617_a(6.0, 15.0, 5.0, 10.0, 16.0, 11.0);
    protected static final VoxelShape field_196373_F = Block.func_208617_a(5.0, 15.0, 6.0, 11.0, 16.0, 10.0);
    protected static final VoxelShape field_196374_G = Block.func_208617_a(6.0, 0.0, 5.0, 10.0, 1.0, 11.0);
    protected static final VoxelShape field_196375_H = Block.func_208617_a(5.0, 0.0, 6.0, 11.0, 1.0, 10.0);
    protected static final VoxelShape field_185623_D = Block.func_208617_a(5.0, 6.0, 15.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape field_185625_E = Block.func_208617_a(5.0, 6.0, 0.0, 11.0, 10.0, 1.0);
    protected static final VoxelShape field_185627_F = Block.func_208617_a(15.0, 6.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape field_185629_G = Block.func_208617_a(0.0, 6.0, 5.0, 1.0, 10.0, 11.0);
    private final boolean field_150047_a;

    protected BlockButton(boolean bl, Block.Properties properties) {
        super(properties);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_185512_D, EnumFacing.NORTH)).func_206870_a(field_176584_b, false)).func_206870_a(field_196366_M, AttachFace.WALL));
        this.field_150047_a = bl;
    }

    @Override
    public int func_149738_a(IWorldReaderBase iWorldReaderBase) {
        return this.field_150047_a ? 30 : 20;
    }

    @Override
    public boolean func_149686_d(IBlockState iBlockState) {
        return false;
    }

    @Override
    public VoxelShape func_196244_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        EnumFacing enumFacing = iBlockState.func_177229_b(field_185512_D);
        boolean \u26032 = iBlockState.func_177229_b(field_176584_b);
        switch ((AttachFace)iBlockState.func_177229_b(field_196366_M)) {
            case FLOOR: {
                if (enumFacing.func_176740_k() == EnumFacing.Axis.X) {
                    return \u26032 ? field_196374_G : field_196376_y;
                }
                return \u26032 ? field_196375_H : field_196377_z;
            }
            case WALL: {
                switch (enumFacing) {
                    case EAST: {
                        return \u26032 ? field_185629_G : field_185628_g;
                    }
                    case WEST: {
                        return \u26032 ? field_185627_F : field_185626_f;
                    }
                    case SOUTH: {
                        return \u26032 ? field_185625_E : field_185624_e;
                    }
                }
                return \u26032 ? field_185623_D : field_185622_d;
            }
        }
        if (enumFacing.func_176740_k() == EnumFacing.Axis.X) {
            return \u26032 ? field_196372_E : field_196370_b;
        }
        return \u26032 ? field_196373_F : field_196371_c;
    }

    @Override
    public boolean func_196250_a(IBlockState iBlockState, World world, BlockPos blockPos, EntityPlayer entityPlayer, EnumHand enumHand, EnumFacing enumFacing, float f, float f2, float f3) {
        if (iBlockState.func_177229_b(field_176584_b).booleanValue()) {
            return true;
        }
        world.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_176584_b, true), 3);
        this.func_196367_a(entityPlayer, world, blockPos, true);
        this.func_196368_e(iBlockState, world, blockPos);
        world.func_205220_G_().func_205360_a(blockPos, this, this.func_149738_a(world));
        return true;
    }

    protected void func_196367_a(@Nullable EntityPlayer entityPlayer, IWorld iWorld, BlockPos blockPos, boolean bl) {
        iWorld.func_184133_a(bl ? entityPlayer : null, blockPos, this.func_196369_b(bl), SoundCategory.BLOCKS, 0.3f, bl ? 0.6f : 0.5f);
    }

    protected abstract SoundEvent func_196369_b(boolean var1);

    @Override
    public void func_196243_a(IBlockState iBlockState, World world, BlockPos blockPos, IBlockState iBlockState2, boolean bl) {
        if (bl || iBlockState.func_177230_c() == iBlockState2.func_177230_c()) {
            return;
        }
        if (iBlockState.func_177229_b(field_176584_b).booleanValue()) {
            this.func_196368_e(iBlockState, world, blockPos);
        }
        super.func_196243_a(iBlockState, world, blockPos, iBlockState2, bl);
    }

    @Override
    public int func_180656_a(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, EnumFacing enumFacing) {
        return iBlockState.func_177229_b(field_176584_b) != false ? 15 : 0;
    }

    @Override
    public int func_176211_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, EnumFacing enumFacing) {
        if (iBlockState.func_177229_b(field_176584_b).booleanValue() && BlockButton.func_196365_i(iBlockState) == enumFacing) {
            return 15;
        }
        return 0;
    }

    @Override
    public boolean func_149744_f(IBlockState iBlockState) {
        return true;
    }

    @Override
    public void func_196267_b(IBlockState iBlockState, World world, BlockPos blockPos, Random random) {
        if (world.field_72995_K || !iBlockState.func_177229_b(field_176584_b).booleanValue()) {
            return;
        }
        if (this.field_150047_a) {
            this.func_185616_e(iBlockState, world, blockPos);
        } else {
            world.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_176584_b, false), 3);
            this.func_196368_e(iBlockState, world, blockPos);
            this.func_196367_a(null, world, blockPos, false);
        }
    }

    @Override
    public void func_196262_a(IBlockState iBlockState, World world, BlockPos blockPos, Entity entity) {
        if (world.field_72995_K || !this.field_150047_a || iBlockState.func_177229_b(field_176584_b).booleanValue()) {
            return;
        }
        this.func_185616_e(iBlockState, world, blockPos);
    }

    private void func_185616_e(IBlockState iBlockState, World world, BlockPos blockPos) {
        List<EntityArrow> list = world.func_72872_a(EntityArrow.class, iBlockState.func_196954_c(world, blockPos).func_197752_a().func_186670_a(blockPos));
        boolean \u26032 = !list.isEmpty();
        if (\u26032 != (\u2603 = iBlockState.func_177229_b(field_176584_b).booleanValue())) {
            world.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_176584_b, \u26032), 3);
            this.func_196368_e(iBlockState, world, blockPos);
            this.func_196367_a(null, world, blockPos, \u26032);
        }
        if (\u26032) {
            world.func_205220_G_().func_205360_a(new BlockPos(blockPos), this, this.func_149738_a(world));
        }
    }

    private void func_196368_e(IBlockState iBlockState, World world, BlockPos blockPos) {
        world.func_195593_d(blockPos, this);
        world.func_195593_d(blockPos.func_177972_a(BlockButton.func_196365_i(iBlockState).func_176734_d()), this);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_185512_D, field_176584_b, field_196366_M);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader iBlockReader, IBlockState iBlockState, BlockPos blockPos, EnumFacing enumFacing) {
        return BlockFaceShape.UNDEFINED;
    }
}

