/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockAttachedStem;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockBannerWall;
import net.minecraft.block.BlockBarrier;
import net.minecraft.block.BlockBeacon;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockBlueIce;
import net.minecraft.block.BlockBookshelf;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockBubbleColumn;
import net.minecraft.block.BlockButtonStone;
import net.minecraft.block.BlockButtonWood;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCake;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockCarrot;
import net.minecraft.block.BlockCarvedPumpkin;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockChorusFlower;
import net.minecraft.block.BlockChorusPlant;
import net.minecraft.block.BlockClay;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockConcretePowder;
import net.minecraft.block.BlockConduit;
import net.minecraft.block.BlockCoral;
import net.minecraft.block.BlockCoralFan;
import net.minecraft.block.BlockCoralFin;
import net.minecraft.block.BlockCoralPlant;
import net.minecraft.block.BlockCoralPlantDead;
import net.minecraft.block.BlockCoralWallFan;
import net.minecraft.block.BlockCoralWallFanDead;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDaylightDetector;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.BlockDirtSnowy;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDragonEgg;
import net.minecraft.block.BlockDropper;
import net.minecraft.block.BlockEmptyDrops;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.BlockEndGateway;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockEndRod;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockFlowingFluid;
import net.minecraft.block.BlockFrostedIce;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGlassPane;
import net.minecraft.block.BlockGlazedTerracotta;
import net.minecraft.block.BlockGlowstone;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockHay;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.BlockKelp;
import net.minecraft.block.BlockKelpTop;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockMagma;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockNote;
import net.minecraft.block.BlockObserver;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockPackedIce;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockPotato;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.BlockPressurePlateWeighted;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailDetector;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.BlockRedstone;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneLamp;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockRedstoneTorchWall;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockSeaGrass;
import net.minecraft.block.BlockSeaGrassTall;
import net.minecraft.block.BlockSeaLantern;
import net.minecraft.block.BlockSeaPickle;
import net.minecraft.block.BlockShearableDoublePlant;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockSkullPlayer;
import net.minecraft.block.BlockSkullWall;
import net.minecraft.block.BlockSkullWallPlayer;
import net.minecraft.block.BlockSkullWither;
import net.minecraft.block.BlockSkullWitherWall;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSlime;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockSnowLayer;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.BlockStructureVoid;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.BlockTallFlower;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTorchWall;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockTrappedChest;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.BlockTurtleEgg;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWall;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.BlockWetSponge;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.trees.AcaciaTree;
import net.minecraft.block.trees.BirchTree;
import net.minecraft.block.trees.DarkOakTree;
import net.minecraft.block.trees.JungleTree;
import net.minecraft.block.trees.OakTree;
import net.minecraft.block.trees.SpruceTree;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Fluids;
import net.minecraft.init.Items;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.StatList;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Block
implements IItemProvider {
    protected static final Logger field_196273_d = LogManager.getLogger();
    public static final ObjectIntIdentityMap<IBlockState> field_176229_d = new ObjectIntIdentityMap();
    private static final EnumFacing[] field_212556_a = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.DOWN, EnumFacing.UP};
    protected final int field_149784_t;
    protected final float field_149782_v;
    protected final float field_149781_w;
    protected final boolean field_149789_z;
    protected final SoundType field_149762_H;
    protected final Material field_149764_J;
    protected final MaterialColor field_181083_K;
    private final float field_149765_K;
    protected final StateContainer<Block, IBlockState> field_176227_L;
    private IBlockState field_196275_y;
    protected final boolean field_196274_w;
    private final boolean field_208621_p;
    @Nullable
    private String field_149770_b;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<RenderSideCacheKey>> field_210300_r = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2ByteLinkedOpenHashMap = new Object2ByteLinkedOpenHashMap<RenderSideCacheKey>(200){

            protected void rehash(int n) {
            }
        };
        object2ByteLinkedOpenHashMap.defaultReturnValue((byte)127);
        return object2ByteLinkedOpenHashMap;
    });

    public static int func_196246_j(@Nullable IBlockState iBlockState) {
        if (iBlockState == null) {
            return 0;
        }
        int n = field_176229_d.func_148747_b(iBlockState);
        return n == -1 ? 0 : n;
    }

    public static IBlockState func_196257_b(int n) {
        IBlockState iBlockState = field_176229_d.func_148745_a(n);
        return iBlockState == null ? Blocks.field_150350_a.func_176223_P() : iBlockState;
    }

    public static Block func_149634_a(@Nullable Item item) {
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).func_179223_d();
        }
        return Blocks.field_150350_a;
    }

    public static IBlockState func_199601_a(IBlockState iBlockState, IBlockState iBlockState22, World world, BlockPos blockPos) {
        IBlockState iBlockState22;
        VoxelShape voxelShape = VoxelShapes.func_197882_b(iBlockState.func_196952_d(world, blockPos), iBlockState22.func_196952_d(world, blockPos), IBooleanFunction.ONLY_SECOND).func_197751_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        List<Entity> \u26032 = world.func_72839_b(null, voxelShape.func_197752_a());
        for (Entity entity : \u26032) {
            double d = VoxelShapes.func_212437_a(EnumFacing.Axis.Y, entity.func_174813_aQ().func_72317_d(0.0, 1.0, 0.0), Stream.of(voxelShape), -1.0);
            entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + 1.0 + d, entity.field_70161_v);
        }
        return iBlockState22;
    }

    public static VoxelShape func_208617_a(double d, double d2, double d3, double d4, double d5, double d6) {
        return VoxelShapes.func_197873_a(d / 16.0, d2 / 16.0, d3 / 16.0, d4 / 16.0, d5 / 16.0, d6 / 16.0);
    }

    @Deprecated
    public boolean func_189872_a(IBlockState iBlockState, Entity entity) {
        return true;
    }

    @Deprecated
    public boolean func_196261_e(IBlockState iBlockState) {
        return false;
    }

    @Deprecated
    public int func_149750_m(IBlockState iBlockState) {
        return this.field_149784_t;
    }

    @Deprecated
    public Material func_149688_o(IBlockState iBlockState) {
        return this.field_149764_J;
    }

    @Deprecated
    public MaterialColor func_180659_g(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return this.field_181083_K;
    }

    @Deprecated
    public void func_196242_c(IBlockState iBlockState, IWorld iWorld, BlockPos blockPos, int n) {
        try (BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (EnumFacing enumFacing : field_212556_a) {
                pooledMutableBlockPos.func_189533_g(blockPos).func_189536_c(enumFacing);
                IBlockState iBlockState2 = iWorld.func_180495_p(pooledMutableBlockPos);
                \u2603 = iBlockState2.func_196956_a(enumFacing.func_176734_d(), iBlockState, iWorld, pooledMutableBlockPos, blockPos);
                Block.func_196263_a(iBlockState2, \u2603, iWorld, pooledMutableBlockPos, n);
            }
        }
    }

    public boolean func_203417_a(Tag<Block> tag) {
        return tag.func_199685_a_(this);
    }

    public static IBlockState func_199770_b(IBlockState iBlockState, IWorld iWorld, BlockPos blockPos) {
        IBlockState iBlockState2 = iBlockState;
        BlockPos.MutableBlockPos \u26032 = new BlockPos.MutableBlockPos();
        for (EnumFacing enumFacing : field_212556_a) {
            \u26032.func_189533_g(blockPos).func_189536_c(enumFacing);
            iBlockState2 = iBlockState2.func_196956_a(enumFacing, iWorld.func_180495_p(\u26032), iWorld, blockPos, \u26032);
        }
        return iBlockState2;
    }

    public static void func_196263_a(IBlockState iBlockState, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, int n) {
        if (iBlockState2 != iBlockState) {
            if (iBlockState2.func_196958_f()) {
                if (!iWorld.func_201670_d()) {
                    iWorld.func_175655_b(blockPos, (n & 0x20) == 0);
                }
            } else {
                iWorld.func_180501_a(blockPos, iBlockState2, n & 0xFFFFFFDF);
            }
        }
    }

    @Deprecated
    public void func_196248_b(IBlockState iBlockState, IWorld iWorld, BlockPos blockPos, int n) {
    }

    @Deprecated
    public IBlockState func_196271_a(IBlockState iBlockState, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        return iBlockState;
    }

    @Deprecated
    public IBlockState func_185499_a(IBlockState iBlockState, Rotation rotation) {
        return iBlockState;
    }

    @Deprecated
    public IBlockState func_185471_a(IBlockState iBlockState, Mirror mirror) {
        return iBlockState;
    }

    public Block(Properties properties) {
        StateContainer.Builder<Block, IBlockState> builder = new StateContainer.Builder<Block, IBlockState>(this);
        this.func_206840_a(builder);
        this.field_176227_L = builder.func_206893_a(BlockState::new);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.field_149764_J = properties.field_200953_a;
        this.field_181083_K = properties.field_200954_b;
        this.field_196274_w = properties.field_200955_c;
        this.field_149762_H = properties.field_200956_d;
        this.field_149784_t = properties.field_200957_e;
        this.field_149781_w = properties.field_200958_f;
        this.field_149782_v = properties.field_200959_g;
        this.field_149789_z = properties.field_200960_h;
        this.field_149765_K = properties.field_200961_i;
        this.field_208621_p = properties.field_208772_j;
    }

    protected static boolean func_193384_b(Block block) {
        return block instanceof BlockShulkerBox || block instanceof BlockLeaves || block.func_203417_a(BlockTags.field_212185_E) || block instanceof BlockStainedGlass || block == Blocks.field_150461_bJ || block == Blocks.field_150383_bp || block == Blocks.field_150359_w || block == Blocks.field_150426_aN || block == Blocks.field_150432_aD || block == Blocks.field_180398_cJ || block == Blocks.field_205165_jY;
    }

    public static boolean func_193382_c(Block block) {
        return Block.func_193384_b(block) || block == Blocks.field_150331_J || block == Blocks.field_150320_F || block == Blocks.field_150332_K;
    }

    @Deprecated
    public boolean func_149637_q(IBlockState iBlockState) {
        return iBlockState.func_185904_a().func_76230_c() && iBlockState.func_185917_h();
    }

    @Deprecated
    public boolean func_149721_r(IBlockState iBlockState) {
        return iBlockState.func_185904_a().func_76218_k() && iBlockState.func_185917_h() && !iBlockState.func_185897_m();
    }

    @Deprecated
    public boolean func_176214_u(IBlockState iBlockState) {
        return this.field_149764_J.func_76230_c() && iBlockState.func_185917_h();
    }

    @Deprecated
    public boolean func_149686_d(IBlockState iBlockState) {
        return true;
    }

    @Deprecated
    public boolean func_185481_k(IBlockState iBlockState) {
        return iBlockState.func_185904_a().func_76218_k() && iBlockState.func_185917_h();
    }

    @Deprecated
    public boolean func_196266_a(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        switch (pathType) {
            case LAND: {
                return !Block.func_208062_a(this.func_196268_f(iBlockState, iBlockReader, blockPos));
            }
            case WATER: {
                return iBlockReader.func_204610_c(blockPos).func_206884_a(FluidTags.field_206959_a);
            }
            case AIR: {
                return !Block.func_208062_a(this.func_196268_f(iBlockState, iBlockReader, blockPos));
            }
        }
        return false;
    }

    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState iBlockState) {
        return EnumBlockRenderType.MODEL;
    }

    @Deprecated
    public boolean func_196253_a(IBlockState iBlockState, BlockItemUseContext blockItemUseContext) {
        return this.field_149764_J.func_76222_j() && blockItemUseContext.func_195996_i().func_77973_b() != this.func_199767_j();
    }

    @Deprecated
    public float func_176195_g(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return this.field_149782_v;
    }

    public boolean func_149653_t(IBlockState iBlockState) {
        return this.field_149789_z;
    }

    public boolean func_149716_u() {
        return this instanceof ITileEntityProvider;
    }

    @Deprecated
    public boolean func_201783_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return false;
    }

    @Deprecated
    public boolean func_200124_e(IBlockState iBlockState) {
        return this.field_196274_w && iBlockState.func_177230_c().func_180664_k() == BlockRenderLayer.SOLID;
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockReader iBlockReader, IBlockState iBlockState, BlockPos blockPos, EnumFacing enumFacing) {
        return BlockFaceShape.SOLID;
    }

    @Deprecated
    public VoxelShape func_196244_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return VoxelShapes.func_197868_b();
    }

    @Deprecated
    public VoxelShape func_196268_f(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return this.field_196274_w ? iBlockState.func_196954_c(iBlockReader, blockPos) : VoxelShapes.func_197880_a();
    }

    @Deprecated
    public VoxelShape func_196247_c(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return iBlockState.func_196954_c(iBlockReader, blockPos);
    }

    @Deprecated
    public VoxelShape func_199600_g(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return VoxelShapes.func_197880_a();
    }

    public static boolean func_208061_a(VoxelShape voxelShape, EnumFacing enumFacing) {
        VoxelShape voxelShape2 = voxelShape.func_212434_a(enumFacing);
        return Block.func_208062_a(voxelShape2);
    }

    public static boolean func_208062_a(VoxelShape voxelShape) {
        return !VoxelShapes.func_197879_c(VoxelShapes.func_197868_b(), voxelShape, IBooleanFunction.ONLY_FIRST);
    }

    @Deprecated
    public final boolean func_200012_i(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        boolean bl = iBlockState.func_200132_m();
        VoxelShape \u26032 = bl ? iBlockState.func_196951_e(iBlockReader, blockPos) : VoxelShapes.func_197880_a();
        return Block.func_208062_a(\u26032);
    }

    public boolean func_200123_i(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return !Block.func_208062_a(iBlockState.func_196954_c(iBlockReader, blockPos)) && iBlockState.func_204520_s().func_206888_e();
    }

    @Deprecated
    public int func_200011_d(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        if (iBlockState.func_200015_d(iBlockReader, blockPos)) {
            return iBlockReader.func_201572_C();
        }
        return iBlockState.func_200131_a(iBlockReader, blockPos) ? 0 : 1;
    }

    @Deprecated
    public final boolean func_200125_k(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return !iBlockState.func_200015_d(iBlockReader, blockPos) && iBlockState.func_200016_a(iBlockReader, blockPos) == iBlockReader.func_201572_C();
    }

    public boolean func_200293_a(IBlockState iBlockState) {
        return this.func_149703_v();
    }

    public boolean func_149703_v() {
        return true;
    }

    @Deprecated
    public void func_196265_a(IBlockState iBlockState, World world, BlockPos blockPos, Random random) {
        this.func_196267_b(iBlockState, world, blockPos, random);
    }

    @Deprecated
    public void func_196267_b(IBlockState iBlockState, World world, BlockPos blockPos, Random random) {
    }

    public void func_176206_d(IWorld iWorld, BlockPos blockPos, IBlockState iBlockState) {
    }

    @Deprecated
    public void func_189540_a(IBlockState iBlockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2) {
    }

    public int func_149738_a(IWorldReaderBase iWorldReaderBase) {
        return 10;
    }

    @Deprecated
    public void func_196259_b(IBlockState iBlockState, World world, BlockPos blockPos, IBlockState iBlockState2) {
    }

    @Deprecated
    public void func_196243_a(IBlockState iBlockState, World world, BlockPos blockPos, IBlockState iBlockState2, boolean bl) {
    }

    public int func_196264_a(IBlockState iBlockState, Random random) {
        return 1;
    }

    public IItemProvider func_199769_a(IBlockState iBlockState, World world, BlockPos blockPos, int n) {
        return this;
    }

    @Deprecated
    public float func_180647_a(IBlockState iBlockState, EntityPlayer entityPlayer, IBlockReader iBlockReader, BlockPos blockPos) {
        float f = iBlockState.func_185887_b(iBlockReader, blockPos);
        if (f == -1.0f) {
            return 0.0f;
        }
        int \u26032 = entityPlayer.func_184823_b(iBlockState) ? 30 : 100;
        return entityPlayer.func_184813_a(iBlockState) / f / (float)\u26032;
    }

    @Deprecated
    public void func_196255_a(IBlockState iBlockState, World world, BlockPos blockPos, float f, int n) {
        if (world.field_72995_K) {
            return;
        }
        \u2603 = this.func_196251_a(iBlockState, n, world, blockPos, world.field_73012_v);
        for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
            if (f < 1.0f && world.field_73012_v.nextFloat() > f || (\u2603 = this.func_199769_a(iBlockState, world, blockPos, n).func_199767_j()) == Items.field_190931_a) continue;
            Block.func_180635_a(world, blockPos, new ItemStack(\u2603));
        }
    }

    public static void func_180635_a(World world, BlockPos blockPos, ItemStack itemStack) {
        if (world.field_72995_K || itemStack.func_190926_b() || !world.func_82736_K().func_82766_b("doTileDrops")) {
            return;
        }
        float f = 0.5f;
        double \u26032 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double \u26033 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double \u26034 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        EntityItem \u26035 = new EntityItem(world, (double)blockPos.func_177958_n() + \u26032, (double)blockPos.func_177956_o() + \u26033, (double)blockPos.func_177952_p() + \u26034, itemStack);
        \u26035.func_174869_p();
        world.func_72838_d(\u26035);
    }

    protected void func_180637_b(World world, BlockPos blockPos, int n) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            while (n > 0) {
                \u2603 = EntityXPOrb.func_70527_a(n);
                n -= \u2603;
                world.func_72838_d(new EntityXPOrb(world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, \u2603));
            }
        }
    }

    public float func_149638_a() {
        return this.field_149781_w;
    }

    @Nullable
    public static RayTraceResult func_180636_a(IBlockState iBlockState, World world, BlockPos blockPos, Vec3d vec3d, Vec3d vec3d2) {
        RayTraceResult rayTraceResult = iBlockState.func_196954_c(world, blockPos).func_212433_a(vec3d, vec3d2, blockPos);
        if (rayTraceResult != null && (\u2603 = iBlockState.func_199611_f(world, blockPos).func_212433_a(vec3d, vec3d2, blockPos)) != null && \u2603.field_72307_f.func_178788_d(vec3d).func_189985_c() < rayTraceResult.field_72307_f.func_178788_d(vec3d).func_189985_c()) {
            rayTraceResult.field_178784_b = \u2603.field_178784_b;
        }
        return rayTraceResult;
    }

    public void func_180652_a(World world, BlockPos blockPos, Explosion explosion) {
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    @Deprecated
    public boolean func_196260_a(IBlockState iBlockState, IWorldReaderBase iWorldReaderBase, BlockPos blockPos) {
        return true;
    }

    @Deprecated
    public boolean func_196250_a(IBlockState iBlockState, World world, BlockPos blockPos, EntityPlayer entityPlayer, EnumHand enumHand, EnumFacing enumFacing, float f, float f2, float f3) {
        return false;
    }

    public void func_176199_a(World world, BlockPos blockPos, Entity entity) {
    }

    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        return this.func_176223_P();
    }

    @Deprecated
    public void func_196270_a(IBlockState iBlockState, World world, BlockPos blockPos, EntityPlayer entityPlayer) {
    }

    @Deprecated
    public int func_180656_a(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, EnumFacing enumFacing) {
        return 0;
    }

    @Deprecated
    public boolean func_149744_f(IBlockState iBlockState) {
        return false;
    }

    @Deprecated
    public void func_196262_a(IBlockState iBlockState, World world, BlockPos blockPos, Entity entity) {
    }

    @Deprecated
    public int func_176211_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, EnumFacing enumFacing) {
        return 0;
    }

    public void func_180657_a(World world, EntityPlayer entityPlayer, BlockPos blockPos, IBlockState iBlockState, @Nullable TileEntity tileEntity, ItemStack itemStack) {
        entityPlayer.func_71029_a(StatList.field_188065_ae.func_199076_b(this));
        entityPlayer.func_71020_j(0.005f);
        if (this.func_149700_E() && EnchantmentHelper.func_77506_a(Enchantments.field_185306_r, itemStack) > 0) {
            \u2603 = this.func_180643_i(iBlockState);
            Block.func_180635_a(world, blockPos, \u2603);
        } else {
            int n = EnchantmentHelper.func_77506_a(Enchantments.field_185308_t, itemStack);
            iBlockState.func_196949_c(world, blockPos, n);
        }
    }

    protected boolean func_149700_E() {
        return this.func_176223_P().func_185917_h() && !this.func_149716_u();
    }

    protected ItemStack func_180643_i(IBlockState iBlockState) {
        return new ItemStack(this);
    }

    public int func_196251_a(IBlockState iBlockState, int n, World world, BlockPos blockPos, Random random) {
        return this.func_196264_a(iBlockState, random);
    }

    public void func_180633_a(World world, BlockPos blockPos, IBlockState iBlockState, @Nullable EntityLivingBase entityLivingBase, ItemStack itemStack) {
    }

    public boolean func_181623_g() {
        return !this.field_149764_J.func_76220_a() && !this.field_149764_J.func_76224_d();
    }

    public String func_149739_a() {
        if (this.field_149770_b == null) {
            this.field_149770_b = Util.func_200697_a("block", IRegistry.field_212618_g.func_177774_c(this));
        }
        return this.field_149770_b;
    }

    @Deprecated
    public boolean func_189539_a(IBlockState iBlockState, World world, BlockPos blockPos, int n, int n2) {
        return false;
    }

    @Deprecated
    public EnumPushReaction func_149656_h(IBlockState iBlockState) {
        return this.field_149764_J.func_186274_m();
    }

    public void func_180658_a(World world, BlockPos blockPos, Entity entity, float f) {
        entity.func_180430_e(f, 1.0f);
    }

    public void func_176216_a(IBlockReader iBlockReader, Entity entity) {
        entity.field_70181_x = 0.0;
    }

    public ItemStack func_185473_a(IBlockReader iBlockReader, BlockPos blockPos, IBlockState iBlockState) {
        return new ItemStack(this);
    }

    public void func_149666_a(ItemGroup itemGroup, NonNullList<ItemStack> nonNullList) {
        nonNullList.add(new ItemStack(this));
    }

    @Deprecated
    public IFluidState func_204507_t(IBlockState iBlockState) {
        return Fluids.field_204541_a.func_207188_f();
    }

    public float func_208618_m() {
        return this.field_149765_K;
    }

    public void func_176208_a(World world, BlockPos blockPos, IBlockState iBlockState, EntityPlayer entityPlayer) {
        world.func_180498_a(entityPlayer, 2001, blockPos, Block.func_196246_j(iBlockState));
    }

    public void func_176224_k(World world, BlockPos blockPos) {
    }

    public boolean func_149659_a(Explosion explosion) {
        return true;
    }

    @Deprecated
    public boolean func_149740_M(IBlockState iBlockState) {
        return false;
    }

    @Deprecated
    public int func_180641_l(IBlockState iBlockState, World world, BlockPos blockPos) {
        return 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
    }

    public StateContainer<Block, IBlockState> func_176194_O() {
        return this.field_176227_L;
    }

    protected final void func_180632_j(IBlockState iBlockState) {
        this.field_196275_y = iBlockState;
    }

    public final IBlockState func_176223_P() {
        return this.field_196275_y;
    }

    public EnumOffsetType func_176218_Q() {
        return EnumOffsetType.NONE;
    }

    @Deprecated
    public Vec3d func_190949_e(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        EnumOffsetType enumOffsetType = this.func_176218_Q();
        if (enumOffsetType == EnumOffsetType.NONE) {
            return Vec3d.field_186680_a;
        }
        long \u26032 = MathHelper.func_180187_c(blockPos.func_177958_n(), 0, blockPos.func_177952_p());
        return new Vec3d(((double)((float)(\u26032 & 0xFL) / 15.0f) - 0.5) * 0.5, enumOffsetType == EnumOffsetType.XYZ ? ((double)((float)(\u26032 >> 4 & 0xFL) / 15.0f) - 1.0) * 0.2 : 0.0, ((double)((float)(\u26032 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5);
    }

    public SoundType func_185467_w() {
        return this.field_149762_H;
    }

    @Override
    public Item func_199767_j() {
        return Item.func_150898_a(this);
    }

    public boolean func_208619_r() {
        return this.field_208621_p;
    }

    public String toString() {
        return "Block{" + IRegistry.field_212618_g.func_177774_c(this) + "}";
    }

    public static boolean func_196252_e(Block block) {
        return block == Blocks.field_150348_b || block == Blocks.field_196650_c || block == Blocks.field_196654_e || block == Blocks.field_196656_g;
    }

    public static boolean func_196245_f(Block block) {
        return block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l;
    }

    public static void func_149671_p() {
        BlockAir blockAir = new BlockAir(Properties.func_200945_a(Material.field_151579_a).func_200942_a());
        Block.func_196249_a(IRegistry.field_212618_g.func_212609_b(), blockAir);
        BlockStone \u26032 = new BlockStone(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151665_m).func_200948_a(1.5f, 6.0f));
        Block.func_196254_a("stone", \u26032);
        Block.func_196254_a("granite", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151664_l).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("polished_granite", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151664_l).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("diorite", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151677_p).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("polished_diorite", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151677_p).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("andesite", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151665_m).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("polished_andesite", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151665_m).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("grass_block", new BlockGrass(Properties.func_200945_a(Material.field_151577_b).func_200944_c().func_200943_b(0.6f).func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("dirt", new Block(Properties.func_200949_a(Material.field_151578_c, MaterialColor.field_151664_l).func_200943_b(0.5f).func_200947_a(SoundType.field_185849_b)));
        Block.func_196254_a("coarse_dirt", new Block(Properties.func_200949_a(Material.field_151578_c, MaterialColor.field_151664_l).func_200943_b(0.5f).func_200947_a(SoundType.field_185849_b)));
        Block.func_196254_a("podzol", new BlockDirtSnowy(Properties.func_200949_a(Material.field_151578_c, MaterialColor.field_151654_J).func_200943_b(0.5f).func_200947_a(SoundType.field_185849_b)));
        Block \u26033 = new Block(Properties.func_200945_a(Material.field_151576_e).func_200948_a(2.0f, 6.0f));
        Block.func_196254_a("cobblestone", \u26033);
        Block \u26034 = new Block(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151663_o).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
        Block \u26035 = new Block(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151654_J).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
        Block \u26036 = new Block(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151658_d).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
        Block \u26037 = new Block(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151664_l).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
        Block \u26038 = new Block(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151676_q).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
        Block \u26039 = new Block(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151650_B).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
        Block.func_196254_a("oak_planks", \u26034);
        Block.func_196254_a("spruce_planks", \u26035);
        Block.func_196254_a("birch_planks", \u26036);
        Block.func_196254_a("jungle_planks", \u26037);
        Block.func_196254_a("acacia_planks", \u26038);
        Block.func_196254_a("dark_oak_planks", \u26039);
        BlockSapling \u260310 = new BlockSapling(new OakTree(), Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockSapling \u260311 = new BlockSapling(new SpruceTree(), Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockSapling \u260312 = new BlockSapling(new BirchTree(), Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockSapling \u260313 = new BlockSapling(new JungleTree(), Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockSapling \u260314 = new BlockSapling(new AcaciaTree(), Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockSapling \u260315 = new BlockSapling(new DarkOakTree(), Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c));
        Block.func_196254_a("oak_sapling", \u260310);
        Block.func_196254_a("spruce_sapling", \u260311);
        Block.func_196254_a("birch_sapling", \u260312);
        Block.func_196254_a("jungle_sapling", \u260313);
        Block.func_196254_a("acacia_sapling", \u260314);
        Block.func_196254_a("dark_oak_sapling", \u260315);
        Block.func_196254_a("bedrock", new BlockEmptyDrops(Properties.func_200945_a(Material.field_151576_e).func_200948_a(-1.0f, 3600000.0f)));
        Block.func_196254_a("water", new BlockFlowingFluid(Fluids.field_204546_a, Properties.func_200945_a(Material.field_151586_h).func_200942_a().func_200943_b(100.0f)));
        Block.func_196254_a("lava", new BlockFlowingFluid(Fluids.field_204547_b, Properties.func_200945_a(Material.field_151587_i).func_200942_a().func_200944_c().func_200943_b(100.0f).func_200951_a(15)));
        Block.func_196254_a("sand", new BlockSand(14406560, Properties.func_200949_a(Material.field_151595_p, MaterialColor.field_151658_d).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("red_sand", new BlockSand(11098145, Properties.func_200949_a(Material.field_151595_p, MaterialColor.field_151676_q).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("gravel", new BlockGravel(Properties.func_200949_a(Material.field_151595_p, MaterialColor.field_151665_m).func_200943_b(0.6f).func_200947_a(SoundType.field_185849_b)));
        Block.func_196254_a("gold_ore", new BlockOre(Properties.func_200945_a(Material.field_151576_e).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("iron_ore", new BlockOre(Properties.func_200945_a(Material.field_151576_e).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("coal_ore", new BlockOre(Properties.func_200945_a(Material.field_151576_e).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("oak_log", new BlockLog(MaterialColor.field_151663_o, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151654_J).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("spruce_log", new BlockLog(MaterialColor.field_151654_J, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151650_B).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("birch_log", new BlockLog(MaterialColor.field_151658_d, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151677_p).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jungle_log", new BlockLog(MaterialColor.field_151664_l, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151654_J).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("acacia_log", new BlockLog(MaterialColor.field_151676_q, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151665_m).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("dark_oak_log", new BlockLog(MaterialColor.field_151650_B, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151650_B).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_spruce_log", new BlockLog(MaterialColor.field_151654_J, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151654_J).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_birch_log", new BlockLog(MaterialColor.field_151658_d, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151658_d).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_jungle_log", new BlockLog(MaterialColor.field_151664_l, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151664_l).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_acacia_log", new BlockLog(MaterialColor.field_151676_q, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151676_q).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_dark_oak_log", new BlockLog(MaterialColor.field_151650_B, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151650_B).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_oak_log", new BlockLog(MaterialColor.field_151663_o, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151663_o).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("oak_wood", new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151663_o).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("spruce_wood", new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151654_J).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("birch_wood", new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151658_d).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jungle_wood", new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151664_l).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("acacia_wood", new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151676_q).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("dark_oak_wood", new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151650_B).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_oak_wood", new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151663_o).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_spruce_wood", new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151654_J).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_birch_wood", new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151658_d).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_jungle_wood", new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151664_l).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_acacia_wood", new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151676_q).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_dark_oak_wood", new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151650_B).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("oak_leaves", new BlockLeaves(Properties.func_200945_a(Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("spruce_leaves", new BlockLeaves(Properties.func_200945_a(Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("birch_leaves", new BlockLeaves(Properties.func_200945_a(Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("jungle_leaves", new BlockLeaves(Properties.func_200945_a(Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("acacia_leaves", new BlockLeaves(Properties.func_200945_a(Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("dark_oak_leaves", new BlockLeaves(Properties.func_200945_a(Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("sponge", new BlockSponge(Properties.func_200945_a(Material.field_151583_m).func_200943_b(0.6f).func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("wet_sponge", new BlockWetSponge(Properties.func_200945_a(Material.field_151583_m).func_200943_b(0.6f).func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("glass", new BlockGlass(Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("lapis_ore", new BlockOre(Properties.func_200945_a(Material.field_151576_e).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("lapis_block", new Block(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151652_H).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("dispenser", new BlockDispenser(Properties.func_200945_a(Material.field_151576_e).func_200943_b(3.5f)));
        Block \u260316 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151658_d).func_200943_b(0.8f));
        Block.func_196254_a("sandstone", \u260316);
        Block.func_196254_a("chiseled_sandstone", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151658_d).func_200943_b(0.8f)));
        Block.func_196254_a("cut_sandstone", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151658_d).func_200943_b(0.8f)));
        Block.func_196254_a("note_block", new BlockNote(Properties.func_200945_a(Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200943_b(0.8f)));
        Block.func_196254_a("white_bed", new BlockBed(EnumDyeColor.WHITE, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f)));
        Block.func_196254_a("orange_bed", new BlockBed(EnumDyeColor.ORANGE, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f)));
        Block.func_196254_a("magenta_bed", new BlockBed(EnumDyeColor.MAGENTA, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f)));
        Block.func_196254_a("light_blue_bed", new BlockBed(EnumDyeColor.LIGHT_BLUE, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f)));
        Block.func_196254_a("yellow_bed", new BlockBed(EnumDyeColor.YELLOW, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f)));
        Block.func_196254_a("lime_bed", new BlockBed(EnumDyeColor.LIME, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f)));
        Block.func_196254_a("pink_bed", new BlockBed(EnumDyeColor.PINK, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f)));
        Block.func_196254_a("gray_bed", new BlockBed(EnumDyeColor.GRAY, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f)));
        Block.func_196254_a("light_gray_bed", new BlockBed(EnumDyeColor.LIGHT_GRAY, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f)));
        Block.func_196254_a("cyan_bed", new BlockBed(EnumDyeColor.CYAN, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f)));
        Block.func_196254_a("purple_bed", new BlockBed(EnumDyeColor.PURPLE, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f)));
        Block.func_196254_a("blue_bed", new BlockBed(EnumDyeColor.BLUE, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f)));
        Block.func_196254_a("brown_bed", new BlockBed(EnumDyeColor.BROWN, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f)));
        Block.func_196254_a("green_bed", new BlockBed(EnumDyeColor.GREEN, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f)));
        Block.func_196254_a("red_bed", new BlockBed(EnumDyeColor.RED, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f)));
        Block.func_196254_a("black_bed", new BlockBed(EnumDyeColor.BLACK, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f)));
        Block.func_196254_a("powered_rail", new BlockRailPowered(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.7f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("detector_rail", new BlockRailDetector(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.7f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("sticky_piston", new BlockPistonBase(true, Properties.func_200945_a(Material.field_76233_E).func_200943_b(0.5f)));
        Block.func_196254_a("cobweb", new BlockWeb(Properties.func_200945_a(Material.field_151569_G).func_200942_a().func_200943_b(4.0f)));
        BlockTallGrass \u260317 = new BlockTallGrass(Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockTallGrass \u260318 = new BlockTallGrass(Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockDeadBush \u260319 = new BlockDeadBush(Properties.func_200949_a(Material.field_151582_l, MaterialColor.field_151663_o).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        Block.func_196254_a("grass", \u260317);
        Block.func_196254_a("fern", \u260318);
        Block.func_196254_a("dead_bush", \u260319);
        BlockSeaGrass \u260320 = new BlockSeaGrass(Properties.func_200945_a(Material.field_204868_h).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m));
        Block.func_196254_a("seagrass", \u260320);
        Block.func_196254_a("tall_seagrass", new BlockSeaGrassTall(\u260320, Properties.func_200945_a(Material.field_204868_h).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("piston", new BlockPistonBase(false, Properties.func_200945_a(Material.field_76233_E).func_200943_b(0.5f)));
        Block.func_196254_a("piston_head", new BlockPistonExtension(Properties.func_200945_a(Material.field_76233_E).func_200943_b(0.5f)));
        Block.func_196254_a("white_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151666_j).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("orange_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151676_q).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("magenta_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151675_r).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("light_blue_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151674_s).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("yellow_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151673_t).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("lime_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151672_u).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("pink_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151671_v).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("gray_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151670_w).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("light_gray_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_197656_x).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("cyan_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151679_y).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("purple_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151678_z).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("blue_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151649_A).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("brown_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151650_B).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("green_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151651_C).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("red_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151645_D).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("black_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151646_E).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("moving_piston", new BlockPistonMoving(Properties.func_200945_a(Material.field_76233_E).func_200943_b(-1.0f).func_208770_d()));
        BlockFlower \u260321 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower \u260322 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower \u260323 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower \u260324 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower \u260325 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower \u260326 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower \u260327 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower \u260328 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower \u260329 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower \u260330 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        Block.func_196254_a("dandelion", \u260321);
        Block.func_196254_a("poppy", \u260322);
        Block.func_196254_a("blue_orchid", \u260323);
        Block.func_196254_a("allium", \u260324);
        Block.func_196254_a("azure_bluet", \u260325);
        Block.func_196254_a("red_tulip", \u260326);
        Block.func_196254_a("orange_tulip", \u260327);
        Block.func_196254_a("white_tulip", \u260328);
        Block.func_196254_a("pink_tulip", \u260329);
        Block.func_196254_a("oxeye_daisy", \u260330);
        BlockMushroom \u260331 = new BlockMushroom(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c).func_200951_a(1));
        BlockMushroom \u260332 = new BlockMushroom(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c));
        Block.func_196254_a("brown_mushroom", \u260331);
        Block.func_196254_a("red_mushroom", \u260332);
        Block.func_196254_a("gold_block", new Block(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151647_F).func_200948_a(3.0f, 6.0f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("iron_block", new Block(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151668_h).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e)));
        Block \u260333 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151645_D).func_200948_a(2.0f, 6.0f));
        Block.func_196254_a("bricks", \u260333);
        Block.func_196254_a("tnt", new BlockTNT(Properties.func_200945_a(Material.field_151590_u).func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("bookshelf", new BlockBookshelf(Properties.func_200945_a(Material.field_151575_d).func_200943_b(1.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("mossy_cobblestone", new Block(Properties.func_200945_a(Material.field_151576_e).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("obsidian", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151646_E).func_200948_a(50.0f, 1200.0f)));
        Block.func_196254_a("torch", new BlockTorch(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200946_b().func_200951_a(14).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("wall_torch", new BlockTorchWall(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200946_b().func_200951_a(14).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("fire", new BlockFire(Properties.func_200949_a(Material.field_151581_o, MaterialColor.field_151656_f).func_200942_a().func_200944_c().func_200946_b().func_200951_a(15).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("spawner", new BlockMobSpawner(Properties.func_200945_a(Material.field_151576_e).func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("oak_stairs", new BlockStairs(\u26034.func_176223_P(), Properties.func_200950_a(\u26034)));
        Block.func_196254_a("chest", new BlockChest(Properties.func_200945_a(Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("redstone_wire", new BlockRedstoneWire(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200946_b()));
        Block.func_196254_a("diamond_ore", new BlockOre(Properties.func_200945_a(Material.field_151576_e).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("diamond_block", new Block(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151648_G).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("crafting_table", new BlockWorkbench(Properties.func_200945_a(Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("wheat", new BlockCrops(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        BlockFarmland \u260334 = new BlockFarmland(Properties.func_200945_a(Material.field_151578_c).func_200944_c().func_200943_b(0.6f).func_200947_a(SoundType.field_185849_b));
        Block.func_196254_a("farmland", \u260334);
        Block.func_196254_a("furnace", new BlockFurnace(Properties.func_200945_a(Material.field_151576_e).func_200943_b(3.5f).func_200951_a(13)));
        Block.func_196254_a("sign", new BlockStandingSign(Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("oak_door", new BlockDoor(Properties.func_200949_a(Material.field_151575_d, \u26034.field_181083_K).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("ladder", new BlockLadder(Properties.func_200945_a(Material.field_151594_q).func_200943_b(0.4f).func_200947_a(SoundType.field_185857_j)));
        Block.func_196254_a("rail", new BlockRail(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.7f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("cobblestone_stairs", new BlockStairs(\u26033.func_176223_P(), Properties.func_200950_a(\u26033)));
        Block.func_196254_a("wall_sign", new BlockWallSign(Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("lever", new BlockLever(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stone_pressure_plate", new BlockPressurePlate(BlockPressurePlate.Sensitivity.MOBS, Properties.func_200945_a(Material.field_151576_e).func_200942_a().func_200943_b(0.5f)));
        Block.func_196254_a("iron_door", new BlockDoor(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151668_h).func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("oak_pressure_plate", new BlockPressurePlate(BlockPressurePlate.Sensitivity.EVERYTHING, Properties.func_200949_a(Material.field_151575_d, \u26034.field_181083_K).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("spruce_pressure_plate", new BlockPressurePlate(BlockPressurePlate.Sensitivity.EVERYTHING, Properties.func_200949_a(Material.field_151575_d, \u26035.field_181083_K).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("birch_pressure_plate", new BlockPressurePlate(BlockPressurePlate.Sensitivity.EVERYTHING, Properties.func_200949_a(Material.field_151575_d, \u26036.field_181083_K).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jungle_pressure_plate", new BlockPressurePlate(BlockPressurePlate.Sensitivity.EVERYTHING, Properties.func_200949_a(Material.field_151575_d, \u26037.field_181083_K).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("acacia_pressure_plate", new BlockPressurePlate(BlockPressurePlate.Sensitivity.EVERYTHING, Properties.func_200949_a(Material.field_151575_d, \u26038.field_181083_K).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("dark_oak_pressure_plate", new BlockPressurePlate(BlockPressurePlate.Sensitivity.EVERYTHING, Properties.func_200949_a(Material.field_151575_d, \u26039.field_181083_K).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("redstone_ore", new BlockRedstoneOre(Properties.func_200945_a(Material.field_151576_e).func_200944_c().func_200951_a(9).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("redstone_torch", new BlockRedstoneTorch(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200946_b().func_200951_a(7).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("redstone_wall_torch", new BlockRedstoneTorchWall(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200946_b().func_200951_a(7).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stone_button", new BlockButtonStone(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.5f)));
        Block.func_196254_a("snow", new BlockSnowLayer(Properties.func_200945_a(Material.field_151597_y).func_200944_c().func_200943_b(0.1f).func_200947_a(SoundType.field_185856_i)));
        Block.func_196254_a("ice", new BlockIce(Properties.func_200945_a(Material.field_151588_w).func_200941_a(0.98f).func_200944_c().func_200943_b(0.5f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("snow_block", new BlockSnow(Properties.func_200945_a(Material.field_151596_z).func_200944_c().func_200943_b(0.2f).func_200947_a(SoundType.field_185856_i)));
        BlockCactus \u260335 = new BlockCactus(Properties.func_200945_a(Material.field_151570_A).func_200944_c().func_200943_b(0.4f).func_200947_a(SoundType.field_185854_g));
        Block.func_196254_a("cactus", \u260335);
        Block.func_196254_a("clay", new BlockClay(Properties.func_200945_a(Material.field_151571_B).func_200943_b(0.6f).func_200947_a(SoundType.field_185849_b)));
        Block.func_196254_a("sugar_cane", new BlockReed(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("jukebox", new BlockJukebox(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151664_l).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("oak_fence", new BlockFence(Properties.func_200949_a(Material.field_151575_d, \u26034.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        BlockPumpkin \u260336 = new BlockPumpkin(Properties.func_200949_a(Material.field_151572_C, MaterialColor.field_151676_q).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a));
        Block.func_196254_a("pumpkin", \u260336);
        Block.func_196254_a("netherrack", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151655_K).func_200943_b(0.4f)));
        Block.func_196254_a("soul_sand", new BlockSoulSand(Properties.func_200949_a(Material.field_151595_p, MaterialColor.field_151650_B).func_200944_c().func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("glowstone", new BlockGlowstone(Properties.func_200949_a(Material.field_151592_s, MaterialColor.field_151658_d).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_200951_a(15)));
        Block.func_196254_a("nether_portal", new BlockPortal(Properties.func_200945_a(Material.field_151567_E).func_200942_a().func_200944_c().func_200943_b(-1.0f).func_200947_a(SoundType.field_185853_f).func_200951_a(11)));
        Block.func_196254_a("carved_pumpkin", new BlockCarvedPumpkin(Properties.func_200949_a(Material.field_151572_C, MaterialColor.field_151676_q).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jack_o_lantern", new BlockCarvedPumpkin(Properties.func_200949_a(Material.field_151572_C, MaterialColor.field_151676_q).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a).func_200951_a(15)));
        Block.func_196254_a("cake", new BlockCake(Properties.func_200945_a(Material.field_151568_F).func_200943_b(0.5f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("repeater", new BlockRedstoneRepeater(Properties.func_200945_a(Material.field_151594_q).func_200946_b().func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("white_stained_glass", new BlockStainedGlass(EnumDyeColor.WHITE, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.WHITE).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("orange_stained_glass", new BlockStainedGlass(EnumDyeColor.ORANGE, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.ORANGE).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("magenta_stained_glass", new BlockStainedGlass(EnumDyeColor.MAGENTA, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.MAGENTA).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("light_blue_stained_glass", new BlockStainedGlass(EnumDyeColor.LIGHT_BLUE, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.LIGHT_BLUE).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("yellow_stained_glass", new BlockStainedGlass(EnumDyeColor.YELLOW, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.YELLOW).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("lime_stained_glass", new BlockStainedGlass(EnumDyeColor.LIME, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.LIME).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("pink_stained_glass", new BlockStainedGlass(EnumDyeColor.PINK, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.PINK).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("gray_stained_glass", new BlockStainedGlass(EnumDyeColor.GRAY, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.GRAY).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("light_gray_stained_glass", new BlockStainedGlass(EnumDyeColor.LIGHT_GRAY, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.LIGHT_GRAY).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("cyan_stained_glass", new BlockStainedGlass(EnumDyeColor.CYAN, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.CYAN).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("purple_stained_glass", new BlockStainedGlass(EnumDyeColor.PURPLE, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.PURPLE).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("blue_stained_glass", new BlockStainedGlass(EnumDyeColor.BLUE, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.BLUE).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("brown_stained_glass", new BlockStainedGlass(EnumDyeColor.BROWN, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.BROWN).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("green_stained_glass", new BlockStainedGlass(EnumDyeColor.GREEN, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.GREEN).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("red_stained_glass", new BlockStainedGlass(EnumDyeColor.RED, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.RED).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("black_stained_glass", new BlockStainedGlass(EnumDyeColor.BLACK, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.BLACK).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("oak_trapdoor", new BlockTrapDoor(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151663_o).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("spruce_trapdoor", new BlockTrapDoor(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151654_J).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("birch_trapdoor", new BlockTrapDoor(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151658_d).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jungle_trapdoor", new BlockTrapDoor(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151664_l).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("acacia_trapdoor", new BlockTrapDoor(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151676_q).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("dark_oak_trapdoor", new BlockTrapDoor(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151650_B).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block \u260337 = new Block(Properties.func_200945_a(Material.field_151576_e).func_200948_a(1.5f, 6.0f));
        Block \u260338 = new Block(Properties.func_200945_a(Material.field_151576_e).func_200948_a(1.5f, 6.0f));
        Block \u260339 = new Block(Properties.func_200945_a(Material.field_151576_e).func_200948_a(1.5f, 6.0f));
        Block \u260340 = new Block(Properties.func_200945_a(Material.field_151576_e).func_200948_a(1.5f, 6.0f));
        Block.func_196254_a("infested_stone", new BlockSilverfish(\u26032, Properties.func_200945_a(Material.field_151571_B).func_200948_a(0.0f, 0.75f)));
        Block.func_196254_a("infested_cobblestone", new BlockSilverfish(\u26033, Properties.func_200945_a(Material.field_151571_B).func_200948_a(0.0f, 0.75f)));
        Block.func_196254_a("infested_stone_bricks", new BlockSilverfish(\u260337, Properties.func_200945_a(Material.field_151571_B).func_200948_a(0.0f, 0.75f)));
        Block.func_196254_a("infested_mossy_stone_bricks", new BlockSilverfish(\u260338, Properties.func_200945_a(Material.field_151571_B).func_200948_a(0.0f, 0.75f)));
        Block.func_196254_a("infested_cracked_stone_bricks", new BlockSilverfish(\u260339, Properties.func_200945_a(Material.field_151571_B).func_200948_a(0.0f, 0.75f)));
        Block.func_196254_a("infested_chiseled_stone_bricks", new BlockSilverfish(\u260340, Properties.func_200945_a(Material.field_151571_B).func_200948_a(0.0f, 0.75f)));
        Block.func_196254_a("stone_bricks", \u260337);
        Block.func_196254_a("mossy_stone_bricks", \u260338);
        Block.func_196254_a("cracked_stone_bricks", \u260339);
        Block.func_196254_a("chiseled_stone_bricks", \u260340);
        BlockHugeMushroom \u260341 = new BlockHugeMushroom(\u260331, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151664_l).func_200943_b(0.2f).func_200947_a(SoundType.field_185848_a));
        Block.func_196254_a("brown_mushroom_block", \u260341);
        BlockHugeMushroom \u260342 = new BlockHugeMushroom(\u260332, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151645_D).func_200943_b(0.2f).func_200947_a(SoundType.field_185848_a));
        Block.func_196254_a("red_mushroom_block", \u260342);
        Block.func_196254_a("mushroom_stem", new BlockHugeMushroom(null, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_193561_M).func_200943_b(0.2f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("iron_bars", new BlockPane(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151660_b).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("glass_pane", new BlockGlassPane(Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        BlockMelon \u260343 = new BlockMelon(Properties.func_200949_a(Material.field_151572_C, MaterialColor.field_151672_u).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a));
        Block.func_196254_a("melon", \u260343);
        Block.func_196254_a("attached_pumpkin_stem", new BlockAttachedStem(\u260336, Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("attached_melon_stem", new BlockAttachedStem(\u260343, Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("pumpkin_stem", new BlockStem(\u260336, Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("melon_stem", new BlockStem(\u260343, Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("vine", new BlockVine(Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200944_c().func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("oak_fence_gate", new BlockFenceGate(Properties.func_200949_a(Material.field_151575_d, \u26034.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("brick_stairs", new BlockStairs(\u260333.func_176223_P(), Properties.func_200950_a(\u260333)));
        Block.func_196254_a("stone_brick_stairs", new BlockStairs(\u260337.func_176223_P(), Properties.func_200950_a(\u260337)));
        Block.func_196254_a("mycelium", new BlockMycelium(Properties.func_200949_a(Material.field_151577_b, MaterialColor.field_151678_z).func_200944_c().func_200943_b(0.6f).func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("lily_pad", new BlockLilyPad(Properties.func_200945_a(Material.field_151585_k).func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block \u260344 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151655_K).func_200948_a(2.0f, 6.0f));
        Block.func_196254_a("nether_bricks", \u260344);
        Block.func_196254_a("nether_brick_fence", new BlockFence(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151655_K).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("nether_brick_stairs", new BlockStairs(\u260344.func_176223_P(), Properties.func_200950_a(\u260344)));
        Block.func_196254_a("nether_wart", new BlockNetherWart(Properties.func_200949_a(Material.field_151585_k, MaterialColor.field_151645_D).func_200942_a().func_200944_c()));
        Block.func_196254_a("enchanting_table", new BlockEnchantmentTable(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151645_D).func_200948_a(5.0f, 1200.0f)));
        Block.func_196254_a("brewing_stand", new BlockBrewingStand(Properties.func_200945_a(Material.field_151573_f).func_200943_b(0.5f).func_200951_a(1)));
        Block.func_196254_a("cauldron", new BlockCauldron(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151665_m).func_200943_b(2.0f)));
        Block.func_196254_a("end_portal", new BlockEndPortal(Properties.func_200949_a(Material.field_151567_E, MaterialColor.field_151646_E).func_200942_a().func_200951_a(15).func_200948_a(-1.0f, 3600000.0f)));
        Block.func_196254_a("end_portal_frame", new BlockEndPortalFrame(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151651_C).func_200947_a(SoundType.field_185853_f).func_200951_a(1).func_200948_a(-1.0f, 3600000.0f)));
        Block.func_196254_a("end_stone", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151658_d).func_200948_a(3.0f, 9.0f)));
        Block.func_196254_a("dragon_egg", new BlockDragonEgg(Properties.func_200949_a(Material.field_151566_D, MaterialColor.field_151646_E).func_200948_a(3.0f, 9.0f).func_200951_a(1)));
        Block.func_196254_a("redstone_lamp", new BlockRedstoneLamp(Properties.func_200945_a(Material.field_151591_t).func_200951_a(15).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("cocoa", new BlockCocoa(Properties.func_200945_a(Material.field_151585_k).func_200944_c().func_200948_a(0.2f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("sandstone_stairs", new BlockStairs(\u260316.func_176223_P(), Properties.func_200950_a(\u260316)));
        Block.func_196254_a("emerald_ore", new BlockOre(Properties.func_200945_a(Material.field_151576_e).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("ender_chest", new BlockEnderChest(Properties.func_200945_a(Material.field_151576_e).func_200948_a(22.5f, 600.0f).func_200951_a(7)));
        BlockTripWireHook \u260345 = new BlockTripWireHook(Properties.func_200945_a(Material.field_151594_q).func_200942_a());
        Block.func_196254_a("tripwire_hook", \u260345);
        Block.func_196254_a("tripwire", new BlockTripWire(\u260345, Properties.func_200945_a(Material.field_151594_q).func_200942_a()));
        Block.func_196254_a("emerald_block", new Block(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151653_I).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("spruce_stairs", new BlockStairs(\u26035.func_176223_P(), Properties.func_200950_a(\u26035)));
        Block.func_196254_a("birch_stairs", new BlockStairs(\u26036.func_176223_P(), Properties.func_200950_a(\u26036)));
        Block.func_196254_a("jungle_stairs", new BlockStairs(\u26037.func_176223_P(), Properties.func_200950_a(\u26037)));
        Block.func_196254_a("command_block", new BlockCommandBlock(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151650_B).func_200948_a(-1.0f, 3600000.0f)));
        Block.func_196254_a("beacon", new BlockBeacon(Properties.func_200949_a(Material.field_151592_s, MaterialColor.field_151648_G).func_200943_b(3.0f).func_200951_a(15)));
        Block.func_196254_a("cobblestone_wall", new BlockWall(Properties.func_200950_a(\u26033)));
        Block.func_196254_a("mossy_cobblestone_wall", new BlockWall(Properties.func_200950_a(\u26033)));
        Block.func_196254_a("flower_pot", new BlockFlowerPot(blockAir, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_oak_sapling", new BlockFlowerPot(\u260310, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_spruce_sapling", new BlockFlowerPot(\u260311, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_birch_sapling", new BlockFlowerPot(\u260312, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_jungle_sapling", new BlockFlowerPot(\u260313, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_acacia_sapling", new BlockFlowerPot(\u260314, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_dark_oak_sapling", new BlockFlowerPot(\u260315, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_fern", new BlockFlowerPot(\u260318, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_dandelion", new BlockFlowerPot(\u260321, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_poppy", new BlockFlowerPot(\u260322, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_blue_orchid", new BlockFlowerPot(\u260323, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_allium", new BlockFlowerPot(\u260324, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_azure_bluet", new BlockFlowerPot(\u260325, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_red_tulip", new BlockFlowerPot(\u260326, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_orange_tulip", new BlockFlowerPot(\u260327, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_white_tulip", new BlockFlowerPot(\u260328, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_pink_tulip", new BlockFlowerPot(\u260329, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_oxeye_daisy", new BlockFlowerPot(\u260330, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_red_mushroom", new BlockFlowerPot(\u260332, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_brown_mushroom", new BlockFlowerPot(\u260331, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_dead_bush", new BlockFlowerPot(\u260319, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_cactus", new BlockFlowerPot(\u260335, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("carrots", new BlockCarrot(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("potatoes", new BlockPotato(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("oak_button", new BlockButtonWood(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("spruce_button", new BlockButtonWood(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("birch_button", new BlockButtonWood(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jungle_button", new BlockButtonWood(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("acacia_button", new BlockButtonWood(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("dark_oak_button", new BlockButtonWood(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("skeleton_wall_skull", new BlockSkullWall(BlockSkull.Types.SKELETON, Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("skeleton_skull", new BlockSkull(BlockSkull.Types.SKELETON, Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("wither_skeleton_wall_skull", new BlockSkullWitherWall(Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("wither_skeleton_skull", new BlockSkullWither(Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("zombie_wall_head", new BlockSkullWall(BlockSkull.Types.ZOMBIE, Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("zombie_head", new BlockSkull(BlockSkull.Types.ZOMBIE, Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("player_wall_head", new BlockSkullWallPlayer(Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("player_head", new BlockSkullPlayer(Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("creeper_wall_head", new BlockSkullWall(BlockSkull.Types.CREEPER, Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("creeper_head", new BlockSkull(BlockSkull.Types.CREEPER, Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("dragon_wall_head", new BlockSkullWall(BlockSkull.Types.DRAGON, Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("dragon_head", new BlockSkull(BlockSkull.Types.DRAGON, Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("anvil", new BlockAnvil(Properties.func_200949_a(Material.field_151574_g, MaterialColor.field_151668_h).func_200948_a(5.0f, 1200.0f).func_200947_a(SoundType.field_185858_k)));
        Block.func_196254_a("chipped_anvil", new BlockAnvil(Properties.func_200949_a(Material.field_151574_g, MaterialColor.field_151668_h).func_200948_a(5.0f, 1200.0f).func_200947_a(SoundType.field_185858_k)));
        Block.func_196254_a("damaged_anvil", new BlockAnvil(Properties.func_200949_a(Material.field_151574_g, MaterialColor.field_151668_h).func_200948_a(5.0f, 1200.0f).func_200947_a(SoundType.field_185858_k)));
        Block.func_196254_a("trapped_chest", new BlockTrappedChest(Properties.func_200945_a(Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("light_weighted_pressure_plate", new BlockPressurePlateWeighted(15, Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151647_F).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("heavy_weighted_pressure_plate", new BlockPressurePlateWeighted(150, Properties.func_200945_a(Material.field_151573_f).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("comparator", new BlockRedstoneComparator(Properties.func_200945_a(Material.field_151594_q).func_200946_b().func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("daylight_detector", new BlockDaylightDetector(Properties.func_200945_a(Material.field_151575_d).func_200943_b(0.2f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("redstone_block", new BlockRedstone(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151656_f).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("nether_quartz_ore", new BlockOre(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151655_K).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("hopper", new BlockHopper(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151665_m).func_200948_a(3.0f, 4.8f).func_200947_a(SoundType.field_185852_e)));
        Block \u260346 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151677_p).func_200943_b(0.8f));
        Block.func_196254_a("quartz_block", \u260346);
        Block.func_196254_a("chiseled_quartz_block", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151677_p).func_200943_b(0.8f)));
        Block.func_196254_a("quartz_pillar", new BlockRotatedPillar(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151677_p).func_200943_b(0.8f)));
        Block.func_196254_a("quartz_stairs", new BlockStairs(\u260346.func_176223_P(), Properties.func_200950_a(\u260346)));
        Block.func_196254_a("activator_rail", new BlockRailPowered(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.7f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("dropper", new BlockDropper(Properties.func_200945_a(Material.field_151576_e).func_200943_b(3.5f)));
        Block.func_196254_a("white_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193561_M).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("orange_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193562_N).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("magenta_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193563_O).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("light_blue_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193564_P).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("yellow_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193565_Q).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("lime_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193566_R).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("pink_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193567_S).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("gray_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193568_T).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("light_gray_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_197655_T).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("cyan_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193570_V).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("purple_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193571_W).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("blue_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193572_X).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("brown_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193573_Y).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("green_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193574_Z).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("red_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193559_aa).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("black_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193560_ab).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("white_stained_glass_pane", new BlockStainedGlassPane(EnumDyeColor.WHITE, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("orange_stained_glass_pane", new BlockStainedGlassPane(EnumDyeColor.ORANGE, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("magenta_stained_glass_pane", new BlockStainedGlassPane(EnumDyeColor.MAGENTA, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("light_blue_stained_glass_pane", new BlockStainedGlassPane(EnumDyeColor.LIGHT_BLUE, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("yellow_stained_glass_pane", new BlockStainedGlassPane(EnumDyeColor.YELLOW, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("lime_stained_glass_pane", new BlockStainedGlassPane(EnumDyeColor.LIME, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("pink_stained_glass_pane", new BlockStainedGlassPane(EnumDyeColor.PINK, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("gray_stained_glass_pane", new BlockStainedGlassPane(EnumDyeColor.GRAY, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("light_gray_stained_glass_pane", new BlockStainedGlassPane(EnumDyeColor.LIGHT_GRAY, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("cyan_stained_glass_pane", new BlockStainedGlassPane(EnumDyeColor.CYAN, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("purple_stained_glass_pane", new BlockStainedGlassPane(EnumDyeColor.PURPLE, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("blue_stained_glass_pane", new BlockStainedGlassPane(EnumDyeColor.BLUE, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("brown_stained_glass_pane", new BlockStainedGlassPane(EnumDyeColor.BROWN, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("green_stained_glass_pane", new BlockStainedGlassPane(EnumDyeColor.GREEN, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("red_stained_glass_pane", new BlockStainedGlassPane(EnumDyeColor.RED, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("black_stained_glass_pane", new BlockStainedGlassPane(EnumDyeColor.BLACK, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("acacia_stairs", new BlockStairs(\u26038.func_176223_P(), Properties.func_200950_a(\u26038)));
        Block.func_196254_a("dark_oak_stairs", new BlockStairs(\u26039.func_176223_P(), Properties.func_200950_a(\u26039)));
        Block.func_196254_a("slime_block", new BlockSlime(Properties.func_200949_a(Material.field_151571_B, MaterialColor.field_151661_c).func_200941_a(0.8f).func_200947_a(SoundType.field_185859_l)));
        Block.func_196254_a("barrier", new BlockBarrier(Properties.func_200945_a(Material.field_175972_I).func_200948_a(-1.0f, 3600000.8f)));
        Block.func_196254_a("iron_trapdoor", new BlockTrapDoor(Properties.func_200945_a(Material.field_151573_f).func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e)));
        Block \u260347 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151679_y).func_200948_a(1.5f, 6.0f));
        Block.func_196254_a("prismarine", \u260347);
        Block \u260348 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151648_G).func_200948_a(1.5f, 6.0f));
        Block.func_196254_a("prismarine_bricks", \u260348);
        Block \u260349 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151648_G).func_200948_a(1.5f, 6.0f));
        Block.func_196254_a("dark_prismarine", \u260349);
        Block.func_196254_a("prismarine_stairs", new BlockStairs(\u260347.func_176223_P(), Properties.func_200950_a(\u260347)));
        Block.func_196254_a("prismarine_brick_stairs", new BlockStairs(\u260348.func_176223_P(), Properties.func_200950_a(\u260348)));
        Block.func_196254_a("dark_prismarine_stairs", new BlockStairs(\u260349.func_176223_P(), Properties.func_200950_a(\u260349)));
        Block.func_196254_a("prismarine_slab", new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151679_y).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("prismarine_brick_slab", new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151648_G).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("dark_prismarine_slab", new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151648_G).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("sea_lantern", new BlockSeaLantern(Properties.func_200949_a(Material.field_151592_s, MaterialColor.field_151677_p).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_200951_a(15)));
        Block.func_196254_a("hay_block", new BlockHay(Properties.func_200949_a(Material.field_151577_b, MaterialColor.field_151673_t).func_200943_b(0.5f).func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("white_carpet", new BlockCarpet(EnumDyeColor.WHITE, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151666_j).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("orange_carpet", new BlockCarpet(EnumDyeColor.ORANGE, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151676_q).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("magenta_carpet", new BlockCarpet(EnumDyeColor.MAGENTA, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151675_r).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("light_blue_carpet", new BlockCarpet(EnumDyeColor.LIGHT_BLUE, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151674_s).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("yellow_carpet", new BlockCarpet(EnumDyeColor.YELLOW, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151673_t).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("lime_carpet", new BlockCarpet(EnumDyeColor.LIME, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151672_u).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("pink_carpet", new BlockCarpet(EnumDyeColor.PINK, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151671_v).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("gray_carpet", new BlockCarpet(EnumDyeColor.GRAY, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151670_w).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("light_gray_carpet", new BlockCarpet(EnumDyeColor.LIGHT_GRAY, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_197656_x).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("cyan_carpet", new BlockCarpet(EnumDyeColor.CYAN, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151679_y).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("purple_carpet", new BlockCarpet(EnumDyeColor.PURPLE, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151678_z).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("blue_carpet", new BlockCarpet(EnumDyeColor.BLUE, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151649_A).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("brown_carpet", new BlockCarpet(EnumDyeColor.BROWN, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151650_B).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("green_carpet", new BlockCarpet(EnumDyeColor.GREEN, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151651_C).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("red_carpet", new BlockCarpet(EnumDyeColor.RED, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151645_D).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("black_carpet", new BlockCarpet(EnumDyeColor.BLACK, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151646_E).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151676_q).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("coal_block", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151646_E).func_200948_a(5.0f, 6.0f)));
        Block.func_196254_a("packed_ice", new BlockPackedIce(Properties.func_200945_a(Material.field_151598_x).func_200941_a(0.98f).func_200943_b(0.5f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("sunflower", new BlockTallFlower(Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("lilac", new BlockTallFlower(Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("rose_bush", new BlockTallFlower(Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("peony", new BlockTallFlower(Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("tall_grass", new BlockShearableDoublePlant(\u260317, Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("large_fern", new BlockShearableDoublePlant(\u260318, Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("white_banner", new BlockBanner(EnumDyeColor.WHITE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("orange_banner", new BlockBanner(EnumDyeColor.ORANGE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("magenta_banner", new BlockBanner(EnumDyeColor.MAGENTA, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("light_blue_banner", new BlockBanner(EnumDyeColor.LIGHT_BLUE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("yellow_banner", new BlockBanner(EnumDyeColor.YELLOW, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("lime_banner", new BlockBanner(EnumDyeColor.LIME, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("pink_banner", new BlockBanner(EnumDyeColor.PINK, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("gray_banner", new BlockBanner(EnumDyeColor.GRAY, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("light_gray_banner", new BlockBanner(EnumDyeColor.LIGHT_GRAY, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("cyan_banner", new BlockBanner(EnumDyeColor.CYAN, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("purple_banner", new BlockBanner(EnumDyeColor.PURPLE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("blue_banner", new BlockBanner(EnumDyeColor.BLUE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("brown_banner", new BlockBanner(EnumDyeColor.BROWN, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("green_banner", new BlockBanner(EnumDyeColor.GREEN, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("red_banner", new BlockBanner(EnumDyeColor.RED, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("black_banner", new BlockBanner(EnumDyeColor.BLACK, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("white_wall_banner", new BlockBannerWall(EnumDyeColor.WHITE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("orange_wall_banner", new BlockBannerWall(EnumDyeColor.ORANGE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("magenta_wall_banner", new BlockBannerWall(EnumDyeColor.MAGENTA, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("light_blue_wall_banner", new BlockBannerWall(EnumDyeColor.LIGHT_BLUE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("yellow_wall_banner", new BlockBannerWall(EnumDyeColor.YELLOW, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("lime_wall_banner", new BlockBannerWall(EnumDyeColor.LIME, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("pink_wall_banner", new BlockBannerWall(EnumDyeColor.PINK, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("gray_wall_banner", new BlockBannerWall(EnumDyeColor.GRAY, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("light_gray_wall_banner", new BlockBannerWall(EnumDyeColor.LIGHT_GRAY, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("cyan_wall_banner", new BlockBannerWall(EnumDyeColor.CYAN, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("purple_wall_banner", new BlockBannerWall(EnumDyeColor.PURPLE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("blue_wall_banner", new BlockBannerWall(EnumDyeColor.BLUE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("brown_wall_banner", new BlockBannerWall(EnumDyeColor.BROWN, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("green_wall_banner", new BlockBannerWall(EnumDyeColor.GREEN, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("red_wall_banner", new BlockBannerWall(EnumDyeColor.RED, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("black_wall_banner", new BlockBannerWall(EnumDyeColor.BLACK, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block \u260350 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151676_q).func_200943_b(0.8f));
        Block.func_196254_a("red_sandstone", \u260350);
        Block.func_196254_a("chiseled_red_sandstone", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151676_q).func_200943_b(0.8f)));
        Block.func_196254_a("cut_red_sandstone", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151676_q).func_200943_b(0.8f)));
        Block.func_196254_a("red_sandstone_stairs", new BlockStairs(\u260350.func_176223_P(), Properties.func_200950_a(\u260350)));
        Block.func_196254_a("oak_slab", new BlockSlab(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151663_o).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("spruce_slab", new BlockSlab(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151654_J).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("birch_slab", new BlockSlab(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151658_d).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jungle_slab", new BlockSlab(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151664_l).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("acacia_slab", new BlockSlab(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151676_q).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("dark_oak_slab", new BlockSlab(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151650_B).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stone_slab", new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151665_m).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("sandstone_slab", new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151658_d).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("petrified_oak_slab", new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151663_o).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("cobblestone_slab", new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151665_m).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("brick_slab", new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151645_D).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("stone_brick_slab", new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151665_m).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("nether_brick_slab", new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151655_K).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("quartz_slab", new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151677_p).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("red_sandstone_slab", new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151676_q).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("purpur_slab", new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151675_r).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("smooth_stone", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151665_m).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("smooth_sandstone", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151658_d).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("smooth_quartz", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151677_p).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("smooth_red_sandstone", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151676_q).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("spruce_fence_gate", new BlockFenceGate(Properties.func_200949_a(Material.field_151575_d, \u26035.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("birch_fence_gate", new BlockFenceGate(Properties.func_200949_a(Material.field_151575_d, \u26036.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jungle_fence_gate", new BlockFenceGate(Properties.func_200949_a(Material.field_151575_d, \u26037.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("acacia_fence_gate", new BlockFenceGate(Properties.func_200949_a(Material.field_151575_d, \u26038.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("dark_oak_fence_gate", new BlockFenceGate(Properties.func_200949_a(Material.field_151575_d, \u26039.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("spruce_fence", new BlockFence(Properties.func_200949_a(Material.field_151575_d, \u26035.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("birch_fence", new BlockFence(Properties.func_200949_a(Material.field_151575_d, \u26036.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jungle_fence", new BlockFence(Properties.func_200949_a(Material.field_151575_d, \u26037.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("acacia_fence", new BlockFence(Properties.func_200949_a(Material.field_151575_d, \u26038.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("dark_oak_fence", new BlockFence(Properties.func_200949_a(Material.field_151575_d, \u26039.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("spruce_door", new BlockDoor(Properties.func_200949_a(Material.field_151575_d, \u26035.field_181083_K).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("birch_door", new BlockDoor(Properties.func_200949_a(Material.field_151575_d, \u26036.field_181083_K).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jungle_door", new BlockDoor(Properties.func_200949_a(Material.field_151575_d, \u26037.field_181083_K).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("acacia_door", new BlockDoor(Properties.func_200949_a(Material.field_151575_d, \u26038.field_181083_K).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("dark_oak_door", new BlockDoor(Properties.func_200949_a(Material.field_151575_d, \u26039.field_181083_K).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("end_rod", new BlockEndRod(Properties.func_200945_a(Material.field_151594_q).func_200946_b().func_200951_a(14).func_200947_a(SoundType.field_185848_a)));
        BlockChorusPlant \u260351 = new BlockChorusPlant(Properties.func_200949_a(Material.field_151585_k, MaterialColor.field_151678_z).func_200943_b(0.4f).func_200947_a(SoundType.field_185848_a));
        Block.func_196254_a("chorus_plant", \u260351);
        Block.func_196254_a("chorus_flower", new BlockChorusFlower(\u260351, Properties.func_200949_a(Material.field_151585_k, MaterialColor.field_151678_z).func_200944_c().func_200943_b(0.4f).func_200947_a(SoundType.field_185848_a)));
        Block \u260352 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151675_r).func_200948_a(1.5f, 6.0f));
        Block.func_196254_a("purpur_block", \u260352);
        Block.func_196254_a("purpur_pillar", new BlockRotatedPillar(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151675_r).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("purpur_stairs", new BlockStairs(\u260352.func_176223_P(), Properties.func_200950_a(\u260352)));
        Block.func_196254_a("end_stone_bricks", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151658_d).func_200943_b(0.8f)));
        Block.func_196254_a("beetroots", new BlockBeetroot(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        BlockGrassPath \u260353 = new BlockGrassPath(Properties.func_200945_a(Material.field_151578_c).func_200943_b(0.65f).func_200947_a(SoundType.field_185850_c));
        Block.func_196254_a("grass_path", \u260353);
        Block.func_196254_a("end_gateway", new BlockEndGateway(Properties.func_200949_a(Material.field_151567_E, MaterialColor.field_151646_E).func_200942_a().func_200951_a(15).func_200948_a(-1.0f, 3600000.0f)));
        Block.func_196254_a("repeating_command_block", new BlockCommandBlock(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151678_z).func_200948_a(-1.0f, 3600000.0f)));
        Block.func_196254_a("chain_command_block", new BlockCommandBlock(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151651_C).func_200948_a(-1.0f, 3600000.0f)));
        Block.func_196254_a("frosted_ice", new BlockFrostedIce(Properties.func_200945_a(Material.field_151588_w).func_200941_a(0.98f).func_200944_c().func_200943_b(0.5f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("magma_block", new BlockMagma(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151655_K).func_200951_a(3).func_200944_c().func_200943_b(0.5f)));
        Block.func_196254_a("nether_wart_block", new Block(Properties.func_200949_a(Material.field_151577_b, MaterialColor.field_151645_D).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("red_nether_bricks", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151655_K).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("bone_block", new BlockRotatedPillar(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151658_d).func_200943_b(2.0f)));
        Block.func_196254_a("structure_void", new BlockStructureVoid(Properties.func_200945_a(Material.field_189963_J).func_200942_a()));
        Block.func_196254_a("observer", new BlockObserver(Properties.func_200945_a(Material.field_151576_e).func_200943_b(3.0f)));
        Block.func_196254_a("shulker_box", new BlockShulkerBox(null, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151678_z).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("white_shulker_box", new BlockShulkerBox(EnumDyeColor.WHITE, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151666_j).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("orange_shulker_box", new BlockShulkerBox(EnumDyeColor.ORANGE, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151676_q).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("magenta_shulker_box", new BlockShulkerBox(EnumDyeColor.MAGENTA, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151675_r).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("light_blue_shulker_box", new BlockShulkerBox(EnumDyeColor.LIGHT_BLUE, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151674_s).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("yellow_shulker_box", new BlockShulkerBox(EnumDyeColor.YELLOW, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151673_t).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("lime_shulker_box", new BlockShulkerBox(EnumDyeColor.LIME, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151672_u).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("pink_shulker_box", new BlockShulkerBox(EnumDyeColor.PINK, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151671_v).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("gray_shulker_box", new BlockShulkerBox(EnumDyeColor.GRAY, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("light_gray_shulker_box", new BlockShulkerBox(EnumDyeColor.LIGHT_GRAY, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_197656_x).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("cyan_shulker_box", new BlockShulkerBox(EnumDyeColor.CYAN, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151679_y).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("purple_shulker_box", new BlockShulkerBox(EnumDyeColor.PURPLE, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193571_W).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("blue_shulker_box", new BlockShulkerBox(EnumDyeColor.BLUE, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151649_A).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("brown_shulker_box", new BlockShulkerBox(EnumDyeColor.BROWN, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151650_B).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("green_shulker_box", new BlockShulkerBox(EnumDyeColor.GREEN, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151651_C).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("red_shulker_box", new BlockShulkerBox(EnumDyeColor.RED, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151645_D).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("black_shulker_box", new BlockShulkerBox(EnumDyeColor.BLACK, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151646_E).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("white_glazed_terracotta", new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.WHITE).func_200943_b(1.4f)));
        Block.func_196254_a("orange_glazed_terracotta", new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.ORANGE).func_200943_b(1.4f)));
        Block.func_196254_a("magenta_glazed_terracotta", new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.MAGENTA).func_200943_b(1.4f)));
        Block.func_196254_a("light_blue_glazed_terracotta", new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.LIGHT_BLUE).func_200943_b(1.4f)));
        Block.func_196254_a("yellow_glazed_terracotta", new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.YELLOW).func_200943_b(1.4f)));
        Block.func_196254_a("lime_glazed_terracotta", new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.LIME).func_200943_b(1.4f)));
        Block.func_196254_a("pink_glazed_terracotta", new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.PINK).func_200943_b(1.4f)));
        Block.func_196254_a("gray_glazed_terracotta", new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.GRAY).func_200943_b(1.4f)));
        Block.func_196254_a("light_gray_glazed_terracotta", new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.LIGHT_GRAY).func_200943_b(1.4f)));
        Block.func_196254_a("cyan_glazed_terracotta", new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.CYAN).func_200943_b(1.4f)));
        Block.func_196254_a("purple_glazed_terracotta", new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.PURPLE).func_200943_b(1.4f)));
        Block.func_196254_a("blue_glazed_terracotta", new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.BLUE).func_200943_b(1.4f)));
        Block.func_196254_a("brown_glazed_terracotta", new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.BROWN).func_200943_b(1.4f)));
        Block.func_196254_a("green_glazed_terracotta", new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.GREEN).func_200943_b(1.4f)));
        Block.func_196254_a("red_glazed_terracotta", new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.RED).func_200943_b(1.4f)));
        Block.func_196254_a("black_glazed_terracotta", new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.BLACK).func_200943_b(1.4f)));
        Block \u260354 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.WHITE).func_200943_b(1.8f));
        Block \u260355 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.ORANGE).func_200943_b(1.8f));
        Block \u260356 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.MAGENTA).func_200943_b(1.8f));
        Block \u260357 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.LIGHT_BLUE).func_200943_b(1.8f));
        Block \u260358 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.YELLOW).func_200943_b(1.8f));
        Block \u260359 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.LIME).func_200943_b(1.8f));
        Block \u260360 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.PINK).func_200943_b(1.8f));
        Block \u260361 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.GRAY).func_200943_b(1.8f));
        Block \u260362 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.LIGHT_GRAY).func_200943_b(1.8f));
        Block \u260363 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.CYAN).func_200943_b(1.8f));
        Block \u260364 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.PURPLE).func_200943_b(1.8f));
        Block \u260365 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.BLUE).func_200943_b(1.8f));
        Block \u260366 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.BROWN).func_200943_b(1.8f));
        Block \u260367 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.GREEN).func_200943_b(1.8f));
        Block \u260368 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.RED).func_200943_b(1.8f));
        Block \u260369 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.BLACK).func_200943_b(1.8f));
        Block.func_196254_a("white_concrete", \u260354);
        Block.func_196254_a("orange_concrete", \u260355);
        Block.func_196254_a("magenta_concrete", \u260356);
        Block.func_196254_a("light_blue_concrete", \u260357);
        Block.func_196254_a("yellow_concrete", \u260358);
        Block.func_196254_a("lime_concrete", \u260359);
        Block.func_196254_a("pink_concrete", \u260360);
        Block.func_196254_a("gray_concrete", \u260361);
        Block.func_196254_a("light_gray_concrete", \u260362);
        Block.func_196254_a("cyan_concrete", \u260363);
        Block.func_196254_a("purple_concrete", \u260364);
        Block.func_196254_a("blue_concrete", \u260365);
        Block.func_196254_a("brown_concrete", \u260366);
        Block.func_196254_a("green_concrete", \u260367);
        Block.func_196254_a("red_concrete", \u260368);
        Block.func_196254_a("black_concrete", \u260369);
        Block.func_196254_a("white_concrete_powder", new BlockConcretePowder(\u260354, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.WHITE).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("orange_concrete_powder", new BlockConcretePowder(\u260355, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.ORANGE).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("magenta_concrete_powder", new BlockConcretePowder(\u260356, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.MAGENTA).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("light_blue_concrete_powder", new BlockConcretePowder(\u260357, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.LIGHT_BLUE).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("yellow_concrete_powder", new BlockConcretePowder(\u260358, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.YELLOW).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("lime_concrete_powder", new BlockConcretePowder(\u260359, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.LIME).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("pink_concrete_powder", new BlockConcretePowder(\u260360, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.PINK).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("gray_concrete_powder", new BlockConcretePowder(\u260361, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.GRAY).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("light_gray_concrete_powder", new BlockConcretePowder(\u260362, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.LIGHT_GRAY).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("cyan_concrete_powder", new BlockConcretePowder(\u260363, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.CYAN).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("purple_concrete_powder", new BlockConcretePowder(\u260364, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.PURPLE).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("blue_concrete_powder", new BlockConcretePowder(\u260365, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.BLUE).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("brown_concrete_powder", new BlockConcretePowder(\u260366, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.BROWN).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("green_concrete_powder", new BlockConcretePowder(\u260367, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.GREEN).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("red_concrete_powder", new BlockConcretePowder(\u260368, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.RED).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("black_concrete_powder", new BlockConcretePowder(\u260369, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.BLACK).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        BlockKelpTop \u260370 = new BlockKelpTop(Properties.func_200945_a(Material.field_203243_f).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_211382_m));
        Block.func_196254_a("kelp", \u260370);
        Block.func_196254_a("kelp_plant", new BlockKelp(\u260370, Properties.func_200945_a(Material.field_203243_f).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("dried_kelp_block", new Block(Properties.func_200949_a(Material.field_151577_b, MaterialColor.field_151650_B).func_200948_a(0.5f, 2.5f).func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("turtle_egg", new BlockTurtleEgg(Properties.func_200949_a(Material.field_151566_D, MaterialColor.field_197656_x).func_200943_b(0.5f).func_200947_a(SoundType.field_185852_e).func_200944_c()));
        Block \u260371 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200948_a(1.5f, 6.0f));
        Block \u260372 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200948_a(1.5f, 6.0f));
        Block \u260373 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200948_a(1.5f, 6.0f));
        Block \u260374 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200948_a(1.5f, 6.0f));
        Block \u260375 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200948_a(1.5f, 6.0f));
        Block.func_196254_a("dead_tube_coral_block", \u260371);
        Block.func_196254_a("dead_brain_coral_block", \u260372);
        Block.func_196254_a("dead_bubble_coral_block", \u260373);
        Block.func_196254_a("dead_fire_coral_block", \u260374);
        Block.func_196254_a("dead_horn_coral_block", \u260375);
        Block.func_196254_a("tube_coral_block", new BlockCoral(\u260371, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151649_A).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_211383_n)));
        Block.func_196254_a("brain_coral_block", new BlockCoral(\u260372, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151671_v).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_211383_n)));
        Block.func_196254_a("bubble_coral_block", new BlockCoral(\u260373, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151678_z).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_211383_n)));
        Block.func_196254_a("fire_coral_block", new BlockCoral(\u260374, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151645_D).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_211383_n)));
        Block.func_196254_a("horn_coral_block", new BlockCoral(\u260375, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151673_t).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_211383_n)));
        BlockCoralPlantDead \u260376 = new BlockCoralPlantDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralPlantDead \u260377 = new BlockCoralPlantDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralPlantDead \u260378 = new BlockCoralPlantDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralPlantDead \u260379 = new BlockCoralPlantDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralPlantDead \u260380 = new BlockCoralPlantDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        Block.func_196254_a("dead_tube_coral", \u260376);
        Block.func_196254_a("dead_brain_coral", \u260377);
        Block.func_196254_a("dead_bubble_coral", \u260378);
        Block.func_196254_a("dead_fire_coral", \u260379);
        Block.func_196254_a("dead_horn_coral", \u260380);
        Block.func_196254_a("tube_coral", new BlockCoralPlant(\u260376, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151649_A).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("brain_coral", new BlockCoralPlant(\u260377, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151671_v).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("bubble_coral", new BlockCoralPlant(\u260378, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151678_z).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("fire_coral", new BlockCoralPlant(\u260379, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151645_D).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("horn_coral", new BlockCoralPlant(\u260380, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151673_t).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        BlockCoralWallFanDead \u260381 = new BlockCoralWallFanDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralWallFanDead \u260382 = new BlockCoralWallFanDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralWallFanDead \u260383 = new BlockCoralWallFanDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralWallFanDead \u260384 = new BlockCoralWallFanDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralWallFanDead \u260385 = new BlockCoralWallFanDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        Block.func_196254_a("dead_tube_coral_wall_fan", \u260381);
        Block.func_196254_a("dead_brain_coral_wall_fan", \u260382);
        Block.func_196254_a("dead_bubble_coral_wall_fan", \u260383);
        Block.func_196254_a("dead_fire_coral_wall_fan", \u260384);
        Block.func_196254_a("dead_horn_coral_wall_fan", \u260385);
        Block.func_196254_a("tube_coral_wall_fan", new BlockCoralWallFan(\u260381, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151649_A).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("brain_coral_wall_fan", new BlockCoralWallFan(\u260382, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151671_v).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("bubble_coral_wall_fan", new BlockCoralWallFan(\u260383, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151678_z).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("fire_coral_wall_fan", new BlockCoralWallFan(\u260384, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151645_D).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("horn_coral_wall_fan", new BlockCoralWallFan(\u260385, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151673_t).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        BlockCoralFan \u260386 = new BlockCoralFan(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralFan \u260387 = new BlockCoralFan(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralFan \u260388 = new BlockCoralFan(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralFan \u260389 = new BlockCoralFan(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralFan \u260390 = new BlockCoralFan(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        Block.func_196254_a("dead_tube_coral_fan", \u260386);
        Block.func_196254_a("dead_brain_coral_fan", \u260387);
        Block.func_196254_a("dead_bubble_coral_fan", \u260388);
        Block.func_196254_a("dead_fire_coral_fan", \u260389);
        Block.func_196254_a("dead_horn_coral_fan", \u260390);
        Block.func_196254_a("tube_coral_fan", new BlockCoralFin(\u260386, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151649_A).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("brain_coral_fan", new BlockCoralFin(\u260387, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151671_v).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("bubble_coral_fan", new BlockCoralFin(\u260388, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151678_z).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("fire_coral_fan", new BlockCoralFin(\u260389, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151645_D).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("horn_coral_fan", new BlockCoralFin(\u260390, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151673_t).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("sea_pickle", new BlockSeaPickle(Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151651_C).func_200951_a(3).func_200947_a(SoundType.field_185859_l)));
        Block.func_196254_a("blue_ice", new BlockBlueIce(Properties.func_200945_a(Material.field_151598_x).func_200943_b(2.8f).func_200941_a(0.989f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("conduit", new BlockConduit(Properties.func_200949_a(Material.field_151592_s, MaterialColor.field_151648_G).func_200943_b(3.0f).func_200951_a(15)));
        Block.func_196254_a("void_air", new BlockAir(Properties.func_200945_a(Material.field_151579_a).func_200942_a()));
        Block.func_196254_a("cave_air", new BlockAir(Properties.func_200945_a(Material.field_151579_a).func_200942_a()));
        Block.func_196254_a("bubble_column", new BlockBubbleColumn(Properties.func_200945_a(Material.field_203244_i).func_200942_a()));
        Block.func_196254_a("structure_block", new BlockStructure(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_197656_x).func_200948_a(-1.0f, 3600000.0f)));
        for (Block block : IRegistry.field_212618_g) {
            for (IBlockState iBlockState : block.func_176194_O().func_177619_a()) {
                field_176229_d.func_195867_b(iBlockState);
            }
        }
    }

    private static void func_196249_a(ResourceLocation resourceLocation, Block block) {
        IRegistry.field_212618_g.func_82595_a(resourceLocation, block);
    }

    private static void func_196254_a(String string, Block block) {
        Block.func_196249_a(new ResourceLocation(string), block);
    }

    public static enum EnumOffsetType {
        NONE,
        XZ,
        XYZ;

    }

    public static class Properties {
        private Material field_200953_a;
        private MaterialColor field_200954_b;
        private boolean field_200955_c = true;
        private SoundType field_200956_d = SoundType.field_185851_d;
        private int field_200957_e;
        private float field_200958_f;
        private float field_200959_g;
        private boolean field_200960_h;
        private float field_200961_i = 0.6f;
        private boolean field_208772_j;

        private Properties(Material material, MaterialColor materialColor) {
            this.field_200953_a = material;
            this.field_200954_b = materialColor;
        }

        public static Properties func_200945_a(Material material) {
            return Properties.func_200949_a(material, material.func_151565_r());
        }

        public static Properties func_200952_a(Material material, EnumDyeColor enumDyeColor) {
            return Properties.func_200949_a(material, enumDyeColor.func_196055_e());
        }

        public static Properties func_200949_a(Material material, MaterialColor materialColor) {
            return new Properties(material, materialColor);
        }

        public static Properties func_200950_a(Block block) {
            Properties properties = new Properties(block.field_149764_J, block.field_181083_K);
            properties.field_200953_a = block.field_149764_J;
            properties.field_200959_g = block.field_149782_v;
            properties.field_200958_f = block.field_149781_w;
            properties.field_200955_c = block.field_196274_w;
            properties.field_200960_h = block.field_149789_z;
            properties.field_200957_e = block.field_149784_t;
            properties.field_200953_a = block.field_149764_J;
            properties.field_200954_b = block.field_181083_K;
            properties.field_200956_d = block.field_149762_H;
            properties.field_200961_i = block.func_208618_m();
            properties.field_208772_j = block.field_208621_p;
            return properties;
        }

        public Properties func_200942_a() {
            this.field_200955_c = false;
            return this;
        }

        public Properties func_200941_a(float f) {
            this.field_200961_i = f;
            return this;
        }

        protected Properties func_200947_a(SoundType soundType) {
            this.field_200956_d = soundType;
            return this;
        }

        protected Properties func_200951_a(int n) {
            this.field_200957_e = n;
            return this;
        }

        public Properties func_200948_a(float f, float f2) {
            this.field_200959_g = f;
            this.field_200958_f = Math.max(0.0f, f2);
            return this;
        }

        protected Properties func_200946_b() {
            return this.func_200943_b(0.0f);
        }

        protected Properties func_200943_b(float f) {
            this.func_200948_a(f, f);
            return this;
        }

        protected Properties func_200944_c() {
            this.field_200960_h = true;
            return this;
        }

        protected Properties func_208770_d() {
            this.field_208772_j = true;
            return this;
        }
    }

    public static final class RenderSideCacheKey {
        private final IBlockState field_212164_a;
        private final IBlockState field_212165_b;
        private final EnumFacing field_212166_c;

        public RenderSideCacheKey(IBlockState iBlockState, IBlockState iBlockState2, EnumFacing enumFacing) {
            this.field_212164_a = iBlockState;
            this.field_212165_b = iBlockState2;
            this.field_212166_c = enumFacing;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof RenderSideCacheKey)) {
                return false;
            }
            RenderSideCacheKey renderSideCacheKey = (RenderSideCacheKey)object;
            return this.field_212164_a == renderSideCacheKey.field_212164_a && this.field_212165_b == renderSideCacheKey.field_212165_b && this.field_212166_c == renderSideCacheKey.field_212166_c;
        }

        public int hashCode() {
            return Objects.hash(this.field_212164_a, this.field_212165_b, this.field_212166_c);
        }
    }
}

