/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.AbstractCriterionInstance;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.WorldServer;

public class PlacedBlockTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation field_193174_a = new ResourceLocation("placed_block");
    private final Map<PlayerAdvancements, Listeners> field_193175_b = Maps.newHashMap();

    @Override
    public ResourceLocation func_192163_a() {
        return field_193174_a;
    }

    @Override
    public void func_192165_a(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.field_193175_b.get(playerAdvancements);
        if (listeners == null) {
            listeners = new Listeners(playerAdvancements);
            this.field_193175_b.put(playerAdvancements, listeners);
        }
        listeners.func_193490_a(listener);
    }

    @Override
    public void func_192164_b(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.field_193175_b.get(playerAdvancements);
        if (listeners != null) {
            listeners.func_193487_b(listener);
            if (listeners.func_193488_a()) {
                this.field_193175_b.remove(playerAdvancements);
            }
        }
    }

    @Override
    public void func_192167_a(PlayerAdvancements playerAdvancements) {
        this.field_193175_b.remove(playerAdvancements);
    }

    @Override
    public Instance func_192166_a(JsonObject jsonObject2, JsonDeserializationContext jsonDeserializationContext) {
        JsonObject jsonObject2;
        Object object;
        Block block = null;
        if (jsonObject2.has("block")) {
            object = new ResourceLocation(JsonUtils.func_151200_h(jsonObject2, "block"));
            if (IRegistry.field_212618_g.func_212607_c((ResourceLocation)object)) {
                block = IRegistry.field_212618_g.func_82594_a((ResourceLocation)object);
            } else {
                throw new JsonSyntaxException("Unknown block type '" + object + "'");
            }
        }
        object = null;
        if (jsonObject2.has("state")) {
            if (block == null) {
                throw new JsonSyntaxException("Can't define block state without a specific block type");
            }
            \u26034 = block.func_176194_O();
            for (Map.Entry entry2 : JsonUtils.func_152754_s(jsonObject2, "state").entrySet()) {
                Map.Entry entry2;
                IProperty<?> iProperty = ((StateContainer)\u26034).func_185920_a((String)entry2.getKey());
                if (iProperty == null) {
                    throw new JsonSyntaxException("Unknown block state property '" + (String)entry2.getKey() + "' for block '" + IRegistry.field_212618_g.func_177774_c(block) + "'");
                }
                String \u26032 = JsonUtils.func_151206_a((JsonElement)entry2.getValue(), (String)entry2.getKey());
                Optional<?> \u26033 = iProperty.func_185929_b(\u26032);
                if (\u26033.isPresent()) {
                    if (object == null) {
                        object = Maps.newHashMap();
                    }
                    object.put(iProperty, \u26033.get());
                    continue;
                }
                throw new JsonSyntaxException("Invalid block state value '" + \u26032 + "' for property '" + (String)entry2.getKey() + "' on block '" + IRegistry.field_212618_g.func_177774_c(block) + "'");
            }
        }
        Object \u26034 = LocationPredicate.func_193454_a(jsonObject2.get("location"));
        ItemPredicate \u26035 = ItemPredicate.func_192492_a(jsonObject2.get("item"));
        return new Instance(block, (Map<IProperty<?>, Object>)object, (LocationPredicate)\u26034, \u26035);
    }

    public void func_193173_a(EntityPlayerMP entityPlayerMP, BlockPos blockPos, ItemStack itemStack) {
        IBlockState iBlockState = entityPlayerMP.field_70170_p.func_180495_p(blockPos);
        Listeners \u26032 = this.field_193175_b.get(entityPlayerMP.func_192039_O());
        if (\u26032 != null) {
            \u26032.func_193489_a(iBlockState, blockPos, entityPlayerMP.func_71121_q(), itemStack);
        }
    }

    @Override
    public /* synthetic */ ICriterionInstance func_192166_a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
        return this.func_192166_a(jsonObject, jsonDeserializationContext);
    }

    static class Listeners {
        private final PlayerAdvancements field_193491_a;
        private final Set<ICriterionTrigger.Listener<Instance>> field_193492_b = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancements) {
            this.field_193491_a = playerAdvancements;
        }

        public boolean func_193488_a() {
            return this.field_193492_b.isEmpty();
        }

        public void func_193490_a(ICriterionTrigger.Listener<Instance> listener) {
            this.field_193492_b.add(listener);
        }

        public void func_193487_b(ICriterionTrigger.Listener<Instance> listener) {
            this.field_193492_b.remove(listener);
        }

        public void func_193489_a(IBlockState iBlockState, BlockPos blockPos, WorldServer worldServer, ItemStack itemStack) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.field_193492_b) {
                if (!listener.func_192158_a().func_193210_a(iBlockState, blockPos, worldServer, itemStack)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener<Instance> listener : list) {
                    listener.func_192159_a(this.field_193491_a);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final Block field_193211_a;
        private final Map<IProperty<?>, Object> field_193212_b;
        private final LocationPredicate field_193213_c;
        private final ItemPredicate field_193214_d;

        public Instance(@Nullable Block block, @Nullable Map<IProperty<?>, Object> map, LocationPredicate locationPredicate, ItemPredicate itemPredicate) {
            super(field_193174_a);
            this.field_193211_a = block;
            this.field_193212_b = map;
            this.field_193213_c = locationPredicate;
            this.field_193214_d = itemPredicate;
        }

        public static Instance func_203934_a(Block block) {
            return new Instance(block, null, LocationPredicate.field_193455_a, ItemPredicate.field_192495_a);
        }

        public boolean func_193210_a(IBlockState iBlockState, BlockPos blockPos, WorldServer worldServer2, ItemStack itemStack) {
            WorldServer worldServer2;
            if (this.field_193211_a != null && iBlockState.func_177230_c() != this.field_193211_a) {
                return false;
            }
            if (this.field_193212_b != null) {
                for (Map.Entry<IProperty<?>, Object> entry : this.field_193212_b.entrySet()) {
                    if (iBlockState.func_177229_b(entry.getKey()) == entry.getValue()) continue;
                    return false;
                }
            }
            if (!this.field_193213_c.func_193453_a(worldServer2, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p())) {
                return false;
            }
            return this.field_193214_d.func_192493_a(itemStack);
        }

        @Override
        public JsonElement func_200288_b() {
            JsonObject jsonObject = new JsonObject();
            if (this.field_193211_a != null) {
                jsonObject.addProperty("block", IRegistry.field_212618_g.func_177774_c(this.field_193211_a).toString());
            }
            if (this.field_193212_b != null) {
                \u2603 = new JsonObject();
                for (Map.Entry<IProperty<?>, Object> entry : this.field_193212_b.entrySet()) {
                    \u2603.addProperty(entry.getKey().func_177701_a(), Util.func_200269_a(entry.getKey(), entry.getValue()));
                }
                jsonObject.add("state", (JsonElement)\u2603);
            }
            jsonObject.add("location", this.field_193213_c.func_204009_a());
            jsonObject.add("item", this.field_193214_d.func_200319_a());
            return jsonObject;
        }
    }
}

