/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;

public class MobEffectsPredicate {
    public static final MobEffectsPredicate field_193473_a = new MobEffectsPredicate(Collections.emptyMap());
    private final Map<Potion, InstancePredicate> field_193474_b;

    public MobEffectsPredicate(Map<Potion, InstancePredicate> map) {
        this.field_193474_b = map;
    }

    public static MobEffectsPredicate func_204014_a() {
        return new MobEffectsPredicate(Maps.newHashMap());
    }

    public MobEffectsPredicate func_204015_a(Potion potion) {
        this.field_193474_b.put(potion, new InstancePredicate());
        return this;
    }

    public boolean func_193469_a(Entity entity) {
        if (this == field_193473_a) {
            return true;
        }
        if (entity instanceof EntityLivingBase) {
            return this.func_193470_a(((EntityLivingBase)entity).func_193076_bZ());
        }
        return false;
    }

    public boolean func_193472_a(EntityLivingBase entityLivingBase) {
        if (this == field_193473_a) {
            return true;
        }
        return this.func_193470_a(entityLivingBase.func_193076_bZ());
    }

    public boolean func_193470_a(Map<Potion, PotionEffect> map) {
        if (this == field_193473_a) {
            return true;
        }
        for (Map.Entry<Potion, InstancePredicate> entry : this.field_193474_b.entrySet()) {
            PotionEffect potionEffect = map.get(entry.getKey());
            if (entry.getValue().func_193463_a(potionEffect)) continue;
            return false;
        }
        return true;
    }

    public static MobEffectsPredicate func_193471_a(@Nullable JsonElement jsonElement) {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return field_193473_a;
        }
        JsonObject jsonObject = JsonUtils.func_151210_l(jsonElement, "effects");
        HashMap \u26032 = Maps.newHashMap();
        for (Map.Entry entry : jsonObject.entrySet()) {
            ResourceLocation resourceLocation = new ResourceLocation((String)entry.getKey());
            Potion \u26033 = IRegistry.field_212631_t.func_212608_b(resourceLocation);
            if (\u26033 == null) {
                throw new JsonSyntaxException("Unknown effect '" + resourceLocation + "'");
            }
            InstancePredicate \u26034 = InstancePredicate.func_193464_a(JsonUtils.func_151210_l((JsonElement)entry.getValue(), (String)entry.getKey()));
            \u26032.put(\u26033, \u26034);
        }
        return new MobEffectsPredicate(\u26032);
    }

    public JsonElement func_204013_b() {
        if (this == field_193473_a) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<Potion, InstancePredicate> entry : this.field_193474_b.entrySet()) {
            jsonObject.add(IRegistry.field_212631_t.func_177774_c(entry.getKey()).toString(), entry.getValue().func_204012_a());
        }
        return jsonObject;
    }

    public static class InstancePredicate {
        private final MinMaxBounds.IntBound field_193465_a;
        private final MinMaxBounds.IntBound field_193466_b;
        @Nullable
        private final Boolean field_193467_c;
        @Nullable
        private final Boolean field_193468_d;

        public InstancePredicate(MinMaxBounds.IntBound intBound, MinMaxBounds.IntBound intBound2, @Nullable Boolean bl, @Nullable Boolean bl2) {
            this.field_193465_a = intBound;
            this.field_193466_b = intBound2;
            this.field_193467_c = bl;
            this.field_193468_d = bl2;
        }

        public InstancePredicate() {
            this(MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, null, null);
        }

        public boolean func_193463_a(@Nullable PotionEffect potionEffect) {
            if (potionEffect == null) {
                return false;
            }
            if (!this.field_193465_a.func_211339_d(potionEffect.func_76458_c())) {
                return false;
            }
            if (!this.field_193466_b.func_211339_d(potionEffect.func_76459_b())) {
                return false;
            }
            if (this.field_193467_c != null && this.field_193467_c.booleanValue() != potionEffect.func_82720_e()) {
                return false;
            }
            return this.field_193468_d == null || this.field_193468_d.booleanValue() == potionEffect.func_188418_e();
        }

        public JsonElement func_204012_a() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("amplifier", this.field_193465_a.func_200321_c());
            jsonObject.add("duration", this.field_193466_b.func_200321_c());
            jsonObject.addProperty("ambient", this.field_193467_c);
            jsonObject.addProperty("visible", this.field_193468_d);
            return jsonObject;
        }

        public static InstancePredicate func_193464_a(JsonObject jsonObject) {
            MinMaxBounds.IntBound intBound = MinMaxBounds.IntBound.func_211344_a(jsonObject.get("amplifier"));
            \u2603 = MinMaxBounds.IntBound.func_211344_a(jsonObject.get("duration"));
            Boolean \u26032 = jsonObject.has("ambient") ? Boolean.valueOf(JsonUtils.func_151212_i(jsonObject, "ambient")) : null;
            Boolean \u26033 = jsonObject.has("visible") ? Boolean.valueOf(JsonUtils.func_151212_i(jsonObject, "visible")) : null;
            return new InstancePredicate(intBound, \u2603, \u26032, \u26033);
        }
    }
}

