/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.FunctionObject;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.resources.SimpleResource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FunctionManager
implements ITickable,
IResourceManagerReloadListener {
    private static final Logger field_193067_a = LogManager.getLogger();
    private static final ResourceLocation field_200001_d = new ResourceLocation("tick");
    private static final ResourceLocation field_200222_e = new ResourceLocation("load");
    public static final int field_195454_a = "functions/".length();
    public static final int field_195455_b = ".mcfunction".length();
    private final MinecraftServer field_193069_c;
    private final Map<ResourceLocation, FunctionObject> field_193070_d = Maps.newHashMap();
    private final ArrayDeque<QueuedCommand> field_194020_g = new ArrayDeque();
    private boolean field_194021_h;
    private final TagCollection<FunctionObject> field_200002_i = new TagCollection<FunctionObject>(resourceLocation -> this.func_193058_a((ResourceLocation)resourceLocation) != null, this::func_193058_a, "tags/functions", true, "function");
    private final List<FunctionObject> field_200003_j = Lists.newArrayList();
    private boolean field_200223_l;

    public FunctionManager(MinecraftServer minecraftServer) {
        this.field_193069_c = minecraftServer;
    }

    @Nullable
    public FunctionObject func_193058_a(ResourceLocation resourceLocation) {
        return this.field_193070_d.get(resourceLocation);
    }

    public MinecraftServer func_195450_a() {
        return this.field_193069_c;
    }

    public int func_193065_c() {
        return this.field_193069_c.func_200252_aR().func_180263_c("maxCommandChainLength");
    }

    public Map<ResourceLocation, FunctionObject> func_193066_d() {
        return this.field_193070_d;
    }

    public CommandDispatcher<CommandSource> func_195446_d() {
        return this.field_193069_c.func_195571_aL().func_197054_a();
    }

    @Override
    public void func_73660_a() {
        this.field_193069_c.field_71304_b.func_194340_a(field_200001_d::toString);
        for (FunctionObject functionObject : this.field_200003_j) {
            this.func_195447_a(functionObject, this.func_195448_f());
        }
        this.field_193069_c.field_71304_b.func_76319_b();
        if (this.field_200223_l) {
            this.field_200223_l = false;
            Collection<FunctionObject> collection = this.func_200000_g().func_199915_b(field_200222_e).func_199885_a();
            this.field_193069_c.field_71304_b.func_194340_a(field_200222_e::toString);
            for (FunctionObject functionObject : collection) {
                this.func_195447_a(functionObject, this.func_195448_f());
            }
            this.field_193069_c.field_71304_b.func_76319_b();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int func_195447_a(FunctionObject functionObject, CommandSource commandSource) {
        int n = this.func_193065_c();
        if (this.field_194021_h) {
            if (this.field_194020_g.size() < n) {
                this.field_194020_g.addFirst(new QueuedCommand(this, commandSource, new FunctionObject.FunctionEntry(functionObject)));
            }
            return 0;
        }
        try {
            int n2;
            this.field_194021_h = true;
            n2 = 0;
            FunctionObject.Entry[] entryArray = functionObject.func_193528_a();
            for (int i = entryArray.length - 1; i >= 0; --i) {
                this.field_194020_g.push(new QueuedCommand(this, commandSource, entryArray[i]));
            }
            while (!this.field_194020_g.isEmpty()) {
                try {
                    QueuedCommand queuedCommand = this.field_194020_g.removeFirst();
                    this.field_193069_c.field_71304_b.func_194340_a(queuedCommand::toString);
                    queuedCommand.func_194222_a(this.field_194020_g, n);
                }
                finally {
                    this.field_193069_c.field_71304_b.func_76319_b();
                }
                if (++n2 < n) continue;
                int n3 = n2;
                return n3;
            }
            int n4 = n2;
            return n4;
        }
        finally {
            this.field_194020_g.clear();
            this.field_194021_h = false;
        }
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        this.field_193070_d.clear();
        this.field_200003_j.clear();
        this.field_200002_i.func_199917_b();
        Collection<ResourceLocation> collection = iResourceManager.func_199003_a("functions", string -> string.endsWith(".mcfunction"));
        ArrayList \u26032 = Lists.newArrayList();
        for (ResourceLocation resourceLocation : collection) {
            String string2 = resourceLocation.func_110623_a();
            ResourceLocation \u26033 = new ResourceLocation(resourceLocation.func_110624_b(), string2.substring(field_195454_a, string2.length() - field_195455_b));
            \u26032.add(((CompletableFuture)CompletableFuture.supplyAsync(() -> FunctionManager.func_195449_a(iResourceManager, resourceLocation), SimpleResource.field_199031_a).thenApplyAsync(list -> FunctionObject.func_197000_a(\u26033, this, list))).handle((functionObject, throwable) -> this.func_212250_a((FunctionObject)functionObject, (Throwable)throwable, resourceLocation)));
        }
        CompletableFuture.allOf(\u26032.toArray(new CompletableFuture[0])).join();
        if (!this.field_193070_d.isEmpty()) {
            field_193067_a.info("Loaded {} custom command functions", (Object)this.field_193070_d.size());
        }
        this.field_200002_i.func_199909_a(iResourceManager);
        this.field_200003_j.addAll(this.field_200002_i.func_199915_b(field_200001_d).func_199885_a());
        this.field_200223_l = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private FunctionObject func_212250_a(FunctionObject functionObject, @Nullable Throwable throwable, ResourceLocation resourceLocation) {
        if (throwable != null) {
            field_193067_a.error("Couldn't load function at {}", (Object)resourceLocation, (Object)throwable);
            return null;
        }
        Map<ResourceLocation, FunctionObject> map = this.field_193070_d;
        synchronized (map) {
            this.field_193070_d.put(functionObject.func_197001_a(), functionObject);
        }
        return functionObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> func_195449_a(IResourceManager iResourceManager, ResourceLocation resourceLocation) {
        try (IResource iResource = iResourceManager.func_199002_a(resourceLocation);){
            List list = IOUtils.readLines((InputStream)iResource.func_199027_b(), (Charset)StandardCharsets.UTF_8);
            return list;
        }
        catch (IOException iOException) {
            throw new CompletionException(iOException);
        }
    }

    public CommandSource func_195448_f() {
        return this.field_193069_c.func_195573_aM().func_197033_a(2).func_197031_a();
    }

    public TagCollection<FunctionObject> func_200000_g() {
        return this.field_200002_i;
    }

    public static class QueuedCommand {
        private final FunctionManager field_194223_a;
        private final CommandSource field_194224_b;
        private final FunctionObject.Entry field_194225_c;

        public QueuedCommand(FunctionManager functionManager, CommandSource commandSource, FunctionObject.Entry entry) {
            this.field_194223_a = functionManager;
            this.field_194224_b = commandSource;
            this.field_194225_c = entry;
        }

        public void func_194222_a(ArrayDeque<QueuedCommand> arrayDeque, int n) {
            try {
                this.field_194225_c.func_196998_a(this.field_194223_a, this.field_194224_b, arrayDeque, n);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public String toString() {
            return this.field_194225_c.toString();
        }
    }
}

