/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementTreeNode;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.EnumTypeAdapterFactory;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementManager
implements IResourceManagerReloadListener {
    private static final Logger field_192782_a = LogManager.getLogger();
    private static final Gson field_192783_b = new GsonBuilder().registerTypeHierarchyAdapter(Advancement.Builder.class, (jsonElement, type, jsonDeserializationContext) -> {
        JsonObject jsonObject = JsonUtils.func_151210_l(jsonElement, "advancement");
        return Advancement.Builder.func_192059_a(jsonObject, jsonDeserializationContext);
    }).registerTypeAdapter(AdvancementRewards.class, (Object)new AdvancementRewards.Deserializer()).registerTypeHierarchyAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer()).registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory()).create();
    private static final AdvancementList field_195443_e = new AdvancementList();
    public static final int field_195441_a = "advancements/".length();
    public static final int field_195442_b = ".json".length();
    private boolean field_193768_e;

    private Map<ResourceLocation, Advancement.Builder> func_195439_b(IResourceManager iResourceManager) {
        HashMap hashMap = Maps.newHashMap();
        for (ResourceLocation resourceLocation : iResourceManager.func_199003_a("advancements", string -> string.endsWith(".json"))) {
            String string2 = resourceLocation.func_110623_a();
            ResourceLocation \u26032 = new ResourceLocation(resourceLocation.func_110624_b(), string2.substring(field_195441_a, string2.length() - field_195442_b));
            try {
                IResource iResource = iResourceManager.func_199002_a(resourceLocation);
                Throwable throwable = null;
                try {
                    Advancement.Builder builder = JsonUtils.func_188178_a(field_192783_b, IOUtils.toString((InputStream)iResource.func_199027_b(), (Charset)StandardCharsets.UTF_8), Advancement.Builder.class);
                    if (builder == null) {
                        field_192782_a.error("Couldn't load custom advancement {} from {} as it's empty or null", (Object)\u26032, (Object)resourceLocation);
                        continue;
                    }
                    hashMap.put(\u26032, builder);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iResource == null) continue;
                    if (throwable != null) {
                        try {
                            iResource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iResource.close();
                }
            }
            catch (JsonParseException | IllegalArgumentException throwable) {
                field_192782_a.error("Parsing error loading custom advancement {}: {}", (Object)\u26032, (Object)throwable.getMessage());
                this.field_193768_e = true;
            }
            catch (IOException iOException) {
                field_192782_a.error("Couldn't read custom advancement {} from {}", (Object)\u26032, (Object)resourceLocation, (Object)iOException);
                this.field_193768_e = true;
            }
        }
        return hashMap;
    }

    @Nullable
    public Advancement func_192778_a(ResourceLocation resourceLocation) {
        return field_195443_e.func_192084_a(resourceLocation);
    }

    public Collection<Advancement> func_195438_b() {
        return field_195443_e.func_195651_c();
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        this.field_193768_e = false;
        field_195443_e.func_192087_a();
        Map<ResourceLocation, Advancement.Builder> map = this.func_195439_b(iResourceManager);
        field_195443_e.func_192083_a(map);
        for (Advancement advancement : field_195443_e.func_192088_b()) {
            if (advancement.func_192068_c() == null) continue;
            AdvancementTreeNode.func_192323_a(advancement);
        }
    }
}

