/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.IModLocator;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExplodedDirectoryLocator
implements IModLocator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<Pair<Path, List<Path>>> rootDirs = new ArrayList<Pair<Path, List<Path>>>();
    private final Map<ModFile, Pair<Path, List<Path>>> mods = new HashMap<ModFile, Pair<Path, List<Path>>>();

    @Override
    public List<ModFile> scanMods() {
        Path modstoml = Paths.get("META-INF", "mods.toml");
        this.rootDirs.forEach(pathPathPair -> {
            Path resources = (Path)pathPathPair.getLeft();
            Path modtoml = resources.resolve(modstoml);
            if (Files.exists(modtoml, new LinkOption[0])) {
                ModFile mf = new ModFile((Path)pathPathPair.getLeft(), this);
                this.mods.put(mf, (Pair<Path, List<Path>>)pathPathPair);
            } else {
                LOGGER.warn(LogMarkers.LOADING, "Failed to find exploded resource mods.toml in directory {}", (Object)resources.toString());
            }
        });
        return new ArrayList<ModFile>(this.mods.keySet());
    }

    @Override
    public String name() {
        return "exploded directory";
    }

    @Override
    public Path findPath(ModFile modFile, String ... path) {
        if (path.length < 1) {
            throw new IllegalArgumentException("Missing path");
        }
        Path target = Paths.get(path[0], Arrays.copyOfRange(path, 1, path.length));
        Path found = ((Path)this.mods.get(modFile).getLeft()).resolve(target);
        if (Files.exists(found, new LinkOption[0])) {
            return found;
        }
        return ((List)this.mods.get(modFile).getRight()).stream().map(p -> p.resolve(target)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().orElse(found.resolve(target));
    }

    @Override
    public void scanFile(ModFile modFile, Consumer<Path> pathConsumer) {
        LOGGER.debug(LogMarkers.SCAN, "Scanning exploded directory {}", (Object)modFile.getFilePath().toString());
        Pair<Path, List<Path>> pathPathPair = this.mods.get(modFile);
        ((List)pathPathPair.getRight()).forEach(path -> this.scanIndividualPath((Path)path, pathConsumer));
        LOGGER.debug(LogMarkers.SCAN, "Exploded directory scan complete {}", (Object)((Path)pathPathPair.getLeft()).toString());
    }

    private void scanIndividualPath(Path path, Consumer<Path> pathConsumer) {
        LOGGER.debug(LogMarkers.SCAN, "Scanning exploded target {}", (Object)path.toString());
        try (Stream<Path> files = Files.find(path, Integer.MAX_VALUE, (p, a) -> p.getNameCount() > 0 && p.getFileName().toString().endsWith(".class"), new FileVisitOption[0]);){
            files.forEach(pathConsumer);
        }
        catch (IOException e) {
            LOGGER.error(LogMarkers.SCAN, "Exception scanning {}", (Object)path, (Object)e);
        }
    }

    public String toString() {
        return "{ExplodedDir locator}";
    }

    @Override
    public Optional<Manifest> findManifest(Path file) {
        return Optional.empty();
    }

    @Override
    public void initArguments(Map<String, ?> arguments) {
        List explodedTargets = (List)arguments.get("explodedTargets");
        if (explodedTargets != null && !explodedTargets.isEmpty()) {
            this.rootDirs.addAll(explodedTargets);
        }
    }

    @Override
    public boolean isValid(ModFile modFile) {
        return this.mods.get(modFile) != null;
    }
}

