/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import net.minecraftforge.fml.loading.FileUtils;
import net.minecraftforge.fml.loading.LogMarkers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public enum FMLPaths {
    GAMEDIR,
    MODSDIR("mods"),
    CONFIGDIR("config"),
    FMLCONFIG(false, CONFIGDIR, "fml.toml");

    private static final Logger LOGGER;
    private final Path relativePath;
    private final boolean isDirectory;
    private Path absolutePath;

    private FMLPaths() {
        this("");
    }

    private FMLPaths(String ... path) {
        this.relativePath = this.computePath(path);
        this.isDirectory = true;
    }

    private Path computePath(String ... path) {
        return Paths.get(path[0], Arrays.copyOfRange(path, 1, path.length));
    }

    private FMLPaths(boolean isDir, FMLPaths parent, String ... path) {
        this.relativePath = parent.relativePath.resolve(this.computePath(path));
        this.isDirectory = isDir;
    }

    public static void setup(IEnvironment env) {
        Path rootPath = (Path)env.getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get()).orElseThrow(() -> new RuntimeException("No game path found"));
        FMLPaths.loadAbsolutePaths(rootPath);
    }

    public static void loadAbsolutePaths(Path rootPath) {
        for (FMLPaths path : FMLPaths.values()) {
            path.absolutePath = rootPath.resolve(path.relativePath).toAbsolutePath().normalize();
            if (path.isDirectory) {
                FileUtils.getOrCreateDirectory(path.absolutePath, path.name());
            }
            LOGGER.debug(LogMarkers.CORE, "Path {} is {}", new Supplier[]{() -> path, () -> path.absolutePath});
        }
    }

    public Path relative() {
        return this.relativePath;
    }

    public Path get() {
        return this.absolutePath;
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

